/* Java includes */
#include <StubPreamble.h>
#include <javaString.h>
#include "SkipStubs.h"

/* Skip includes */
#include "config.h"
#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "ipsp.h"
#include "crypt.h"
#include "req.h"

#include "../skipd/com.h"

#if SkipCacheEntryList_HASHTBLSIZE != HASHTBLSIZE
#error "The hash table from Java and C sizes do not match!"
#endif

/* A(javaInstanceVariable, cStatisticsMember) assigns the
 * value of named member of the statistics structure to the
 * named java instance variable.
 *
 * Attention: Neither var nor value may be an expression, they must be names!
 */
#define A(var, value) (unhand(this)->var) = stat.stat.value;

static int openCount;

/**
 * Make it aware of multiple possible comInit()
 */
long SkipIoctl_comInit(struct HSkipIoctl *this) {
  int result;

  if (openCount == 0) {
    result = com_init();
    if (result >= 0)
      openCount++;
    return result;
  } else {
    openCount++;
    return 0;
  }
}

/**
 * Wrapper to make only last call really close the device.
 *
 * If it is called when it is already closed, it returns -1. If it's a
 * fake close (not closing yet), it returns 0 (success), otherwise, it
 * returns the real return value of com_exit().
 */
long SkipIoctl_comExit(struct HSkipIoctl *this)
{
  if (openCount > 0) {
    openCount--;
    if (openCount == 0)
      return com_exit();
    else
      return 0;
  } else {
    return -1;
  }
}


long SkipPacketStats_comPacketStats(struct HSkipPacketStats *this)
{
  struct skipreq_statipsp stat;

  stat.hdr.req = SKIPREQ_STATIPSP;
  if (com_request((u_char *)&stat, sizeof(stat)) == sizeof(stat)) {
    A(packetsIn, in);
    A(cryptIn, crypt_in);
    A(authIn, auth_in);
    A(seqIn, seq_in);
    A(compIn, comp_in);
    A(tunnelIn, tunnel_in);

    A(packetsOut, out);
    A(cryptOut, crypt_out);
    A(authOut, auth_out);
    A(seqOut, seq_out);
    A(compOut, comp_out);
    A(tunnelOut, tunnel_out);

    A(badChecksum, badipsum);
    A(badPacketLen, badpktlen);
    A(badVersion, badversion);
    A(badN, badn);
    A(badPolicy, badpolicy);
    A(badKijAlg, badKijalg);
    A(badKpAlg, badKpalg);
    A(badBlockLen, badblklen);
    A(badMACAlg, badMACalg);
    A(badMAC, badMAC);
    A(badCompAlg, badCompalg);
    A(badFilter, badfilter);

    A(dropQueueLimit, queuelimit);
    A(dropFrags, fragdrop);
    return 0;
  } else {
    return -1;
  }
}

long SkipCacheStats_comCacheStats(struct HSkipCacheStats *this)
{
  struct skipreq_statcache stat;

  stat.hdr.req = SKIPREQ_STATCACHE;
  if (com_request((u_char *)&stat, sizeof(stat)) == sizeof(stat)) {
    A(entries, entries);
    A(inserted, inserted);
    A(updated, updated);
    A(timedOut, timedout);
    A(removed, removed);
    A(lookupHits, lookuphits);
    A(lookupRequests, lookuprequests);
    return 0;
  } else {
    return -1;
  }
}

long SkipCacheEntryList_comCacheEntryList(struct HSkipCacheEntryList *this)
{
  u_char buf[sizeof(struct skipreq_listcache) +
            sizeof(skip_id_t) * (SkipCacheEntryList_CACHEENTRIES - 1)];
  int len;

  {
    /* One type for the request */
    struct skipreq_hdr *hdr = (struct skipreq_hdr *)buf;
    hdr->req = SKIPREQ_LISTCACHE;
  }
  if ((len = com_request(buf, sizeof(buf))) <= 0) {
    /* Didn't work out, sorry! */
    return -1;
  }
  {
    /* Another type for the result */
    struct skipreq_listcache *l = (struct skipreq_listcache *)buf;
    int i, returned_entries;
    long *hashDepth = unhand(unhand(this)->hashDepth)->body;
    HObject **entries = unhand(unhand(this)->entries)->body;
    int *hash_depth = l->hash_depth;
    skip_id_t *skip_entry = l->entry;
    /* Buffer for the clear-text string for the keys */
    char string[2 * (2 + 1 + 2*SKIP_ID_MAXLEN) + 1 + 1];

    /* Copy the scalar variables */
    unhand(this)->maxEntries = l->cache_maxentries;
    unhand(this)->currentEntries = l->cache_entries;
    /* Does the kernel have more entries than I expected? */
    if (l->cache_entries > SkipCacheEntryList_CACHEENTRIES)
      returned_entries = SkipCacheEntryList_CACHEENTRIES;
    else
      returned_entries = l->cache_entries;
    unhand(this)->returnedEntries = returned_entries;

    /* Copy the hash table depth */
    for (i = 0; i < HASHTBLSIZE; i++, hashDepth++, hash_depth++) {
      *hashDepth = *hash_depth;
    }

    /*
     * And now for something completely different:
     * Copy the list of key pairs
     */
    
    for (i = 0; i < returned_entries; i++, entries++, skip_entry++) {
      id_sprintids(string, sizeof(string), skip_entry);
      *entries = (HObject *)makeJavaString(string, strlen(string));
    }
  }
  return 0;
}

long SkipCacheEntry_comCacheEntry(struct HSkipCacheEntry *this) {
#if 0
  u_char buf[16 * 1024];
  int len, res = 0;

  MEMZERO(hdr, sizeof(*hdr));
  hdr->req = SKIPREQ_DUMP;

  if (id_parseids(id, &hdr->id) < 0)
    return -2;
  {
    struct skipreq_hdr *hdr = (struct skipreq_hdr *)buf;
    if ((len = com_request((u_char *)buf, sizeof(buf))) <= 0)
      return -1;
  }

  {
    struct skipcache *c = (struct skipcache *)buf;

    c->data = (u_char *)(c + 1);
    c->next = NULL;

    

    parse_save(c, stdout);

    /* print additional dynamic fields */
    /* shared secret */
    if ((c->flags & SKIP_MANUALKEY) == 0)
    {
      printf("  shared secret: ");
      id_printnicehex(stdout, c->data + c->sharedkey.offset,
                      c->sharedkey.len);
      printf("\n");
    }
    /* 3 * Kijn + n */
    printf("  Kijn (n = %u) = ", c->Kijn[0].n);
    id_printnicehex(stdout, c->data + c->Kijn[0].key.offset, c->Kijn[0].key.len);
    printf("\n");
    printf("  Kijn (n = %u) = ", c->Kijn[1].n);
    id_printnicehex(stdout, c->data + c->Kijn[1].key.offset, c->Kijn[1].key.len);
    printf("\n");
    printf("  Kijn (n = %u) = ", c->Kijn[2].n);
    id_printnicehex(stdout, c->data + c->Kijn[2].key.offset, c->Kijn[2].key.len);
    printf("\n");
    /* enskip_A_Kp, enskip_E_Kp */
    printf("  enskip_A_Kp = ");
    id_printnicehex(stdout, c->data + c->enskip_A_Kp.offset, c->enskip_A_Kp.len);
    printf("\n");
    printf("  enskip_E_Kp = ");
    id_printnicehex(stdout, c->data + c->enskip_E_Kp.offset, c->enskip_E_Kp.len);
    printf("\n");
    /* enskip_Kp_Kijn */
    printf("  enskip_Kp_Kijn (n = %u) = ", c->enskip_Kp_Kijn.n);
    id_printnicehex(stdout, c->data + c->enskip_Kp_Kijn.key.offset, c->enskip_Kp_Kijn.key.len);
    printf("\n");
    /* enskip_Kp_bytes + enskip_Kp_ttl */
    printf("  enskip_Kp_bytes = %d\n", c->enskip_Kp_bytes);
    printf("  enskip_Kp_ttl = %d\n", c->enskip_Kp_ttl);
    /* enskip_MI */
    printf("  enskip_MI = ");
    id_printnicehex(stdout, c->data + c->enskip_MI.offset, c->enskip_MI.len);
    printf("\n");
    /* deskip_Kij_alg */
    printf("  deskip_Kij_alg = %u\n", c->deskip_Kij_alg);
    /* deskip_Crypt_alg */
    printf("  deskip_Kp_Kijn_len = %u\n", c->deskip_Kp_Kijn_len);
    /* deskip_Kp_Kijn */
    printf("  deskip_Kp_Kijn (n = %u) = ", c->deskip_Kp_Kijn.n);
    id_printnicehex(stdout, c->data + c->deskip_Kp_Kijn.key.offset, c->deskip_Kp_Kijn.key.len);
    printf("\n");
    /* deskip_A_Kp, deskip_E_Kp */
    printf("  deskip_A_Kp = ");
    id_printnicehex(stdout, c->data + c->deskip_A_Kp.offset, c->deskip_A_Kp.len);
    printf("\n");
    printf("  deskip_E_Kp = ");
    id_printnicehex(stdout, c->data + c->deskip_E_Kp.offset, c->deskip_E_Kp.len);
    printf("\n");
  }
  }
  return res;
#else
  return 0;
#endif
}
