/**
 * Ask the skip deamon for some requests.
 *
 * Attention: Only one instance is really opened from the low-level library,
 *            it is not aware of multiple opens. The native comInit()/comExit()
 *            functions take care of that.
 *
 * @author Marcel Waldvogel
 */

import java.io.IOException;
import java.util.Hashtable;
import java.util.Enumeration;

public class SkipIoctl extends Object {
  
static {
  System.loadLibrary("skippy");
}

public SkipIoctl() throws IOException {
  if (comInit() < 0)
    throw new IOException("Skip kernel module not found or no permission");
}

protected void finalize() throws IOException {
  if (comExit() < 0)
    throw new IOException("Cannot close Skip module");
}

/**
 * This can be called in any instance and will reconnect it
 */
/*
 * Currently not implemented, would need a mutex, synchronized isn't enough
 *
 public void reconnect() {
 }
 private native int comReconnect();
 *
 */  

private native int comInit();
private native int comExit();

  /**
   * Add the contents of src to dest, prefixing all String keys with
   * prefix.
   *
   * Utility routine for the subclasses.
   */
static public void mergeHashtables(Hashtable dest, Hashtable src, String prefix) {
  Enumeration elements = src.keys();
  while (elements.hasMoreElements()) {
    Object el = elements.nextElement();
    if (el instanceof String) {
      dest.put(prefix + el, src.get(el));
    } else {
      dest.put(el, src.get(el));
    }
  }
}
  
}
