/**
 * Ask the skip kernel module for its packet statistics
 *
 * @author Marcel Waldvogel
 */

import java.io.IOException;
import java.util.Hashtable;
import java.util.Enumeration;

public class SkipPacketStats extends SkipIoctl {
  public long
    /* Input */
    packetsIn, cryptIn, authIn, seqIn, compIn, nodeIn, tunnelIn,
    /* Output */
    packetsOut, cryptOut, authOut, seqOut, compOut, nodeOut, tunnelOut,
    /* Errors */
    badChecksum, badPacketLen, badVersion, badN, badPolicy, badKijAlg,
    badKpAlg, badBlockLen, badMACAlg, badMAC, badCompAlg, badFilter,
    /* Drops */
    dropQueueLimit, dropFrags;

  /**
   * Fill the structure with the current stats
   */
public SkipPacketStats() throws IOException {
  if (comPacketStats() < 0)
    throw new IOException("Cannot read Skip packet statistics");
}

  /**
   * Fills the instance variable with the current stats
   */
private native int comPacketStats();

  /**
   * Returns a hashtable containing name/value pairs for all input statistics
   */
public Hashtable inputValues() {
  Hashtable h = new Hashtable();
  h.put("Packets", new Long(packetsIn));
  h.put("Encrypted", new Long(cryptIn));
  h.put("Authenticated", new Long(authIn));
  h.put("Sequenced", new Long(seqIn));
  h.put("Compressed", new Long(compIn));
  h.put("with Node ID", new Long(nodeIn));
  h.put("Tunnel mode", new Long(tunnelIn));
  return h;
}
  
  /**
   * Returns a hashtable containing name/value pairs for all output statistics
   */
public Hashtable outputValues() {
  Hashtable h = new Hashtable();
  h.put("Packets", new Long(packetsOut));
  h.put("Encrypted", new Long(cryptOut));
  h.put("Authenticated", new Long(authOut));
  h.put("Sequenced", new Long(seqOut));
  h.put("Compressed", new Long(compOut));
  h.put("with Node ID", new Long(nodeOut));
  h.put("Tunnel mode", new Long(tunnelOut));
  return h;
}

  
  /**
   * Returns a hashtable containing name/value pairs for all error statistics
   */
public Hashtable badValues() {
  Hashtable h = new Hashtable();
  h.put("Checksum", new Long(badChecksum));
  h.put("Packet Length", new Long(badPacketLen));
  h.put("Version", new Long(badVersion));
  h.put("N", new Long(badN));
  h.put("Policy", new Long(badPolicy));
  h.put("Kij Algorithm", new Long(badKijAlg));
  h.put("Kp Algorithm", new Long(badKpAlg));
  h.put("Block Length", new Long(badBlockLen));
  h.put("MAC Algorithm", new Long(badMACAlg));
  h.put("MAC", new Long(badMAC));
  h.put("Compression Algorithm", new Long(badCompAlg));
  h.put("Filter", new Long(badFilter));
  return h;
}

  /**
   * Returns a hashtable containing name/value pairs for all drop statistics
   */
public Hashtable dropValues() {
  Hashtable h = new Hashtable();
  h.put("Queue Limit", new Long(dropQueueLimit));
  h.put("Fragments", new Long(dropFrags));
  return h;
}

  /**
   * Returns a hashtable containing all name/value pairs
   */
public Hashtable values() {
  Hashtable h = new Hashtable();
  mergeHashtables(h, inputValues(), "Input ");
  mergeHashtables(h, outputValues(), "Output ");
  mergeHashtables(h, badValues(), "Bad ");
  mergeHashtables(h, dropValues(), "Dropped ");
  return h;
}
  
}
