import java.awt.*;

public class SmartArea extends TextArea {

  /**
   * Some initializers, calling directly the parent
   */
public SmartArea() {
}
public SmartArea(int rows, int columns) {
  super(rows, columns);
}
public SmartArea(String text) {
  super(text);
}
public SmartArea(String text, int rows, int columns) {
  super(text, rows, columns);
}

  /**
   * A smart replaceText method, replacing only what's necessary
   */
public synchronized void replaceText(String str, int start, int end) {
  int len = str.length();
  int unlen = 0;
  String text = getText();
  // Find matching tail
  while (end > start && len > 0
         && text.charAt(end - 1) == str.charAt(len - 1)) {
    end--;
    len--;
  }
  // Find matching head
  while (end > start && len > unlen
         && text.charAt(start) == str.charAt(unlen)) {
    start++;
    unlen++;
  }
  /* Now we could start and find the line endings and copy (differing) line
   * by line. But in our case it isn't necessary (the changes are very local
   */
  // Is there any difference remaining?
  if (start != end || unlen != len)
    super.replaceText(str.substring(unlen, len), start, end);
}

  /**
   * A smart setText method, just being smart enough to call a smart
   * replaceText.
   */
public void setText(String str) {
  replaceText(str, 0, getText().length());
}
  
}
