import java.util.*;
import java.lang.String;

public class SortableHash extends Hashtable {

public SortableHash() {
}

  /**
   * Install it as a copy of the other hashtable
   */
public SortableHash(Hashtable h) {
  Enumeration elements = h.keys();
  while (elements.hasMoreElements()) {
    Object el = elements.nextElement();
    put(el, h.get(el));
  }
}
  
  /**
   * Get a sorted array of keys
   */
public synchronized Object[] getSortedKeys() {
  int count = size();
  Object list[] = new Object[count];
  Enumeration element = keys();

  for (int i = 0; i < count; i++) {
    list[i] = element.nextElement();
  }
  sortInPlace(count, list);
  return list;
}

  /**
   * Primitive bubble sort. Please feel free to improve the speed :-)
   */
private void sortInPlace(int count, Object list[]) {
  for (int i = 0; i < count; i++) {
    for (int j = i + 1; j < count; j++) {
      if (list[i].toString().compareTo(list[j].toString()) > 0) {
        Object swap = list[i];
        list[i] = list[j];
        list[j] = swap;
      }
    }
  }
}

}

