import java.awt.*;
import java.io.IOException;
import java.util.*;
import java.lang.*;

public abstract class Statistics extends Frame implements Runnable {
  VersatileLineChart lc = new VersatileLineChart(40);
  MultipleChoice choices = new MultipleChoice();
  Thread my;
  Hashtable colorList, usedColors;
//  Label label; // Bad modularization, shouldn't be here

public Statistics() throws IOException {
  init();
}
  
public Statistics(String title) throws IOException {
  super(title);
  init();
}

  /**
   * The common part of the constructors
   */
private void init() throws IOException {
  lc.resize(300, 200);
  lc.setBackground(Color.black);
  add("Center", lc);

  colorList = new Hashtable();
  colorList.put(Color.green, Color.green);
  colorList.put(Color.magenta, Color.magenta);
  colorList.put(Color.blue, Color.blue);
  colorList.put(Color.yellow, Color.yellow);
  colorList.put(Color.white, Color.white);
  colorList.put(Color.orange, Color.orange);
  colorList.put(Color.red, Color.red);
  colorList.put(Color.cyan, Color.cyan);
  colorList.put(Color.gray, Color.gray);
//  colorList.put(Color.pink, Color.pink); // Badly visible on gray

  Hashtable scs = newValues();
  choices.setLayout(new GridLayout(scs.size(), 1));
//  usedColors = assignColors(scs, colorList);
  addAllTo(choices, scs, null); // usedColors);
  lc.addMeasure(scs);
  // Get the active buttons from the MultipleChoice, assign colors to
  // them and set these name/color pairs as the curves to be drawn.
  recolor();
  add("West", choices);

  // Debugging
  //  SkipCacheStats scs = new SkipCacheStats();
  //  System.out.println(scs.entryValues().toString());

  // Layout and display
  pack();
  resize(preferredSize());
  show();

  // Start update thread
  my = new Thread(this);
  my.start();
}

public abstract Hashtable newValues() throws IOException;

/**
 * Add all items from the given Hashtable
 */
private void addAllTo(MultipleChoice mc, Hashtable h, Hashtable fgColors) {
  GridBagLayout gridBag = new GridBagLayout();
  mc.setLayout(gridBag);

  GridBagConstraints c = new GridBagConstraints();
  c.gridwidth = GridBagConstraints.REMAINDER;
  c.gridy = GridBagConstraints.RELATIVE;
  c.anchor = GridBagConstraints.WEST;

  Object elements[] = new SortableHash(h).getSortedKeys();
  int count = h.size();
  
  for (int i = 0; i < count; i++) {
    Object el = elements[i];
    Component addEl;
    
    // If it is a String, then add a Checkbox with that label
    // Otherwise, add the element itself
    if (el instanceof String) {
      addEl = new Checkbox((String)el);
      if (fgColors != null) {
        Color color = (Color)fgColors.get(el);
        if (color != null)
          addEl.setForeground(color);
      }
    } else {
      addEl = (Component)el;
    }
    gridBag.setConstraints(addEl, c);
    mc.add(addEl, -1, h.get(el));
  }
  // Add the buttons
  c.gridwidth = 1;
  c.fill = GridBagConstraints.BOTH;
  Button allButton = new Button("All");
  gridBag.setConstraints(allButton, c);
  mc.addSelectAll(allButton, -1);

  Button noneButton = new Button("None");
  gridBag.setConstraints(noneButton, c);
  mc.addSelectNone(noneButton, -1);
  
  // Also let the all/none buttons drop out here
  mc.setHandleButtonsFinally(false);

  // Add a max display
  c.gridwidth = GridBagConstraints.REMAINDER;
  Label label = new Label();
  label.setAlignment(Label.RIGHT);
  gridBag.setConstraints(label, c);
  mc.add(label, -1, null);
  lc.setMaxdisplay(label);

  // Add the relative/absolute buttons
  c.gridwidth = GridBagConstraints.REMAINDER;
  Panel p = new Panel();
  gridBag.setConstraints(p, c);
  mc.add(p, -1, null);
  p.setLayout(new FlowLayout(FlowLayout.LEFT));
  CheckboxGroup group = new CheckboxGroup();
  p.add(new Checkbox("Absolute", group, true));
  p.add(new Checkbox("Relative", group, false));
  p.add(new Checkbox("Delta", group, false));
}
  
/**
 * Returns a Hashtable with all it's elements changed to successive
 * colors from the given ColorList's keys
 */
public Hashtable assignColors(Hashtable h, Hashtable cList) {
  Hashtable result = new Hashtable();
  Enumeration elements = h.keys();
  Enumeration colors = cList.keys();
  while (elements.hasMoreElements()) {
    Object el = elements.nextElement();
    // Make sure we can assign another color
    if (!colors.hasMoreElements()) {
      colors = cList.keys();
    }
    Object color = colors.nextElement();

    // Assign the color found to the list
    result.put(el, color);
  }
  return result;
}

/**
 * Returns a Hashtable with all it's elements changed to the appropriate
 * colors from the given colorList
 */
public Hashtable findColors(Hashtable h, Hashtable cList) {
  Hashtable result = new Hashtable();
  Enumeration elements = h.keys();
  while (elements.hasMoreElements()) {
    Object el = elements.nextElement();
    // Assign the color found to the list
    result.put(el, cList.get(el));
  }
  return result;
}

public void recolor() {
  // Get the active buttons from the MultipleChoice, assign colors to
  // them and set these name/color pairs as the curves to be drawn.
  usedColors = assignColors(choices.activeElements(), colorList);
  lc.setColors(usedColors);
  // Recolor the buttons
  Component components[] = choices.getComponents();
  for (int i = 0; i < choices.countComponents(); i++) {
    if (components[i] instanceof Checkbox) {
      Checkbox cb = (Checkbox)components[i];
      Color c = (Color)usedColors.get(cb.getLabel());
      if (c == null)
        c = Color.black;
      if (!c.equals(cb.getForeground()))
        cb.setForeground(c);
    }
  }
}

public boolean action(Event evt, Object arg) {
  // Find out whether we need to change the display mode
  if (evt.target instanceof Checkbox) {
    String label = ((Checkbox)evt.target).getLabel();
    if ("Absolute".equals(label))
      lc.absoluteMode();
    else if ("Relative".equals(label))
      lc.relativeMode();
    else if ("Delta".equals(label))
      lc.deltaMode();
  }
  // In any case, they might have been changed, so recompute the
  // curves and their color assignments.
  recolor();
  return super.action(evt, arg);
}

public void run() {
  while (true) {
    try {
      my.sleep(2000);
    } catch (InterruptedException e) {
      // Do nothing useful!
      System.out.println(e.toString());
    }
    try {
      lc.addMeasure(newValues());
    } catch (IOException e) {
      // Do nothing useful!
      System.out.println(e.toString());
    }
  }
}
  
public boolean handleEvent(Event evt) {
  // Handle WM Quit message
  if (evt.id == Event.WINDOW_DESTROY) {
    my.stop();
    dispose();
    return true;
  }
  return super.handleEvent(evt); // be sure to do this!!!
}

}
