import java.util.*;

public class VersatileLineChart extends RelativeLineChart {
  boolean deltaInhibit = true;
  Hashtable lastMeasure;
  
public VersatileLineChart() {
}

public VersatileLineChart(int c) {
  super(c);
}

  /**
   * Make it run like a LineChart.
   */
public synchronized void absoluteMode() {
  if (deltaInhibit != true || getBase() != null) {
    // We need to change the attributes
    deltaInhibit = true;
    setBase(null);
    // And forget all the samples collected with another method
    forgetSamples();
    repaint();
  }
}

  /**
   * Make it run like a RelativeLineChart.
   */
public synchronized void relativeMode() {
  // Always set the new mode (because we want a new base measure)
  deltaInhibit = true;
  setBase(lastMeasure);
  forgetSamples();
  repaint();
}

  /**
   * Make it run like a DeltaLineChart.
   */
public synchronized void deltaMode() {
  if (deltaInhibit == true) {
    // Yes, we need to change it
    deltaInhibit = false;
    setBase(lastMeasure);
    forgetSamples();
    repaint();
  }
}
  
  /**
   * Calling this method does the same thing as the parent method, but
   * it only adds the deltas to the previous measure
   */
public synchronized void addMeasure(Hashtable measure) {
  lastMeasure = measure;
  super.addMeasure(measure);
  // Set this measure as the base for the next measure, effectively
  // showing delta measures
  if (!deltaInhibit)
    setBase(measure);
}

}
