/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
/* cert.h -- (c) by G. Caronni, M. Hauber and C. Schneider in 1995
 *
 * Author: G. Caronni 		Date of creation: 18.11.95
 *
 * $Id: cert.h,v 1.2 1995/12/21 16:40:20 skip Rel $
 *
 * Description:
 * Interface to the certificate part of the skip daemon
 *
 * $Log: cert.h,v $
 * Revision 1.2  1995/12/21  16:40:20  skip
 * .
 *
 * Revision 1.1  1995/12/21  16:40:20  skip
 * Release 0.20 (pre-alpha)
 *
 */

#ifndef CERT__H
#define CERT__H

#ifndef IN_CERT
/* the reply function gets this structure.
 * it can be *read* in the receiver, but may not be remembered otherwise.
 * THIS IS READ-ONLY DATA! DO NOT MODIFY OR COPY -- CONTAINS POINTERS
 * This structure is actually larger than the exported part. 
 */
typedef struct dh_data {
    int secret_len;             /* number of valid bytes in shared secret */
    u_char *secret;             /* shared secret, MSB first, without n */
    u_long oip[4];              /* own and remote IPv6 addresses, v4 addr */
    u_long rip[4];              /* is in the first 4 bytes. add ports later */
    u_char ons;                 /* own and remote NSID */
    u_char rns; 
    u_char *omk;                /* own and remote master key ID */
    u_char *rmk; 
    u_char old_ons;             /* own and remote NSID -- currently the same */
    u_char old_rns;             /* as above. This might change in the future */
    u_char *old_omk;            /* if and when lookup gets smart enough to */
    u_char *old_rmk;            /* find 'related' keys */
    int ireq;                   /* for the SKIP cache - as in cert_discover */
    /* ... */                    /* OPAQUE - see dh_data in cert_global.h */
} dh_data;
#endif


/* waits for io on the udp sockets. returns either when an event has
 * been processed, io has been performed, or a signal interrupted the
 * select() system call. 
 */
extern int cert_iowait(void);


/* is called when a cert_reply is needed by the skip cache 
 * lookup_hosts contains IP addresses of hosts to ask, nr contains
 * the amount of addresses. The direct partner will always be asked
 * first 
 * Format of IP addresses is network byte order
 */
extern void cert_discover(u_long *oip,  /* own and remote IPv6 address */
			  u_long *rip,  /* add ports later! */
			  u_char ons,   /* own and remote NSID */
			  u_char rns, 
			  u_char *omk,  /* own and remote master key ID */
		          u_char *rmk, 
			  int lookup_nr, 
			  u_long *lookup_hosts, /* IP v6 size */
			  int ireq      /* hint for reply to skipcache */
			  );


/* does all cert dependant initializations, returns 0 if successful 
 * gets the function that is to be called with certificate replies 
 */
extern int cert_init(void (*skipd_receiver)(dh_data *reply), char *basedir);


/* clears all data associated with certificate management 
 * and releases all sockets. Call this only if you have unexported
 * all dh_data structures the receiver got via cert_drop();
 */
extern void cert_exit(void);


/* dumps the internal state of the cert part for debugging purposes 
 * Not yet implemented...
 */
extern void cert_dump(FILE *f);


#endif
