/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"

#include "skip_defs.h"
#include "cert.h"

#ifdef __GNUC__
#ident "$Id: cert_test.c,v 1.3 1996/04/25 15:00:43 cschneid Exp $"
#else
static char rcsid[] = "$Id: cert_test.c,v 1.3 1996/04/25 15:00:43 cschneid Exp $";
#endif

static void (*skip_recv)(dh_data *reply);

int cert_iowait()
{
  pause();
  return 0;
}

void cert_discover(u_long *oip,  /* own and remote IPv6 address */
                   u_long *rip,  /* add ports later! */
                   u_char ons,   /* own and remote NSID */
                   u_char rns, 
                   u_char *omk,  /* own and remote master key ID */
                   u_char *rmk, 
                   int lookup_nr, 
                   u_long *lookup_hosts, /* IP v6 size */
                   int ireq      /* hint for reply to skipcache */
                   )
{
  static dh_data d;
  static u_char kij[SKIP_KIJ_MAXLEN];
  
  MEMZERO(&d, sizeof(d));
  MEMCPY(d.oip, oip, IPADDRSIZE);
  MEMCPY(d.rip, rip, IPADDRSIZE);
  d.ons = d.old_ons = ons;
  d.rns = d.old_rns = rns;
  d.omk = d.old_omk = omk;
  d.rmk = d.old_rmk = rmk;

  d.ireq = ireq;
  d.secret = kij;
  d.secret_len = sizeof(kij);	    /* 0 means that no shared secret is available */

  skip_recv(&d);  
}

int cert_init(void (*skipd_receiver)(dh_data *reply), char *path)
{
  skip_recv = skipd_receiver;
  return 0;
}

void cert_exit()
{
}
