/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"

#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "ipsp.h"
#include "com.h"
#include "crypt.h"
#include "req.h"
#include "inet_aton.h"

#ifdef __GNUC__
#ident "$Id: skip_attach.c,v 1.6 1996/04/25 15:00:43 cschneid Exp $"
#else
static char rcsid[] = "$Id: skip_attach.c,v 1.6 1996/04/25 15:00:43 cschneid Exp $";
#endif

int main(int argc, char *argv[], char *envp[])
{
  int result = 0;
  struct skipreq_hdr hdr;

  if (argc < 2)
  {
    fprintf(stderr, "Usage: skip_attach <ipaddr>\n");
    return 1;
  }

  if (com_init() < 0)
  {
    fprintf(stderr, "%s: SKIP module not found\n", argv[0]);
    return 1;
  }

  MEMZERO(&hdr, sizeof(hdr));
  hdr.req = SKIPREQ_ATTACH;
  inet_aton(argv[1], (struct in_addr *) hdr.srcip);

  if (com_request((u_char *)&hdr, sizeof(hdr)) != sizeof(hdr))
  {
    fprintf(stderr, "Failed to attach to interface\n");
    result = 2;
  }
  else
    fprintf(stderr, "Attached to interface\n");

  com_exit();

  return result;
}
