/*
 * Copyright (C) 1995,1997 M. Hauber, Ch. Schneider, G. Caronni, R. Muchsel
 * See COPYING for more details
 */
#include "config.h"
#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "ipsp.h"
#include "com.h"
#include "crypt.h"
#include "req.h"
#include "parse.h"

#ifdef __GNUC__
#ident "$Id: skip_dump.c,v 1.4 1996/04/25 15:00:43 cschneid Exp $"
#else
static char rcsid[] = "$Id: skip_dump.c,v 1.4 1996/04/25 15:00:43 cschneid Exp $";
#endif


static int dumpentry(char *id)
{
  u_char buf[16 * 1024];
  int len, res = 0;
  struct skipreq_hdr *hdr = (struct skipreq_hdr *)buf;

  MEMZERO(hdr, sizeof(*hdr));
  hdr->req = SKIPREQ_DUMP;

  if (id_parseids(id, &hdr->id) == 0)
  {
    if ((len = com_request((u_char *)buf, sizeof(buf))) <= 0)
    {
      fprintf(stderr, "Failed to dump entry.\n");
      res = -1;
    }
    else
    {
      struct skipcache *c = (struct skipcache *)buf;

      c->data = (u_char *)(c + 1);
      c->next = NULL;

      parse_save(c, stdout);

      /* print additional dynamic fields */

      /* shared secret */
      /* Cannot print shared secrets, since they are only in the secondary
         cache!! 
      if ((c->flags & SKIP_MANUALKEY) == 0)
      {
        printf("  shared secret (len=%i): ", c->sharedkey.len);
        id_printnicehex(stdout, c->data + c->sharedkey.offset, c->sharedkey.len);
        printf("\n");
      }
      */
      /* 3 * Kijn + n */
      printf("  Kijn (n = %u) = ", c->Kijn[0].n);
      id_printnicehex(stdout, c->data + c->Kijn[0].key.offset, c->Kijn[0].key.len);
      printf("\n");
      printf("  Kijn (n = %u) = ", c->Kijn[1].n);
      id_printnicehex(stdout, c->data + c->Kijn[1].key.offset, c->Kijn[1].key.len);
      printf("\n");
      printf("  Kijn (n = %u) = ", c->Kijn[2].n);
      id_printnicehex(stdout, c->data + c->Kijn[2].key.offset, c->Kijn[2].key.len);
      printf("\n");
      /* enskip_A_Kp, enskip_E_Kp */
      printf("  enskip_A_Kp = ");
      id_printnicehex(stdout, c->data + c->enskip_A_Kp.offset, c->enskip_A_Kp.len);
      printf("\n");
      printf("  enskip_E_Kp = ");
      id_printnicehex(stdout, c->data + c->enskip_E_Kp.offset, c->enskip_E_Kp.len);
      printf("\n");
      /* enskip_Kp_Kijn */
      printf("  enskip_Kp_Kijn (n = %u) = ", c->enskip_Kp_Kijn.n);
      id_printnicehex(stdout, c->data + c->enskip_Kp_Kijn.key.offset, c->enskip_Kp_Kijn.key.len);
      printf("\n");
      /* enskip_Kp_bytes + enskip_Kp_ttl */
      printf("  enskip_Kp_bytes = %d\n", c->enskip_Kp_bytes);
      printf("  enskip_Kp_ttl = %d\n", c->enskip_Kp_ttl);
      /* enskip_MI */
      printf("  enskip_MI = ");
      id_printnicehex(stdout, c->data + c->enskip_MI.offset, c->enskip_MI.len);
      printf("\n");
      /* deskip_Kij_alg */
      printf("  deskip_Kij_alg = %u\n", c->deskip_Kij_alg);
      /* deskip_Crypt_alg */
      printf("  deskip_Kp_Kijn_len = %u\n", c->deskip_Kp_Kijn_len);
      /* deskip_Kp_Kijn */
      printf("  deskip_Kp_Kijn (n = %u) = ", c->deskip_Kp_Kijn.n);
      id_printnicehex(stdout, c->data + c->deskip_Kp_Kijn.key.offset, c->deskip_Kp_Kijn_len);
      printf("\n");
      /* deskip_A_Kp, deskip_E_Kp */
      printf("  deskip_A_Kp = ");
      id_printnicehex(stdout, c->data + c->deskip_A_Kp.offset, c->deskip_A_Kp.len);
      printf("\n");
      printf("  deskip_E_Kp = ");
      id_printnicehex(stdout, c->data + c->deskip_E_Kp.offset, c->deskip_E_Kp.len);
      printf("\n");
    }
  }
  return res;
}

static int listcache(void)
{
    u_char buf[16 * 1024];
    int len, res = 0;
    struct skipreq_hdr *hdr = (struct skipreq_hdr *)buf;

    MEMZERO(hdr, sizeof(*hdr));
    hdr->req = SKIPREQ_LISTCACHE;

    if ((len = com_request((u_char *)buf, sizeof(buf))) <= 0) {
        fprintf(stderr, "Failed to list cache.\n");
        res = -1;
    } else {
        struct skipreq_listcache *l = (struct skipreq_listcache *)buf;
	int i;
        printf("Max. Hash: %d   Max. Entries: %d   Entries: %d\n",
			HASHTBLSIZE, l->cache_maxentries, l->cache_entries);
        for (i=0;i<HASHTBLSIZE; i++) {
	    printf("%01X",l->hash_depth[i]>15?15:l->hash_depth[i]);
	}
	printf("\n");

        for (i=0;i<l->cache_entries; i++) {
	    id_saveids(stdout,&l->entry[i]);
	}
    }

    return res;
}

int main(int argc, char *argv[], char *envp[])
{
  int res = 0;

  if (argc !=1 && argc != 2)
  {
    fprintf(stderr, "Usage: skip_dump [nsid-masterkeyid,nsid-masterkeyid]\n");
    return 1;
  }

  if (com_init() < 0)
  {
    fprintf(stderr, "%s: SKIP module not found\n", argv[0]);
    return 1;
  }

  if (argc == 2) {
      res = dumpentry(argv[1]);
  } else {
      res = listcache();
  }

  com_exit();

  return res;
}
