/*
 * Copyright (C) 1995 M. Hauber, Ch. Schneider, G. Caronni
 * See COPYING for more details
 */
#include "config.h"
#include "skip_defs.h"
#include "dynamic.h"
#include "memblk.h"
#include "skipcache.h"
#include "ipsp.h"
#include "com.h"
#include "crypt.h"
#include "req.h"

#ifdef __GNUC__
#ident "$Id: skip_stat.c,v 1.6 1996/04/25 15:00:43 cschneid Exp $"
#else
static char rcsid[] = "$Id: skip_stat.c,v 1.6 1996/04/25 15:00:43 cschneid Exp $";
#endif

int main(int argc, char **argv)
{
  int result = 0;
  struct skipreq_statipsp ipsp;
  struct skipreq_statcache cache;

  if (com_init() < 0)
  {
    fprintf(stderr, "%s: SKIP module not found\n", argv[0]);
    return 1;
  }

  ipsp.hdr.req = SKIPREQ_STATIPSP;

  if (com_request((u_char *)&ipsp, sizeof(ipsp)) == sizeof(ipsp))
  {
    printf("ipsp:\n");
    printf("\t%lu total packets received\n", ipsp.stat.in);
    printf("\t%lu encrypted\n", ipsp.stat.crypt_in);
    printf("\t%lu authenticated\n", ipsp.stat.auth_in);
    printf("\t%lu sequenced\n", ipsp.stat.seq_in);
    printf("\t%lu compressed\n", ipsp.stat.comp_in);
    printf("\t%lu with node ID\n", ipsp.stat.node_in);
    printf("\t%lu in tunnel mode\n", ipsp.stat.tunnel_in);
    printf("\t%lu with bad ip checksum\n", ipsp.stat.badipsum);
    printf("\t%lu with bad length (too short)\n", ipsp.stat.badpktlen);
    printf("\t%lu with bad SKIP version\n", ipsp.stat.badversion);
    printf("\t%lu with count N out of range\n", ipsp.stat.badn);
    printf("\t%lu with policy violation\n", ipsp.stat.badpolicy);
    printf("\t%lu with unknown Kij algorithm\n", ipsp.stat.badKijalg);
    printf("\t%lu with unknown Kp algorithm\n", ipsp.stat.badKpalg);
    printf("\t%lu with unassigned block length\n", ipsp.stat.badblklen);
    printf("\t%lu with unknown MAC algorithm\n", ipsp.stat.badMACalg);
    printf("\t%lu with incorrect MAC\n", ipsp.stat.badMAC);
    printf("\t%lu with unknown Comp algorithm\n", ipsp.stat.badCompalg);
    printf("\t%lu with bad protocol for filter\n", ipsp.stat.badfilter);

    printf("\t%lu total packets sent\n", ipsp.stat.out);
    printf("\t%lu encrypted\n", ipsp.stat.crypt_out);
    printf("\t%lu authenticated\n", ipsp.stat.auth_out);
    printf("\t%lu sequenced\n", ipsp.stat.seq_out);
    printf("\t%lu compressed\n", ipsp.stat.comp_out);
    printf("\t%lu with node ID\n", ipsp.stat.node_out);
    printf("\t%lu in tunnel mode\n\n", ipsp.stat.tunnel_out);

    printf("\t%lu packets dropped due to queue limits\n", ipsp.stat.queuelimit);
    printf("\t%lu packets fragments dropped\n", ipsp.stat.fragdrop);
  }
  else
  {
    fprintf(stderr, "Failed to retrieve SKIP IPSP statistics.\n");
    result++;
  }

  cache.hdr.req = SKIPREQ_STATCACHE;

  if (com_request((u_char *)&cache, sizeof(cache)) == sizeof(cache))
  {
    printf("\ncache:\n");
    printf("\t%lu entries in cache\n", cache.stat.entries);
    printf("\t%lu entries inserted\n", cache.stat.inserted);
    printf("\t%lu entries updated\n", cache.stat.updated);
    printf("\t%lu entries timed out\n", cache.stat.timedout);
    printf("\t%lu entries removed\n", cache.stat.removed);
    printf("\t%lu lookup hits\n", cache.stat.lookuphits);
    printf("\t%lu lookup requests\n", cache.stat.lookuprequests);
  }
  else
  {
    fprintf(stderr, "Failed to retrieve SKIP cache statistics.\n");
    result++;
  }

  com_exit();

  return result;
}
