#include "config.h"
#include <sys/proc.h>

#ifdef __GNUC__
#ident "$Id: com.c,v 1.7 1996/04/25 14:56:44 cschneid Exp $"
#else
static char rcsid[] = "$Id: com.c,v 1.7 1996/04/25 14:56:44 cschneid Exp $";
#endif

static pid_t daemonpid;

int com_register(pid_t pid)
{
  daemonpid = pid;
  return 0;
}

int com_signal(int sig)
{
  if (daemonpid)
  {
    proc_t *proc = prfind(daemonpid);

    if (proc)
      psignal(proc, sig);
    else
      daemonpid = 0;  /* Daemon probably died, don't send any more signals */
  }

  return 0;
}
