/*
 * All system depending ressources are defined as a macro in this file
 */

#ifndef SOLARIS_CONFIG_H
#define SOLARIS_CONFIG_H

#define CERTDIR		"/etc/cert"
#define CONFIGFILE	"/etc/skipd.conf"
#define LOGFILE         "/var/log/skipd.log"

#ifdef KERNEL
#define _KERNEL 1
#endif /* KERNEL */
 
#include <sys/types.h>
/*
 * some functions to convert values from network byte order and inverse
 */
#include <sys/param.h>

typedef int int32;
typedef u_int u_int32;
typedef u_short u_int16;
typedef u_char u_int8;

/* Get __LITTLE_ENDIAN_ or __BIG_ENDIAN__ */
#include <sys/byteorder.h>

#ifdef _LITTLE_ENDIAN

/* no, we are on a big endian machine !!! */

#define SKIP_HTONL(x)		((((x) >> 24) & 0xFF) | \
                                 (((x) >> 8) & 0xFF00) | \
                                 (((x) << 8) & 0xFF0000) | \
				 (((x) << 24)))
#define SKIP_NTOHL(x)		SKIP_HTONL((x))
#define SKIP_HTONS(x)		((((x) >> 8) & 0xFF) | (((x) << 8)))
#define SKIP_NTOHS(x)		SKIP_HTONS((x))
#else
#define SKIP_HTONL(x) (x)
#define SKIP_NTOHL(x) (x)
#define SKIP_HTONS(x) (x)
#define SKIP_NTOHS(x) (x)
#endif /* _LITTLE_ENDIAN */


#ifdef KERNEL

#include <sys/cmn_err.h>
#include <sys/kmem.h>
#include <sys/kmem_impl.h>

#define KALLOC(size)		kmem_alloc((size), KM_SLEEP)
#define KFREE(ptr, size)	kmem_free((ptr), (size)); (ptr) = (void *)0

#include <sys/systm.h>

/* MEMCMP should return 0, if areas match */
#define MEMCMP(a, b, size)	bcmp((caddr_t)(a), (caddr_t)(b), (size))
#define MEMCPY(to, from, size)	bcopy((caddr_t)(from), (caddr_t)(to), (size))
#define MEMZERO(a, size)	bzero((caddr_t)(a), (size))

#include <sys/ddi.h>
int timeout_id;
#define TIMEOUT(func, arg, sec)	timeout_id = timeout((void *)(func), (arg), drv_usectohz(1000000 * (sec)))
#define UNTIMEOUT(func, arg)	untimeout(timeout_id)


#ifndef USE_MUTEX
#include <sys/semaphore.h>

#define SEMTYPE			ksema_t *
#define SEMALLOC(s)		(s) = (SEMTYPE)KALLOC(sizeof(*s))
#define SEMINIT(s)		sema_init((s), 1, "skip", SEMA_DRIVER, NULL)
#define SEMLOCK(s)		sema_p(s)
#define SEMUNLOCK(s)		sema_v(s)
/*
 * SEMLOCKTRY should try to lock the semaphore
 * if the semaphore is lock 0 is returned.
 */
#define SEMLOCKTRY(s)		!sema_tryp((s))
#define SEMFREE(s)		sema_p(s); sema_destroy(s); KFREE((s), sizeof(*s));

#else
#include <sys/ksynch.h>

#define SEMTYPE			kmutex_t *
#define SEMALLOC(s)		(s) = (SEMTYPE)KALLOC(sizeof(*s))
#define SEMINIT(s)		mutex_init((s), "skip mutex", MUTEX_DRIVER, NULL)
#define SEMLOCK(s)		mutex_enter(s)
#define SEMUNLOCK(s)		mutex_exit(s)
/*
 * SEMLOCKTRY should try to lock the semaphore
 * if the semaphore is lock 0 is returned.
 */
#define SEMLOCKTRY(s)		!mutex_tryenter((s))
#define SEMFREE(s)		mutex_destroy(s); KFREE((s), sizeof(*s));
#endif

#include <sys/cpuvar.h>
#undef u  /* Remove annoying define */
#define SEEDTYPE		cpu_t
#define SEEDINIT(s)		MEMCPY(s, cpu_list, sizeof(*s))

#include <sys/time.h>
#define GMTSECONDS              tod_get().tv_sec

/*
 * type definition for queues in cache
 */
#include <sys/stream.h>

typedef struct skip_ifq
{
  mblk_t *ifq_head, *ifq_tail;
  int ifq_len;
  int ifq_maxlen;
} QUEUE;

extern int queue_free(void *c);
extern int queue_feed(void *c);

#define SKIP_FREEQ(x)		  queue_free((x))
#define SKIP_FEEDQ(x)		  queue_feed((x))

#ifndef NULL
#define NULL	(void *)0
#endif /* NULL */


#else /* IF NOT KERNEL */

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
 
#define KALLOC(size)            malloc((size))
#define KFREE(ptr, size)        free((ptr))

/* MEMCMP should return 0, if areas match */
#define MEMCMP(a, b, size)      memcmp((caddr_t)(a), (caddr_t)(b), (size))
#define MEMCPY(to, from, size)  memcpy((caddr_t)(to), (caddr_t)(from), (size))
#define MEMZERO(a, size)        memset((caddr_t)(a), '\0', (size))
 
#include <signal.h>
#include <unistd.h>

static int (*to_func)(void *);
static void *to_arg;
 
static void sig_hdl(int sig)
{
  signal(sig, sig_hdl);
  if (to_func)
    to_func(to_arg);
}
 
#define TIMEOUT(func, arg, sec) to_func = (func), to_arg = (arg), signal(SIGALRM , sig_hdl), alarm((sec))
#define UNTIMEOUT(func, arg)    to_func = NULL, alarm(0)
 
/* no semaphores at user level */
#define SEMTYPE                 int
#define SEMALLOC(s)
#define SEMINIT(s)              s = 0;  /* Avoid compiler warnings */
#define SEMLOCK(s)
#define SEMUNLOCK(s)
/*
 * SEMLOCKTRY should try to lock the semaphore
 * if the semaphore is lock 0 is returned.
 */
#define SEMLOCKTRY(s)           0
#define SEMFREE(s)
 
#include <sys/time.h>
#define SEEDTYPE                struct timeval
#define SEEDINIT(s)             gettimeofday((s), NULL)
 
#include <sys/time.h>
#define GMTSECONDS              time(NULL)
 
#define SKIP_FREEQ(x) 
#define SKIP_FEEDQ(x)
 
#ifndef NULL
#define NULL    (void *)0
#endif /* NULL */

#endif /* KERNEL */

#ifndef IP_CE
#define IP_CE 0x8000	/* Flag "Congestion" */
#endif

#endif /* SOLARIS_CONFIG_H */
