#include "config.h"
#include <sys/stream.h>
#include <netinet/in.h>
#include <netinet/in_systm.h>
#include <netinet/ip.h>
#include "skip_defs.h"
#include "memblk.h"
#include "dynamic.h"
#include "skipcache.h"
#include "queue.h"
#include "interface.h"

#ifdef __GNUC__
#ident "$Id: queue.c,v 1.8 1996/04/25 14:56:44 cschneid Exp $"
#else
static char rcsid[] = "$Id: queue.c,v 1.8 1996/04/25 14:56:44 cschneid Exp $";
#endif

static SEMTYPE semaphore;

int queue_enqueuein(struct skipcache *c, void *interface, void *headerptr,
		    void *mptr)
{
  mblk_t *header = (mblk_t *)headerptr, *m = (mblk_t *)mptr;
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

#if 0
  printf(">>queue_enqueuein: prev len = %d\n", q->inq.ifq_len);
#endif

  SEMLOCK(semaphore);
  /* limit reached? */
  if ((q->inq.ifq_maxlen <= 0) || (q->inq.ifq_maxlen > q->inq.ifq_len))
  {
    mblk_t *info;

    /* enqueue */
    if ((info = allocb(sizeof(interface) + 2 * IPADDRSIZE, BPRI_LO)))
    {
      struct ip *ip = (struct ip *)m->b_rptr;

      /* Build info block containing interface and src/dst ips */
      MEMCPY(info->b_wptr, &interface, sizeof(interface));
      info->b_wptr += sizeof(interface);
      MEMZERO(info->b_wptr, 2 * IPADDRSIZE);
      MEMCPY(info->b_wptr, &ip->ip_src, sizeof(ip->ip_src));
      MEMCPY(info->b_wptr + IPADDRSIZE, &ip->ip_dst, sizeof(ip->ip_dst));
#if 0
printf(">>queue_enqueuein: src=%u.%u.%u.%u/ dst=%u.%u.%u.%u\n",
       info->b_wptr[0], info->b_wptr[1], info->b_wptr[2], info->b_wptr[3],
       info->b_wptr[16], info->b_wptr[17], info->b_wptr[18], info->b_wptr[19]);

#endif
      info->b_wptr += 2 * IPADDRSIZE;

      /* Queue both header and m */
      if (header)
      {
	linkb(header, m);
	m = header;
      }

      info->b_cont = m;
      m = info;

      m->b_next = NULL;
      if (q->inq.ifq_tail == NULL)
      {
	m->b_prev = NULL;
	q->inq.ifq_head = q->inq.ifq_tail = m;
      }
      else
      {
	m->b_prev = q->inq.ifq_tail;
	q->inq.ifq_tail->b_next = m;
	q->inq.ifq_tail = m;
      }

      q->inq.ifq_len++;
      result = 0;
    }
  }
  SEMUNLOCK(semaphore);

  return result;
}

int queue_enqueueout(struct skipcache *c, void *interface, void *headerptr,
		     void *mptr)
{
  mblk_t *header = (mblk_t *)headerptr, *m = (mblk_t *)mptr;
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

#if 0
  printf(">>queue_enqueueout: prev len = %d\n", q->outq.ifq_len);
#endif
  SEMLOCK(semaphore);
  /* limit reached? */
  if ((q->outq.ifq_maxlen <= 0) || (q->outq.ifq_maxlen > q->outq.ifq_len))
  {
    mblk_t *info;

    /* enqueue */
    if ((info = allocb(sizeof(interface) + 2 * IPADDRSIZE, BPRI_LO)))
    {
      struct ip *ip = (struct ip *)m->b_rptr;

      /* Build info block containing interface and src/dst ips */
      MEMCPY(info->b_wptr, &interface, sizeof(interface));
      info->b_wptr += sizeof(interface);
      MEMZERO(info->b_wptr, 2 * IPADDRSIZE);
      MEMCPY(info->b_wptr, &ip->ip_src, sizeof(ip->ip_src));
      MEMCPY(info->b_wptr + IPADDRSIZE, &ip->ip_dst, sizeof(ip->ip_dst));
      info->b_wptr += 2 * IPADDRSIZE;

      /* Queue both header and m */
      if (header)
      {
	linkb(header, m);
	m = header;
      }

      info->b_cont = m;
      m = info;

      m->b_next = NULL;
      if (q->outq.ifq_tail == NULL)
      {
	m->b_prev = NULL;
	q->outq.ifq_head = q->outq.ifq_tail = m;
      }
      else
      {
	m->b_prev = q->outq.ifq_tail;
	q->outq.ifq_tail->b_next = m;
	q->outq.ifq_tail = m;
      }
      
      q->outq.ifq_len++;
      result = 0;
    }
  }
  SEMUNLOCK(semaphore);

  return result;
}

int queue_getips(struct skipcache *c, u_char *srcip, u_char *dstip)
{
  int result = -1;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);
  mblk_t *m;

  SEMLOCK(semaphore);

  if ((m = q->inq.ifq_head) == NULL)
    m = q->outq.ifq_head;

  if (m)
  {
    MEMCPY(srcip, m->b_rptr + sizeof(void *), IPADDRSIZE);
    MEMCPY(dstip, m->b_rptr + sizeof(void *) + IPADDRSIZE, IPADDRSIZE);
    result = 0;
  }
  
  SEMUNLOCK(semaphore);

#if 0
  printf(">>queue_getips: %d\n", result);
  if (result == 0)
  {
    printf(">>queue_getips: srcip %u.%u.%u.%u, dstip %u.%u.%u.%u\n",
	   srcip[0], srcip[1], srcip[2], srcip[3],
	   dstip[0], dstip[1], dstip[2], dstip[3]);
  }
#endif
  return result;
}

int queue_free(void *x)
{
  struct skipcache *c = (struct skipcache *)x;
  mblk_t *walk = NULL, *next;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

#if 0
  printf(">>queue_free: in %d, out %d\n", q->inq.ifq_len, q->outq.ifq_len);
#endif
  SEMLOCK(semaphore);
  for (walk = q->inq.ifq_head; walk; walk = next)
  {
    next = walk->b_next;
    freemsg(walk);
  }
  q->inq.ifq_head = q->inq.ifq_tail = NULL;
  q->inq.ifq_len = 0;

  for (walk = q->outq.ifq_head; walk; walk = next)
  {
    next = walk->b_next;
    freemsg(walk);
  }
  q->outq.ifq_head = q->outq.ifq_tail = NULL;
  q->outq.ifq_len = 0;
  SEMUNLOCK(semaphore);

  return 0;
}

int queue_feed(void *x)
{
  struct skipcache *c = (struct skipcache *)x;
  mblk_t *in, *out, *walk = NULL, *next;
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

#if 0
  printf(">>queue_feed: in %d, out %d\n", q->inq.ifq_len, q->outq.ifq_len);
#endif

  SEMLOCK(semaphore);
  in = q->inq.ifq_head;
  q->inq.ifq_head = q->inq.ifq_tail = NULL;
  q->inq.ifq_len = 0;
  out = q->outq.ifq_head;
  q->outq.ifq_head = q->outq.ifq_tail = NULL;
  q->outq.ifq_len = 0;
  SEMUNLOCK(semaphore);

  for (walk = in; walk; walk = next)
  {
    mblk_t *info;
    void *interface;

    next = walk->b_next;
    walk->b_next = NULL;

    info = walk;
    walk = walk->b_cont;
    MEMCPY(&interface, info->b_rptr, sizeof(interface));
    freeb(info);

    interface_infeedback(interface, walk);
  }

  for (walk = out; walk; walk = next)
  {
    mblk_t *info;
    void *interface;

    next = walk->b_next;
    walk->b_next = NULL;

    info = walk;
    walk = walk->b_cont;
    MEMCPY(&interface, info->b_rptr, sizeof(interface));
    freeb(info);

    interface_outfeedback(interface, walk);
  }

  return 0;
}

int queue_initqueues(struct skipcache *c)
{
  struct _kernel_queue *q = (struct _kernel_queue *)(c->data + c->q.offset);

  q->inq.ifq_maxlen = q->outq.ifq_maxlen = QUEUESIZE;
  return 0;
}

int queue_init(void)
{
  SEMALLOC(semaphore);
  SEMINIT(semaphore);
  return 0;
}

int queue_exit(void)
{
  SEMFREE(semaphore);
  return 0;
}
