/* -*-Mode: C;-*-
 * Xdelta - A binary delta library
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el 1.7 Thu, 11 Mar 1999 02:19:42 -0800 jmacd $
 */

#include "edsio.h"

/* Declarations. */

static const char* Edsio_StringString_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_Source_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_Void_event_field_to_string (GenericEvent* ev, gint field);
static const char* Edsio_IntInt_event_field_to_string (GenericEvent* ev, gint field);

/* initialize this library. */

gboolean
edsio_edsio_init (void)
{
  static gboolean once = FALSE;
  static gboolean result = FALSE;
  if (once) return result;
  once = TRUE;
  eventdelivery_initialize_event_def (EC_EdsioInvalidIntegerSignValue, EL_Error, EF_None, "InvalidIntegerSign", "${0}: expected an unsigned integer: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIntegerOutOfRangeValue, EL_Error, EF_None, "IntegerOutOfRange", "${0}: integer out of range: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidIntegerStringValue, EL_Error, EF_None, "InvalidIntegerString", "${0}: not an integer: ${1}", & Edsio_StringString_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioIncorrectAllocationValue, EL_Error, EF_None, "IncorrectAllocation", "${0}: Incorrect allocation", & Edsio_Source_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioSourceEofValue, EL_Error, EF_None, "SourceEof", "${0}: Unexpected EOF", & Edsio_Source_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidChecksumValue, EL_Error, EF_None, "InvalidChecksum", "Checksum verification failed", & Edsio_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioMissingChecksumValue, EL_Error, EF_None, "MissingChecksum", "Missing embedded checksum in base64 encoding", & Edsio_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioInvalidBase64EncodingValue, EL_Error, EF_None, "InvalidBase64Encoding", "Invalid base64 encoding", & Edsio_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioOutputBufferShortValue, EL_Error, EF_None, "OutputBufferShort", "Output buffer is too short", & Edsio_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioUnexpectedTypeValue, EL_Error, EF_None, "UnexpectedType", "Unexpected serial type", & Edsio_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioUnexpectedLibraryTypeValue, EL_Error, EF_None, "UnexpectedLibraryType", "Unexpected serial library type: expected ${0}, received ${1}", & Edsio_IntInt_event_field_to_string);
  eventdelivery_initialize_event_def (EC_EdsioUnregisteredTypeValue, EL_Error, EF_None, "UnregisteredType", "Unregistered serial type: library=${0} number=${1}", & Edsio_IntInt_event_field_to_string);
  result = TRUE;
  return TRUE;
};

void
edsio_generate_intint_event_internal (EdsioIntIntEventCode _code, const char* _srcfile, gint _srcline, int library, int number)
{
  EdsioIntIntEvent *_e = g_new0 (EdsioIntIntEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->library = library;
  _e->number = number;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_IntInt_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioIntIntEvent* it = (EdsioIntIntEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_int_to_string (it->library);
    case 1: return eventdelivery_int_to_string (it->number);
    default: abort ();
    }
}

const EdsioIntIntEventCode EC_EdsioUnregisteredType = { EC_EdsioUnregisteredTypeValue };

const EdsioIntIntEventCode EC_EdsioUnexpectedLibraryType = { EC_EdsioUnexpectedLibraryTypeValue };

void
edsio_generate_void_event_internal (EdsioVoidEventCode _code, const char* _srcfile, gint _srcline)
{
  EdsioVoidEvent *_e = g_new0 (EdsioVoidEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_Void_event_field_to_string (GenericEvent* ev, gint field)
{
  abort (); return NULL;
}

const EdsioVoidEventCode EC_EdsioUnexpectedType = { EC_EdsioUnexpectedTypeValue };

const EdsioVoidEventCode EC_EdsioOutputBufferShort = { EC_EdsioOutputBufferShortValue };

const EdsioVoidEventCode EC_EdsioInvalidBase64Encoding = { EC_EdsioInvalidBase64EncodingValue };

const EdsioVoidEventCode EC_EdsioMissingChecksum = { EC_EdsioMissingChecksumValue };

const EdsioVoidEventCode EC_EdsioInvalidChecksum = { EC_EdsioInvalidChecksumValue };

void
edsio_generate_source_event_internal (EdsioSourceEventCode _code, const char* _srcfile, gint _srcline, SerialSource* source)
{
  EdsioSourceEvent *_e = g_new0 (EdsioSourceEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->source = source;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_Source_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioSourceEvent* it = (EdsioSourceEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_source_to_string (it->source);
    default: abort ();
    }
}

const EdsioSourceEventCode EC_EdsioSourceEof = { EC_EdsioSourceEofValue };

const EdsioSourceEventCode EC_EdsioIncorrectAllocation = { EC_EdsioIncorrectAllocationValue };

void
edsio_generate_stringstring_event_internal (EdsioStringStringEventCode _code, const char* _srcfile, gint _srcline, const char* msg, const char* arg)
{
  EdsioStringStringEvent *_e = g_new0 (EdsioStringStringEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->msg = msg;
  _e->arg = arg;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Edsio_StringString_event_field_to_string (GenericEvent* ev, gint field)
{
  EdsioStringStringEvent* it = (EdsioStringStringEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_string_to_string (it->msg);
    case 1: return eventdelivery_string_to_string (it->arg);
    default: abort ();
    }
}

const EdsioStringStringEventCode EC_EdsioInvalidIntegerString = { EC_EdsioInvalidIntegerStringValue };

const EdsioStringStringEventCode EC_EdsioIntegerOutOfRange = { EC_EdsioIntegerOutOfRangeValue };

const EdsioStringStringEventCode EC_EdsioInvalidIntegerSign = { EC_EdsioInvalidIntegerSignValue };

