/* -*-Mode: C;-*-
 * Xdelta - A binary delta library
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el 1.7 Thu, 11 Mar 1999 02:19:42 -0800 jmacd $
 */

#include "edsio.h"

#include "edsio.h"

#ifndef _EDSIO_EDSIO_H_
#define _EDSIO_EDSIO_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Initialize this library. */

gboolean edsio_edsio_init (void);

/* Types defined here. */

/* EdsioStringStringEventCode.
 */

typedef struct _EdsioStringStringEventCode EdsioStringStringEventCode;
struct _EdsioStringStringEventCode { gint code; };

typedef struct _EdsioStringStringEvent EdsioStringStringEvent;
struct _EdsioStringStringEvent { gint code; const char* srcfile; guint srcline; const char* msg; const char* arg; };

/* EdsioSourceEventCode.
 */

typedef struct _EdsioSourceEventCode EdsioSourceEventCode;
struct _EdsioSourceEventCode { gint code; };

typedef struct _EdsioSourceEvent EdsioSourceEvent;
struct _EdsioSourceEvent { gint code; const char* srcfile; guint srcline; SerialSource* source; };

/* EdsioVoidEventCode.
 */

typedef struct _EdsioVoidEventCode EdsioVoidEventCode;
struct _EdsioVoidEventCode { gint code; };

typedef struct _EdsioVoidEvent EdsioVoidEvent;
struct _EdsioVoidEvent { gint code; const char* srcfile; guint srcline; };

/* EdsioIntIntEventCode.
 */

typedef struct _EdsioIntIntEventCode EdsioIntIntEventCode;
struct _EdsioIntIntEventCode { gint code; };

typedef struct _EdsioIntIntEvent EdsioIntIntEvent;
struct _EdsioIntIntEvent { gint code; const char* srcfile; guint srcline; int library; int number; };

/* Functions declared here. */

void edsio_generate_intint_event_internal (EdsioIntIntEventCode code, const char* srcfile, gint srcline, int library, int number);
#define edsio_generate_intint_event(ecode, library, number) edsio_generate_intint_event_internal((ecode),__FILE__,__LINE__, (library), (number))

extern const EdsioIntIntEventCode EC_EdsioUnregisteredType;
#define EC_EdsioUnregisteredTypeValue ((0<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioIntIntEventCode EC_EdsioUnexpectedLibraryType;
#define EC_EdsioUnexpectedLibraryTypeValue ((1<<ERROR_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_void_event_internal (EdsioVoidEventCode code, const char* srcfile, gint srcline);
#define edsio_generate_void_event(ecode) edsio_generate_void_event_internal((ecode),__FILE__,__LINE__)

extern const EdsioVoidEventCode EC_EdsioUnexpectedType;
#define EC_EdsioUnexpectedTypeValue ((2<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioOutputBufferShort;
#define EC_EdsioOutputBufferShortValue ((3<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioInvalidBase64Encoding;
#define EC_EdsioInvalidBase64EncodingValue ((4<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioMissingChecksum;
#define EC_EdsioMissingChecksumValue ((5<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioVoidEventCode EC_EdsioInvalidChecksum;
#define EC_EdsioInvalidChecksumValue ((6<<ERROR_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_source_event_internal (EdsioSourceEventCode code, const char* srcfile, gint srcline, SerialSource* source);
#define edsio_generate_source_event(ecode, source) edsio_generate_source_event_internal((ecode),__FILE__,__LINE__, (source))

extern const EdsioSourceEventCode EC_EdsioSourceEof;
#define EC_EdsioSourceEofValue ((7<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioSourceEventCode EC_EdsioIncorrectAllocation;
#define EC_EdsioIncorrectAllocationValue ((8<<ERROR_LIBRARY_OFFSET_BITS)+6)

void edsio_generate_stringstring_event_internal (EdsioStringStringEventCode code, const char* srcfile, gint srcline, const char* msg, const char* arg);
#define edsio_generate_stringstring_event(ecode, msg, arg) edsio_generate_stringstring_event_internal((ecode),__FILE__,__LINE__, (msg), (arg))

extern const EdsioStringStringEventCode EC_EdsioInvalidIntegerString;
#define EC_EdsioInvalidIntegerStringValue ((9<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioIntegerOutOfRange;
#define EC_EdsioIntegerOutOfRangeValue ((10<<ERROR_LIBRARY_OFFSET_BITS)+6)

extern const EdsioStringStringEventCode EC_EdsioInvalidIntegerSign;
#define EC_EdsioInvalidIntegerSignValue ((11<<ERROR_LIBRARY_OFFSET_BITS)+6)

#ifdef __cplusplus
}
#endif

#endif /* _EDSIO_EDSIO_H_ */

