/* -*-Mode: C;-*-
 * Xdelta - A binary delta library
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el 1.7 Thu, 11 Mar 1999 02:19:42 -0800 jmacd $
 */

#include "xdelta.h"

/* Declarations. */

static const char* Xd_Void_event_field_to_string (GenericEvent* ev, gint field);
static const char* Xd_Stream_event_field_to_string (GenericEvent* ev, gint field);
static void print_spaces (guint n) { int i; for (i = 0; i < n; i += 1) g_print (" "); }


/* initialize this library. */

gboolean
xd_edsio_init (void)
{
  static gboolean once = FALSE;
  static gboolean result = FALSE;
  if (once) return result;
  once = TRUE;
  eventdelivery_initialize_event_def (EC_XdInvalidRsyncCacheValue, EL_Error, EF_None, "InvalidRsyncCache", "The rsync checksum cache is corrupt", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdCallbackShortValue, EL_Error, EF_None, "CallbackShort", "The copy callback did not copy enough data", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdCallbackFailedValue, EL_Error, EF_None, "CallbackFailed", "The copy callback failed", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdCannotNormalizeValue, EL_Error, EF_None, "CannotNormalize", "The delta does not have normalized indices", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdIllegalInstructionValue, EL_Error, EF_None, "IllegalInstruction", "Illegal delta instruction", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdInvalidControlValue, EL_Error, EF_None, "InvalidControl", "Delta control is corrupt", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdTooManySourcesValue, EL_Error, EF_None, "TooManySources", "Too many input sources", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdTooFewSourcesValue, EL_Error, EF_None, "TooFewSources", "Too few input sources", & Xd_Void_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdStreamTooLongValue, EL_Error, EF_None, "StreamTooLong", "${0}: Stream too long (currently there is a 64M limit)", & Xd_Stream_event_field_to_string);
  eventdelivery_initialize_event_def (EC_XdStreamValidationFailedValue, EL_Error, EF_None, "StreamValidationFailed", "${0}: Checksum validation failed", & Xd_Stream_event_field_to_string);
  result = TRUE;
  return TRUE;
};

/* XdeltaChecksum Count
 */

guint
serializeio_count_xdeltachecksum (guint16 high, guint16 low) {
  guint size = sizeof (SerialXdeltaChecksum);
  ALIGN_8 (size);
  size += sizeof (guint16);
  ALIGN_8 (size);
  size += sizeof (guint16);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltachecksum_obj (SerialXdeltaChecksum const* obj) {
  return serializeio_count_xdeltachecksum (obj->high, obj->low);
}

/* XdeltaChecksum Print
 */

void
serializeio_print_xdeltachecksum_obj (SerialXdeltaChecksum* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_XdeltaChecksum]\n");
  print_spaces (indent_spaces);
  g_print ("high = ");
  g_print ("%d\n", obj->high);
  print_spaces (indent_spaces);
  g_print ("low = ");
  g_print ("%d\n", obj->low);
}

/* XdeltaChecksum Serialize
 */

gboolean
serialize_xdeltachecksum_internal (SerialSink *sink, guint16 high, guint16 low)
{
  if (! (* sink->next_uint16) (sink, high)) goto bail;
  if (! (* sink->next_uint16) (sink, low)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltachecksum_obj_internal (SerialSink *sink, SerialXdeltaChecksum* obj)
{
  return serialize_xdeltachecksum_internal (sink, obj->high, obj->low);
}

gboolean
serialize_xdeltachecksum (SerialSink *sink, guint16 high, guint16 low)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaChecksum, serializeio_count_xdeltachecksum (high, low), TRUE)) goto bail;
  if (! serialize_xdeltachecksum_internal (sink, high, low)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltachecksum_obj (SerialSink *sink, const SerialXdeltaChecksum* obj) {

  return serialize_xdeltachecksum (sink, obj->high, obj->low);
}

/* XdeltaChecksum Unserialize
 */

gboolean
unserialize_xdeltachecksum_internal_noalloc (SerialSource *source, SerialXdeltaChecksum* result)
{
  if (! (* source->next_uint16) (source, &result->high)) goto bail;
  if (! (* source->next_uint16) (source, &result->low)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltachecksum_internal (SerialSource *source, SerialXdeltaChecksum** result)
{
  SerialXdeltaChecksum* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaChecksum));
  if (! unser) goto bail;
  if (! unserialize_xdeltachecksum_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltachecksum (SerialSource *source, SerialXdeltaChecksum** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_XdeltaChecksum) goto bail;
  if (! unserialize_xdeltachecksum_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* RsyncIndexElt Count
 */

guint
serializeio_count_rsyncindexelt (const guint8 md5[16], SerialXdeltaChecksum const* cksum) {
  guint size = sizeof (SerialRsyncIndexElt);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  size += serializeio_count_xdeltachecksum_obj (cksum) - sizeof (SerialXdeltaChecksum);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_rsyncindexelt_obj (SerialRsyncIndexElt const* obj) {
  return serializeio_count_rsyncindexelt (obj->md5, &obj->cksum);
}

/* RsyncIndexElt Print
 */

void
serializeio_print_rsyncindexelt_obj (SerialRsyncIndexElt* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_RsyncIndexElt]\n");
  print_spaces (indent_spaces);
  g_print ("md5 = ");
  g_print ("<byte array>\n");
  print_spaces (indent_spaces);
  g_print ("cksum = ");
  g_print ("{\n");
  serializeio_print_xdeltachecksum_obj (& obj->cksum, indent_spaces + 2);
  print_spaces (indent_spaces);
;
  g_print ("}\n");
}

/* RsyncIndexElt Serialize
 */

gboolean
serialize_rsyncindexelt_internal (SerialSink *sink, const guint8 md5[16], SerialXdeltaChecksum const* cksum)
{
  if (! (* sink->next_bytes_known) (sink, md5, 16)) goto bail;
  if (! serialize_xdeltachecksum_internal (sink, cksum->high, cksum->low)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_rsyncindexelt_obj_internal (SerialSink *sink, SerialRsyncIndexElt* obj)
{
  return serialize_rsyncindexelt_internal (sink, obj->md5, &obj->cksum);
}

gboolean
serialize_rsyncindexelt (SerialSink *sink, const guint8 md5[16], SerialXdeltaChecksum const* cksum)
{
  if (! (* sink->sink_type) (sink, ST_RsyncIndexElt, serializeio_count_rsyncindexelt (md5, cksum), TRUE)) goto bail;
  if (! serialize_rsyncindexelt_internal (sink, md5, cksum)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_rsyncindexelt_obj (SerialSink *sink, const SerialRsyncIndexElt* obj) {

  return serialize_rsyncindexelt (sink, obj->md5, &obj->cksum);
}

/* RsyncIndexElt Unserialize
 */

gboolean
unserialize_rsyncindexelt_internal_noalloc (SerialSource *source, SerialRsyncIndexElt* result)
{
  if (! (* source->next_bytes_known) (source, result->md5, 16)) goto bail;
  if (! unserialize_xdeltachecksum_internal_noalloc (source, &result->cksum)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_rsyncindexelt_internal (SerialSource *source, SerialRsyncIndexElt** result)
{
  SerialRsyncIndexElt* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialRsyncIndexElt));
  if (! unser) goto bail;
  if (! unserialize_rsyncindexelt_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_rsyncindexelt (SerialSource *source, SerialRsyncIndexElt** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_RsyncIndexElt) goto bail;
  if (! unserialize_rsyncindexelt_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* RsyncIndex Count
 */

guint
serializeio_count_rsyncindex (guint32 seg_len, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt const* index) {
  guint size = sizeof (SerialRsyncIndex);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < index_len; i += 1)
      {
        size += serializeio_count_rsyncindexelt_obj (& (index[i])) - sizeof (SerialRsyncIndexElt);
      }
  }
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_rsyncindex_obj (SerialRsyncIndex const* obj) {
  return serializeio_count_rsyncindex (obj->seg_len, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}

/* RsyncIndex Print
 */

void
serializeio_print_rsyncindex_obj (SerialRsyncIndex* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_RsyncIndex]\n");
  print_spaces (indent_spaces);
  g_print ("seg_len = ");
  g_print ("%d\n", obj->seg_len);
  print_spaces (indent_spaces);
  g_print ("file_len = ");
  g_print ("%d\n", obj->file_len);
  print_spaces (indent_spaces);
  g_print ("file_md5 = ");
  g_print ("<byte array>\n");
  print_spaces (indent_spaces);
  g_print ("index = ");
  {
    gint i;
    for (i = 0; i < obj->index_len; i += 1)
      {
        print_spaces (indent_spaces);
      g_print ("array = ");
      g_print ("{\n");
      serializeio_print_rsyncindexelt_obj (& (obj->index[i]), indent_spaces + 2);
      print_spaces (indent_spaces);
;
      g_print ("}\n");
      }
  }
}

/* RsyncIndex Serialize
 */

gboolean
serialize_rsyncindex_internal (SerialSink *sink, guint32 seg_len, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt const* index)
{
  if (! (* sink->next_uint) (sink, seg_len)) goto bail;
  if (! (* sink->next_uint) (sink, file_len)) goto bail;
  if (! (* sink->next_bytes_known) (sink, file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, index_len)) goto bail;
    for (i = 0; i < index_len; i += 1)
      {
        if (! serialize_rsyncindexelt_internal (sink, (index[i]).md5, &(index[i]).cksum)) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_rsyncindex_obj_internal (SerialSink *sink, SerialRsyncIndex* obj)
{
  return serialize_rsyncindex_internal (sink, obj->seg_len, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}

gboolean
serialize_rsyncindex (SerialSink *sink, guint32 seg_len, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt const* index)
{
  if (! (* sink->sink_type) (sink, ST_RsyncIndex, serializeio_count_rsyncindex (seg_len, file_len, file_md5, index_len, index), TRUE)) goto bail;
  if (! serialize_rsyncindex_internal (sink, seg_len, file_len, file_md5, index_len, index)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_rsyncindex_obj (SerialSink *sink, const SerialRsyncIndex* obj) {

  return serialize_rsyncindex (sink, obj->seg_len, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}

/* RsyncIndex Unserialize
 */

gboolean
unserialize_rsyncindex_internal_noalloc (SerialSource *source, SerialRsyncIndex* result)
{
  if (! (* source->next_uint) (source, &result->seg_len)) goto bail;
  if (! (* source->next_uint) (source, &result->file_len)) goto bail;
  if (! (* source->next_bytes_known) (source, result->file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->index_len)) goto bail;
    if (! (result->index = serializeio_source_alloc (source, sizeof (SerialRsyncIndexElt) * result->index_len))) goto bail;
    for (i = 0; i < result->index_len; i += 1)
      {
        if (! unserialize_rsyncindexelt_internal_noalloc (source, &(result->index[i]))) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_rsyncindex_internal (SerialSource *source, SerialRsyncIndex** result)
{
  SerialRsyncIndex* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialRsyncIndex));
  if (! unser) goto bail;
  if (! unserialize_rsyncindex_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_rsyncindex (SerialSource *source, SerialRsyncIndex** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_RsyncIndex) goto bail;
  if (! unserialize_rsyncindex_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdeltaIndex Count
 */

guint
serializeio_count_xdeltaindex (guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum const* index) {
  guint size = sizeof (SerialXdeltaIndex);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < index_len; i += 1)
      {
        size += serializeio_count_xdeltachecksum_obj (& (index[i])) - sizeof (SerialXdeltaChecksum);
      }
  }
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltaindex_obj (SerialXdeltaIndex const* obj) {
  return serializeio_count_xdeltaindex (obj->file_len, obj->file_md5, obj->index_len, obj->index);
}

/* XdeltaIndex Print
 */

void
serializeio_print_xdeltaindex_obj (SerialXdeltaIndex* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_XdeltaIndex]\n");
  print_spaces (indent_spaces);
  g_print ("file_len = ");
  g_print ("%d\n", obj->file_len);
  print_spaces (indent_spaces);
  g_print ("file_md5 = ");
  g_print ("<byte array>\n");
  print_spaces (indent_spaces);
  g_print ("index = ");
  {
    gint i;
    for (i = 0; i < obj->index_len; i += 1)
      {
        print_spaces (indent_spaces);
      g_print ("array = ");
      g_print ("{\n");
      serializeio_print_xdeltachecksum_obj (& (obj->index[i]), indent_spaces + 2);
      print_spaces (indent_spaces);
;
      g_print ("}\n");
      }
  }
}

/* XdeltaIndex Serialize
 */

gboolean
serialize_xdeltaindex_internal (SerialSink *sink, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum const* index)
{
  if (! (* sink->next_uint) (sink, file_len)) goto bail;
  if (! (* sink->next_bytes_known) (sink, file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, index_len)) goto bail;
    for (i = 0; i < index_len; i += 1)
      {
        if (! serialize_xdeltachecksum_internal (sink, (index[i]).high, (index[i]).low)) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltaindex_obj_internal (SerialSink *sink, SerialXdeltaIndex* obj)
{
  return serialize_xdeltaindex_internal (sink, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}

gboolean
serialize_xdeltaindex (SerialSink *sink, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum const* index)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaIndex, serializeio_count_xdeltaindex (file_len, file_md5, index_len, index), TRUE)) goto bail;
  if (! serialize_xdeltaindex_internal (sink, file_len, file_md5, index_len, index)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltaindex_obj (SerialSink *sink, const SerialXdeltaIndex* obj) {

  return serialize_xdeltaindex (sink, obj->file_len, obj->file_md5, obj->index_len, obj->index);
}

/* XdeltaIndex Unserialize
 */

gboolean
unserialize_xdeltaindex_internal_noalloc (SerialSource *source, SerialXdeltaIndex* result)
{
  if (! (* source->next_uint) (source, &result->file_len)) goto bail;
  if (! (* source->next_bytes_known) (source, result->file_md5, 16)) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->index_len)) goto bail;
    if (! (result->index = serializeio_source_alloc (source, sizeof (SerialXdeltaChecksum) * result->index_len))) goto bail;
    for (i = 0; i < result->index_len; i += 1)
      {
        if (! unserialize_xdeltachecksum_internal_noalloc (source, &(result->index[i]))) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltaindex_internal (SerialSource *source, SerialXdeltaIndex** result)
{
  SerialXdeltaIndex* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaIndex));
  if (! unser) goto bail;
  if (! unserialize_xdeltaindex_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltaindex (SerialSource *source, SerialXdeltaIndex** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_XdeltaIndex) goto bail;
  if (! unserialize_xdeltaindex_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdeltaSourceInfo Count
 */

guint
serializeio_count_xdeltasourceinfo (const guint8 md5[16], const guint8 real_md5[16], guint32 length) {
  guint size = sizeof (SerialXdeltaSourceInfo);
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  size += 0;
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltasourceinfo_obj (SerialXdeltaSourceInfo const* obj) {
  return serializeio_count_xdeltasourceinfo (obj->md5, obj->real_md5, obj->length);
}

/* XdeltaSourceInfo Print
 */

void
serializeio_print_xdeltasourceinfo_obj (SerialXdeltaSourceInfo* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_XdeltaSourceInfo]\n");
  print_spaces (indent_spaces);
  g_print ("md5 = ");
  g_print ("<byte array>\n");
  print_spaces (indent_spaces);
  g_print ("real_md5 = ");
  g_print ("<byte array>\n");
  print_spaces (indent_spaces);
  g_print ("length = ");
  g_print ("%d\n", obj->length);
}

/* XdeltaSourceInfo Serialize
 */

gboolean
serialize_xdeltasourceinfo_internal (SerialSink *sink, const guint8 md5[16], const guint8 real_md5[16], guint32 length)
{
  if (! (* sink->next_bytes_known) (sink, md5, 16)) goto bail;
  if (! (* sink->next_bytes_known) (sink, real_md5, 16)) goto bail;
  if (! (* sink->next_uint) (sink, length)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltasourceinfo_obj_internal (SerialSink *sink, SerialXdeltaSourceInfo* obj)
{
  return serialize_xdeltasourceinfo_internal (sink, obj->md5, obj->real_md5, obj->length);
}

gboolean
serialize_xdeltasourceinfo (SerialSink *sink, const guint8 md5[16], const guint8 real_md5[16], guint32 length)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaSourceInfo, serializeio_count_xdeltasourceinfo (md5, real_md5, length), TRUE)) goto bail;
  if (! serialize_xdeltasourceinfo_internal (sink, md5, real_md5, length)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltasourceinfo_obj (SerialSink *sink, const SerialXdeltaSourceInfo* obj) {

  return serialize_xdeltasourceinfo (sink, obj->md5, obj->real_md5, obj->length);
}

/* XdeltaSourceInfo Unserialize
 */

gboolean
unserialize_xdeltasourceinfo_internal_noalloc (SerialSource *source, SerialXdeltaSourceInfo* result)
{
  if (! (* source->next_bytes_known) (source, result->md5, 16)) goto bail;
  if (! (* source->next_bytes_known) (source, result->real_md5, 16)) goto bail;
  if (! (* source->next_uint) (source, &result->length)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltasourceinfo_internal (SerialSource *source, SerialXdeltaSourceInfo** result)
{
  SerialXdeltaSourceInfo* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaSourceInfo));
  if (! unser) goto bail;
  if (! unserialize_xdeltasourceinfo_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltasourceinfo (SerialSource *source, SerialXdeltaSourceInfo** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_XdeltaSourceInfo) goto bail;
  if (! unserialize_xdeltasourceinfo_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdeltaControl Count
 */

guint
serializeio_count_xdeltacontrol (gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo const* to_info, guint32 source_info_len, SerialXdeltaSourceInfo* const* source_info, guint32 inst_len, SerialXdeltaInstruction const* inst) {
  guint size = sizeof (SerialXdeltaControl);
  ALIGN_8 (size);
  size += 1;
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += serializeio_count_xdeltasourceinfo_obj (to_info) - sizeof (SerialXdeltaSourceInfo);
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < source_info_len; i += 1)
      {
        size += serializeio_count_xdeltasourceinfo_obj ((source_info[i]));
      }
  }
  ALIGN_8 (size);
  {
    gint i;
    for (i = 0; i < inst_len; i += 1)
      {
        size += serializeio_count_xdeltainstruction_obj (& (inst[i])) - sizeof (SerialXdeltaInstruction);
      }
  }
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltacontrol_obj (SerialXdeltaControl const* obj) {
  return serializeio_count_xdeltacontrol (obj->normalized, obj->data_len, &obj->to_info, obj->source_info_len, obj->source_info, obj->inst_len, obj->inst);
}

/* XdeltaControl Print
 */

void
serializeio_print_xdeltacontrol_obj (SerialXdeltaControl* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_XdeltaControl]\n");
  print_spaces (indent_spaces);
  g_print ("normalized = ");
  g_print ("%s\n", obj->normalized ? "true" : "false");
  print_spaces (indent_spaces);
  g_print ("data_len = ");
  g_print ("%d\n", obj->data_len);
  print_spaces (indent_spaces);
  g_print ("to_info = ");
  g_print ("{\n");
  serializeio_print_xdeltasourceinfo_obj (& obj->to_info, indent_spaces + 2);
  print_spaces (indent_spaces);
;
  g_print ("}\n");
  print_spaces (indent_spaces);
  g_print ("source_info = ");
  {
    gint i;
    for (i = 0; i < obj->source_info_len; i += 1)
      {
        print_spaces (indent_spaces);
      g_print ("array = ");
      g_print ("{\n");
      serializeio_print_xdeltasourceinfo_obj ((obj->source_info[i]), indent_spaces + 2);
      print_spaces (indent_spaces);
;
      g_print ("}\n");
      }
  }
  print_spaces (indent_spaces);
  g_print ("inst = ");
  {
    gint i;
    for (i = 0; i < obj->inst_len; i += 1)
      {
        print_spaces (indent_spaces);
      g_print ("array = ");
      g_print ("{\n");
      serializeio_print_xdeltainstruction_obj (& (obj->inst[i]), indent_spaces + 2);
      print_spaces (indent_spaces);
;
      g_print ("}\n");
      }
  }
}

/* XdeltaControl Serialize
 */

gboolean
serialize_xdeltacontrol_internal (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo const* to_info, guint32 source_info_len, SerialXdeltaSourceInfo* const* source_info, guint32 inst_len, SerialXdeltaInstruction const* inst)
{
  if (! (* sink->next_bool) (sink, normalized)) goto bail;
  if (! (* sink->next_uint) (sink, data_len)) goto bail;
  if (! serialize_xdeltasourceinfo_internal (sink, to_info->md5, to_info->real_md5, to_info->length)) goto bail;
  {
    gint i;
    if (! (* sink->next_uint) (sink, source_info_len)) goto bail;
    for (i = 0; i < source_info_len; i += 1)
      {
        if (! serialize_xdeltasourceinfo_internal (sink, (source_info[i])->md5, (source_info[i])->real_md5, (source_info[i])->length)) goto bail;
      }
  }
  {
    gint i;
    if (! (* sink->next_uint) (sink, inst_len)) goto bail;
    for (i = 0; i < inst_len; i += 1)
      {
        if (! serialize_xdeltainstruction_internal (sink, (inst[i]).offset, (inst[i]).length)) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltacontrol_obj_internal (SerialSink *sink, SerialXdeltaControl* obj)
{
  return serialize_xdeltacontrol_internal (sink, obj->normalized, obj->data_len, &obj->to_info, obj->source_info_len, obj->source_info, obj->inst_len, obj->inst);
}

gboolean
serialize_xdeltacontrol (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo const* to_info, guint32 source_info_len, SerialXdeltaSourceInfo* const* source_info, guint32 inst_len, SerialXdeltaInstruction const* inst)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaControl, serializeio_count_xdeltacontrol (normalized, data_len, to_info, source_info_len, source_info, inst_len, inst), TRUE)) goto bail;
  if (! serialize_xdeltacontrol_internal (sink, normalized, data_len, to_info, source_info_len, source_info, inst_len, inst)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltacontrol_obj (SerialSink *sink, const SerialXdeltaControl* obj) {

  return serialize_xdeltacontrol (sink, obj->normalized, obj->data_len, &obj->to_info, obj->source_info_len, obj->source_info, obj->inst_len, obj->inst);
}

/* XdeltaControl Unserialize
 */

gboolean
unserialize_xdeltacontrol_internal_noalloc (SerialSource *source, SerialXdeltaControl* result)
{
  if (! (* source->next_bool) (source, &result->normalized)) goto bail;
  if (! (* source->next_uint) (source, &result->data_len)) goto bail;
  if (! unserialize_xdeltasourceinfo_internal_noalloc (source, &result->to_info)) goto bail;
  {
    gint i;
    if (! (* source->next_uint) (source, &result->source_info_len)) goto bail;
    if (! (result->source_info = serializeio_source_alloc (source, sizeof (SerialXdeltaSourceInfo*) * result->source_info_len))) goto bail;
    for (i = 0; i < result->source_info_len; i += 1)
      {
        if (! unserialize_xdeltasourceinfo_internal (source, &(result->source_info[i]))) goto bail;
      }
  }
  {
    gint i;
    if (! (* source->next_uint) (source, &result->inst_len)) goto bail;
    if (! (result->inst = serializeio_source_alloc (source, sizeof (SerialXdeltaInstruction) * result->inst_len))) goto bail;
    for (i = 0; i < result->inst_len; i += 1)
      {
        if (! unserialize_xdeltainstruction_internal_noalloc (source, &(result->inst[i]))) goto bail;
      }
  }
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltacontrol_internal (SerialSource *source, SerialXdeltaControl** result)
{
  SerialXdeltaControl* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaControl));
  if (! unser) goto bail;
  if (! unserialize_xdeltacontrol_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltacontrol (SerialSource *source, SerialXdeltaControl** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_XdeltaControl) goto bail;
  if (! unserialize_xdeltacontrol_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

/* XdeltaInstruction Count
 */

guint
serializeio_count_xdeltainstruction (guint32 offset, guint32 length) {
  guint size = sizeof (SerialXdeltaInstruction);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  size += sizeof (guint32);
  ALIGN_8 (size);
  return size;
}

guint
serializeio_count_xdeltainstruction_obj (SerialXdeltaInstruction const* obj) {
  return serializeio_count_xdeltainstruction (obj->offset, obj->length);
}

/* XdeltaInstruction Print
 */

void
serializeio_print_xdeltainstruction_obj (SerialXdeltaInstruction* obj, guint indent_spaces) {
  print_spaces (indent_spaces);
  g_print ("[ST_XdeltaInstruction]\n");
  print_spaces (indent_spaces);
  g_print ("offset = ");
  g_print ("%d\n", obj->offset);
  print_spaces (indent_spaces);
  g_print ("length = ");
  g_print ("%d\n", obj->length);
}

/* XdeltaInstruction Serialize
 */

gboolean
serialize_xdeltainstruction_internal (SerialSink *sink, guint32 offset, guint32 length)
{
  if (! (* sink->next_uint) (sink, offset)) goto bail;
  if (! (* sink->next_uint) (sink, length)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltainstruction_obj_internal (SerialSink *sink, SerialXdeltaInstruction* obj)
{
  return serialize_xdeltainstruction_internal (sink, obj->offset, obj->length);
}

gboolean
serialize_xdeltainstruction (SerialSink *sink, guint32 offset, guint32 length)
{
  if (! (* sink->sink_type) (sink, ST_XdeltaInstruction, serializeio_count_xdeltainstruction (offset, length), TRUE)) goto bail;
  if (! serialize_xdeltainstruction_internal (sink, offset, length)) goto bail;
  if (sink->sink_quantum && ! sink->sink_quantum (sink)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
serialize_xdeltainstruction_obj (SerialSink *sink, const SerialXdeltaInstruction* obj) {

  return serialize_xdeltainstruction (sink, obj->offset, obj->length);
}

/* XdeltaInstruction Unserialize
 */

gboolean
unserialize_xdeltainstruction_internal_noalloc (SerialSource *source, SerialXdeltaInstruction* result)
{
  if (! (* source->next_uint) (source, &result->offset)) goto bail;
  if (! (* source->next_uint) (source, &result->length)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltainstruction_internal (SerialSource *source, SerialXdeltaInstruction** result)
{
  SerialXdeltaInstruction* unser;
  (*result) = NULL;
  unser = serializeio_source_alloc (source, sizeof (SerialXdeltaInstruction));
  if (! unser) goto bail;
  if (! unserialize_xdeltainstruction_internal_noalloc (source, unser)) goto bail;
  (*result) = unser;
  return TRUE;
bail:
  return FALSE;
}

gboolean
unserialize_xdeltainstruction (SerialSource *source, SerialXdeltaInstruction** result)
{
  if ( (* source->source_type) (source, TRUE) != ST_XdeltaInstruction) goto bail;
  if (! unserialize_xdeltainstruction_internal (source, result)) goto bail;
  if (! serializeio_source_object_received (source)) goto bail;
  return TRUE;
bail:
  return FALSE;
}

void
xd_generate_stream_event_internal (XdStreamEventCode _code, const char* _srcfile, gint _srcline, FileHandle* stream)
{
  XdStreamEvent *_e = g_new0 (XdStreamEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  _e->stream = stream;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Xd_Stream_event_field_to_string (GenericEvent* ev, gint field)
{
  XdStreamEvent* it = (XdStreamEvent*) ev;
  switch (field)
    {
    case 0: return eventdelivery_stream_to_string (it->stream);
    default: abort ();
    }
}

const XdStreamEventCode EC_XdStreamValidationFailed = { EC_XdStreamValidationFailedValue };

const XdStreamEventCode EC_XdStreamTooLong = { EC_XdStreamTooLongValue };

void
xd_generate_void_event_internal (XdVoidEventCode _code, const char* _srcfile, gint _srcline)
{
  XdVoidEvent *_e = g_new0 (XdVoidEvent, 1);
  _e->code = _code.code;
  _e->srcline = _srcline;
  _e->srcfile = _srcfile;
  eventdelivery_event_deliver ((GenericEvent*) _e);
}

const char*
Xd_Void_event_field_to_string (GenericEvent* ev, gint field)
{
  abort (); return NULL;
}

const XdVoidEventCode EC_XdTooFewSources = { EC_XdTooFewSourcesValue };

const XdVoidEventCode EC_XdTooManySources = { EC_XdTooManySourcesValue };

const XdVoidEventCode EC_XdInvalidControl = { EC_XdInvalidControlValue };

const XdVoidEventCode EC_XdIllegalInstruction = { EC_XdIllegalInstructionValue };

const XdVoidEventCode EC_XdCannotNormalize = { EC_XdCannotNormalizeValue };

const XdVoidEventCode EC_XdCallbackFailed = { EC_XdCallbackFailedValue };

const XdVoidEventCode EC_XdCallbackShort = { EC_XdCallbackShortValue };

const XdVoidEventCode EC_XdInvalidRsyncCache = { EC_XdInvalidRsyncCacheValue };

