/* -*-Mode: C;-*-
 * Xdelta - A binary delta library
 * Copyright (C) 1997, 1998  Josh MacDonald
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Josh MacDonald <jmacd@CS.Berkeley.EDU>
 *
 * This file was AUTOMATICALLY GENERATED using:
 *
 * $Id: edsio.el 1.7 Thu, 11 Mar 1999 02:19:42 -0800 jmacd $
 */

#include "edsio.h"

#include "xdelta.h"

#ifndef _XD_EDSIO_H_
#define _XD_EDSIO_H_

#ifdef __cplusplus
extern "C" {
#endif

/* Initialize this library. */

gboolean xd_edsio_init (void);

/* Types defined here. */

/* XdVoidEventCode.
 */

typedef struct _XdVoidEventCode XdVoidEventCode;
struct _XdVoidEventCode { gint code; };

typedef struct _XdVoidEvent XdVoidEvent;
struct _XdVoidEvent { gint code; const char* srcfile; guint srcline; };

/* XdStreamEventCode.
 */

typedef struct _XdStreamEventCode XdStreamEventCode;
struct _XdStreamEventCode { gint code; };

typedef struct _XdStreamEvent XdStreamEvent;
struct _XdStreamEvent { gint code; const char* srcfile; guint srcline; FileHandle* stream; };

typedef struct _SerialXdeltaInstruction SerialXdeltaInstruction;
typedef struct _SerialXdeltaControl SerialXdeltaControl;
typedef struct _SerialXdeltaSourceInfo SerialXdeltaSourceInfo;
typedef struct _SerialXdeltaIndex SerialXdeltaIndex;
typedef struct _SerialRsyncIndex SerialRsyncIndex;
typedef struct _SerialRsyncIndexElt SerialRsyncIndexElt;
typedef struct _SerialXdeltaChecksum SerialXdeltaChecksum;
/* Functions declared here. */

/* Serial Types */

enum _SerialXdType {

  ST_XdeltaChecksum = (1<<(0+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_RsyncIndexElt = (1<<(1+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_RsyncIndex = (1<<(2+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaIndex = (1<<(3+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaSourceInfo = (1<<(4+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaControl = (1<<(5+SER_LIBRARY_OFFSET_BITS))+3, 
  ST_XdeltaInstruction = (1<<(6+SER_LIBRARY_OFFSET_BITS))+3
};



/* XdeltaChecksum Structure
 */

struct _SerialXdeltaChecksum {
  guint16 high;
  guint16 low;
};

void     serializeio_print_xdeltachecksum_obj        (SerialXdeltaChecksum* obj, guint indent_spaces);

gboolean unserialize_xdeltachecksum                  (SerialSource *source, SerialXdeltaChecksum**);
gboolean unserialize_xdeltachecksum_internal         (SerialSource *source, SerialXdeltaChecksum** );
gboolean unserialize_xdeltachecksum_internal_noalloc (SerialSource *source, SerialXdeltaChecksum* );
gboolean serialize_xdeltachecksum                    (SerialSink *sink, guint16 high, guint16 low);
gboolean serialize_xdeltachecksum_obj                (SerialSink *sink, const SerialXdeltaChecksum* obj);
gboolean serialize_xdeltachecksum_internal           (SerialSink *sink, guint16 high, guint16 low);
gboolean serialize_xdeltachecksum_obj_internal (SerialSink *sink, SerialXdeltaChecksum* obj);
guint    serializeio_count_xdeltachecksum            (guint16 high, guint16 low);
guint    serializeio_count_xdeltachecksum_obj        (SerialXdeltaChecksum const* obj);

/* RsyncIndexElt Structure
 */

struct _SerialRsyncIndexElt {
  guint8 md5[16];
  SerialXdeltaChecksum cksum;
  SerialRsyncIndexElt* next;
  gint match_offset;
};

void     serializeio_print_rsyncindexelt_obj        (SerialRsyncIndexElt* obj, guint indent_spaces);

gboolean unserialize_rsyncindexelt                  (SerialSource *source, SerialRsyncIndexElt**);
gboolean unserialize_rsyncindexelt_internal         (SerialSource *source, SerialRsyncIndexElt** );
gboolean unserialize_rsyncindexelt_internal_noalloc (SerialSource *source, SerialRsyncIndexElt* );
gboolean serialize_rsyncindexelt                    (SerialSink *sink, const guint8 md5[16], SerialXdeltaChecksum const* cksum);
gboolean serialize_rsyncindexelt_obj                (SerialSink *sink, const SerialRsyncIndexElt* obj);
gboolean serialize_rsyncindexelt_internal           (SerialSink *sink, const guint8 md5[16], SerialXdeltaChecksum const* cksum);
gboolean serialize_rsyncindexelt_obj_internal (SerialSink *sink, SerialRsyncIndexElt* obj);
guint    serializeio_count_rsyncindexelt            (const guint8 md5[16], SerialXdeltaChecksum const* cksum);
guint    serializeio_count_rsyncindexelt_obj        (SerialRsyncIndexElt const* obj);

/* RsyncIndex Structure
 */

struct _SerialRsyncIndex {
  guint32 seg_len;
  guint32 file_len;
  guint8 file_md5[16];
  guint32 index_len;
  SerialRsyncIndexElt* index;
  SerialRsyncIndexElt** table;
  guint table_size;
};

void     serializeio_print_rsyncindex_obj        (SerialRsyncIndex* obj, guint indent_spaces);

gboolean unserialize_rsyncindex                  (SerialSource *source, SerialRsyncIndex**);
gboolean unserialize_rsyncindex_internal         (SerialSource *source, SerialRsyncIndex** );
gboolean unserialize_rsyncindex_internal_noalloc (SerialSource *source, SerialRsyncIndex* );
gboolean serialize_rsyncindex                    (SerialSink *sink, guint32 seg_len, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt const* index);
gboolean serialize_rsyncindex_obj                (SerialSink *sink, const SerialRsyncIndex* obj);
gboolean serialize_rsyncindex_internal           (SerialSink *sink, guint32 seg_len, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt const* index);
gboolean serialize_rsyncindex_obj_internal (SerialSink *sink, SerialRsyncIndex* obj);
guint    serializeio_count_rsyncindex            (guint32 seg_len, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialRsyncIndexElt const* index);
guint    serializeio_count_rsyncindex_obj        (SerialRsyncIndex const* obj);

/* XdeltaIndex Structure
 */

struct _SerialXdeltaIndex {
  guint32 file_len;
  guint8 file_md5[16];
  guint32 index_len;
  SerialXdeltaChecksum* index;
};

void     serializeio_print_xdeltaindex_obj        (SerialXdeltaIndex* obj, guint indent_spaces);

gboolean unserialize_xdeltaindex                  (SerialSource *source, SerialXdeltaIndex**);
gboolean unserialize_xdeltaindex_internal         (SerialSource *source, SerialXdeltaIndex** );
gboolean unserialize_xdeltaindex_internal_noalloc (SerialSource *source, SerialXdeltaIndex* );
gboolean serialize_xdeltaindex                    (SerialSink *sink, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum const* index);
gboolean serialize_xdeltaindex_obj                (SerialSink *sink, const SerialXdeltaIndex* obj);
gboolean serialize_xdeltaindex_internal           (SerialSink *sink, guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum const* index);
gboolean serialize_xdeltaindex_obj_internal (SerialSink *sink, SerialXdeltaIndex* obj);
guint    serializeio_count_xdeltaindex            (guint32 file_len, const guint8 file_md5[16], guint32 index_len, SerialXdeltaChecksum const* index);
guint    serializeio_count_xdeltaindex_obj        (SerialXdeltaIndex const* obj);

/* XdeltaSourceInfo Structure
 */

struct _SerialXdeltaSourceInfo {
  guint8 md5[16];
  guint8 real_md5[16];
  guint32 length;
};

void     serializeio_print_xdeltasourceinfo_obj        (SerialXdeltaSourceInfo* obj, guint indent_spaces);

gboolean unserialize_xdeltasourceinfo                  (SerialSource *source, SerialXdeltaSourceInfo**);
gboolean unserialize_xdeltasourceinfo_internal         (SerialSource *source, SerialXdeltaSourceInfo** );
gboolean unserialize_xdeltasourceinfo_internal_noalloc (SerialSource *source, SerialXdeltaSourceInfo* );
gboolean serialize_xdeltasourceinfo                    (SerialSink *sink, const guint8 md5[16], const guint8 real_md5[16], guint32 length);
gboolean serialize_xdeltasourceinfo_obj                (SerialSink *sink, const SerialXdeltaSourceInfo* obj);
gboolean serialize_xdeltasourceinfo_internal           (SerialSink *sink, const guint8 md5[16], const guint8 real_md5[16], guint32 length);
gboolean serialize_xdeltasourceinfo_obj_internal (SerialSink *sink, SerialXdeltaSourceInfo* obj);
guint    serializeio_count_xdeltasourceinfo            (const guint8 md5[16], const guint8 real_md5[16], guint32 length);
guint    serializeio_count_xdeltasourceinfo_obj        (SerialXdeltaSourceInfo const* obj);

/* XdeltaControl Structure
 */

struct _SerialXdeltaControl {
  gboolean normalized;
  guint32 data_len;
  SerialXdeltaSourceInfo to_info;
  guint32 source_info_len;
  SerialXdeltaSourceInfo** source_info;
  guint32 inst_len;
  SerialXdeltaInstruction* inst;
  GArray    *inst_array;
  GPtrArray *source_info_array;
};

void     serializeio_print_xdeltacontrol_obj        (SerialXdeltaControl* obj, guint indent_spaces);

gboolean unserialize_xdeltacontrol                  (SerialSource *source, SerialXdeltaControl**);
gboolean unserialize_xdeltacontrol_internal         (SerialSource *source, SerialXdeltaControl** );
gboolean unserialize_xdeltacontrol_internal_noalloc (SerialSource *source, SerialXdeltaControl* );
gboolean serialize_xdeltacontrol                    (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo const* to_info, guint32 source_info_len, SerialXdeltaSourceInfo* const* source_info, guint32 inst_len, SerialXdeltaInstruction const* inst);
gboolean serialize_xdeltacontrol_obj                (SerialSink *sink, const SerialXdeltaControl* obj);
gboolean serialize_xdeltacontrol_internal           (SerialSink *sink, gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo const* to_info, guint32 source_info_len, SerialXdeltaSourceInfo* const* source_info, guint32 inst_len, SerialXdeltaInstruction const* inst);
gboolean serialize_xdeltacontrol_obj_internal (SerialSink *sink, SerialXdeltaControl* obj);
guint    serializeio_count_xdeltacontrol            (gboolean normalized, guint32 data_len, SerialXdeltaSourceInfo const* to_info, guint32 source_info_len, SerialXdeltaSourceInfo* const* source_info, guint32 inst_len, SerialXdeltaInstruction const* inst);
guint    serializeio_count_xdeltacontrol_obj        (SerialXdeltaControl const* obj);

/* XdeltaInstruction Structure
 */

struct _SerialXdeltaInstruction {
  guint32 offset;
  guint32 length;
  guint8 type;
  guint8 index;
};

void     serializeio_print_xdeltainstruction_obj        (SerialXdeltaInstruction* obj, guint indent_spaces);

gboolean unserialize_xdeltainstruction                  (SerialSource *source, SerialXdeltaInstruction**);
gboolean unserialize_xdeltainstruction_internal         (SerialSource *source, SerialXdeltaInstruction** );
gboolean unserialize_xdeltainstruction_internal_noalloc (SerialSource *source, SerialXdeltaInstruction* );
gboolean serialize_xdeltainstruction                    (SerialSink *sink, guint32 offset, guint32 length);
gboolean serialize_xdeltainstruction_obj                (SerialSink *sink, const SerialXdeltaInstruction* obj);
gboolean serialize_xdeltainstruction_internal           (SerialSink *sink, guint32 offset, guint32 length);
gboolean serialize_xdeltainstruction_obj_internal (SerialSink *sink, SerialXdeltaInstruction* obj);
guint    serializeio_count_xdeltainstruction            (guint32 offset, guint32 length);
guint    serializeio_count_xdeltainstruction_obj        (SerialXdeltaInstruction const* obj);

void xd_generate_stream_event_internal (XdStreamEventCode code, const char* srcfile, gint srcline, FileHandle* stream);
#define xd_generate_stream_event(ecode, stream) xd_generate_stream_event_internal((ecode),__FILE__,__LINE__, (stream))

extern const XdStreamEventCode EC_XdStreamValidationFailed;
#define EC_XdStreamValidationFailedValue ((0<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdStreamEventCode EC_XdStreamTooLong;
#define EC_XdStreamTooLongValue ((1<<ERROR_LIBRARY_OFFSET_BITS)+3)

void xd_generate_void_event_internal (XdVoidEventCode code, const char* srcfile, gint srcline);
#define xd_generate_void_event(ecode) xd_generate_void_event_internal((ecode),__FILE__,__LINE__)

extern const XdVoidEventCode EC_XdTooFewSources;
#define EC_XdTooFewSourcesValue ((2<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdTooManySources;
#define EC_XdTooManySourcesValue ((3<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdInvalidControl;
#define EC_XdInvalidControlValue ((4<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdIllegalInstruction;
#define EC_XdIllegalInstructionValue ((5<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdCannotNormalize;
#define EC_XdCannotNormalizeValue ((6<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdCallbackFailed;
#define EC_XdCallbackFailedValue ((7<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdCallbackShort;
#define EC_XdCallbackShortValue ((8<<ERROR_LIBRARY_OFFSET_BITS)+3)

extern const XdVoidEventCode EC_XdInvalidRsyncCache;
#define EC_XdInvalidRsyncCacheValue ((9<<ERROR_LIBRARY_OFFSET_BITS)+3)

#ifdef __cplusplus
}
#endif

#endif /* _XD_EDSIO_H_ */

