///////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About
#include "stdafx.h"
#include "resource.h"

#if !defined(_ABOUTDLG_H_)
    #include "AboutDlg.h"
#endif//_ABOUTDLG_H_

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
    //{{AFX_MSG_MAP(CAboutDlg)
    ON_WM_CTLCOLOR()
    ON_WM_LBUTTONDOWN()
    ON_WM_MOUSEMOVE()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
    //{{AFX_DATA_INIT(CAboutDlg)
    //}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CAboutDlg)
    //}}AFX_DATA_MAP
}

HBRUSH CAboutDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
    HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
    if ( CTLCOLOR_STATIC == nCtlColor )	
    {
        if ( GetDlgItem( IDC_EMAIL_ADDRESS )->GetSafeHwnd() == pWnd->GetSafeHwnd() )
        {
            pDC->SetTextColor( RGB( 0, 0, 255 ) );
        }
    }
    return hbr;
}

void CAboutDlg::OnLButtonDown(UINT nFlags, CPoint point) 
{
    CRect emailRect;
    CWnd* pWnd = GetDlgItem( IDC_EMAIL_ADDRESS );
    pWnd->GetWindowRect( emailRect );
    ScreenToClient( emailRect );
    if ( emailRect.PtInRect( point ) )
    { 
        // fire off the email reader
        TRACE( "Setting off e-mail\n" );
        CString szText;
        pWnd->GetWindowText( szText );
        szText = "mailto:" + szText;
        HINSTANCE hInst = ShellExecute( NULL, "open", szText, NULL,
                                        NULL, SW_SHOWNORMAL );
        if ( reinterpret_cast<int>(hInst) <= 32 )
        {
            TRACE( "Failed to set off e-mail\n" );
        }
    }
    CDialog::OnLButtonDown(nFlags, point);
}

void CAboutDlg::OnMouseMove(UINT nFlags, CPoint point) 
{
    CRect emailRect;
    CWnd* pWnd = GetDlgItem( IDC_EMAIL_ADDRESS );
    pWnd->GetWindowRect( emailRect );
    ScreenToClient( emailRect );
    if ( emailRect.PtInRect( point ) )
    { 
        SetCursor( LoadCursor( AfxGetResourceHandle(), MAKEINTRESOURCE(IDC_FINGER) ) );
    }
    else
    {
        SetCursor( LoadCursor( NULL, IDC_ARROW) );
    }
	
    CDialog::OnMouseMove(nFlags, point);
}


