// CAnimTry.cpp : implementation file
//

#ifndef __AFXWIN_H__
	#include <afxwin.h>         // MFC core and standard components
#endif //__AFXWIN_H__

#if !defined(_CANIMTRAYICON_H_)
    #include "CAnimTry.h"  // CAnimTrayIcon
#endif //_CANIMTRAYICON_H_

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

///////////////////////////////////////////////////////////////////
// CAnimTrayIcon
const int CAnimTrayIcon::INACTIVE_ICON = 0;
const int CAnimTrayIcon::FIRST_ANIMATED_ICON = 1;

CAnimTrayIcon::CAnimTrayIcon(const UINT unIconIDs[]):
    m_bInitialized( false ),
    m_unTimerID( -1 ),
    m_unTimerInterval( 100 ),
    m_unCurrentIcon( INACTIVE_ICON ),
    m_unCallbackID( 0 ),
    m_pParent( NULL ),
    m_szTip( _T("") )
{
    // Store all the icon IDs.
    for ( int i = 0; 0 != unIconIDs[i]; ++i )
    { 
        m_vunIconIDs.insert( m_vunIconIDs.end(), unIconIDs[i] );
    }
}

CAnimTrayIcon::~CAnimTrayIcon()
{
}


BEGIN_MESSAGE_MAP(CAnimTrayIcon, CWnd)
    ON_WM_TIMER()
    ON_WM_DESTROY()
END_MESSAGE_MAP()


///////////////////////////////////////////////////////////////////
// CAnimTrayIcon message handlers

void CAnimTrayIcon::Init( UINT unCallbackID, CWnd* pParent )
{
    ASSERT_VALID( pParent );
    m_pParent = pParent;

    // Creates a small, invisible child window on the parent.
    // This allows us to receive WM_TIMER messages.
    // This also allows us to clean up after ourselves.  We will
    // receive a WM_DESTROY message when our parent is destroyed.
    Create( NULL, "CAnimTrayIcon", WS_CHILD, CRect(0,0,1,1),
                m_pParent, 0 );
    m_bInitialized = true;

    // We don't use ShowIcon here because ShowIcon
    // relies on the tray icon already having been created.
    // This creates the icon in the tray.
    NOTIFYICONDATA strNIData;
    m_unCallbackID = unCallbackID;
    strNIData.cbSize = sizeof( strNIData );
    strNIData.hWnd   = m_pParent->GetSafeHwnd();
    strNIData.uID    = m_unCallbackID;
    strNIData.uCallbackMessage = m_unCallbackID;
    strcpy( strNIData.szTip, m_szTip );
    strNIData.hIcon = ::LoadIcon( AfxGetResourceHandle(), 
                        MAKEINTRESOURCE( m_vunIconIDs[0] ) );
    strNIData.uFlags = NIF_MESSAGE | NIF_TIP | NIF_ICON;
    Shell_NotifyIcon(NIM_ADD, &strNIData);
}

void CAnimTrayIcon::SetTip(const CString & szTip)
{
    // Get the maximum length of a tip.  This should
    // avoid us having to keep the length up to date.
    const UINT KunTipLength = ( sizeof ( NOTIFYICONDATA ) - 
                              offsetof( NOTIFYICONDATA, szTip ) )/
                              (sizeof( char ) );

    // If your code asserts here, the string being passed in
    // is too long to go into the tooltip.  
    ASSERT( szTip.GetLength() < KunTipLength );
    if ( szTip.GetLength() >= KunTipLength )
    {
        CString szError;
        szError.Format( 
            _T("The maximum length of a tip string is %d"),
            KunTipLength );
        throw std::length_error( std::string( szError ) );
    }

    // All is well, remember the new tip and set it if the user
    // has initialized the tray icon.
    m_szTip = szTip;
    if ( m_bInitialized )
    {
        NOTIFYICONDATA strNIData;
        strNIData.cbSize = sizeof( strNIData );
        strNIData.hWnd   = m_pParent->GetSafeHwnd();
        strNIData.uID    = m_unCallbackID;
        strcpy( strNIData.szTip, m_szTip );
        strNIData.uFlags = NIF_TIP;
        Shell_NotifyIcon(NIM_MODIFY, &strNIData);
    }
}

void CAnimTrayIcon::ShowIcon(UINT unIndex)
{
    // if the user has initialized the tray icon,
    // show the icon at the specified index.
    if ( m_bInitialized )
    {
        NOTIFYICONDATA strNIData;
        strNIData.cbSize = sizeof( strNIData );
        strNIData.hWnd   = m_pParent->GetSafeHwnd();
        strNIData.uID    = m_unCallbackID;
        strNIData.uFlags = NIF_ICON;
        strNIData.hIcon = ::LoadIcon( AfxGetResourceHandle(), 
                MAKEINTRESOURCE( m_vunIconIDs[unIndex] ) );
        Shell_NotifyIcon(NIM_MODIFY, &strNIData);
    }
}

void CAnimTrayIcon::StartAnimation()
{
    // If you assert here, you are calling this method before
    // calling Init.
    ASSERT( m_bInitialized );
    if ( m_bInitialized )
    {
        m_unCurrentIcon = FIRST_ANIMATED_ICON;
        m_unTimerID = SetTimer( m_unTimerID, m_unTimerInterval, NULL );
    }
}

void CAnimTrayIcon::StopAnimation()
{
    // If you assert here, you are calling this method before
    // calling Init.
    ASSERT( m_bInitialized );
    if ( m_bInitialized )
    {
        KillTimer( m_unTimerID );
        m_unCurrentIcon = INACTIVE_ICON;
        ShowIcon( m_unCurrentIcon );
    }
}

void CAnimTrayIcon::OnTimer(UINT nIDEvent) 
{
    // There should only be one timer for this class.  An assertion
    // here indicates that assumption is no longer valid.
    ASSERT( m_unTimerID == nIDEvent );
    ShowIcon( m_unCurrentIcon );
    ++m_unCurrentIcon;
    if ( m_unCurrentIcon >= m_vunIconIDs.size() )
    {
        m_unCurrentIcon = FIRST_ANIMATED_ICON;
    }
    CWnd::OnTimer(nIDEvent);
}

void CAnimTrayIcon::OnDestroy() 
{
    if ( !IsStopped() )
    {
        KillTimer( m_unTimerID );
    }
    NOTIFYICONDATA strNIData;
    strNIData.cbSize = sizeof( strNIData );
    strNIData.hWnd   = m_pParent->GetSafeHwnd();
    strNIData.uID    = m_unCallbackID;
    Shell_NotifyIcon(NIM_DELETE, &strNIData);
    CWnd::OnDestroy();
}

bool CAnimTrayIcon::IsStopped()
{
    return ( INACTIVE_ICON == m_unCurrentIcon );    
}
