#if !defined(_CANIMTRAYICON_H_)
#define _CANIMTRAYICON_H_

#ifndef _VECTOR_
    #include <vector>   //vector
#endif // _VECTOR_

///////////////////////////////////////////////////////////////////
// CAnimTrayIcon window

class CAnimTrayIcon : public CWnd
{
// Construction/Destruction
public:
    // unIconIDs: Pass a 0 terminated list of icons IDs.
    // The first icon is for when there is no animation.
    // The rest are for the animation.  The animation moves
    // from unIconIDs[1]-->unIconIDs[last], then repeats.
    CAnimTrayIcon( const UINT unIconIDs[] );
    virtual ~CAnimTrayIcon();

    static const int INACTIVE_ICON;
    static const int FIRST_ANIMATED_ICON;
// Operations
public:

// Implementation
public:
    // If the tray icon is not moving, returns true.
    // Otherwise, it returns false.
    bool IsStopped();

    // Stops the tray icon animation
    void StopAnimation();

    // Starts the tray icon animation.  
    void StartAnimation();

    // Sets the tooltip that is displayed when the
    // mouse cursor hovers over the tray icon
    void SetTip( const CString& szTip ) throw( std::length_error );

    // Call this member only when the owner CWnd has a valid HWND
    // unCallbackID:    This message ID must be unique to the
    //                  pParent window
    // pParent:         Pointer to the owner of the CAnimTrayIcon
    void Init( UINT unCallbackID, CWnd* pParent );

protected:
    afx_msg void OnTimer(UINT nIDEvent);
    afx_msg void OnDestroy();
    DECLARE_MESSAGE_MAP()
// Attributes
private:
    // Indicates the "on-deck" icon.  This will be the next
    // icon that the class will display.
    UINT m_unCurrentIcon;

    // This value can be tweaked to speed up or slow down the 
    // speed of the animation.  
    UINT m_unTimerInterval;

    // Uniquely identifies the timer event.
    UINT m_unTimerID;

    // Used internally to check if Init has been called yet.
    // If Init hasn't been called, this is false.
    bool m_bInitialized;

    // Identifies the message to use when sending messages
    // back to the parent window from the tray.
    UINT m_unCallbackID;

    // Indicates the tip to display when the user hovers
    // over the tray icon.
    CString m_szTip;

    // Stores the IDs of the various icons to display in the tray
    std::vector<UINT> m_vunIconIDs;

    // Points to the owner of the window.
    CWnd* m_pParent;

    // Helper method that shows the specified icon at the specified
    // index
    void ShowIcon( UINT unIndex );
};

#endif // !defined(_CANIMTRAYICON_H_)
