// TrayDlg.cpp : implementation file
//
#include "stdafx.h"

#if !defined(_ANIMTRAYICON_H_)
    #include "AnimTray.h"
#endif //_ANIMTRAYICON_H_

#if !defined(_ANIMTRAYICONDLG_H_)
    #include "TrayDlg.h"
#endif//_ANIMTRAYICONDLG_H_

#ifndef _INC_SHELLAPI
    #include <shellapi.h>
#endif //_INC_SHELLAPI

#if !defined(_ABOUTDLG_H_)
    #include "AboutDlg.h"
#endif//_ABOUTDLG_H_

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

const UINT g_KunIconID = WM_APP + 1;

///////////////////////////////////////////////////////////////////
// CAnimTrayIconDlg dialog
const UINT KunIconIDs[] = { IDI_ICON1, IDI_ICON2, IDI_ICON3,
                            IDI_ICON4, IDI_ICON5, IDI_ICON6,
                            IDI_ICON7, IDI_ICON8, 0 };

CAnimTrayIconDlg::CAnimTrayIconDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CAnimTrayIconDlg::IDD, pParent),
    m_oTrayIcon( KunIconIDs )
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAnimTrayIconDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAnimTrayIconDlg, CDialog)
    ON_WM_SYSCOMMAND()
    ON_BN_CLICKED(IDC_START, OnStart)
    ON_BN_CLICKED(IDC_STOP, OnStop)
    ON_COMMAND(IDM_STOP, OnStop)
    ON_COMMAND(IDM_START, OnStart)
    ON_MESSAGE( g_KunIconID, OnTrayMessage )
END_MESSAGE_MAP()

///////////////////////////////////////////////////////////////////
// CAnimTrayIconDlg message handlers

BOOL CAnimTrayIconDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    CMenu* pSysMenu = GetSystemMenu(FALSE);
    if (pSysMenu != NULL)
    {
        CString strAboutMenu;
        strAboutMenu.LoadString(IDS_ABOUTBOX);
        if (!strAboutMenu.IsEmpty())
        {
            pSysMenu->AppendMenu(MF_SEPARATOR);
            pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, 
                    strAboutMenu);
        }
    }
    SetIcon(m_hIcon, FALSE);        // Set small icon

    // Set the initial tip
    m_oTrayIcon.SetTip( "Icon hasn't been started yet" );

    // Tell the tray icon what message we want
    m_oTrayIcon.Init( g_KunIconID, this );
    return TRUE;
}

void CAnimTrayIconDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
    if ((nID & 0xFFF0) == IDM_ABOUTBOX)
    {
        CAboutDlg dlgAbout;
        dlgAbout.DoModal();
    }
    else
    {
        CDialog::OnSysCommand(nID, lParam);
    }
}

void CAnimTrayIconDlg::OnStart() 
{
    m_oTrayIcon.SetTip( "Icon is moving" );
    m_oTrayIcon.StartAnimation();
}

void CAnimTrayIconDlg::OnStop() 
{
    m_oTrayIcon.SetTip( "Icon is stopped" );
    m_oTrayIcon.StopAnimation();	
}

LONG CAnimTrayIconDlg::OnTrayMessage(WPARAM wparam, LPARAM lparam)
{   // The tray icon sent us a message.  Let's see what it is
    switch ( lparam )
    {
        case WM_RBUTTONDOWN:
            {// The user clicked the right mouse button.
             // Let's give them a menu so they can start/stop   
             // the animation.   
                CMenu oMenu;
                if (oMenu.LoadMenu(IDR_MNU_TRAY))        
                {
                    CMenu* pPopup = oMenu.GetSubMenu(0);
                    ASSERT(pPopup != NULL);
                    CPoint oPoint;
                    // Figure out where the mouse is so we
                    // can display the menu near it.
					GetCursorPos( &oPoint );
                    SetForegroundWindow();
                    pPopup->TrackPopupMenu(
                        TPM_LEFTALIGN | TPM_RIGHTBUTTON,
                        oPoint.x, oPoint.y, this); 
                }
            }
            break;
    }
    return 0;
}
