#include <stdlib.h>
#include <stdio.h>
#include <windows.h>

volatile int GlobalInt = 0;

#ifdef __BORLANDC__
#   pragma argsused
#endif
DWORD WINAPI Thread0(LPVOID Arg)
{
   int i;

   for (;;) {
      if (GlobalInt == -1) {
         printf("+");
         GlobalInt++;
      } else if (GlobalInt != 0) {
         printf("Oops-0!");
         exit(EXIT_FAILURE);
      } else
         Sleep(0);  /* give up time slice */
   }
   return 0;
} 

#ifdef __BORLANDC__
#   pragma argsused
#endif
DWORD WINAPI Thread1(LPVOID Arg)
{
   int i;

   for (;;) {
      if (GlobalInt == 0) {
         printf("-");
         GlobalInt--;
      } else if (GlobalInt != -1) {
         printf("Oops-1!");
         exit(EXIT_FAILURE);
      } else
         Sleep(0);  /* give up time slice */
   }
   return 1;
} 

int main(int argc, char *argv[])
{
    DWORD   Id, pAff, sAff;
    HANDLE  T1, T2;

    if (argc <= 1) {
       printf("ERROR: Requires affinity parameter (1 or 2)\n");
       return EXIT_FAILURE;
    }

    T1 = CreateThread(0, 0, Thread0, 0, 0, &Id);
    T2 = CreateThread(0, 0, Thread1, 0, 0, &Id);

    GetProcessAffinityMask(GetCurrentProcess(), &pAff, &sAff);
    
    if (*argv[1] == '1') {
        SetThreadAffinityMask(T1, 0x01);
        SetThreadAffinityMask(T2, 0x01);
    } else if ((*argv[1] == '2') && (pAff & 0x3)) {
       SetThreadAffinityMask(T1, 0x01);
       SetThreadAffinityMask(T2, 0x02);
    } else {
       printf("ERROR\n");
       return EXIT_FAILURE;
    }
   
    WaitForSingleObject(T1, INFINITE);
    WaitForSingleObject(T2, INFINITE);
    return EXIT_SUCCESS;
}

