// This program demonstrates an apparent problem with the AnsiString
// class as implemented in C++ Builder 1 and 3.  Like most string
// classes, AnsiString should use the copy-on-write technique,
// which makes for efficient copy and assigment operations. 
//
// Unfortunately, copy-on-write seems to be broken, as this demo 
// shows.  In this case, we use an assignment operator to create 
// two objects that point to the same master storage.  Changing a 
// single character in one object should trigger a copy, so that 
// we can then have two distinct strings.  As the program output 
// shows, this doesn't happen.
//
// A second operation, concatenating characters to the end of
// the string, seems to trigger a copy, so that the second operation 
// works as expected.
//
// To build this program, simply create a new console application 
// under C++Builder 1 or 3, and copy this source into the main
// cpp file.  Compile, run, and enjoy! 
//
#include <vcl\condefs.h>
#include <vcl\dstring.h>
#include <iostream.h>
#include <conio.h>

#pragma hdrstop

//------------------------------------------------------------------- 
USERES("Oct98.res");
//------------------------------------------------------------------- 
int main(int argc, char **argv)
{
    AnsiString s1;
    AnsiString s2;
    s1 = "Hello, world!";
    s2 = s1;
    cout << "s1 and s2 are the same at this point:\n"; 
    cout << "s1 = " << s1 << endl;
    cout << "s2 = " << s2 << endl;
   //
    s2[ 1 ] = 'X';
    cout << "\ns1 and s2 should be different now:\n"; 
    cout << "s1 = " << s1 << endl;
    cout << "s2 = " << s2 << endl;
    //
    s2 += "X";
    cout << "\ns1 and s2 should really be different now:\n"; 
    cout << "s1 = " << s1 << endl;
    cout << "s2 = " << s2 << endl;
   //
    cout << "\nHit any key to continue..." << flush;
   getch();
   return 0;
}


