//+ Queue.h: interface for the CQueue class.

#ifndef __QUEUE_H__
#define __QUEUE_H__

class CQueue  
{
    enum {FMT_NAME_FIRST_TRY = 54};

// Construction/Destruction
public:
    CQueue();
    virtual ~CQueue();
    HRESULT Create();
    HRESULT Open(const CLSID* type);
    HRESULT Open(LPCWSTR lpwcsPathName, DWORD dwAccess,
        DWORD dwShareMode);
    void Close();
    void CloseHandles();

// Attributes
    // Read Properties
    MQPROPVARIANT* GetReadProperty(MSGPROPID propID);
    void SetReadProperty(MSGPROPID propID, size_t cElems = 0);

    // Write Properties
    void SetWriteProperty(MSGPROPID propID, LPWSTR lpwString);
    void SetWriteProperty(MSGPROPID propID, PBYTE blob,
        size_t nBytes);
    void SetWriteProperty(MSGPROPID propID, const CLSID* pCLSID);

    // Miscellaneous
    bool IsOpen() const { return m_vecHQueue.size() > 0; }
    int HandleCount() const { return m_vecHQueue.size(); }
    HANDLE GetEventHandle() { return m_overlapped.hEvent; }

// Operations
    void ReceiveNonBlock();
    void Send();
    void ResetProperties();
    void Reset();

// Implementation
private:
    // State Variables
    vector<QUEUEHANDLE>     m_vecHQueue;
    vector<MQPROPVARIANT>   m_msgVals;
    vector<MSGPROPID>       m_msgPropIDs;
    OVERLAPPED              m_overlapped;
    MQMSGPROPS              m_msgProps;

    // Helper Functions
    LPWSTR GetFmtName(LPCWSTR lpwcsPathName);
};

bool operator<(const MQPROPVARIANT& l, const MQPROPVARIANT& r);
bool operator==(const MQPROPVARIANT& l, const MQPROPVARIANT& r);


#endif //__QUEUE_H__
