//+ File:      TryMQ.cpp

#define STRICT
#include <windows.h>
#include <comdef.h>
#include <crtdbg.h>
#include <mq.h>
#pragma warning(disable: 4786)  // OK to ignore symbol > 255
#include <vector>
#include <string>
#include <algorithm>
using namespace std;
#include "Queue.h"

// {CA767EB0-774E-11d1-8B81-00AA006B0C2B}
static const GUID GUID_NotifyQueue = 
{ 0xca767eb0, 0x774e, 0x11d1,
{ 0x8b, 0x81, 0x0, 0xaa, 0x0, 0x6b, 0xc, 0x2b } };

#if ! defined(UNICODE)
#error UNICODE must be defined
#endif

WCHAR QueueName[80];

static HRESULT OpenReadQueue(CQueue& queue)
{
    TCHAR cpuname[MAX_COMPUTERNAME_LENGTH + 1];
    DWORD dwNumChars = MAX_COMPUTERNAME_LENGTH + 1;
    GetComputerName(cpuname, &dwNumChars);
    _bstr_t computername(cpuname);
    WCHAR buffer[MAX_PATH];
    swprintf(buffer, L"Notify:%s", (wchar_t*) computername);
    queue.SetWriteProperty(PROPID_Q_LABEL, buffer);
    swprintf(buffer, L"%s\\%s", (wchar_t*) computername, QueueName);
    queue.SetWriteProperty(PROPID_Q_PATHNAME, buffer);
    queue.SetWriteProperty(PROPID_Q_TYPE, &GUID_NotifyQueue);
    queue.Create();
    queue.ResetProperties();
    return queue.Open(buffer, MQ_RECEIVE_ACCESS,
        MQ_DENY_RECEIVE_SHARE);
}

static HANDLE ReadThisQueue(CQueue& theQueue)
{
    theQueue.Reset();
    theQueue.SetReadProperty(PROPID_M_BODY, 640);
    theQueue.ReceiveNonBlock();
    return theQueue.GetEventHandle();
}

static void ProcessNotifyMessage(CQueue& queue)
{
    MQPROPVARIANT* pVar = queue.GetReadProperty(PROPID_M_BODY);
    wprintf(L"\n%s\n", pVar->caub.pElems);
}

static DWORD WINAPI ListenThread(void* pv)
{
    CQueue queue;
    HANDLE events[2];
    DWORD numEvt = sizeof events / sizeof *events;
    
    events[0] = (HANDLE) pv;
    if (FAILED(OpenReadQueue(queue))) return 1;
    
    events[1] = ReadThisQueue(queue);
    while (1)
    {
        WaitForMultipleObjects(numEvt, events, FALSE, INFINITE);
        if (WaitForSingleObject(events[0], 0) == WAIT_OBJECT_0)
            break;
        if (WaitForSingleObject(events[1], 0) == WAIT_OBJECT_0)
        {
            ProcessNotifyMessage(queue);
            events[1] = ReadThisQueue(queue);
        }
    }
    return 0;
}

main()
{
    int argc;
    LPWSTR* argv = 0;
    CQueue queue;
    DWORD dwThreadID;
    HANDLE EventHandle;
    HANDLE ThreadHandle;

    argv = CommandLineToArgvW(GetCommandLineW(), &argc);

    if (argc != 2) return 1;
    wcscpy(QueueName, argv[1]);
    LocalFree(argv);

    EventHandle = CreateEvent(NULL, TRUE, FALSE, NULL);
    ThreadHandle = CreateThread(NULL, 0, &ListenThread,
            EventHandle, 0, &dwThreadID);
    if (FAILED(queue.Open(&GUID_NotifyQueue))) return 1;

    while (1)
    {
        static const size_t nch = 80;
        static const size_t nby = nch * sizeof(WCHAR);
        WCHAR Buffer[nch];
        wprintf(L"Enter msg text (enter to quit): ");
        if (_getws(Buffer) == NULL) break;
        if (wcslen(Buffer) == 0) break;
        queue.ResetProperties();
        PBYTE pByte = new BYTE[nby];
        memcpy(pByte, Buffer, nby);

        queue.SetWriteProperty(PROPID_M_BODY, pByte, nby);
        // Passing the body to the queue also passes ownership.
        // The queue is now responsible for deleting the memory. 
        queue.Send();
    }

    SetEvent(EventHandle);
    WaitForSingleObject(ThreadHandle, INFINITE);
    CloseHandle(ThreadHandle);
    CloseHandle(EventHandle);
    return 0;
}
