
/*  A Bison parser, made from dfilter-grammar.y
 by  GNU Bison version 1.27
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	T_FT_UINT8	257
#define	T_FT_UINT16	258
#define	T_FT_UINT32	259
#define	T_FT_ETHER	260
#define	T_FT_IPv4	261
#define	T_FT_NONE	262
#define	T_FT_BYTES	263
#define	T_FT_BOOLEAN	264
#define	T_FT_STRING	265
#define	T_FT_IPXNET	266
#define	T_VAL_UNQUOTED_STRING	267
#define	T_VAL_ETHER	268
#define	T_VAL_BYTES	269
#define	T_VAL_BYTE_RANGE	270
#define	TOK_AND	271
#define	TOK_OR	272
#define	TOK_NOT	273
#define	TOK_XOR	274
#define	TOK_EQ	275
#define	TOK_NE	276
#define	TOK_GT	277
#define	TOK_GE	278
#define	TOK_LT	279
#define	TOK_LE	280
#define	TOK_TRUE	281
#define	TOK_FALSE	282

#line 1 "dfilter-grammar.y"


/* dfilter-grammar.y
 * Parser for display filters
 *
 * $Id: dfilter-grammar.y,v 1.6 1999/08/11 16:25:07 gram Exp $
 *
 * Ethereal - Network traffic analyzer
 * By Gerald Combs <gerald@zing.org>
 * Copyright 1998 Gerald Combs
 *
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#define yylex dfilter_lex

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#ifdef HAVE_SYS_TYPES_H
# include <sys/types.h>
#endif

#ifdef HAVE_NETINET_IN_H
# include <netinet/in.h>
#endif

#ifndef __GLIB_H__
#include <glib.h>
#endif

#include <string.h> /* during testing */

#ifndef _STDLIB_H
#include <stdlib.h>
#endif

#ifndef __PROTO_H__
#include "proto.h"
#endif

#ifndef __PACKET_H__
#include "packet.h"
#endif

#ifndef __DFILTER_H__
#include "dfilter.h"
#endif

#ifndef __RESOLV_H__
#include "resolv.h"
#endif

void dfilter_yacc_init(void);
static GNode* dfilter_mknode_join(GNode *n1, enum node_type ntype, int operand, GNode *n2);
static GNode* dfilter_mknode_unary(int operand, GNode *n2);
static GNode* dfilter_mknode_numeric_variable(gint id);
static GNode* dfilter_mknode_numeric_value(guint32 val);
static GNode* dfilter_mknode_ether_value(guint8*);
static GNode* dfilter_mknode_ether_variable(gint id);
static GNode* dfilter_mknode_ipxnet_value(guint32);
static GNode* dfilter_mknode_ipxnet_variable(gint id);
static GNode* dfilter_mknode_ipv4_value(char *host);
static GNode* dfilter_mknode_ipv4_variable(gint id);
static GNode* dfilter_mknode_existence(gint id);
static GNode* dfilter_mknode_bytes_value(GByteArray *barray);
static GNode* dfilter_mknode_bytes_variable(gint id, gint offset, guint length);
static GNode* dfilter_mknode_boolean_value(gint truth_value);
static GNode* dfilter_mknode_boolean_variable(gint id);

static guint32 string_to_value(char *s);

/* space for dfilter_nodes */
GMemChunk *gmc_dfilter_nodes = NULL;

/* this is how we pass display filter tree (dfcode) back to calling routine */
GNode *dfilter_tree = NULL;

/* list of byte arrays we allocate during parse. We can traverse this list
 * faster than the tree when we go back and free the byte arrays */
GSList *dfilter_list_byte_arrays = NULL;


#line 99 "dfilter-grammar.y"
typedef union {
	gint		operand;	/* logical, relation, alternation */
	gint		variable;
	GNode*		node;
	gchar*		id;
	GByteArray*	bytes;
	guint8		ether[6];
	struct {
		gint	offset;
		guint	length;
	} byte_range;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		87
#define	YYFLAG		-32768
#define	YYNTBASE	31

#define YYTRANSLATE(x) ((unsigned)(x) <= 282 ? yytranslate[x] : 51)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,    29,
    30,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
    27,    28
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     2,     3,     7,    11,    15,    19,    22,    24,    26,
    30,    34,    38,    42,    46,    50,    54,    58,    62,    66,
    70,    74,    76,    78,    80,    82,    84,    86,    88,    90,
    92,    94,    96,    98,   100,   102,   104,   106,   109,   111,
   113,   115,   117,   119,   121,   123,   125,   127,   129,   131,
   133,   135,   137,   139,   141,   143,   145,   147,   149,   151
};

static const short yyrhs[] = {    32,
     0,     0,    29,    32,    30,     0,    32,    17,    32,     0,
    32,    18,    32,     0,    32,    20,    32,     0,    19,    32,
     0,    33,     0,    44,     0,    40,    48,    34,     0,    40,
    48,    40,     0,    41,    49,    35,     0,    41,    49,    41,
     0,    42,    49,    36,     0,    42,    49,    42,     0,    43,
    48,    37,     0,    43,    48,    43,     0,    45,    50,    38,
     0,    45,    50,    45,     0,    46,    49,    39,     0,    46,
    49,    46,     0,    13,     0,    14,     0,    13,     0,    13,
     0,    15,     0,    13,     0,    14,     0,    27,     0,    28,
     0,     3,     0,     4,     0,     5,     0,     6,     0,    12,
     0,     7,     0,    47,     0,    47,    16,     0,    10,     0,
     3,     0,     4,     0,     5,     0,     6,     0,     7,     0,
     8,     0,     9,     0,    10,     0,    11,     0,    21,     0,
    22,     0,    23,     0,    24,     0,    25,     0,    26,     0,
    21,     0,    22,     0,    21,     0,    22,     0,    23,     0,
    25,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   154,   158,   161,   162,   163,   164,   165,   166,   167,   170,
   174,   179,   183,   188,   192,   198,   202,   207,   211,   216,
   220,   228,   235,   241,   247,   254,   259,   272,   283,   284,
   288,   289,   290,   293,   296,   299,   302,   305,   311,   314,
   315,   316,   317,   318,   319,   320,   321,   322,   325,   326,
   327,   328,   329,   330,   333,   334,   337,   338,   339,   340
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","T_FT_UINT8",
"T_FT_UINT16","T_FT_UINT32","T_FT_ETHER","T_FT_IPv4","T_FT_NONE","T_FT_BYTES",
"T_FT_BOOLEAN","T_FT_STRING","T_FT_IPXNET","T_VAL_UNQUOTED_STRING","T_VAL_ETHER",
"T_VAL_BYTES","T_VAL_BYTE_RANGE","TOK_AND","TOK_OR","TOK_NOT","TOK_XOR","TOK_EQ",
"TOK_NE","TOK_GT","TOK_GE","TOK_LT","TOK_LE","TOK_TRUE","TOK_FALSE","'('","')'",
"statement","expression","relation","numeric_value","ether_value","ipxnet_value",
"ipv4_value","bytes_value","boolean_value","numeric_variable","ether_variable",
"ipxnet_variable","ipv4_variable","variable_name","bytes_variable","boolean_variable",
"any_variable_type","numeric_relation","equality_relation","bytes_relation", NULL
};
#endif

static const short yyr1[] = {     0,
    31,    31,    32,    32,    32,    32,    32,    32,    32,    33,
    33,    33,    33,    33,    33,    33,    33,    33,    33,    33,
    33,    34,    35,    36,    37,    38,    38,    38,    39,    39,
    40,    40,    40,    41,    42,    43,    44,    45,    46,    47,
    47,    47,    47,    47,    47,    47,    47,    47,    48,    48,
    48,    48,    48,    48,    49,    49,    50,    50,    50,    50
};

static const short yyr2[] = {     0,
     1,     0,     3,     3,     3,     3,     2,     1,     1,     3,
     3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
     3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1
};

static const short yydefact[] = {     2,
    31,    32,    33,    43,    36,    45,    46,    47,    48,    35,
     0,     0,     1,     8,     0,     0,     0,     0,     9,     0,
     0,    37,     7,     0,     0,     0,     0,    49,    50,    51,
    52,    53,    54,     0,    55,    56,     0,     0,     0,    57,
    58,    59,    60,     0,     0,    38,     3,     4,     5,     6,
    31,    32,    33,    22,    10,    11,    34,    23,    12,    13,
    24,    14,    15,    36,    25,    16,    17,    40,    41,    42,
    43,    44,    47,    27,    28,    26,    18,    19,     0,    39,
    29,    30,    20,    21,     0,     0,     0
};

static const short yydefgoto[] = {    85,
    13,    14,    55,    59,    62,    66,    77,    83,    15,    16,
    17,    18,    19,    20,    21,    22,    34,    37,    44
};

static const short yypact[] = {    54,
     0,     5,    11,    -9,    26,-32768,-32768,    74,-32768,-32768,
    54,    54,    73,-32768,    29,    77,    77,    29,-32768,    46,
    77,    -8,-32768,   -16,    54,    54,    54,-32768,-32768,-32768,
-32768,-32768,-32768,    84,-32768,-32768,     1,    88,    -4,-32768,
-32768,-32768,-32768,    71,     9,-32768,-32768,    20,     4,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    -8,-32768,
-32768,-32768,-32768,-32768,    32,    39,-32768
};

static const short yypgoto[] = {-32768,
    22,-32768,-32768,-32768,-32768,-32768,-32768,-32768,    36,     8,
    34,    53,-32768,    50,    57,    59,    86,   -11,-32768
};


#define	YYLAST		104


static const short yytable[] = {   -40,
    25,    26,    64,    27,   -41,    38,    57,    46,    65,    45,
   -42,   -34,   -34,    47,    58,   -40,   -40,   -40,    80,   -40,
   -41,   -41,   -41,    27,   -41,   -44,   -42,   -42,   -42,   -40,
   -42,    86,    23,    24,   -41,    81,    82,    26,    87,    27,
   -42,   -44,   -44,   -44,    60,   -44,    48,    49,    50,    28,
    29,    30,    31,    32,    33,   -44,     1,     2,     3,     4,
     5,     6,     7,     8,     9,    10,    40,    41,    42,    56,
    43,    63,    11,    68,    69,    70,    71,    72,     6,     7,
    73,     9,    12,    74,    75,    76,    51,    52,    53,    25,
    26,    67,    27,    78,   -39,   -39,    54,    35,    36,    10,
    61,    84,    79,    39
};

static const short yycheck[] = {     0,
    17,    18,     7,    20,     0,    17,     6,    16,    13,    21,
     0,    21,    22,    30,    14,    16,    17,    18,    10,    20,
    16,    17,    18,    20,    20,     0,    16,    17,    18,    30,
    20,     0,    11,    12,    30,    27,    28,    18,     0,    20,
    30,    16,    17,    18,    37,    20,    25,    26,    27,    21,
    22,    23,    24,    25,    26,    30,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    21,    22,    23,    34,
    25,    38,    19,     3,     4,     5,     6,     7,     8,     9,
    10,    11,    29,    13,    14,    15,     3,     4,     5,    17,
    18,    39,    20,    44,    21,    22,    13,    21,    22,    12,
    13,    45,    44,    18
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.27.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC malloc
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      free (yyss);
	      free (yyvs);
#ifdef YYLSP_NEEDED
	      free (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 155 "dfilter-grammar.y"
{
			dfilter_tree = yyvsp[0].node;
		;
    break;}
case 2:
#line 158 "dfilter-grammar.y"
{ dfilter_tree = NULL; ;
    break;}
case 3:
#line 161 "dfilter-grammar.y"
{ yyval.node = yyvsp[-1].node; ;
    break;}
case 4:
#line 162 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 5:
#line 163 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 6:
#line 164 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_join(yyvsp[-2].node, logical, yyvsp[-1].operand, yyvsp[0].node); ;
    break;}
case 7:
#line 165 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_unary(TOK_NOT, yyvsp[0].node); ;
    break;}
case 8:
#line 166 "dfilter-grammar.y"
{ yyval.node = yyvsp[0].node; ;
    break;}
case 9:
#line 167 "dfilter-grammar.y"
{ yyval.node = yyvsp[0].node; ;
    break;}
case 10:
#line 171 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 11:
#line 175 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 12:
#line 180 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 13:
#line 184 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 14:
#line 189 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 15:
#line 193 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 16:
#line 199 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 17:
#line 203 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 18:
#line 208 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 19:
#line 212 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 20:
#line 217 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 21:
#line 221 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_join(yyvsp[-2].node, relation, yyvsp[-1].operand, yyvsp[0].node);
		;
    break;}
case 22:
#line 229 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_numeric_value(string_to_value(yyvsp[0].id));
		g_free(yyvsp[0].id);
	 ;
    break;}
case 23:
#line 236 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_ether_value(yyvsp[0].ether);
		;
    break;}
case 24:
#line 242 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_ipxnet_value(string_to_value(yyvsp[0].id));
		;
    break;}
case 25:
#line 248 "dfilter-grammar.y"
{
		yyval.node = dfilter_mknode_ipv4_value(yyvsp[0].id);
		g_free(yyvsp[0].id);
	;
    break;}
case 26:
#line 255 "dfilter-grammar.y"
{								/* 2 - 5, or > 6 bytes */
		 yyval.node = dfilter_mknode_bytes_value(yyvsp[0].bytes);
	;
    break;}
case 27:
#line 260 "dfilter-grammar.y"
{								/* one byte */
		GByteArray	*barray = g_byte_array_new();
		guint8		val;
		char		*endptr;

		dfilter_list_byte_arrays = g_slist_append(dfilter_list_byte_arrays, barray);
		val = (guint8) strtoul(yyvsp[0].id, &endptr, 16);
		g_byte_array_append(barray, &val, 1);
		yyval.node = dfilter_mknode_bytes_value(barray);
		g_free(yyvsp[0].id);
	;
    break;}
case 28:
#line 273 "dfilter-grammar.y"
{								/* 6 bytes */
		GByteArray	*barray = g_byte_array_new();

		dfilter_list_byte_arrays = g_slist_append(dfilter_list_byte_arrays, barray);
		g_byte_array_append(barray, yyvsp[0].ether, 6);
		yyval.node = dfilter_mknode_bytes_value(barray);
	;
    break;}
case 29:
#line 283 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_boolean_value(yyvsp[0].operand); ;
    break;}
case 30:
#line 284 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_boolean_value(yyvsp[0].operand); ;
    break;}
case 31:
#line 288 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable); ;
    break;}
case 32:
#line 289 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable); ;
    break;}
case 33:
#line 290 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_numeric_variable(yyvsp[0].variable); ;
    break;}
case 34:
#line 293 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ether_variable(yyvsp[0].variable); ;
    break;}
case 35:
#line 296 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipxnet_variable(yyvsp[0].variable); ;
    break;}
case 36:
#line 299 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_ipv4_variable(yyvsp[0].variable); ;
    break;}
case 37:
#line 302 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_existence(yyvsp[0].variable); ;
    break;}
case 38:
#line 306 "dfilter-grammar.y"
{
			yyval.node = dfilter_mknode_bytes_variable(yyvsp[-1].variable, yyvsp[0].byte_range.offset, yyvsp[0].byte_range.length);
		;
    break;}
case 39:
#line 311 "dfilter-grammar.y"
{ yyval.node = dfilter_mknode_boolean_variable(yyvsp[0].variable); ;
    break;}
case 40:
#line 314 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 41:
#line 315 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 42:
#line 316 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 43:
#line 317 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 44:
#line 318 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 45:
#line 319 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 46:
#line 320 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 47:
#line 321 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 48:
#line 322 "dfilter-grammar.y"
{ yyval.variable = yyvsp[0].variable; ;
    break;}
case 49:
#line 325 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 50:
#line 326 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 51:
#line 327 "dfilter-grammar.y"
{ yyval.operand = TOK_GT; ;
    break;}
case 52:
#line 328 "dfilter-grammar.y"
{ yyval.operand = TOK_GE; ;
    break;}
case 53:
#line 329 "dfilter-grammar.y"
{ yyval.operand = TOK_LT; ;
    break;}
case 54:
#line 330 "dfilter-grammar.y"
{ yyval.operand = TOK_LE; ;
    break;}
case 55:
#line 333 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 56:
#line 334 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 57:
#line 337 "dfilter-grammar.y"
{ yyval.operand = TOK_EQ; ;
    break;}
case 58:
#line 338 "dfilter-grammar.y"
{ yyval.operand = TOK_NE; ;
    break;}
case 59:
#line 339 "dfilter-grammar.y"
{ yyval.operand = TOK_GT; ;
    break;}
case 60:
#line 340 "dfilter-grammar.y"
{ yyval.operand = TOK_LT; ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) malloc(size + 15);
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      free(msg);
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      free (yyss);
      free (yyvs);
#ifdef YYLSP_NEEDED
      free (yyls);
#endif
    }
  return 1;
}
#line 343 "dfilter-grammar.y"


void
dfilter_yacc_init(void)
{
	if (gmc_dfilter_nodes)
		g_mem_chunk_destroy(gmc_dfilter_nodes);

	gmc_dfilter_nodes = g_mem_chunk_new("gmc_dfilter_nodes",
		sizeof(dfilter_node), 50 * sizeof(dfilter_node),
		G_ALLOC_ONLY);

	if (dfilter_list_byte_arrays) {
		/* clear the byte arrays */
		g_slist_free(dfilter_list_byte_arrays);
	}
		
}

void
dfilter_yacc_cleanup(void)
{
	if (gmc_dfilter_nodes)
		g_mem_chunk_destroy(gmc_dfilter_nodes);
}


static GNode*
dfilter_mknode_join(GNode *n1, enum node_type ntype, int operand, GNode *n2)
{
	dfilter_node	*node_root;
	GNode		*gnode_root;

	node_root = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node_root->ntype = ntype;
	node_root->elem_size = 0;
	node_root->fill_array_func = NULL;
	node_root->check_relation_func = NULL;
	if (ntype == relation) {
		node_root->value.relation = operand;
	}
	else if (ntype == logical) {
		node_root->value.logical = operand;
	}
	else {
		g_assert_not_reached();
	}

	gnode_root = g_node_new(node_root);
	g_node_append(gnode_root, n1);
	g_node_append(gnode_root, n2);

	return gnode_root;
}

static GNode*
dfilter_mknode_unary(int operand, GNode *n2)
{
	dfilter_node	*node_root;
	GNode		*gnode_root;

	node_root = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node_root->ntype = logical;
	node_root->value.logical = operand;
	node_root->elem_size = 0;
	node_root->fill_array_func = NULL;
	node_root->check_relation_func = NULL;

	gnode_root = g_node_new(node_root);
	g_node_append(gnode_root, n2);

	return gnode_root;
}


static GNode*
dfilter_mknode_numeric_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = variable;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_numeric_variable;
	node->check_relation_func = check_relation_numeric;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ether_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = variable;
	node->elem_size = sizeof(guint8) * 6;
	node->fill_array_func = fill_array_ether_variable;
	node->check_relation_func = check_relation_ether;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipxnet_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = variable;
	node->elem_size = sizeof(guint8) * 4;
	node->fill_array_func = fill_array_numeric_variable; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipv4_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = variable;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_numeric_variable; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_bytes_variable(gint id, gint offset, guint length)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = variable;
	node->elem_size = sizeof(GByteArray*);
	node->fill_array_func = fill_array_bytes_variable;
	node->check_relation_func = check_relation_bytes;
	node->value.variable = id;
	node->offset = offset;
	node->length = length;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_boolean_variable(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = variable;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_boolean_variable; /* cheating ! */
	node->check_relation_func = check_relation_boolean; /* cheating ! */
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_numeric_value(guint32 val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = numeric;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_numeric_value;
	node->check_relation_func = check_relation_numeric;
	node->value.numeric = val;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ether_value(guint8 *ether_bytes)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = ether;
	node->elem_size = sizeof(guint8) * 6;
	node->fill_array_func = fill_array_ether_value;
	node->check_relation_func = check_relation_ether;

	memcpy(&node->value.ether, ether_bytes, 6);

	gnode = g_node_new(node);
	return gnode;
}

static GNode*
dfilter_mknode_ipxnet_value(guint32 ipx_net_val)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = ipxnet;
	node->elem_size = sizeof(guint8) * 4;
	node->fill_array_func = fill_array_numeric_value; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.numeric = ipx_net_val;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_ipv4_value(char *host)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = numeric;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_numeric_value; /* cheating ! */
	node->check_relation_func = check_relation_numeric; /* cheating ! */
	node->value.numeric = get_host_ipaddr(host);
	node->value.numeric = htonl(node->value.numeric);
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_bytes_value(GByteArray *barray)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = bytes;
	node->elem_size = sizeof(GByteArray*);
	node->fill_array_func = fill_array_bytes_value;
	node->check_relation_func = check_relation_bytes;
	node->value.bytes = barray;
	node->offset = G_MAXINT;
	node->length = barray->len;
	gnode = g_node_new(node);

	return gnode;
}

static GNode*
dfilter_mknode_boolean_value(gint truth_value)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = numeric;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = fill_array_boolean_value;
	node->check_relation_func = check_relation_boolean;
	node->value.boolean = truth_value == TOK_TRUE ? TRUE : FALSE;
	gnode = g_node_new(node);

	return gnode;
}

static guint32
string_to_value(char *s)
{
	char	*endptr;
	guint32	val;

	val = strtoul(s, &endptr, 0);
	/* I should probably check errno here */

	return (guint32)val;
}
	
static GNode*
dfilter_mknode_existence(gint id)
{
	dfilter_node	*node;
	GNode		*gnode;

	node = g_mem_chunk_alloc(gmc_dfilter_nodes);
	node->ntype = existence;
	node->elem_size = sizeof(guint32);
	node->fill_array_func = NULL;
	node->check_relation_func = NULL;
	node->value.variable = id;
	gnode = g_node_new(node);

	return gnode;
}
