/*
 * Decompiled with CFR 0.152.
 */
package jscan.ui;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Properties;
import jscan.net.Boss;

public class WebScan
extends Panel
implements ActionListener,
AdjustmentListener {
    private final String FILE = "jscan.txt";
    private final String CR = System.getProperty("line.separator");
    private Properties jscan_properties;
    private TextField host_name;
    private TextField netmask;
    private List vul_list;
    private TextArea output;
    private Button start_scan;
    private Button exit;
    private Button cancel;
    private Button interrupt;
    private Label lab_info;
    private Checkbox all_vul;
    private Choice request_method;
    private GridBagLayout gridbag;
    private GridBagConstraints constraints;

    public WebScan(TextArea textArea) {
        this.output = textArea;
        this.initialize();
        this.initActionListener();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block8: {
            if (actionEvent.getSource() == this.getButtonSCAN()) {
                try {
                    if (this.getVulList().getSelectedItems().length != 0) {
                        this.getOutputArea().setText("");
                        this.getLabelInfo().setText("Zt4rt1ng zk4n%&@!");
                        new Thread(new Boss(InetAddress.getByName(this.getHostName().getText()), this.getVulList().getSelectedItems(), this.getLabelInfo(), this.getOutputArea(), this.getButtonINTERRUPT(), this.getRequestMethod().getSelectedItem(), this.getNetmask().getText())).start();
                        return;
                    }
                    break block8;
                }
                catch (UnknownHostException unknownHostException) {
                    this.getOutputArea().setText(unknownHostException.toString());
                    return;
                }
                catch (IOException iOException) {
                    this.getOutputArea().setText(iOException.toString());
                    return;
                }
            }
            if (actionEvent.getSource() == this.getButtonEXIT()) {
                System.exit(0);
                return;
            }
            if (actionEvent.getSource() == this.getButtonCANCEL()) {
                this.getLabelInfo().setText("|-=o0O0o=-|");
                this.getOutputArea().setText("");
                int[] nArray = this.getVulList().getSelectedIndexes();
                int n = 0;
                while (n < nArray.length) {
                    this.getVulList().deselect(nArray[n]);
                    ++n;
                }
                this.getVulList().select(0);
            }
        }
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        int n = adjustmentEvent.getAdjustmentType();
        if (n == 1) {
            ((TextComponent)this.getNetmask()).setText("32");
            return;
        }
        if (n == 2) {
            ((TextComponent)this.getNetmask()).setText("24");
            return;
        }
        if (n == 5) {
            String string = this.getNetmask().getText();
            if (string.equals("32")) {
                ((TextComponent)this.getNetmask()).setText("24");
                return;
            }
            ((TextComponent)this.getNetmask()).setText("32");
        }
    }

    private void initialize() {
        this.gridbag = new GridBagLayout();
        this.setLayout(this.gridbag);
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 17;
        this.constraints.fill = 2;
        this.constraints.gridwidth = 0;
        this.constraints.weightx = 1.0;
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0));
        panel.add(new Label("H0zt t0 zk4n:"));
        panel.add(this.getHostName());
        panel.add(new Label("R3qu3zt:"));
        panel.add(this.getRequestMethod());
        panel.add(new Label("N3ttm4zk:"));
        this.getNetmask().setEditable(false);
        ((Component)this.getNetmask()).setBackground(Color.blue);
        this.getNetmask().setForeground(Color.yellow);
        panel.add(this.getNetmask());
        Scrollbar scrollbar = new Scrollbar(0, 32, 8, 24, 33);
        scrollbar.addAdjustmentListener(this);
        panel.add(scrollbar);
        this.gridbag.setConstraints(panel, this.constraints);
        this.add(panel);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0));
        panel2.add(new Label("Ch00z3 z1ngl3/mult1pl3 \"f1l3(z)\"t0 zk4n 4ft3r..."));
        this.gridbag.setConstraints(panel2, this.constraints);
        this.add(panel2);
        this.getVulList().select(0);
        this.getVulList().setMultipleMode(true);
        this.gridbag.setConstraints(this.getVulList(), this.constraints);
        this.add(this.getVulList());
        this.gridbag.setConstraints(this.getOutputArea(), this.constraints);
        this.add(this.getOutputArea());
        Panel panel3 = new Panel();
        panel3.setLayout(new FlowLayout(1));
        panel3.add(this.getButtonSCAN());
        panel3.add(this.getButtonCANCEL());
        panel3.add(this.getButtonINTERRUPT());
        panel3.add(this.getButtonEXIT());
        this.gridbag.setConstraints(panel3, this.constraints);
        this.add(panel3);
        this.gridbag.setConstraints(this.getLabelInfo(), this.constraints);
        this.add(this.getLabelInfo());
    }

    private void initActionListener() {
        this.getHostName().addActionListener(this);
        this.getButtonSCAN().addActionListener(this);
        this.getButtonCANCEL().addActionListener(this);
        this.getButtonEXIT().addActionListener(this);
    }

    private Button getButtonCANCEL() {
        if (this.cancel == null) {
            this.cancel = new Button("Kl34r");
        }
        return this.cancel;
    }

    private Button getButtonEXIT() {
        if (this.exit == null) {
            this.exit = new Button("3x1t");
        }
        return this.exit;
    }

    private Button getButtonSCAN() {
        if (this.start_scan == null) {
            this.start_scan = new Button("Zt4rt zk4n");
        }
        return this.start_scan;
    }

    private Button getButtonINTERRUPT() {
        if (this.interrupt == null) {
            this.interrupt = new Button("1nterrupt zk4n");
            this.interrupt.setEnabled(false);
        }
        return this.interrupt;
    }

    private Label getLabelInfo() {
        if (this.lab_info == null) {
            this.lab_info = new Label("|-=o0O0o=-|", 1);
        }
        return this.lab_info;
    }

    private TextArea getOutputArea() {
        return this.output;
    }

    private List getVulList() {
        if (this.vul_list == null) {
            this.vul_list = new List();
            this.readProperties();
            Enumeration<?> enumeration = this.jscan_properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement().toString();
                this.vul_list.add(this.jscan_properties.getProperty(string));
            }
        }
        return this.vul_list;
    }

    private TextField getHostName() {
        if (this.host_name == null) {
            this.host_name = new TextField(15);
        }
        return this.host_name;
    }

    private TextField getNetmask() {
        if (this.netmask == null) {
            this.netmask = new TextField("32", 2);
        }
        return this.netmask;
    }

    public Choice getRequestMethod() {
        if (this.request_method == null) {
            this.request_method = new Choice();
            this.request_method.add("HEAD");
            this.request_method.add("GET");
            this.request_method.add("POST");
            this.request_method.add("OPTIONS");
            this.request_method.add("PUT");
            this.request_method.add("DELETE");
            this.request_method.add("TRACE");
        }
        return this.request_method;
    }

    private void readProperties() {
        this.jscan_properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("jscan.txt");
            this.jscan_properties.load(fileInputStream);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getOutputArea().setText(fileNotFoundException.toString());
            return;
        }
        catch (IOException iOException) {
            this.getOutputArea().setText(iOException.toString());
            return;
        }
    }
}

