package jscan;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import jscan.ui.*;

/**
 * Kl4zz M41nFr4m3.
 *
 * Copyright (C) 1999 Jack Smiley
 * This program is free software.
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * Either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @author Jack Smiley jacksmil@sdf.lonestar.org
 * @version 1.1
 */

public class M41nFr4m3 extends Frame implements ActionListener{

  /* FIELDS */

  private static M41nFr4m3 main_frame;

  private final String CR   = System.getProperty("line.separator");
  private final String FS   = System.getProperty("file.separator");

  private final int WIDTH  = 630;
  private final int HEIGHT = 415;
  private MenuItem  save, exit, about;
  private TextArea  output;
  private Dimension screen_size;

  /* PUBLIC */

  /**
   * K0nstrukt0r
   * @return 4 0bj3kt 0f M41nFr4m3
   */
  public M41nFr4m3(String title){
    super(title);
    initialize(this);
  }
  /**
   * @return 4 sh4r3d M41nFr4m3 1nzt4nc3.
   */
  public static M41nFr4m3 sharedInstance(){
    return main_frame;
  }
  /**
   * M41N M4N#%&!
   */
  public static void main(String[] args){
    M41nFr4m3 main_frame = new M41nFr4m3("J4v4 Httpd Zk4nn3r");

    main_frame.addWindowListener(new WindowAdapter(){
      public void windowClosing(WindowEvent e){
	System.exit(0);
      }
    });
  }

  /* PRIVATE */

  /**
   * 1n1t M41nFr4m3
   */
  private void initialize(Frame frame){
    screen_size = Toolkit.getDefaultToolkit().getScreenSize();
    MenuBar   bar         = new MenuBar();

    /* File menu */
    Menu file = new Menu("F1l3");
    save = new MenuItem("Z4v3 0utput 4z...");
    save.addActionListener(this);
    file.add(save);
    file.addSeparator();
    exit = new MenuItem("3x1t");
    exit.addActionListener(this);
    file.add(exit);
    bar.add(file);

    /* Help menu */
    Menu help = new Menu("H3lp");
    about = new MenuItem("Y34 R1ght#%@!");
    about.addActionListener(this);
    help.add(about);
    bar.add(help);
    setMenuBar(bar);

    frame.setLayout(new FlowLayout(FlowLayout.LEFT));
    this.output = new TextArea(10,5);
    frame.add(new WebScan(output));
    frame.setBounds((screen_size.width-WIDTH)/2,(screen_size.height-HEIGHT)/2,WIDTH,HEIGHT);
    frame.pack();
    frame.setVisible(true);
  }
  public void actionPerformed(ActionEvent e){
    if(e.getSource() == this.exit){
      System.exit(0);
    }else if(e.getSource() == this.save){
      FileDialog dlg = new FileDialog(this,"Z4v3 0utput 4z...",FileDialog.SAVE);
      dlg.setBounds((screen_size.width-WIDTH)/2,(screen_size.height-HEIGHT)/2,WIDTH,HEIGHT);
      dlg.pack();
      dlg.setVisible(true);
      String filename = dlg.getFile();
      if(filename!=null){
	try{
	  FileWriter file = new FileWriter(new File(filename));
	  file.write(this.output.getText());
	  file.flush();
	  file.close();
	}catch(IOException ex){
	  System.out.println(ex.toString());
	  ex.printStackTrace();
	}
      }
    }else if(e.getSource() == this.about){
      Dialog dlg = new Dialog(this, "H3y%&@!", false);
      dlg.addWindowListener(new WindowAdapter(){
	public void windowClosing(WindowEvent e){
	  e.getWindow().setVisible(false);
	}
      });
      dlg.add(new About(Toolkit.getDefaultToolkit().getImage("images"+FS+"smiley.gif")));
      dlg.pack();
      dlg.setVisible(true);
      dlg.setBounds((screen_size.width-350)/2,(screen_size.height-193)/2,350,193);
    }
  }
} /* EOC */
class About extends Canvas{
  private Image smiley;
  public About(Image image){
    this.smiley = image;
  }
  public void paint(Graphics g){
    g.drawImage(this.smiley,0,0,this);
  }
} /* EOF */


