package jscan.net;

import java.net.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;

/**
 * Kl4zz B0zz rul3z th3 thr34dz.
 *
 * Copyright (C) 1999 Jack Smiley
 * This program is free software.
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * Either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @author Jack Smiley jacksmil@sdf.lonestar.org
 * @version 1.1
 */

public class Boss extends Thread implements ActionListener{
  private final String CR   = System.getProperty("line.separator");

  private Label info;
  private ThreadGroup group;
  private Button interrupt;
  private InetAddress host;
  private String[] all_vul;
  private TextArea output;
  private String netmask;
  private String request_method;

  public Boss(InetAddress host,
	      String[] all_vul,
	      Label info,
	      TextArea output,
	      Button interrupt,
	      String request_method,
	      String netmask){

    this.host           = host;
    this.all_vul        = all_vul;
    this.info           = info;
    this.output         = output;
    this.interrupt      = interrupt;
    this.request_method = request_method;
    this.netmask        = netmask;

    this.interrupt.addActionListener(this);
  }

  /**
   *
   */
  public void run(){
    int start;
    int end;
    int mask = 0x0ffffffff;
    this.group  = new ThreadGroup("jscan");
    /* calc netmask */
    for (int n = new Integer(this.netmask).intValue();n < 32; n++) {
      mask = mask << 1;
    }
    byte ip[] = this.host.getAddress();
    start = (ip[3] &  mask);
    end   = (ip[3] | ~mask);


    this.output.append("Zk4nn1ng ["+
		       (ip[0] & 0xff)+"."+
		       (ip[1] & 0xff)+"."+
		       (start & 0xff)+"-"+(end & 0xff)+"] "+CR);
    for(; start <= end; start++){
      try{
	StringBuffer new_ip = new StringBuffer();
	for (int i=0; i<ip.length-1; i++) {
	  if (i > 0){
	    new_ip.append(".");
	  }
	  new_ip.append((ip[i] & 0xff));
	}
	new_ip.append("."+(start & 0xff));
	this.host = InetAddress.getByName(new_ip.toString());
	new Thread(this.group,new TCPScan(this.host, this.all_vul, this.output, this.request_method)).start();
      }catch(UnknownHostException ex){
	this.output.append("["+ this.host.getHostName()+ "] "+ ex.toString()+CR);
      }
    }
    this.interrupt.setEnabled(true);
    new Thread(new Watch(this.group, this.info, this.interrupt)).start();
  }
  /**
   * 1nv0k3d wh3n 4n 4kt10n 0kkurz.
   */
  public void actionPerformed(ActionEvent e){
    if(e.getSource()==this.interrupt){
      if(this.group!=null){
	Thread[] alive = new Thread[256];
	this.group.enumerate(alive);
	for(int i=0;i<alive.length;i++){
	  if(alive[i]!=null){
	    alive[i].interrupt();
	    this.output.append("###ZK4N 1NT3RRUPT3D KL34N1NG UP#&@! B3 P4T13NT...###"+CR);
	  }
	}
      }
    }
  }
} /* EOC */
class Watch extends Thread{
  private Label info;
  private ThreadGroup group;
  private String animate_right;
  private String animate_left;
  private Button interrupt;
  private final int max = 35;


  Watch(ThreadGroup group, Label info, Button interrupt){
    this.info  = info;
    this.group = group;
    this.interrupt = interrupt;
    this.animate_right = ">";
    this.animate_left  = "<";
  }
  public void  run(){
    boolean first_time = true;
    int nr_threads = this.group.activeCount();
    while(nr_threads>0){
      try{
	if(this.info.getText().length()<=max){
	  animate_right += ">";
	  animate_left  += "<";
	  this.info.setText(animate_left+ "Zk4nn1ng "+nr_threads+" h0ztz"+animate_right);
	}else{
	  animate_right = ">";
	  animate_left  = "<";
	  this.info.setText(animate_left+"Zk4nn1ng "+nr_threads+" h0ztz"+animate_right);
	}
	this.sleep(750); 
	nr_threads = this.group.activeCount();
      }catch(InterruptedException ex){}
    }
    this.interrupt.setEnabled(false);
    this.info.setText("D0n3...@#&!");
  }
} /* EOF */








