package jscan.net;

import java.net.*;
import java.io.*;
import java.awt.*;

/**
 * Kl4zz TCPZk4n.
 *
 * Copyright (C) 1999 Jack Smiley
 * This program is free software.
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * Either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @author Jack Smiley jacksmil@sdf.lonestar.org
 * @version 1.1
 */

public class TCPScan extends Thread{
  private final String CR   = System.getProperty("line.separator");

  private String request_method;
  private InetAddress host;
  private String[] all_vul;
  private TextArea output;
  private URL url;
  private HttpURLConnection conn;

  public TCPScan(InetAddress host,String[] all_vul, TextArea output, String request_method) {
    this.host           = host;
    this.all_vul        = all_vul;
    this.output         = output;
    this.request_method = request_method;
  }
  /**
   * Scan a single host.
   */
  public void run(){
    boolean connection_refused = false;
    StringBuffer buff = new StringBuffer();
    int i = 0;
    while(i<all_vul.length && !connection_refused){
      try{
	url = new URL("http",host.getHostName(),all_vul[i]);
	conn = (HttpURLConnection)new Conector(url).getURL().openConnection();
	conn.setRequestMethod(this.request_method);
	conn.connect();	
	if(i<1){
	  this.output.append("### "+ host.getHostName()+ " 4PP34RS T0 B3 UP...G00D ###"+CR);
	}
	buff.append("### ["+ host.getHostName()+ "] "+this.request_method+" \""+all_vul[i]+
		    "\"--> "+conn.getResponseMessage()+
		    "!"+CR);
	conn.disconnect();
	++i;
	if(isInterrupted())connection_refused = true;
      }catch(MalformedURLException ex){
  	buff.append("["+ host.getHostName()+ "] "+ex.toString()+CR);
 	connection_refused = true;
      }catch(ProtocolException ex){
  	buff.append("["+ host.getHostName()+ "] "+ex.toString()+CR);
 	connection_refused = true;
      }catch(ConnectException ex){
	buff.append("["+ host.getHostName()+ "] "+ ex.toString()+CR);
 	connection_refused = true;
      }catch(SocketException ex){
	buff.append("["+ host.getHostName()+ "] "+ ex.toString()+CR);
 	connection_refused = true;
      }catch(IOException ex){
	buff.append("["+ host.getHostName()+ "] "+ ex.toString()+CR);
      }
    }
    this.output.append(buff.toString()+CR);
  }
} /* EOF */


