package jscan.ui;

import jscan.net.*;
import java.awt.*;
import java.awt.event.*;
import java.net.*;
import java.util.Properties;
import java.util.Enumeration;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;

/**
 * Th1z 1z th3 GU1 kl4zz f0r th3 M41nFr4m3 kl4zz.
 * 1t 4dd 0n p4n3lz w1th 4kt10nl1zt3n3rz t0 th3 M41nFr4m3.
 *
 * Copyright (C) 1999 Jack Smiley
 * This program is free software.
 * You can redistribute it and/or modify it under the terms of the
 * GNU General Public License as published by the Free Software Foundation.
 * Either version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * @author Jack Smiley jacksmil@sdf.lonestar.org
 * @version 1.1
 */
public class WebScan extends Panel implements ActionListener, AdjustmentListener{
  /* FIELDS */

  private final String FILE = "jscan.txt";
  private final String CR   = System.getProperty("line.separator");

  private Properties jscan_properties;

  private TextField host_name;
  private TextField netmask;
  private List      vul_list;
  private TextArea  output; 
  private Button    start_scan;
  private Button    exit;
  private Button    cancel;
  private Button    interrupt;
  private Label     lab_info;
  private Checkbox  all_vul;
  private Choice    request_method;

  private GridBagLayout       gridbag;
  private GridBagConstraints  constraints;

  /* PUBLIC */

  /**
   * K0nztrukt0r t0 th3 W3bZk4n kl4zz.
   * @param Output 4 T3xt4r34 wh1ch th1z kl4zz w1ll f1ll t3xt 1nt0.
   * Th3 T3xt4r34 1z 4 zh4r3d r3z0urc3 w1th th3 W3bZk4n kr34t0r klazz.
   * @return a W3bZk4n 0bj3kt.
   */
  public WebScan(TextArea output){
    this.output = output;
    initialize();
    initActionListener();
  }
  /**
   * Invoked when an action occurs.
   */
  public void actionPerformed(ActionEvent e){
    if(e.getSource()==getButtonSCAN()){
      try{
	if(getVulList().getSelectedItems().length!=0){
	  getOutputArea().setText("");
	  getLabelInfo().setText("Zt4rt1ng zk4n%&@!");
	  new Thread(new Boss(InetAddress.getByName(getHostName().getText()),
			      getVulList().getSelectedItems(),
			      getLabelInfo(),
			      getOutputArea(),
			      getButtonINTERRUPT(),
			      getRequestMethod().getSelectedItem(),
			      getNetmask().getText())).start();
	}
      }catch(UnknownHostException ex){
	getOutputArea().setText(ex.toString());
      }catch(IOException ex){
	getOutputArea().setText(ex.toString());
      }
    }else if(e.getSource()==getButtonEXIT()){
      System.exit(0);
    }else if(e.getSource()==getButtonCANCEL()){
      getLabelInfo().setText("|-=o0O0o=-|");
      getOutputArea().setText("");
      int[] all_selected = getVulList().getSelectedIndexes();
      for(int i=0;i<all_selected.length;i++){
	getVulList().deselect(all_selected[i]);
      }
      getVulList().select(0);
    }
  }
  /**
   * 
   * Adjust the scrollbar.
   */
  public void adjustmentValueChanged(AdjustmentEvent e){
    int val = e.getAdjustmentType();
    if(val == AdjustmentEvent.UNIT_INCREMENT){
      getNetmask().setText("32");
    }else if(val == AdjustmentEvent.UNIT_DECREMENT){
      getNetmask().setText("24");
    }else if(val == AdjustmentEvent.TRACK){
      String tmp = getNetmask().getText();
      if(tmp.equals("32")){
	getNetmask().setText("24");
      }else{
	getNetmask().setText("32");
      }
    }
  }

  /* PRIVATE */

  /**
   *
   */
  private void initialize(){
    gridbag = new GridBagLayout();
    setLayout(gridbag);
	
    constraints = new GridBagConstraints();
    constraints.anchor = GridBagConstraints.WEST;
    constraints.fill = GridBagConstraints.HORIZONTAL;
    constraints.gridwidth = GridBagConstraints.REMAINDER;
    constraints.weightx = 1.0;

    Panel row1       = new Panel();
    row1.setLayout(new FlowLayout(FlowLayout.LEFT));
    row1.add(new Label("H0zt t0 zk4n:"));
    row1.add(getHostName());
    row1.add(new Label("R3qu3zt:"));
    row1.add(getRequestMethod());
    row1.add(new Label("N3ttm4zk:"));

    getNetmask().setEditable(false);
    getNetmask().setBackground(Color.blue);
    getNetmask().setForeground(Color.yellow);
    row1.add(getNetmask());
    Scrollbar ranger = new Scrollbar(Scrollbar.HORIZONTAL, 32, 8, 24, 33);
    ranger.addAdjustmentListener(this);
    row1.add(ranger);
     
    gridbag.setConstraints(row1, constraints);
    add(row1);

    Panel row2       = new Panel();
    row2.setLayout(new FlowLayout(FlowLayout.LEFT));
    row2.add(new Label("Ch00z3 z1ngl3/mult1pl3 \"f1l3(z)\"t0 zk4n 4ft3r..."));
    gridbag.setConstraints(row2, constraints);
    add(row2);

    getVulList().select(0);
    getVulList().setMultipleMode(true);
    gridbag.setConstraints(getVulList(), constraints);
    add(getVulList());

    gridbag.setConstraints(getOutputArea(), constraints);
    add(getOutputArea());

    Panel row5       = new Panel();
    row5.setLayout(new FlowLayout(FlowLayout.CENTER));
    row5.add(getButtonSCAN());
    row5.add(getButtonCANCEL());
    row5.add(getButtonINTERRUPT());
    row5.add(getButtonEXIT());
    gridbag.setConstraints(row5, constraints);
    add(row5);
    
    gridbag.setConstraints(getLabelInfo(), constraints);
    add(getLabelInfo());
  }
  /**
   * 
   */
  private void initActionListener(){
    getHostName().addActionListener(this);
    getButtonSCAN().addActionListener(this);
    getButtonCANCEL().addActionListener(this);
    getButtonEXIT().addActionListener(this);
  }
  /**
   * @return Button cancel.
   */
  private Button getButtonCANCEL(){
    if(this.cancel==null){
      this.cancel = new Button("Kl34r");
    }
    return this.cancel;
  }
  /**
   *@return Button exit
   */
  private Button getButtonEXIT(){
    if(exit==null){
      exit = new Button("3x1t");
    }
    return exit;
  }
  /**
   *@return Button start_scan
   */
  private Button getButtonSCAN(){
    if(start_scan==null){
      start_scan = new Button("Zt4rt zk4n");
    }
    return start_scan;
  }
  /**
   *@return Button Interrupt
   */
  private Button getButtonINTERRUPT(){
    if(interrupt==null){
      interrupt = new Button("1nterrupt zk4n");
      interrupt.setEnabled(false);
    }
    return interrupt;
  }

  /**
   * @return Label lab_info
   */
  private Label getLabelInfo(){
    if(lab_info==null){
      lab_info = new Label("|-=o0O0o=-|",Label.CENTER);
    }
    return lab_info;
  }
  /**
   *@return TextArea output
   */
  private TextArea getOutputArea(){
    return this.output;
  }
  /**
   * @return List
   */
  private List getVulList(){
    if(this.vul_list == null){
      this.vul_list = new List();
      readProperties();
      for(Enumeration e = jscan_properties.propertyNames(); e.hasMoreElements();){
	String property_name = e.nextElement().toString();
	this.vul_list.add(jscan_properties.getProperty(property_name));	
      }
    }
    return this.vul_list;
  }
  /**
   * @return TextField host_name.
   */
  private TextField getHostName(){
    if(this.host_name == null){
      this.host_name = new TextField(15);
    }
    return this.host_name;
  }
  /**
   * @return TextField netmask.
   */
  private TextField getNetmask(){
    if(this.netmask == null){
      this.netmask = new TextField("32",2);
    }
    return this.netmask;
  }
  /**
   *
   */
  public Choice getRequestMethod(){
    if(this.request_method == null){
      this.request_method = new Choice();
      this.request_method.add("HEAD");
      this.request_method.add("GET");
      this.request_method.add("POST");
      this.request_method.add("OPTIONS");
      this.request_method.add("PUT");
      this.request_method.add("DELETE");
      this.request_method.add("TRACE");
    }
    return this.request_method;
  }
  /**
   *
   */
  private void readProperties(){
    jscan_properties = new Properties();
    try{
      FileInputStream in_stream = new FileInputStream(FILE);
      jscan_properties.load(in_stream);
    }catch(FileNotFoundException ex){
      getOutputArea().setText(ex.toString());
    }catch(IOException ex){
      getOutputArea().setText(ex.toString());
    }
  }
} /* EOF */






