



// assembler procs.

int cipher=1;  // test...


//OTHER CIPHER SOURCE INCLUDED HERE.....
#include "tea.c"
#include "idea.c"    // Other encryption routines..
//#include "des/des.c"
#include "DesAsm.c"
#include "square.c"  // square.......
#include "misty1.c"  // misty
#include "blowfish.c"    // #includes other ciphers....
#include "stegansound.c" //WAV modification 



HANDLE cfile;
formatinfo *formerror; // save handle in case of OS disk file error....
unsigned  short fatsize;    // need global.......
unsigned  short dumdum;
void scramwithpass(char * buffer, char * ukey)

{

// This is only used for the simple "summer" code...
   _asm
    {
	pushad
	mov ah,32
	mov esi,[buffer]
	mov ebx,[ukey]
	mov ecx,2048
	xor edx,edx
dkeyloop:
	mov al,[esi]
	xor al,[edx+ebx]
	mov [esi],al
	inc esi
	inc dl
	cmp dl,ah
    jl dkok
	xor dl,dl
dkok:
	dec ecx
	jnz dkeyloop
	popad
    }

}


void randomstream(unsigned int * key, char * address,int len)

{

_asm
    {

	pushad
		mov esi,[key]
		
		mov eax,[esi]
		mov ebx,[esi+4]
		mov ecx,[esi+8]
		mov edx,[esi+12]

		mov edi,[address]
randout:

      add eax,eax
	  adc ebx,eax
	  adc ecx,ebx
	  adc edx,ecx
	  xor eax,edx

	  mov [edi],eax
	  mov [edi+4],ebx
	  mov [edi+8],ecx
	  mov [edi+12],edx
	  add edi,16
	  dec [len]

	  jnz randout

	  mov [esi],eax
	  mov [esi+4],ebx
	  mov [esi+8],ecx
	  mov [esi+12],edx

	  popad


    }

}




void InitializeCipher(char * blin,int len)

{
unsigned char blowkey[]="abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz   ";
	memset (&blowkey[0],0,34);
	memcpy(&blowkey[0],blin,len);

	if (cipher==BLOWFISH)

		{
		InitializeBlowfish(blowkey,len,0); // ONLY blowfish has variable len key
										   // Our implemenation uses 256 bits(32 bytes)
		}

	if (cipher==TEA16)

		{
		inittea( (unsigned long *) &blowkey,0,16);	// 16 round TEA cipher
		}


	if (cipher==TEA32)


		{
		inittea( (unsigned long *) &blowkey,0,32);  // 32 round TEA cipher
		}

//void ideainitialize(unsigned long *keypntr,int index)

	if (cipher==IDEA)

		{
		ideainitialize((unsigned long *)&blowkey,0); //Assembler implementation of IDEA	
		}											 //Ciphers compared with "C" version

		if (cipher==DES)

		{
		desinitialise((char  *) &blowkey,0);		//Standard DES
		}


		if (cipher==SQUARE)
		{
		squareinitialise((char  *) &blowkey,0);		// The new square code....
		}
	
		if (cipher==MISTY1)
		{
		mistyinitialize((unsigned long *)&blowkey,0); // Misty1 mitsi...
		}

		if (cipher==THREEDES)
		{
		threedesinitialise((char *)&blowkey,0); // Triple DES
		}
}


void CipherKeys(unsigned long * buffer)  // DOES NOT USE CBC_BLOCK_CONST_MODE!
{
					
		   // 128= 512 bytes
	// This code scrambles the inital key, and the table
	// of values used to derive IV values, and white values...
	// The cipher chosen, is used to encrypt the random 1 k
	// block, and 256 bytes where the disk random key is kept..
	// It does not have to be fast. Only executed whrn the disk
	// is formatted,
	// Called after sha1 has hashed the passwords and the particular cipher
	// has been initialised with the 160 bit result... (Or less if cipher key size
	// less.
	//

	int n;
	int ivl=0;  // IVs are initially set to zero for this block...
	int ivr=0;
	int bl=2;

	if (cipher==SQUARE) bl=4;  // 128 bit square blocks... 16 bytes

	for (n=0;n<128*4;n=n+bl) // 2 k key sector scrambler...
				{
				buffer[n]=ivl^buffer[n];
				buffer[n+1]=ivr^buffer[n+1];

				if (cipher==BLOWFISH)
						Blowfish_encipher(&buffer[n],&buffer[n+1],0);

				if ((cipher==TEA16)|| (cipher==TEA32) )
						teaencipher(&buffer[n],0);

				if (cipher==IDEA)
					ideaencipher(&buffer[n],0);
				   

				if (cipher==DES)
					desencipher(&buffer[n],0);

				if (cipher==SQUARE)
					squareencipher(&buffer[n],0);
				
				if (cipher==MISTY1)
					mistyencipher(&buffer[n],0);

				if (cipher==THREEDES)
				threedesencipher(&buffer[n],0);



				ivl=buffer[n];
				ivr=buffer[n+1];
				}

}


void scramble (char * buffer,char *IVkeys,unsigned int temp_block,unsigned int num_sectors)

{


	if (cipher>0) // NOTE All algorithms except the simple "Summer" system
	{

				// note that IVkeys is the table of values for IVs and whites
				// NOT the main keys (sha1 or random), which is set in "initializeCipher"	
				// You'll find cipherblock in my version of "blowfish.c"
				// which also calls the other ciphers....
		cipherblock((unsigned long *)buffer,IVkeys,temp_block,num_sectors);
		return;

	}


_asm
    {

	 // If this code is executed we are using "Summer" and NOTHING else.   
	 pushfd
     pushad

keylpv31:

	push ebp
   	mov eax,[buffer]
	push eax
	mov ecx,[temp_block]
    inc [temp_block]
	mov esi,[IVkeys]

	;ecx=sector number.....

	xor eax,eax
	xor edx,edx
	xor ebp,ebp
	xor edi,edi

		 
	mov ebx,32
		

formkey:
	
	push esi
	shr ecx,1
	jnc nohigh
	add esi,16
nohigh:


	add eax,[esi]			  ;96 bits........
	adc edx,[esi+4]
	adc ebp,[esi+8]	  		  ;....
	adc edi,[esi+12]
	
	pop esi
	add esi,32
	dec ebx
	jnz formkey	


	;ebp done
	


	;eax done

	mov ecx,512/16 ;4
	
	pop esi   ;address of buffer.....
;rnd
		
	  add eax,eax
	  adc edi,eax
	  adc ebp,edi
	  adc edx,ebp
	  xor eax,edx

again3:	      
		     
	
	;rnd

	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx



	xor [esi],edx

	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx

	;rnd

	xor [esi+4],edx
	;rnd

	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx

	xor [esi+8],edx
	;rnd
	add eax,eax
	adc edi,eax
	adc ebp,edi
	adc edx,ebp
	xor eax,edx

	xor [esi+12],edx
	

	add esi,16 ;4

	;inc si	   
	dec ecx
	jnz again3
	
    POP EBP

	add [buffer],512
	dec [num_sectors]
	jnz keylpv31
	

	popad

	popfd

   }//asm

}



void mangle_passwords(char * passwordptr)

{
//ONLY	called for SUMMER code...
unsigned int * shc=(unsigned int *) shiftconsts; //(unsigned int *) &shift_constants;
	
	_asm
	{
		mov Ebx,[passwordptr]
		xor ax,ax
		mov Ecx,160/2
mplp:		
		add ax,[Ebx]	    ;
		add Ebx,2
		dec ecx
		jnz mplp
		
		or ax,ax	    ;null password
		jz mpout

		and eax,01fffh
		add eax,2000h
mplp2:
		push eax
		call big_shift
		pop  eax
		dec Eax
		jnz mplp2
		or ax,1
mpout:			
		jmp bsdone
	


BIG_SHIFT:
        MOV EBX,[passwordptr]		
		MOV ECX,40
		CLC
mpMORE:				
		MOV EAX,[EBX]
		ADC EAX,EAX
		MOV [EBX],EAX
		INC EBX
		INC EBX
		INC EBX
		INC EBX
		DEC ECX
		JNZ mpMORE				
		JNC mpxOUT
        MOV EBX,[passwordptr]
		MOV ESI,[shc]
		MOV ECX,40
mpxXOR:	
		MOV EAX,[EBX]
		XOR EAX,[ESI]
		MOV [EBX],EAX
		ADD EBX,4
		ADD ESI,4
		DEC ECX
		JNZ mpxXOR
		
mpxOUT:
		ret
		
	
			
bsdone:

	}

}



/*
typedef struct formatinfo
{

  unsigned int formattype;    //0=partition encrypted
							  //1=partition DOS
							  //2= file encrypted
							  
  unsigned int subfunction;    
							   
							   //00= open device (used for file stuff)
							   //01= update partition
							   //02= put keys to cryptvol
							   //03= put bootsector to device
							   //04= put fat tables to device
							   //05= put root dir   to device
							   //06= put data area to device

							   //07= close device (used for file stuff)
							   //08=  all done...

 unsigned int blocklen;       //  for main loop, size of data block to do,,,,
 unsigned int currentsector;
 unsigned int sectorcount;
 unsigned int filehandle;
 diskarea * diskarea;  
 char * fullfilename;
 char   volname [12];

}formatinfo;


*/
int WAVDisk2(int sectorstart,int sectorlen,char *bufferaddr)
{
// Used when formatting a .WAV. Modslow byte of data only... 
int get;
int x;

char * ba=(char *) wavbuffer; // Global buffer


	SetFilePointer(cfile,sectorstart*2048+wavi.fileoffset,NULL,FILE_BEGIN);
	ReadFile(cfile, ba,sectorlen*2048,(LPDWORD) &get,NULL);
	for (x=0;x<sectorlen*512;x++)
		{
		
			//wavbuffer[x<<2]=bufferaddr[x];
			_asm
			{
				mov ebx,[ba]
				mov ecx,[x]
				mov edx,[bufferaddr]
				mov al,[edx+ecx]
				mov ah,al
				and al,15
				and [ebx+ecx*4],0xf0
				or  [ebx+ecx*4],al     ;low nibble sam....
				shr ah,4
				and [2+ebx+ecx*4],0xf0
				or [2+ebx+ecx*4],ah

			}


		}
	SetFilePointer(cfile,sectorstart*2048+wavi.fileoffset,NULL,FILE_BEGIN);
	WriteFile(cfile,(LPCVOID) ba,sectorlen*2048,(LPDWORD) &get,NULL);
	if (get!=sectorlen*2048)
	  {
	   formerror->subfunction=FORMAT_OS_FILE_ERROR;
	   CloseHandle(cfile);
      }
	return 0;}


	

int WAVDisk(int sectorstart,int sectorlen,char *bufferaddr)
{
// Used when formatting a .WAV. Modslow byte of data only... 
	
	
int get;
int x;
char * ba=(char *) wavbuffer; // Global buffer

if (WAVformat==2)
{	

	WAVDisk2(sectorstart,sectorlen,bufferaddr);
	return 0;
}

	SetFilePointer(cfile,sectorstart*1024+wavi.fileoffset,NULL,FILE_BEGIN);
	ReadFile(cfile, ba,sectorlen*1024,(LPDWORD) &get,NULL);
	for (x=0;x<sectorlen*512;x++)
		{
		wavbuffer[x<<1]=bufferaddr[x];
		}
	SetFilePointer(cfile,sectorstart*1024+wavi.fileoffset,NULL,FILE_BEGIN);
	WriteFile(cfile,(LPCVOID) ba,sectorlen*1024,(LPDWORD) &get,NULL);
	if (get!=sectorlen*1024)
	  {
	   formerror->subfunction=FORMAT_OS_FILE_ERROR;
	   CloseHandle(cfile);
      }
	return 0;
}




int DiskProc2(MYPDCB dcb,int sectorstart,int sectorlen,char *bufferaddr,int mode)

{
	int get;

	if (dcb)
		return (DiskProc(dcb,sectorstart,sectorlen,bufferaddr,mode));

	if (WAVformat)
		return (WAVDisk(sectorstart,sectorlen,bufferaddr));

	{

    WriteFile(cfile,(LPCVOID) bufferaddr,sectorlen*512,(LPDWORD) &get,NULL);
	if (get!=sectorlen*512)
	  {
	  formerror->subfunction=FORMAT_OS_FILE_ERROR;
	  CloseHandle(cfile);
	  DeleteFile((LPCTSTR)&mountdriveandfile);
	  }
	}
	return 0;  // for now
}

int DiskProc2a(MYPDCB dcb,int sectorstart,int sectorlen,char *bufferaddr,int mode,int more)
// called on writes of data areas.........
// if more<=0 we have reached the last block, and if on quick format
// file mode, we need to write it out, to extend the file..
{
	int get;
		
	int current,newcurrent;

	if (dcb)
	{
		if (bUseQuickFormatter==0)
		   return (DiskProc(dcb,sectorstart,sectorlen,bufferaddr,mode));
		  else return 0; 
	}
	if (WAVformat)  // delibrately always writes ALL of file...
		return (WAVDisk(sectorstart,sectorlen,bufferaddr));

	if ( (bUseQuickFormatter==0) || (more<=0) )
	{	
	
	WriteFile(cfile,(LPCVOID) bufferaddr,sectorlen*512,(LPDWORD) &get,NULL);
	if (get!=sectorlen*512)
	  {
	  formerror->subfunction=FORMAT_OS_FILE_ERROR;
	  CloseHandle(cfile);
	  DeleteFile((LPCTSTR)&mountdriveandfile);
	  }
	}


	else
	
	{
	// just extend the file...
	current=SetFilePointer(cfile,0,NULL,FILE_CURRENT);	
	newcurrent=SetFilePointer(cfile,sectorlen*512,NULL,FILE_CURRENT);
	if (newcurrent!=current+sectorlen*512)
		{
		formerror->subfunction=FORMAT_OS_FILE_ERROR;
		CloseHandle(cfile);
		DeleteFile((LPCTSTR)&mountdriveandfile);

		}

	}



	return 0;  // for now
}




int DiskProc3(MYPDCB dcb,int sectorstart,int sectorlen,char *bufferaddr,int mode)

{
	// partition update call. Not used for file/WAV creation.
	if (dcb)
		return (DiskProc(dcb,sectorstart,sectorlen,bufferaddr,mode));
	return 0;
}





int opendevice(formatinfo * format)

{
	
	

	formerror=format; // in case of error
	format->subfunction++;
	if (format->formattype!=2)
			return 0;
		//open disk file here......
	else 

	if (WAVformat==0)
	   format->filehandle=CreateFile((LPCTSTR)&mountdriveandfile,GENERIC_READ|GENERIC_WRITE,0,0,CREATE_NEW,0,NULL);
	else
		format->filehandle=CreateFile((LPCTSTR)&mountdriveandfile,GENERIC_READ|GENERIC_WRITE,0,0,OPEN_EXISTING,0,NULL);
	cfile=format->filehandle;
	return 0;
}

int closedevice(formatinfo * format)

{
		format->subfunction++;
		if (format->formattype!=2)
			return 0; //Return if partition type
		//close disk file here......
		else 
		
		{
		CloseHandle(cfile);
		cfile=NULL;
		format->filehandle=NULL;
		return 0;
		}
}



int putkeys(formatinfo * format)
{


	char tempkeys[640];
    char *i;
	char *o;
	int c,x;

	SHA_INFO S;
 
	diskarea* da=format->diskarea;
	format->subfunction++;
	
	
//	return 0;   put thisl line in to test "randomness" of containers,,,

	if (format->formattype==1)
		return 0;		//dos 		

	i=(char *) &mainkeys;
    o=(char *) &mainkeysclear;       // original data.........
	memcpy(o,i,8192);       //written to logical volume 1st 4 sectors.......

	memcpy(&tempkeys,pThePasswords,640);  //&

	shash ((unsigned char *)&tempkeys,160,&S);

	if (cipher==0) // old summer format...
	{
		// NOTE ONLY SUMMER, NOT BLOWFISH, IDEA ETC...
		mangle_passwords((char *) &tempkeys);
		scramwithpass((char *) &mainkeys,(char *) &tempkeys);  // scramble....
	}

	else
	{
	//memcpy(&blowkey[0],&S.digest[0],20);
    InitializeCipher( (char *)&S.digest,20);  //160 bit user key from SHA hash....
	CipherKeys((unsigned long *) &mainkeys);  // 2K including random MASTER key
											  // Sramble it with the chosen cipher
	InitializeCipher( (char *) &mainkeysclear+1024,32); // 256 bit keymax...
													     // Prepare for the data
	}



	i=(char *)&mainkeys;
	//o=i+0x1c00;             // WAS 1c00 (8192-1024)

	o=i+6144;               //(8192-2048)

	//randomize the "spare" data... to allow diehard to parse ALL the container....
	CipherKeys((unsigned long *) o);  // 2K including random MASTER key
	CipherKeys((unsigned long *) o);  // 2K including random MASTER key
	CipherKeys((unsigned long *) o);  // 2K including random MASTER key
	CipherKeys((unsigned long *) o);  // 2K including random MASTER key


	if (WAVformat==0)       // BACKUP COPY OF CRITCIAL DATA, BUT NOT ON WAV....(too obvious)
	memcpy (o,i,1024+32);   //copy scrambled keytable to end of table. In case of disk error... 
                            //can be recovered...... INCREASE +32 if max key size is increased

    if (DiskProc2(da->dcb,format->currentsector,16,(char *) &mainkeys,DISK_WRITE))
							// send it all to disk........

				formerror->subfunction=FORMAT_OS_FILE_ERROR;




	format->currentsector+=16;
	format->sectorcount-=16;
	
	o=(char *) &mainkeys;
    i=(char *) &mainkeysclear;       // original data.........
	memcpy(o,i,2048);       // clear.....written to logical volume 1st 4 sectors.......




								// Here we generate some random data, which gets
								// saved to four sectors, all different after 
								// enciphering.... But after deciphering each
								// will contain the same data, PROVIDED that the
								// Ivs, white values, and of course MASTER keys 
								// are correct. Three sectors are compared for
								// equaulity after dechipher, to check for valid
								// disks, before a mount attempt is made.
								// The data can be any random values....				
								// The important issue is that the 3 sectors are 
								// Equal. The first of these 4 sectors later
								// contains the "Disk information" sector, alonng
								// with times opened etc. Encrypted of course!
								

	for (c=0;c<4;c++)			// "compare" BLOCKS..... 
							
	  {
	  
		i=(char *) &mainkeys;
	  
		if (cipher==0) i+=1024;    // move to end of summer table ONLY IF summer
								// else use 1st summer 512 values... BECAUSE the 
								// MASTER KEY LIVES  1024 bytes up from OTHER 
								// Ciphers.... !!!!
								// We don't want to use an (even enciphered)
								// copy of the master key anywhere else, 
								//just in case. on the disk..

		o=(char *) &shaunsboot;  // Is 2k, but only 512 bytes are used....
      
		memcpy (o,i,512);
	 
	  if (cipher>0)
			{
		  
		  for (x=0;x<8;x++)      // just done to Change the (original random data
								 // to different data by re-encipering...
								// NOTE this is NOTHING to do with the encryption KEY
								// or its security....						
				CipherKeys( (unsigned long *)&shaunsboot);
			}
	  
	  	 
		scramble (o,(char *) &mainkeys,format->logicalsector,1);
			if (DiskProc2(da->dcb,format->currentsector,1,o,DISK_WRITE))
		  		formerror->subfunction=FORMAT_OS_FILE_ERROR;

		format->currentsector+=1;
		format->logicalsector+=1;
		format->sectorcount-=1;
		}

	  return 0;
	}


int updatepartition(formatinfo *format)

{
diskarea* da=format->diskarea;
partitionrec * pa;
char buffer[512];
unsigned int bu=  (unsigned int)  &buffer;
int status;

	format->subfunction++;
	
	if (format->formattype==2) 
		return 0;

	bu+=da->PartTableOffset;
	pa=(partitionrec *) bu;
    DiskProc3 (da->dcb,da->PartTableSector,1,(char *) &buffer,DISK_READ);	
	if (format->formattype==1) pa->system=06;      //big dos
					else pa->system=0x74;  // crypted partition....
    status=DiskProc3 (da->dcb,da->PartTableSector,1,(char *) &buffer,DISK_WRITE);
	if (status)		formerror->subfunction=FORMAT_OS_FILE_ERROR;

	return status;
}



void calcfatsize(unsigned int s, unsigned char * spcluster,unsigned short * spfat,unsigned int fatmax)


{
	// work out some DOS (FAT16) parameters according to size etc.
	_asm

	{

		pushad
		mov eax,[s]
		mov ecx,1
		add eax,2
clshift: cmp eax,[fatmax] ;0fff7h
		jc sok
		shl ecx,1
		shr eax,1
		jmp clshift

sok:	mov edi,[spcluster]
		mov [edi],cl

		mov ecx,eax
		shl eax,1
		mov ebx,512
		cdq
		idiv ebx
		or edx,edx
		jz sox
		inc eax
;;;sox:    inc eax         WIN98
sox:	mov edi,[spfat]      
		mov [edi],ax
		popad

	}

}


int dirblock1;


int putbootsector(formatinfo *format)
{
	unsigned int blocksize;
	unsigned int fatmax;
	// create  boot sector...
	unsigned int *serialnoptr;
	diskarea* da=format->diskarea;
	unsigned char * o=(unsigned char *)&shaunsboot;
	bpb * biosp;


	o[510]=0x55;   // boot sector bodge......
	(unsigned char)	o[511]=0xAA;
    
	o[0]=0xEB;
	o++;
	o[0]=0x3e; 
	o++;
	o[0]=0x90;    //was =90
	o++;
	strcpy((char *) o,"SCRMD1.0");
    o=(unsigned char *)&shaunsboot;
    o+=11;
	biosp= (bpb *) o;

/*
typedef struct bpb
{
UWORD  bytespersector;
UBYTE  sectorspercluster;
UWORD  sectorsreserved;
UBYTE  numfats;
UWORD  numdirentries;
UWORD  smalldisksectors;
UBYTE  mediadescripter;
UWORD  sectorsperfat;
UWORD  sectorspertrack;
UWORD  numheads;
ULONG  hiddensectorcount;
ULONG  bigdisksectors;
UBYTE  drivenum;
UBYTE  bytereserved;
UBYTE  extendbootsig;
ULONG  serialnumber;
char   volname[11];
char   voltype [8];
}bpb;

*/

   biosp->bytespersector=512;
   biosp->sectorsreserved=1;
   biosp->numheads=1;
   biosp->numfats=2;
   biosp->smalldisksectors=0;
   biosp->numdirentries=512;
   biosp->mediadescripter=0xf8;
   biosp->drivenum=0;
   biosp->bytereserved=0;
   biosp->extendbootsig=0x29;
   biosp->sectorspertrack=63;
   biosp->hiddensectorcount=0;
   serialnoptr=(unsigned int *) &mainkeys[400];
   biosp->serialnumber=*serialnoptr;
   memcpy((char *) &biosp->volname,(char *) format->volname,11);
   strcpy((char *) &biosp->voltype,"FAT16   ");
   blocksize=format->sectorcount-1;   // added.......
   if (blocksize>65535)
	biosp->bigdisksectors=blocksize;
   else
	biosp->smalldisksectors=blocksize;

   fatmax=0xff7;  //12 bit fat

   if (blocksize>0xff7*8)  
		fatmax=0xfff7; //16 bit fat


   calcfatsize(blocksize,(unsigned char *)&biosp->sectorspercluster,(unsigned short *) &biosp->sectorsperfat,fatmax);

   fatsize=biosp->sectorsperfat;

   if (format->formattype!=1)
	    scramble ((char *) &shaunsboot,(char *) &mainkeys,format->logicalsector,1);
   

    format->fatsize=fatmax;
    if (DiskProc2(da->dcb,format->currentsector,1,(char *) &shaunsboot,DISK_WRITE))
			formerror->subfunction=FORMAT_OS_FILE_ERROR;

    format->currentsector+=1;
    format->logicalsector+=1;
    format->sectorcount-=1;
	format->subfunction++;
	return 0;
}



int putrootdir(formatinfo *format)

{
	diskarea* da=format->diskarea;
	char rdir[512];
	char * d=(char *) &rdir;
	memset(d,0,512);
	strcpy(d,(char *) &format->volname);
	
	dirblock1=0;

	d[11]=0x28;

   if (format->formattype!=1)
	    scramble (d,(char *) &mainkeys,format->logicalsector,1);
   
    if (DiskProc2(da->dcb,format->currentsector,1,(char *) d,DISK_WRITE))
			formerror->subfunction=FORMAT_OS_FILE_ERROR;

    format->currentsector+=1;
    format->logicalsector+=1;
    format->sectorcount-=1;
	format->subfunction++;
	return 0;
}






int put1fat(formatinfo * format, unsigned int onefatsize)

{
diskarea* da=format->diskarea;
char sdiskbuff[512];
unsigned char * db=(unsigned char*)&sdiskbuff;

	memset (db,0,512);
	db[0]=0xf8;
	db[1]=0xff;
	db[2]=0xff;
	if (format->fatsize==0xfff7) db[3]=0xff;

if (format->formattype!=1)
	    scramble ((char *)db,(char *) &mainkeys,format->logicalsector,1);

    if (DiskProc2(da->dcb,format->currentsector,1,(char *) db,DISK_WRITE))
			formerror->subfunction=FORMAT_OS_FILE_ERROR;

	format->currentsector+=1;
    format->logicalsector+=1;
    format->sectorcount-=1;
	onefatsize--;


	do
	    {
	    memset (db,0,512);

        if (format->formattype!=1)
	          scramble ((char *)db,(char *) &mainkeys,format->logicalsector,1);

        if (DiskProc2(da->dcb,format->currentsector,1,(char *) db,DISK_WRITE))
				formerror->subfunction=FORMAT_OS_FILE_ERROR;

        format->currentsector+=1;
        format->logicalsector+=1;
        format->sectorcount-=1;
		onefatsize--;
	    }

	while (onefatsize>0);
	return 0;
}


int putfattables(formatinfo *format)
{
	put1fat(format,fatsize);
	put1fat(format,fatsize);
	format->subfunction++;
	return 0;
}


int putdataarea(formatinfo *format)
{
	diskarea* da=format->diskarea;

	unsigned int thiscount;
	if (format->sectorcount>format->blocklen)
		thiscount=format->blocklen;      //64k
	
	else 
		thiscount=format->sectorcount;

	memset(&bigblock,0,thiscount*512);


   if (format->formattype!=1) 
	{ 
	   if ( (bUseQuickFormatter==0) ||(WAVformat) || (dirblock1==0)  )
			scramble ((char *)&bigblock,(char *) &mainkeys,format->logicalsector,thiscount);
	}

   if (dirblock1>0)
	{

	if (   DiskProc2a(da->dcb,format->currentsector,thiscount,(char *) &bigblock,DISK_WRITE, format->sectorcount-thiscount)) 
			formerror->subfunction=FORMAT_OS_FILE_ERROR;

	}

   else  //dirblock== 0 so write out rest of directory data 
   
	{
    DiskProc2(da->dcb,format->currentsector,thiscount,(char *) &bigblock,DISK_WRITE);
	dirblock1=1;
	}
	
	
	format->currentsector+=thiscount;
    format->logicalsector+=thiscount;
    format->sectorcount-=thiscount;

	if ((int) format->sectorcount<=0)
		format->subfunction++;

	return 0;
}






int formatdevice(formatinfo * format)

{
	
int status;


	switch (format->subfunction)
	
	{

	case 0:
		 status=opendevice(format);
		 break;

	case 1:
		 status=updatepartition(format);
		 break;


	case 2:
		 status=putkeys(format);
		 break;
	
	
	case 3:
		 status=putbootsector(format);
		 break;

	case 4:
		 status=putfattables(format);
		 break;
	case 5:
		 status=putrootdir(format);
		 break;

	case 6:
		 status=putdataarea(format);
		 break;
	case 7:
		 status=closedevice(format);
		 break;
	}


	return status;
}
