
#include <malloc.h>
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include "defines.h"
#include "cd.h"

/* cdtest.c: test program for the cgmdraw module.

        Written by G. Edward Johnson <mailto:lorax@nist.gov>
        Date: April 1996
        Copyright: cd software produced by NIST, an agency of the 
	U.S. government, is by statute not subject to copyright
	in the United States. Recipients of this software assume all 
	responsibilities associated with its operation, modification
	and maintenance.
 
*/


int main () {
cdImagePtr myimage;

	/* Color indexes */
        int white;
        int blue;
        int red;
        int green;
	int black;
	int lavender;
	/* points for polygons and polylines */
	cdPoint points[15];
	/* output file */
	FILE *outf;


/* create an image, 1000 by 1000 pixels */
myimage = cdImageCreate(1000, 1000);

/* Allocate the background color */
white = cdImageColorAllocate (myimage, 255,255,255);
        red = cdImageColorAllocate(myimage, 255, 0, 0);
        green = cdImageColorAllocate(myimage, 0, 255, 0);
        blue = cdImageColorAllocate(myimage, 0, 0, 255);
	black = cdImageColorAllocate(myimage, 0, 0, 0);

if (cdSetLineColor(myimage, blue)) {
  fprintf(stderr, "cdSetLineColor Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineColor Unsuccessfull\n");
}

if (cdSetLineColor(myimage, blue)) {
  fprintf(stderr, "cdSetLineColor Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineColor Unsuccessfull\n");
}


if (cdImageLine(myimage, 400, 8, 520, 8, green)) {
  fprintf(stderr, "cdImageLine Successfull\n");
}
else {
  fprintf(stderr, "cdImageLine Unsuccessfull\n");
}

if (cdImageLine(myimage, 50, 50, 500, 500, red)) {
  fprintf(stderr, "cdImageLine Successfull\n");
}
else {
  fprintf(stderr, "cdImageLine Unsuccessfull\n");
}

if (cdSetLineAttrib(myimage, 2, 3, red)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}

if (cdLine(myimage, 500, 50, 50, 500)) {
  fprintf(stderr, "cdLine Successfull\n");
}
else {
  fprintf(stderr, "cdLine Unsuccessfull\n");
}

/* Now, build a rectangle */
if (cdSetShapeFillAttrib(myimage, 3, blue, 6 )) {  
  fprintf(stderr, "cdSetShapeFillAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetShapeFillAttrib Unsuccessfull\n");
}

if (cdSetShapeEdgeAttrib(myimage, 1, 2, green, 1 )) {  
  fprintf(stderr, "cdSetShapeEdgeAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetShapeEdgeAttrib Unsuccessfull\n");
}

if (cdRectangle(myimage, 100, 100, 250, 250 )) {  
  fprintf(stderr, "cdRectangle Successfull\n");
}
else {
  fprintf(stderr, "cdRectangle Unsuccessfull\n");
}



/* now check out each of the line styles in order */

if (cdSetLineAttrib(myimage, 5, 4, green)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}

if (cdLine(myimage, 100, 600, 500, 600)) {
  fprintf(stderr, "cdLine Successfull\n");
}
else {
  fprintf(stderr, "cdLine Unsuccessfull\n");
}

if (cdSetLineAttrib(myimage, 4, -1, -1)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}
if (cdLine(myimage, 100, 625, 500, 625)) {
  fprintf(stderr, "cdLine Successfull\n");
}
else {
  fprintf(stderr, "cdLine Unsuccessfull\n");
}

if (cdSetLineAttrib(myimage, 3, -1, -1)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}
if (cdLine(myimage, 100, 650, 500, 650)) {
  fprintf(stderr, "cdLine Successfull\n");
}
else {
  fprintf(stderr, "cdLine Unsuccessfull\n");
}


if (cdSetLineAttrib(myimage, 2, -1, -1)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}
if (cdLine(myimage, 100, 675, 500, 675)) {
  fprintf(stderr, "cdLine Successfull\n");
}
else {
  fprintf(stderr, "cdLine Unsuccessfull\n");
}

if (cdSetLineAttrib(myimage, 1, -1, -1)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}
if (cdLine(myimage, 100, 700, 500, 700)) {
  fprintf(stderr, "cdLine Successfull\n");
}
else {
  fprintf(stderr, "cdLine Unsuccessfull\n");
}

/* now make a circle */
if (cdSetShapeFillAttrib(myimage, 1, -1, 6 )) {
  fprintf(stderr, "cdSetShapeFillAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetShapeFillAttrib Unsuccessfull\n");
}

if (cdSetShapeEdgeAttrib(myimage, 1, 2, green, 0 )) {
  fprintf(stderr, "cdSetShapeEdgeAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetShapeEdgeAttrib Unsuccessfull\n");
}

if (cdCircle(myimage, 500, 500, 25)) {
  fprintf(stderr, "cdCircle Successfull\n");
}
else {
  fprintf(stderr, "cdCircle Unsuccessfull\n");
}

/* how about a Circular Arc now */
if (cdArc3Pt(myimage, 550, 500, 600, 600, 650, 550 )) {
  fprintf(stderr, "cdArc3Pt Successfull\n");
}
else {
  fprintf(stderr, "cdArc3Pt Unsuccessfull\n");
}

/* now draw a closed Circular Arc */
if (cdArc3PtClose(myimage, 550, 200, 600, 300, 650, 250, 0 )) {
  fprintf(stderr, "cdArc3PtClose Successfull\n");
}
else {
  fprintf(stderr, "cdArc3PtClose Unsuccessfull\n");
}

/* and now for an ellipse */
if (cdSetShapeEdgeAttrib(myimage, 1, 2, green, 1 )) {
  fprintf(stderr, "cdSetShapeEdgeAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetShapeEdgeAttrib Unsuccessfull\n");
}

if (cdEllipse(myimage, 750, 200, 800, 250, 750, 300 )) {
  fprintf(stderr, "cdEllipse Successfull\n");
}
else {
  fprintf(stderr, "cdEllipse Unsuccessfull\n");
}


/* Now, the harder ones.  First lets try the polygon stuff */
/* a polygon with 7 or less points */

points[0].x = 700;
points[0].y = 700;
points[1].x = 725;
points[1].y = 750;
points[2].x = 775;
points[2].y = 650;

if (cdPolygon(myimage, points, 3)) {
  fprintf(stderr, "cdPolygon Successfull\n");
}
else {
  fprintf(stderr, "cdPolygon Unsuccessfull\n");
}

/* Here's a tough one, a polygon with more than seven points */

points[0].x = 800;
points[0].y = 700;
points[1].x = 825;
points[1].y = 725;
points[2].x = 850;
points[2].y = 700;
points[3].x = 875;
points[3].y = 750;
points[4].x = 900;
points[4].y = 775;
points[5].x = 925;
points[5].y = 750;
points[6].x = 950;
points[6].y = 850;
points[7].x = 925;
points[7].y = 850;
points[8].x = 875;
points[8].y = 800;
points[9].x = 850;
points[9].y = 825;
points[10].x = 825;
points[10].y = 900;

if (cdPolygon(myimage, points, 11)) {
  fprintf(stderr, "cdPolygon Successfull\n");
}
else {
  fprintf(stderr, "cdPolygon Unsuccessfull\n");
}


/* now for poly lines, just like polygons (except they're lines) */

if (cdSetLineAttrib(myimage, 1, 1, red)) {
  fprintf(stderr, "cdSetLineAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetLineAttrib Unsuccessfull\n");
}


points[0].x = 400;
points[0].y = 16;
points[1].x = 520;
points[1].y = 16;
if (cdPolyLine(myimage, points, 2)) {
  fprintf(stderr, "cdPolyLine Successfull\n");
}
else {
  fprintf(stderr, "cdPolyLine Unsuccessfull\n");
}

points[0].x = 800;
points[0].y = 650;
points[1].x = 825;
points[1].y = 675;
points[2].x = 850;
points[2].y = 650;
points[3].x = 875;
points[3].y = 700;
if (cdPolyLine(myimage, points, 4)) {
  fprintf(stderr, "cdPolyLine Successfull\n");
}
else {
  fprintf(stderr, "cdPolyLine Unsuccessfull\n");
}


/* Hey, things are going so well, lets do some text */
lavender = cdImageColorAllocate(myimage, 204, 102, 255);

if (cdSetTextAttrib(myimage, 1, lavender, 50)) {
  fprintf(stderr, "cdSetTextAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetTextAttrib Unsuccessfull\n");
}

if (cdText(myimage, 50, 800, "CGM Draw Version 1.2")) {
  fprintf(stderr, "cdText Successfull\n");
}
else {
  fprintf(stderr, "cdText Unsuccessfull\n");
}

/* More text.  This time test TextPath and TextOrient */
if (cdSetTextPath(myimage, 3)) {
  fprintf(stderr, "cdSetTextPath Successfull\n");
}
else {
  fprintf(stderr, "cdSetTextPath Unsuccessfull\n");
}

if (cdText(myimage, 50, 800, "CGM Draw")) {
  fprintf(stderr, "cdText Successfull\n");
}
else {
  fprintf(stderr, "cdText Unsuccessfull\n");
}

if (cdSetTextOrient(myimage, 1, 0, 0, -1)) {
  fprintf(stderr, "cdSetTextOrient Successfull\n");
}
else {
  fprintf(stderr, "cdSetTextOrient Unsuccessfull\n");
}

if (cdSetTextPath(myimage, 0)) {
  fprintf(stderr, "cdSetTextPath Successfull\n");
}
else {
  fprintf(stderr, "cdSetTextPath Unsuccessfull\n");
}

if (cdText(myimage, 950, 400, "CGM Draw")) {
  fprintf(stderr, "cdText Successfull\n");
}
else {
  fprintf(stderr, "cdText Unsuccessfull\n");
}


if (cdSetTextOrient(myimage, 0, 1, 1, 0)) {
  fprintf(stderr, "cdSetTextOrient Successfull\n");
}
else {
  fprintf(stderr, "cdSetTextOrient Unsuccessfull\n");
}


if (cdSetTextAttrib(myimage, 5, -1, 25)) {
  fprintf(stderr, "cdSetTextAttrib Successfull\n");
}
else {
  fprintf(stderr, "cdSetTextAttrib Unsuccessfull\n");
}

if (cdText(myimage, 5, 5, "G. Edward Johnson")) {
  fprintf(stderr, "cdText Successfull\n");
}
else {
  fprintf(stderr, "cdText Unsuccessfull\n");
}




outf = fopen("cdout.cgm", "wb");
if (!outf) return 0;
cdImageCgm(myimage, outf);
fclose(outf);
outf = 0;

cdImageDestroy(myimage);


return 1;  
}
