 /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s 8 B I M                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method Is8BIM returns True if the image format type, identified by the  %  magick string, is 8BIM. % - %  The format of the Read8BIMImage method is:  % 7 %      unsigned int Is8BIM(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % L %    o status:  Method Is8BIM returns True if the image format type is 8BIM. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */7 Export unsigned int Is8BIM(const unsigned char *magick,    const unsigned int length) {    if (length < 4)      return(False);/   if (strncmp((char *) (magick),"8BIM",4) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d 8 B I M I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Method Read8BIMImage reads an binary file in the 8BIM format and returns it. N %  It allocates the memory necessary for the new Image structure and returns aH %  pointer to the new image.  This method differs from the other decoderN %  methods in that only the Photoshop resource (8BIM) information is useful in %  the returned image. % - %  The format of the Read8BIMImage method is:  % 8 %      Image *Read8BIMImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method Read8BIMImage returns a pointer to the image afterL %      reading. A null image is returned if there is a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *Read8BIMImage(const ImageInfo *image_info) {    Image      *image;      int      c;     register unsigned char     *q;      unsigned int     length,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read 8BIM image.   */   length=MaxTextExtent; ,   image->iptc_profile.info=(unsigned char *)5     AllocateMemory((length+2)*sizeof(unsigned char)); )   for (q=image->iptc_profile.info; ; q++)    {      c=ReadByte(image);     if (c == EOF)        break;7     if ((q-image->iptc_profile.info+1) >= (int) length)        { >         image->iptc_profile.length=q-image->iptc_profile.info;         length<<=1; L         image->iptc_profile.info=(unsigned char *) ReallocateMemory((char *)E           image->iptc_profile.info,(length+2)*sizeof(unsigned char)); ?         if (image->iptc_profile.info == (unsigned char *) NULL)            break;>         q=image->iptc_profile.info+image->iptc_profile.length;       }      *q=(unsigned char) c;    }    image->iptc_profile.length=0; 9   if (image->iptc_profile.info != (unsigned char *) NULL) :     image->iptc_profile.length=q-image->iptc_profile.info;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e 8 B I M I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % < %  Method Write8BIMImage writes an image in the 8BIM format. % . %  The format of the Write8BIMImage method is: % L %      unsigned int Write8BIMImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows.  % I %    o status: Method Write8BIMImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L Export unsigned int Write8BIMImage(const ImageInfo *image_info,Image *image) {    unsigned int     status;   &   if (image->iptc_profile.length == 0)B     WriterExit(FileOpenWarning,"No 8BIM data is available",image);   /*     Open image file.   */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);:   (void) WriteBlob(image,(int) image->iptc_profile.length,'     (char *) image->iptc_profile.info);    CloseBlob(image);    return(True);  } 