 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %              AAA   N   N  IIIII  M   M   AAA   TTTTT  EEEEE                 % O %             A   A  NN  N    I    MM MM  A   A    T    E                     % O %             AAAAA  N N N    I    M M M  AAAAA    T    EEE                   % O %             A   A  N  NN    I    M   M  A   A    T    E                     % O %             A   A  N   N  IIIII  M   M  A   A    T    EEEEE                 % O %                                                                             % O %                                                                             % O %            Methods to Interactively Animate an Image Sequence               % O %                                                                             % O %                                                                             % O %                           Software Design                                   % O %                             John Cristy                                     % O %                              July 1992                                      % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   #if defined(HasX11)  #include "xwindows.h"  #include "animate.h" /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   X M a g i c k C o m m a n d                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method XMagickCommand makes a transform to the image or Image window as7 %  specified by a user menu button or keyboard command.  % . %  The format of the XMagickCommand method is: % K %      Image *XMagickCommand(Display *display,XResourceInfo *resource_info, H %        XWindows *windows,const CommandType command_type,Image **image, %        unsigned int *state)  % + %  A description of each parameter follows:  % D %    o display: Specifies a connection to an X server; returned from %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % < %    o windows: Specifies a pointer to a XWindows structure. % G %    o image: Specifies a pointer to a Image structure;  XMagickCommand > %      may transform the image and return a new image pointer. % E %    o state: Specifies an unsigned int;  XMagickCommand may return a  %      modified state. %  %  */K static Image *XMagickCommand(Display *display,XResourceInfo *resource_info, A   XWindows *windows,const CommandType command_type,Image **image,    unsigned int *state) { . #define LoadImageText  "  Loading images...  "     Image      *loaded_image;     int      status;      XTextProperty      window_name;     /*     Process user command.    */   loaded_image=(Image *) NULL;   switch (command_type)    {      case OpenCommand:      { 
       char         **filelist;          Image          *image,          *next_image;         ImageInfo          *local_info;  	       int          number_files;          MonitorHandler         handler;         register int
         i;         static char '         filenames[MaxTextExtent] = "*";          unsigned int         status;   #       if (resource_info->immutable)          break;       /*$         Request file name from user.       */>       XFileBrowserWidget(display,windows,"Animate",filenames);       if (*filenames == '\0')          return((Image *) NULL);        /*         Expand the filenames.        */8       filelist=(char **) AllocateMemory(sizeof(char *));%       if (filelist == (char **) NULL) 	         { H           MagickWarning(ResourceLimitWarning,"Memory allocation failed",             (char *) NULL); !           return((Image *) NULL); 	         }        number_files=1;        filelist[0]=filenames;6       status=ExpandFilenames(&number_files,&filelist);3       if ((status == False) || (number_files == 0)) 	         { M           MagickWarning(OptionWarning,"No image files were found",filenames); !           return((Image *) NULL); 	         } ;       local_info=CloneImageInfo(resource_info->image_info); +       if (local_info == (ImageInfo *) NULL)          break;       image=(Image *) NULL; $       handler=(MonitorHandler) NULL;,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);&       for (i=0; i < number_files; i++)       {          if (number_files > 5) ;           handler=SetMonitorHandler((MonitorHandler) NULL); 8         (void) strcpy(local_info->filename,filelist[i]);!         *local_info->magick='\0'; )         next_image=ReadImage(local_info);  #if 0 F         /* Something's wrong here.  No matching AllocMemory except for-            filelist[0] .. glennrp Jun 1999 */ %         if (filelist[i] != filenames) "           FreeMemory(filelist[i]); #endif)         if (next_image != (Image *) NULL)            { (             if (image == (Image *) NULL)               image=next_image;              else               { '                 image->next=next_image; ,                 image->next->previous=image;"                 image=image->next;               }            }          if (number_files <= 5)           continue; *         (void) SetMonitorHandler(handler);6         ProgressMonitor(LoadImageText,i,number_files);       }  #if 1        FreeMemory(filelist[0]); #endif#       DestroyImageInfo(local_info); "       if (image == (Image *) NULL)	         { 1           XSetCursorState(display,windows,False); I           MagickWarning(OptionWarning,"No images were loaded",filenames); !           return((Image *) NULL); 	         } /       while (image->previous != (Image *) NULL)          image=image->previous;       loaded_image=image;        *state|=ExitState;       break;     }      case PlayCommand:      { !       *state|=PlayAnimationState; +       *state&=(~AutoReverseAnimationState);        /*0         Window name is the base of the filename.       */>       FormatString(windows->image.name,"ImageMagick: %.1024s",*         BaseFilename((*image)->filename));0       if (resource_info->title != (char *) NULL);         (void) strcpy(windows->image.name,(*image)->label); L       status=XStringListToTextProperty(&windows->image.name,1,&window_name);       if (status == 0)         break;9       XSetWMName(display,windows->image.id,&window_name); (       XFree((void *) window_name.value);       break;     }      case StepCommand:      case StepBackwardCommand:      case StepForwardCommand:     { !       *state|=StepAnimationState; $       *state&=(~PlayAnimationState);.       if (command_type == StepBackwardCommand))         *state&=(~ForwardAnimationState); -       if (command_type == StepForwardCommand) &         *state|=ForwardAnimationState;0       if (resource_info->title != (char *) NULL)         break;       break;     }      case RepeatCommand:      { #       *state|=RepeatAnimationState; +       *state&=(~AutoReverseAnimationState); !       *state|=PlayAnimationState;        break;     }      case AutoReverseCommand:     { (       *state|=AutoReverseAnimationState;&       *state&=(~RepeatAnimationState);!       *state|=PlayAnimationState;        break;     }      case SlowerCommand:      {        resource_info->delay<<=1; $       if (resource_info->delay == 0)         resource_info->delay=1;        break;     }      case FasterCommand:      {        resource_info->delay>>=1;        break;     }      case ForwardCommand:     { #       *state=ForwardAnimationState; +       *state&=(~AutoReverseAnimationState);        break;     }      case ReverseCommand:     { '       *state&=(~ForwardAnimationState); +       *state&=(~AutoReverseAnimationState);        break;     }      case InfoCommand:      { M       XDisplayImageInfo(display,resource_info,windows,(Image *) NULL,*image);        break;     }      case HelpCommand:      {        /*         User requested help.       */:       XTextViewWidget(display,resource_info,windows,False,-         "Help Viewer - Animate",AnimateHelp);        break;     } $     case BrowseDocumentationCommand:     { 
       Atom         mozilla_atom;          Window         mozilla_window,          root_window;         /*-         Browse the ImageMagick documentation.        */?       root_window=XRootWindow(display,XDefaultScreen(display)); A       mozilla_atom=XInternAtom(display,"_MOZILLA_VERSION",False); I       mozilla_window=XWindowByProperty(display,root_window,mozilla_atom); *       if (mozilla_window != (Window) NULL)	         {            char#             command[MaxTextExtent];              /*@             Display documentation using Netscape remote control.           */E           FormatString(command,"openURL(%.1024s,new-window,noraise)", E             "http://www.wizards.dupont.com/cristy/ImageMagick.html"); E           mozilla_atom=XInternAtom(display,"_MOZILLA_COMMAND",False); J           XChangeProperty(display,mozilla_window,mozilla_atom,XA_STRING,8,G             PropModeReplace,(unsigned char *) command,Extent(command)); 1           XSetCursorState(display,windows,False);            break;	         } ,       XSetCursorState(display,windows,True);,       XCheckRefreshWindows(display,windows);F       status=InvokeDelegate(resource_info->image_info,*image,"browse",         (char *) NULL);        if (status != False)G         XNoticeWidget(display,windows,"Unable to browse documentation",            (char *) NULL);        XDelay(display,1500); -       XSetCursorState(display,windows,False);        break;     }      case VersionCommand:     { C       XNoticeWidget(display,windows,MagickVersion,MagickCopyright);        break;     }      case QuitCommand:      {        /*         Exit program       */'       if (!resource_info->confirm_exit) G         XClientMessage(display,windows->image.id,windows->im_protocols, (           windows->im_exit,CurrentTime);
       else	         {            /*!             Confirm program exit.            */M           status=XConfirmWidget(display,windows,"Do you really want to exit", (             resource_info->client_name);           if (status > 0) K             XClientMessage(display,windows->image.id,windows->im_protocols, ,               windows->im_exit,CurrentTime);	         }        break;     }      default:       break;   }    return(loaded_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n i m a t e B a c k g r o u n d I m a g e                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method XAnimateBackgroundImage animates an image sequence in the  %  background of a window. % 7 %  The format of the XAnimateBackgroundImage method is:  % 5 %      void XAnimateBackgroundImage(Display *display, 4 %        XResourceInfo *resource_info, Image *image) % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */  4 static int SceneCompare(const void *x,const void *y) {    Image      **image_1,     **image_2;     image_1=(Image **) x;    image_2=(Image **) y; :   return((int) (*image_1)->scene-(int) (*image_2)->scene); }   5 Export void XAnimateBackgroundImage(Display *display, -   XResourceInfo *resource_info, Image *image)  {    char     geometry[MaxTextExtent],     visual_type[MaxTextExtent];      static XPixelInfo 
     pixel;     static XStandardColormap     *map_info;     static XVisualInfo(     *visual_info = (XVisualInfo *) NULL;     static XWindowInfo     window_info;     Image      *displayed_image, 
     **images;      int      i,
     scene;     unsigned int     height,      number_scenes,     status, 
     width;     Window     root_window;     XEvent
     event;     XGCValues      context_values;      XPixelInfo     scene_info;      XResourceInfo      resources;     XWindowAttributes      window_attributes;     /*     Determine target window.   */   resources=(*resource_info);    window_info.id=(Window) NULL; ;   root_window=XRootWindow(display,XDefaultScreen(display)); 5   if (Latin1Compare(resources.window_id,"root") == 0)      window_info.id=root_window;    else     { 0       if (isdigit((int) (*resources.window_id)))7         window_info.id=XWindowByID(display,root_window, J           (Window) strtol((char *) resources.window_id,(char **) NULL,0));*       if (window_info.id == (Window) NULL)         window_info.id= A           XWindowByName(display,root_window,resources.window_id);      } &   if (window_info.id == (Window) NULL)     { G       MagickWarning(OptionWarning,"No window with specified id exists",          resources.window_id); 
       return;      }    /*     Determine window visual id.    */I   window_attributes.width=XDisplayWidth(display,XDefaultScreen(display)); K   window_attributes.height=XDisplayHeight(display,XDefaultScreen(display)); '   (void) strcpy(visual_type,"default"); I   status=XGetWindowAttributes(display,window_info.id,&window_attributes);    if (status != False)%     FormatString(visual_type,"0x%lx", 5       XVisualIDFromVisual(window_attributes.visual)); *   if (visual_info == (XVisualInfo *) NULL)     {        /*#         Allocate standard colormap.        */(       map_info=XAllocStandardColormap();1       if (map_info == (XStandardColormap *) NULL) F         MagickError(XServerError,"Unable to create standard colormap",&           "Memory allocation failed");)       map_info->colormap=(Colormap) NULL; *       pixel.pixels=(unsigned long *) NULL;&       pixel.gamma_map=(XColor *) NULL;       /*         Initialize visual info.        */'       resources.map_type=(char *) NULL; (       resources.visual_type=visual_type;?       visual_info=XBestVisualInfo(display,map_info,&resources); .       if (visual_info == (XVisualInfo *) NULL)O         MagickError(XServerError,"Unable to get visual",resources.visual_type);        /*         Initialize window info.        */)       window_info.ximage=(XImage *) NULL; .       window_info.matte_image=(XImage *) NULL;'       window_info.pixmap=(Pixmap) NULL; -       window_info.matte_pixmap=(Pixmap) NULL;      }    /*     Free previous root colors.   */$   if (window_info.id == root_window).     XDestroyWindowColors(display,root_window);#   if (image->next != (Image *)NULL)      {        Image          *coalesce_image;  +       coalesce_image=CoalesceImages(image); +       if (coalesce_image != (Image *) NULL) 	         {            DestroyImages(image);            image=coalesce_image; 	         }      } *   if (resources.map_type == (char *) NULL),     if ((visual_info->class != TrueColor) &&,         (visual_info->class != DirectColor))       { 
         Image            *next_image;           unsigned int           global_colormap;  
         /*I           Determine if the sequence of images has the identical colormap. 
         */         global_colormap=True;          next_image=image; J         for ( ; next_image != (Image *) NULL; next_image=next_image->next)	         { "           next_image->matte=False;3           if ((next_image->class == DirectClass) || 6               (next_image->colors != image->colors) ||F               ((int) next_image->colors > visual_info->colormap_size))
             { $               global_colormap=False;               break;
             } 1           for (i=0; i < (int) image->colors; i++) J             if (!ColorMatch(next_image->colormap[i],image->colormap[i],0))               { &                 global_colormap=False;                 break;               } 	         }          if (!global_colormap) 0           (void) MapImages(image,(Image *) NULL,-             resources.quantize_info->dither);        }    /*+     Sort images by increasing scene number.    */0   images=ListToGroupImage(image,&number_scenes);    if (images == (Image **) NULL)>     MagickError(ResourceLimitError,"Unable to animate images","       "Memory allocation failed");5   for (scene=0; scene < (int) number_scenes; scene++) "     if (images[scene]->scene == 0)       break;#   if (scene == (int) number_scenes) 8     qsort((void *) images,number_scenes,sizeof(Image *),:       (int (*)(const void *, const void *)) SceneCompare);   /*!     Initialize Standard Colormap.    */$   resources.colormap=SharedColormap;   displayed_image=images[0];5   for (scene=0; scene < (int) number_scenes; scene++)    { 5     if ((resource_info->map_type != (char *) NULL) || ,         (visual_info->class == TrueColor) ||,         (visual_info->class == DirectColor))'       images[scene]->class=DirectClass; >     if ((displayed_image->columns < images[scene]->columns) &&6         (displayed_image->rows < images[scene]->rows))$       displayed_image=images[scene];   } 3   if ((resource_info->map_type != (char *) NULL) || *       (visual_info->class == TrueColor) ||*       (visual_info->class == DirectColor))'     displayed_image->class=DirectClass; P   XMakeStandardColormap(display,visual_info,&resources,displayed_image,map_info,     &pixel);   /*     Graphic context superclass.    */9   context_values.background=pixel.background_color.pixel; 9   context_values.foreground=pixel.foreground_color.pixel; H   pixel.annotate_context=XCreateGC(display,window_info.id,GCBackground |"     GCForeground,&context_values);*   if (pixel.annotate_context == (GC) NULL)O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL);    /*'     Initialize Image window attributes.    */J   XGetWindowInfo(display,visual_info,map_info,&pixel,(XFontStruct *) NULL,     &resources,&window_info);    /*     Create the X image.    */'   window_info.width=images[0]->columns; %   window_info.height=images[0]->rows; =   FormatString(geometry,"%ux%u+0+0>",window_attributes.width,      window_attributes.height);C   (void) ParseImageGeometry(geometry,&window_info.x,&window_info.y, ,     &window_info.width,&window_info.height);P   status=XMakeImage(display,&resources,&window_info,images[0],window_info.width,     window_info.height);   if (status == False)G     MagickError(XServerError,"Unable to create X image",(char *) NULL);    window_info.x=0;   window_info.y=0;   if (resources.debug)     { L       (void) fprintf(stderr,"Image: %.1024s[%u] %ux%u ",images[0]->filename,=         images[0]->scene,images[0]->columns,images[0]->rows); !       if (images[0]->colors != 0) 8         (void) fprintf(stderr,"%uc ",images[0]->colors);;       (void) fprintf(stderr,"%.1024s\n",images[0]->magick);      }    /*I     Adjust image dimensions as specified by backdrop or geometry options.    */   width=window_info.width;   height=window_info.height;   if (resources.backdrop)      {        /*         Center image on window.        */3       window_info.x=(window_attributes.width >> 1)- )         (window_info.ximage->width >> 1); 4       window_info.y=(window_attributes.height >> 1)-*         (window_info.ximage->height >> 1);$       width=window_attributes.width;&       height=window_attributes.height;     } 0   if (resources.image_geometry != (char *) NULL)     { 
       char(         default_geometry[MaxTextExtent];  	       int          flags,         gravity;         XSizeHints         *size_hints;         /*          User specified geometry.       */#       size_hints=XAllocSizeHints(); ,       if (size_hints == (XSizeHints *) NULL)E         MagickError(ResourceLimitError,"Unable to display on window", &           "Memory allocation failed");$       size_hints->flags=(long) NULL;:       FormatString(default_geometry,"%ux%u",width,height);M       flags=XWMGeometry(display,visual_info->screen,resources.image_geometry, L         default_geometry,window_info.border_width,size_hints,&window_info.x,@         &window_info.y,(int *) &width,(int *) &height,&gravity);$       if (flags & (XValue | YValue))	         { (           width=window_attributes.width;*           height=window_attributes.height;	         } !       XFree((void *) size_hints);      }    /*     Create the X pixmap.   */   window_info.pixmap= I     XCreatePixmap(display,window_info.id,width,height,window_info.depth); *   if (window_info.pixmap == (Pixmap) NULL)H     MagickError(XServerError,"Unable to create X pixmap",(char *) NULL);   /*!     Display pixmap on the window.    */C   if ((width > window_info.width) || (height > window_info.height)) K     XFillRectangle(display,window_info.pixmap,window_info.annotate_context,        0,0,width,height);D   XPutImage(display,window_info.pixmap,window_info.annotate_context,I     window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,      window_info.height);H   XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);'   XClearWindow(display,window_info.id);    /*'     Initialize image pixmaps structure.    */N   window_info.pixmaps=(Pixmap *) AllocateMemory(number_scenes*sizeof(Pixmap));&   window_info.matte_pixmaps=(Pixmap *)1     AllocateMemory(number_scenes*sizeof(Pixmap)); 1   if ((window_info.pixmaps == (Pixmap *) NULL) || 5       (window_info.matte_pixmaps == (Pixmap *) NULL)) >     MagickError(ResourceLimitError,"Unable to animate images","       "Memory allocation failed");,   window_info.pixmaps[0]=window_info.pixmap;2   window_info.matte_pixmaps[0]=window_info.pixmap;+   scene_info.pixels=(unsigned long *) NULL; '   scene_info.gamma_map=(XColor *) NULL; 5   for (scene=1; scene < (int) number_scenes; scene++)    {      /*       Create X image.      */%     window_info.pixmap=(Pixmap) NULL; +     window_info.matte_pixmap=(Pixmap) NULL; 0     if ((resources.map_type != (char *) NULL) ||,         (visual_info->class == TrueColor) ||,         (visual_info->class == DirectColor)).       if (images[scene]->class == PseudoClass)	         {            /**             Get pixel info for this scene.           */P           XGetPixelPacket(display,visual_info,map_info,&resources,images[scene],             &scene_info); /           window_info.pixel_info=(&scene_info); 	         } D     status=XMakeImage(display,&resources,&window_info,images[scene],2       images[scene]->columns,images[scene]->rows);     if (status == False)I       MagickError(XServerError,"Unable to create X image",(char *) NULL);      if (resources.debug)       { P         (void) fprintf(stderr,"Image: [%u] %.1024s %ux%u ",images[scene]->scene,N           images[scene]->filename,images[scene]->columns,images[scene]->rows);'         if (images[scene]->colors != 0) >           (void) fprintf(stderr,"%uc ",images[scene]->colors);A         (void) fprintf(stderr,"%.1024s\n",images[scene]->magick);        }      /*       Create the X pixmap.     */     window_info.pixmap= K       XCreatePixmap(display,window_info.id,width,height,window_info.depth); ,     if (window_info.pixmap == (Pixmap) NULL)J       MagickError(XServerError,"Unable to create X pixmap",(char *) NULL);     /*#       Display pixmap on the window.      */E     if ((width > window_info.width) || (height > window_info.height)) M       XFillRectangle(display,window_info.pixmap,window_info.annotate_context,          0,0,width,height);F     XPutImage(display,window_info.pixmap,window_info.annotate_context,K       window_info.ximage,0,0,window_info.x,window_info.y,window_info.width,        window_info.height);J     XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);)     XClearWindow(display,window_info.id); 2     window_info.pixmaps[scene]=window_info.pixmap;>     window_info.matte_pixmaps[scene]=window_info.matte_pixmap;     if (images[scene]->matte) +       XClearWindow(display,window_info.id);      if (resources.delay != 0) 9       XDelay(display,(unsigned long) resources.delay*10);      else6       XDelay(display,(unsigned long) image->delay*10);   } "   window_info.pixel_info=(&pixel);   /*!     Display pixmap on the window.    */>   XSelectInput(display,window_info.id,SubstructureNotifyMask);   event.type=Expose;   do   { 7     for (scene=0; scene < (int) number_scenes; scene++)      { 6       if (XEventsQueued(display,QueuedAfterFlush) > 0)	         { %           XNextEvent(display,&event); *           if (event.type == DestroyNotify)             break;	         } 4       window_info.pixmap=window_info.pixmaps[scene];@       window_info.matte_pixmap=window_info.matte_pixmaps[scene];L       XSetWindowBackgroundPixmap(display,window_info.id,window_info.pixmap);+       XClearWindow(display,window_info.id);        XSync(display,False);        if (resources.delay != 0) ;         XDelay(display,(unsigned long) resources.delay*10); 
       else@         XDelay(display,(unsigned long) images[scene]->delay*10);     } (   } while (event.type != DestroyNotify);   XSync(display,False);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   X A n i m a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 3 %  Method XAnimateImages displays an image via X11.  % . %  The format of the XAnimateImages method is: % K %      Image *XAnimateImages(Display *display,XResourceInfo *resource_info, 1 %        char **argv,const int argc,Image *image)  % + %  A description of each parameter follows:  % E %    o display: Specifies a connection to an X server;  returned from  %      XOpenDisplay. % K %    o resource_info: Specifies a pointer to a X11 XResourceInfo structure.  % 7 %    o argv: Specifies the application's argument list.  % / %    o argc: Specifies the number of arguments.  % E %    o image: Specifies a pointer to a Image structure; returned from  %      ReadImage.  %  %  */K Export Image *XAnimateImages(Display *display,XResourceInfo *resource_info, *   char **argv,const int argc,Image *image) {  #define MagickMenus  4 #define MaxWindows  8  #define MagickTitle  "Commands"      static const char      *CommandMenu[]=      {        "Animate",       "Speed",       "Direction",
       "Help",        "Image Info", 
       "Quit",        (char *) NULL      },     *AnimateMenu[]=      { 
       "Open", 
       "Play", 
       "Step",        "Repeat",        "Auto Reverse",        (char *) NULL      },     *SpeedMenu[]=      {        "Faster",        "Slower",        (char *) NULL      },     *DirectionMenu[]=      {        "Forward",       "Reverse",       (char *) NULL      },     *HelpMenu[]=     {        "Overview",        "Browse Documentation",        "About Animate",       (char *) NULL      };       static const char      **Menus[MagickMenus]=      {        AnimateMenu,       SpeedMenu,       DirectionMenu,       HelpMenu     };     static const CommandType     CommandMenus[]=      {        NullCommand,       NullCommand,       NullCommand,       NullCommand,       InfoCommand,       QuitCommand      },     CommandTypes[]=      {        OpenCommand,       PlayCommand,       StepCommand,       RepeatCommand,       AutoReverseCommand     },     SpeedCommands[]=     {        FasterCommand,       SlowerCommand      },     DirectionCommands[]=     {        ForwardCommand,        ReverseCommand     },     HelpCommands[]=      {        HelpCommand,!       BrowseDocumentationCommand,        VersionCommand     };     static const CommandType     *Commands[MagickMenus]=      {        CommandTypes,        SpeedCommands,       DirectionCommands,       HelpCommands     };     char     command[MaxTextExtent], !     resource_name[MaxTextExtent];   
   CommandType      command_type;      ErrorHandler     warning_handler;     Image      *displayed_image, 
     **images,      *loaded_image;     int      first_scene,
     scene,     status;      KeySym     key_symbol;      MonitorHandler     monitor_handler;     register char      *p;      register int     i;  
   static char %     working_directory[MaxTextExtent];      static unsigned int      number_windows;      static XWindowInfo      *magick_windows[MaxWindows];     time_t     timestamp;     unsigned int     context_mask,      number_scenes,
     state;     Window     root_window;     XClassHint     *class_hints;      XEvent
     event;  
   XFontStruct      *font_info;      XGCValues      context_values;      XPixelInfo     *icon_pixel,     *pixel,      scene_info;      XResourceInfo      *icon_resources;     XStandardColormap      *icon_map,     *map_info;     XTextProperty      window_name;  
   XVisualInfo      *icon_visual,      *visual_info;   
   XWindows
     *windows;   
   XWMHints     *manager_hints;   (   monitor_handler=(MonitorHandler) NULL;&   warning_handler=(ErrorHandler) NULL;'   windows=XSetWindows((XWindows *) ~0); #   if (windows != (XWindows *) NULL)      { &       (void) chdir(working_directory);:       monitor_handler=SetMonitorHandler(XProgressMonitor);7       warning_handler=resource_info->display_warnings ? M         SetWarningHandler(XWarning) : SetWarningHandler((ErrorHandler) NULL); +       (void) signal(SIGINT,XSignalHandler); ,       (void) signal(SIGSEGV,XSignalHandler);     }    else     {        register Image         *p;          /*$         Initialize window structure.       */3       for (p=image; p != (Image *) NULL; p=p->next)        { $         if (p->class == DirectClass)           { $             resource_info->colors=0;             break;           } .         if (p->colors > resource_info->colors)*           resource_info->colors=p->colors;       } E       windows=XSetWindows(XInitializeWindows(display,resource_info)); '       if (windows == (XWindows *) NULL) >         MagickError(XServerError,"Unable to create X windows",&           "Memory allocation failed");       /*         Initialize window id's.        */       number_windows=0; 8       magick_windows[number_windows++]=(&windows->icon);<       magick_windows[number_windows++]=(&windows->backdrop);9       magick_windows[number_windows++]=(&windows->image); 8       magick_windows[number_windows++]=(&windows->info);;       magick_windows[number_windows++]=(&windows->command); :       magick_windows[number_windows++]=(&windows->widget);9       magick_windows[number_windows++]=(&windows->popup); .       for (i=0; i < (int) number_windows; i++),         magick_windows[i]->id=(Window) NULL;     }    /*     Initialize font info.    */1   if (windows->font_info != (XFontStruct *) NULL) *     XFreeFont(display,windows->font_info);<   windows->font_info=XBestFont(display,resource_info,False);1   if (windows->font_info == (XFontStruct *) NULL) H     MagickError(XServerError,"Unable to load font",resource_info->font);   /*!     Initialize Standard Colormap.    */   map_info=windows->map_info;    icon_map=windows->icon_map; #   visual_info=windows->visual_info; #   icon_visual=windows->icon_visual;    pixel=windows->pixel_info;!   icon_pixel=windows->icon_pixel;    font_info=windows->font_info; )   icon_resources=windows->icon_resources; #   class_hints=windows->class_hints; '   manager_hints=windows->manager_hints; 7   root_window=XRootWindow(display,visual_info->screen); #   if (image->next != (Image *)NULL)      {        Image          *coalesce_image;  +       coalesce_image=CoalesceImages(image); +       if (coalesce_image != (Image *) NULL) 	         {            DestroyImages(image);            image=coalesce_image; 	         }      } /   if (resource_info->map_type == (char *) NULL) ,     if ((visual_info->class != TrueColor) &&,         (visual_info->class != DirectColor))       { 
         Image            *next_image;           unsigned int           global_colormap;  
         /*I           Determine if the sequence of images has the identical colormap. 
         */         global_colormap=True;          next_image=image; J         for ( ; next_image != (Image *) NULL; next_image=next_image->next)	         { 6           TransformRGBImage(next_image,RGBColorspace);"           next_image->matte=False;3           if ((next_image->class == DirectClass) || 6               (next_image->colors != image->colors) ||F               ((int) next_image->colors > visual_info->colormap_size))
             { $               global_colormap=False;               break;
             } 1           for (i=0; i < (int) image->colors; i++) J             if (!ColorMatch(next_image->colormap[i],image->colormap[i],0))               { &                 global_colormap=False;                 break;               } 	         }          if (!global_colormap) 0           (void) MapImages(image,(Image *) NULL,2             resource_info->quantize_info->dither);       }    /*+     Sort images by increasing scene number.    */0   images=ListToGroupImage(image,&number_scenes);    if (images == (Image **) NULL)>     MagickError(ResourceLimitError,"Unable to animate images","       "Memory allocation failed");5   for (scene=0; scene < (int) number_scenes; scene++) "     if (images[scene]->scene == 0)       break;#   if (scene == (int) number_scenes) 8     qsort((void *) images,number_scenes,sizeof(Image *),:       (int (*)(const void *, const void *)) SceneCompare);   /*!     Initialize Standard Colormap.    */   loaded_image=(Image *) NULL;   displayed_image=images[0];3   TransformRGBImage(displayed_image,RGBColorspace); 5   for (scene=0; scene < (int) number_scenes; scene++)    { 5     if ((resource_info->map_type != (char *) NULL) || ,         (visual_info->class == TrueColor) ||,         (visual_info->class == DirectColor))'       images[scene]->class=DirectClass; >     if ((displayed_image->columns < images[scene]->columns) &&6         (displayed_image->rows < images[scene]->rows))$       displayed_image=images[scene];   }    if (resource_info->debug)      { 8       (void) fprintf(stderr,"Image: %.1024s[%u] %ux%u ",9         displayed_image->filename,displayed_image->scene, 8         displayed_image->columns,displayed_image->rows);'       if (displayed_image->colors != 0) >         (void) fprintf(stderr,"%uc ",displayed_image->colors);A       (void) fprintf(stderr,"%.1024s\n",displayed_image->magick);      } J   XMakeStandardColormap(display,visual_info,resource_info,displayed_image,     map_info,pixel);   /*     Initialize graphic context.    */$   windows->context.id=(Window) NULL;>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,%     resource_info,&windows->context); %   class_hints->res_name="superclass"; #   class_hints->res_class="Display"; -   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; .   manager_hints->initial_state=WithdrawnState;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->context);    if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (context)\n",windows->context.id);:   context_values.background=pixel->background_color.pixel;%   context_values.font=font_info->fid; :   context_values.foreground=pixel->foreground_color.pixel;*   context_values.graphics_exposures=False;J   context_mask=GCBackground | GCFont | GCForeground | GCGraphicsExposures;+   if (pixel->annotate_context != (GC) NULL) -     XFreeGC(display,pixel->annotate_context);    pixel->annotate_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);+   if (pixel->annotate_context == (GC) NULL) O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL); 5   context_values.background=pixel->depth_color.pixel; )   if (pixel->widget_context != (GC) NULL) +     XFreeGC(display,pixel->widget_context);    pixel->widget_context=H     XCreateGC(display,windows->context.id,context_mask,&context_values);)   if (pixel->widget_context == (GC) NULL) O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL); :   context_values.background=pixel->foreground_color.pixel;:   context_values.foreground=pixel->background_color.pixel;   context_values.plane_mask=:     context_values.background ^ context_values.foreground;,   if (pixel->highlight_context != (GC) NULL).     XFreeGC(display,pixel->highlight_context);A   pixel->highlight_context=XCreateGC(display,windows->context.id, 0     context_mask | GCPlaneMask,&context_values);,   if (pixel->highlight_context == (GC) NULL)O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL); .   XDestroyWindow(display,windows->context.id);   /*     Initialize icon window.    */N   XGetWindowInfo(display,icon_visual,icon_map,icon_pixel,(XFontStruct *) NULL,#     icon_resources,&windows->icon); 6   windows->icon.geometry=resource_info->icon_geometry;8   XBestIconSize(display,&windows->icon,displayed_image);$   windows->icon.attributes.colormap=2     XDefaultColormap(display,icon_visual->screen);I   windows->icon.attributes.event_mask=ExposureMask | StructureNotifyMask;    class_hints->res_name="icon"; -   manager_hints->flags=InputHint | StateHint;    manager_hints->input=False; +   manager_hints->initial_state=IconicState; F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->icon);   if (resource_info->debug) H     (void) fprintf(stderr,"Window id: 0x%lx (icon)\n",windows->icon.id);   /*/     Initialize graphic context for icon window.    */0   if (icon_pixel->annotate_context != (GC) NULL)2     XFreeGC(display,icon_pixel->annotate_context);?   context_values.background=icon_pixel->background_color.pixel; ?   context_values.foreground=icon_pixel->foreground_color.pixel; B   icon_pixel->annotate_context=XCreateGC(display,windows->icon.id,1     GCBackground | GCForeground,&context_values); 0   if (icon_pixel->annotate_context == (GC) NULL)O     MagickError(XServerError,"Unable to create graphic context",(char *) NULL); >   windows->icon.annotate_context=icon_pixel->annotate_context;   /*     Initialize Image window.   */)   if (windows->image.id != (Window) NULL)      { &       FreeMemory(windows->image.name);+       FreeMemory(windows->image.icon_name);      } >   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,#     resource_info,&windows->image); >   windows->image.shape=True;  /* non-rectangular shape hint */@   windows->image.shared_memory=resource_info->use_shared_memory;J   windows->image.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char));O   windows->image.icon_name=(char *) AllocateMemory(MaxTextExtent*sizeof(char)); J   if ((windows->image.name == NULL) || (windows->image.icon_name == NULL))C     MagickError(ResourceLimitError,"Unable to create Image window", "       "Memory allocation failed");,   if (resource_info->title != (char *) NULL)     {        /*#         User specified window name.        */7       LabelImage(displayed_image,resource_info->title); @       (void) strcpy(windows->image.name,displayed_image->label);E       (void) strcpy(windows->image.icon_name,displayed_image->label);      }    else     {        /*0         Window name is the base of the filename.       */F       p=displayed_image->filename+Extent(displayed_image->filename)-1;M       while ((p > displayed_image->filename) && !IsBasenameSeparator(*(p-1)))          p--;J       FormatString(windows->image.name,"ImageMagick: %.1024s[%u of %u]",p,.         displayed_image->scene,number_scenes);0       (void) strcpy(windows->image.icon_name,p);     }    if (resource_info->immutable) "     windows->image.immutable=True;   windows->image.shape=True;8   windows->image.geometry=resource_info->image_geometry;0   windows->image.width=displayed_image->columns;N   if ((int) windows->image.width > XDisplayWidth(display,visual_info->screen))D     windows->image.width=XDisplayWidth(display,visual_info->screen);.   windows->image.height=displayed_image->rows;P   if ((int) windows->image.height > XDisplayHeight(display,visual_info->screen))F     windows->image.height=XDisplayHeight(display,visual_info->screen);K   windows->image.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |F     PropertyChangeMask | StructureNotifyMask | SubstructureNotifyMask;>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,&     resource_info,&windows->backdrop);K   if ((resource_info->backdrop) || (windows->backdrop.id != (Window) NULL))      {        /*#         Initialize backdrop window.        */       windows->backdrop.x=0;       windows->backdrop.y=0;4       windows->backdrop.name="ImageMagick Backdrop";2       windows->backdrop.flags=USSize | USPosition;I       windows->backdrop.width=XDisplayWidth(display,visual_info->screen); K       windows->backdrop.height=XDisplayHeight(display,visual_info->screen); '       windows->backdrop.border_width=0; '       windows->backdrop.immutable=True; J       windows->backdrop.attributes.do_not_propagate_mask=ButtonPressMask |         ButtonReleaseMask;N       windows->backdrop.attributes.event_mask=ButtonPressMask | KeyPressMask |         StructureNotifyMask;:       windows->backdrop.attributes.override_redirect=True;'       class_hints->res_name="backdrop"; B       manager_hints->flags=IconWindowHint | InputHint | StateHint;2       manager_hints->icon_window=windows->icon.id;        manager_hints->input=True;#       manager_hints->initial_state= :         resource_info->iconic ? IconicState : NormalState;J       XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,         &windows->backdrop);       if (resource_info->debug) >         (void) fprintf(stderr,"Window id: 0x%lx (backdrop)\n",            windows->backdrop.id);/       XMapWindow(display,windows->backdrop.id); 1       XClearWindow(display,windows->backdrop.id); -       if (windows->image.id != (Window) NULL) 	         { 4           XDestroyWindow(display,windows->image.id);*           windows->image.id=(Window) NULL;	         }        /*2         Position image in the center the backdrop.       */'       windows->image.flags|=USPosition; I       windows->image.x=(XDisplayWidth(display,visual_info->screen) >> 1)- $         (windows->image.width >> 1);J       windows->image.y=(XDisplayHeight(display,visual_info->screen) >> 1)-%         (windows->image.height >> 1);      } +   if (resource_info->name == (char *) NULL) 5     class_hints->res_name=resource_info->client_name;    else.     class_hints->res_name=resource_info->name;>   manager_hints->flags=IconWindowHint | InputHint | StateHint;.   manager_hints->icon_window=windows->icon.id;   manager_hints->input=True;   manager_hints->initial_state= 6     resource_info->iconic ? IconicState : NormalState;0   if (windows->group_leader.id != (Window) NULL)     {        /*         Follow the leader.       */,       manager_hints->flags|=WindowGroupHint;;       manager_hints->window_group=windows->group_leader.id; I       XSelectInput(display,windows->group_leader.id,StructureNotifyMask);        if (resource_info->debug) B         (void) fprintf(stderr,"Window id: 0x%lx (group leader)\n",$           windows->group_leader.id);     }    XMakeWindow(display,L     (Window) (resource_info->backdrop ? windows->backdrop.id : root_window),9     argv,argc,class_hints,manager_hints,&windows->image); N   XChangeProperty(display,windows->image.id,windows->im_protocols,XA_STRING,8,.     PropModeReplace,(unsigned char *) NULL,0);0   if (windows->group_leader.id != (Window) NULL)M     XSetTransientForHint(display,windows->image.id,windows->group_leader.id);    if (resource_info->debug) J     (void) fprintf(stderr,"Window id: 0x%lx (image)\n",windows->image.id);   /*     Initialize Info widget.    */>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,"     resource_info,&windows->info);   windows->info.name="Info";!   windows->info.icon_name="Info";    windows->info.border_width=1;    windows->info.x=2;   windows->info.y=2;!   windows->info.flags|=PPosition; 4   windows->info.attributes.win_gravity=UnmapGravity;&   windows->info.attributes.event_mask=9     ButtonPressMask | ExposureMask | StructureNotifyMask;    class_hints->res_name="info"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False; +   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;L   XMakeWindow(display,windows->image.id,argv,argc,class_hints,manager_hints,     &windows->info);@   windows->info.highlight_stipple=XCreateBitmapFromData(display,N     windows->info.id,(char *) HighlightBitmap,HighlightWidth,HighlightHeight);=   windows->info.shadow_stipple=XCreateBitmapFromData(display, E     windows->info.id,(char *) ShadowBitmap,ShadowWidth,ShadowHeight); C   XSetTransientForHint(display,windows->info.id,windows->image.id);    if (windows->image.mapped)C     XWithdrawWindow(display,windows->info.id,windows->info.screen);    if (resource_info->debug) H     (void) fprintf(stderr,"Window id: 0x%lx (info)\n",windows->info.id);   /*     Initialize Command widget.   */>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,%     resource_info,&windows->command); $   windows->command.data=MagickMenus;E   (void) XCommandWidget(display,windows,CommandMenu,(XEvent *) NULL); K   FormatString(resource_name,"%.1024s.command",resource_info->client_name); O   windows->command.geometry=XGetResourceClass(resource_info->resource_database, ,     resource_name,"geometry",(char *) NULL);$   windows->command.name=MagickTitle;"   windows->command.border_width=0;$   windows->command.flags|=PPosition;M   windows->command.attributes.event_mask=ButtonMotionMask | ButtonPressMask | J     ButtonReleaseMask | EnterWindowMask | ExposureMask | LeaveWindowMask |.     OwnerGrabButtonMask | StructureNotifyMask;"   class_hints->res_name="command";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=False; +   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->command); E   windows->command.highlight_stipple=windows->info.highlight_stipple; ?   windows->command.shadow_stipple=windows->info.shadow_stipple; F   XSetTransientForHint(display,windows->command.id,windows->image.id);   if (resource_info->debug) N     (void) fprintf(stderr,"Window id: 0x%lx (command)\n",windows->command.id);   /*     Initialize Widget window.    */*   if (windows->widget.id != (Window) NULL)%     FreeMemory(windows->widget.name); >   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,$     resource_info,&windows->widget);J   FormatString(resource_name,"%.1024s.widget",resource_info->client_name);N   windows->widget.geometry=XGetResourceClass(resource_info->resource_database,,     resource_name,"geometry",(char *) NULL);K   windows->widget.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char)); #   if (windows->widget.name == NULL) C     MagickError(ResourceLimitError,"Unable to create Image window", "       "Memory allocation failed");   *windows->widget.name='\0'; !   windows->widget.border_width=0; #   windows->widget.flags|=PPosition; 6   windows->widget.attributes.backing_store=WhenMapped;-   windows->widget.attributes.save_under=True; L   windows->widget.attributes.event_mask=ButtonMotionMask | ButtonPressMask |G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | <     KeyReleaseMask | LeaveWindowMask | OwnerGrabButtonMask |     StructureNotifyMask;!   class_hints->res_name="widget"; ?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->widget);D   windows->widget.highlight_stipple=windows->info.highlight_stipple;>   windows->widget.shadow_stipple=windows->info.shadow_stipple;E   XSetTransientForHint(display,windows->widget.id,windows->image.id);    if (resource_info->debug) L     (void) fprintf(stderr,"Window id: 0x%lx (widget)\n",windows->widget.id);   /*     Initialize popup window.   */)   if (windows->popup.id != (Window) NULL) $     FreeMemory(windows->popup.name);>   XGetWindowInfo(display,visual_info,map_info,pixel,font_info,#     resource_info,&windows->popup); J   windows->popup.name=(char *) AllocateMemory(MaxTextExtent*sizeof(char));"   if (windows->popup.name == NULL)C     MagickError(ResourceLimitError,"Unable to create Image window", "       "Memory allocation failed");   *windows->popup.name='\0';    windows->popup.border_width=0;"   windows->popup.flags|=PPosition;5   windows->popup.attributes.backing_store=WhenMapped; ,   windows->popup.attributes.save_under=True;K   windows->popup.attributes.event_mask=ButtonMotionMask | ButtonPressMask | G     ButtonReleaseMask | EnterWindowMask | ExposureMask | KeyPressMask | ;     KeyReleaseMask | LeaveWindowMask | StructureNotifyMask;     class_hints->res_name="popup";?   manager_hints->flags=InputHint | StateHint | WindowGroupHint;    manager_hints->input=True;+   manager_hints->initial_state=NormalState; 0   manager_hints->window_group=windows->image.id;F   XMakeWindow(display,root_window,argv,argc,class_hints,manager_hints,     &windows->popup); C   windows->popup.highlight_stipple=windows->info.highlight_stipple; =   windows->popup.shadow_stipple=windows->info.shadow_stipple; D   XSetTransientForHint(display,windows->popup.id,windows->image.id);   if (resource_info->debug) K     (void) fprintf(stderr,"Window id: 0x%lx (pop up)\n",windows->popup.id); H   if (!windows->image.mapped || (windows->backdrop.id != (Window) NULL))*     XMapWindow(display,windows->image.id);   /**     Set out progress and warning handlers.   *//   if (monitor_handler == (MonitorHandler) NULL) 8     monitor_handler=SetMonitorHandler(XProgressMonitor);-   if (warning_handler == (ErrorHandler) NULL) 5     warning_handler=resource_info->display_warnings ? K       SetWarningHandler(XWarning) : SetWarningHandler((ErrorHandler) NULL); '   (void) signal(SIGINT,XSignalHandler); (   (void) signal(SIGSEGV,XSignalHandler);   /*!     Initialize X image structure.    */   windows->image.x=0;    windows->image.y=0; J   status=XMakeImage(display,resource_info,&windows->image,displayed_image,4     displayed_image->columns,displayed_image->rows);   if (status == False)G     MagickError(XServerError,"Unable to create X image",(char *) NULL);    if (windows->image.mapped)<     XRefreshWindow(display,&windows->image,(XEvent *) NULL);   /*'     Initialize image pixmaps structure.    */(   XMapWindow(display,windows->image.id);#   windows->image.pixmaps=(Pixmap *) 1     AllocateMemory(number_scenes*sizeof(Pixmap)); )   windows->image.matte_pixmaps=(Pixmap *) 1     AllocateMemory(number_scenes*sizeof(Pixmap)); 4   if ((windows->image.pixmaps == (Pixmap *) NULL) ||8       (windows->image.matte_pixmaps == (Pixmap *) NULL))>     MagickError(ResourceLimitError,"Unable to animate images","       "Memory allocation failed");2   windows->image.pixmaps[0]=windows->image.pixmap;>   windows->image.matte_pixmaps[0]=windows->image.matte_pixmap;+   scene_info.pixels=(unsigned long *) NULL; '   scene_info.gamma_map=(XColor *) NULL; 5   for (scene=1; scene < (int) number_scenes; scene++)    {      /*       Create X image.      */3     TransformRGBImage(images[scene],RGBColorspace); (     windows->image.pixmap=(Pixmap) NULL;.     windows->image.matte_pixmap=(Pixmap) NULL;5     if ((resource_info->map_type != (char *) NULL) || ,         (visual_info->class == TrueColor) ||,         (visual_info->class == DirectColor)).       if (images[scene]->class == PseudoClass)	         {            /**             Get pixel info for this scene.           */E           XGetPixelPacket(display,visual_info,map_info,resource_info, '             images[scene],&scene_info); 2           windows->image.pixel_info=(&scene_info);	         } J     status=XMakeImage(display,resource_info,&windows->image,images[scene],2       images[scene]->columns,images[scene]->rows);     if (status == False)I       MagickError(XServerError,"Unable to create X image",(char *) NULL);      if (resource_info->debug)        { P         (void) fprintf(stderr,"Image: [%u] %.1024s %ux%u ",images[scene]->scene,N           images[scene]->filename,images[scene]->columns,images[scene]->rows);'         if (images[scene]->colors != 0) >           (void) fprintf(stderr,"%uc ",images[scene]->colors);A         (void) fprintf(stderr,"%.1024s\n",images[scene]->magick);        }      /*.       Window name is the base of the filename.     */.     if (resource_info->title != (char *) NULL)       { 7         LabelImage(images[scene],resource_info->title); @         (void) strcpy(windows->image.name,images[scene]->label);       }      else       { D         p=images[scene]->filename+Extent(images[scene]->filename)-1;@         while ((p > images[scene]->filename) && (*(p-1) != '/'))           p--;L         FormatString(windows->image.name,"ImageMagick: %.1024s[%u of %u]",p,           scene,number_scenes);        } J     status=XStringListToTextProperty(&windows->image.name,1,&window_name);     if (status != 0)       { ;         XSetWMName(display,windows->image.id,&window_name); *         XFree((void *) window_name.value);       } 8     windows->image.pixmaps[scene]=windows->image.pixmap;D     windows->image.matte_pixmaps[scene]=windows->image.matte_pixmap;     event.xexpose.x=0;     event.xexpose.y=0;/     event.xexpose.width=images[scene]->columns; -     event.xexpose.height=images[scene]->rows; 3     XRefreshWindow(display,&windows->image,&event);    }    if (windows->command.mapped),     XMapRaised(display,windows->command.id);   /*     Respond to events.   */   loaded_image=(Image *) NULL;
   scene=0;   first_scene=0;   image=images[0];5   state=ForwardAnimationState | RepeatAnimationState; I   (void) XMagickCommand(display,resource_info,windows,PlayCommand,&image,      &state);   do   { 5     if (XEventsQueued(display,QueuedAfterFlush) == 0) G       if ((state & PlayAnimationState) || (state & StepAnimationState)) 	         { ,           if (state & ForwardAnimationState)
             {                /*;                 Forward animation:  increment scene number.                */2               if (scene < ((int) number_scenes-1))                 scene++;               else6                 if (state & AutoReverseAnimationState)                   { 4                     state&=(~ForwardAnimationState);                     scene--;                   }                  else                   { 8                     if (!(state & RepeatAnimationState))3                       state&=(~PlayAnimationState); &                     scene=first_scene;7                     (void) sleep(resource_info->pause);                    } 
             }            else
             {                /*;                 Reverse animation:  decrement scene number.                */&               if (scene > first_scene)                 scene--;               else6                 if (state & AutoReverseAnimationState)                   { 1                     state|=ForwardAnimationState; &                     scene=first_scene;7                     (void) sleep(resource_info->pause);                    }                  else                   { 8                     if (!(state & RepeatAnimationState))3                       state&=(~PlayAnimationState); *                     scene=number_scenes-1;                   } 
             }            image=images[scene]; #if 0 J           /* This worked in version 4.2.9.  TO DO: get it working again */I           if ((image != (Image *) NULL) && image->restart_animation_here)              first_scene=scene; #endif-           if ((state & StepAnimationState) || 6               (resource_info->title != (char *) NULL))
             {                /*$                 Update window title.               */J               p=images[scene]->filename+Extent(images[scene]->filename)-1;F               while ((p > images[scene]->filename) && (*(p-1) != '/'))                 p--;/               FormatString(windows->image.name, H                 "ImageMagick: %.1024s[%u of %u]",p,scene,number_scenes);8               if (resource_info->title != (char *) NULL)@                 (void) strcpy(windows->image.name,image->label);               status= O                 XStringListToTextProperty(&windows->image.name,1,&window_name);                if (status != 0)                 { E                   XSetWMName(display,windows->image.id,&window_name); 4                   XFree((void *) window_name.value);                 } 
             }            /**             Copy X pixmap to Image window.           */E           XGetPixelPacket(display,visual_info,map_info,resource_info, %           images[scene],&scene_info); 2           windows->image.pixel_info=(&scene_info);6           windows->image.ximage->width=image->columns;4           windows->image.ximage->height=image->rows;>           windows->image.pixmap=windows->image.pixmaps[scene];J           windows->image.matte_pixmap=windows->image.matte_pixmaps[scene];           event.xexpose.x=0;           event.xexpose.y=0;-           event.xexpose.width=image->columns; +           event.xexpose.height=image->rows; 9           XRefreshWindow(display,&windows->image,&event);            XSync(display,False); '           state&=(~StepAnimationState); (           if (resource_info->delay != 0)D             XDelay(display,(unsigned long) resource_info->delay*10);           else<             XDelay(display,(unsigned long) image->delay*10);           continue; 	         }      /*       Handle a window event.     */$     timestamp=time((time_t *) NULL);     XNextEvent(display,&event);      if (!windows->image.stasis) B       windows->image.stasis=(time((time_t *) NULL)-timestamp) > 0;1     if (event.xany.window == windows->command.id)        {          int 
           id;   
         /*3           Select a command from the Command widget. 
         */>         id=XCommandWidget(display,windows,CommandMenu,&event);         if (id < 0)            continue; /         (void) strcpy(command,CommandMenu[id]); &         command_type=CommandMenus[id];         if (id < MagickMenus)            {              int                entry;               /*2               Select a command from a pop-up menu.             */H             entry=XMenuWidget(display,windows,CommandMenu[id],Menus[id],               command);              if (entry < 0)               continue; 4             (void) strcpy(command,Menus[id][entry]);-             command_type=Commands[id][entry];            } (         if (command_type != NullCommand)D           loaded_image=XMagickCommand(display,resource_info,windows,(             command_type,&image,&state);         continue;        }      switch (event.type)      {        case ButtonPress:        { !         if (resource_info->debug) B           (void) fprintf(stderr,"Button Press: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y); 0         if ((event.xbutton.button == Button3) &&-             (event.xbutton.state & Mod1Mask))            {              /*-               Convert Alt-Button3 to Button2.              */)             event.xbutton.button=Button2; -             event.xbutton.state&=(~Mod1Mask);            } 9         if (event.xbutton.window == windows->backdrop.id)            { G             XSetInputFocus(display,event.xbutton.window,RevertToParent, "               event.xbutton.time);             break;           } 6         if (event.xbutton.window == windows->image.id)           { )             if (resource_info->immutable)                { !                 state|=ExitState;                  break;               }              /*'               Map/unmap Command widget.              */(             if (windows->command.mapped):               XWithdrawWindow(display,windows->command.id,)                 windows->command.screen);              else               { B                 (void) XCommandWidget(display,windows,CommandMenu,#                   (XEvent *) NULL); 8                 XMapRaised(display,windows->command.id);               }            }          break;       }        case ButtonRelease:        { !         if (resource_info->debug) D           (void) fprintf(stderr,"Button Release: 0x%lx %u +%d+%d\n",F             event.xbutton.window,event.xbutton.button,event.xbutton.x,             event.xbutton.y);          break;       }        case ClientMessage:        { !         if (resource_info->debug) I           (void) fprintf(stderr,"Client Message: 0x%lx 0x%lx %d 0x%lx\n", <             event.xclient.window,event.xclient.message_type,J             event.xclient.format,(unsigned long) event.xclient.data.l[0]);@         if (event.xclient.message_type == windows->im_protocols)           { K             if (*event.xclient.data.l == (int) windows->im_update_colormap)                {                  /*=                   Update graphic context and window colormap.                  */8                 for (i=0; i < (int) number_windows; i++)                 { @                   if (magick_windows[i]->id == windows->icon.id)                     continue; J                   context_values.background=pixel->background_color.pixel;J                   context_values.foreground=pixel->foreground_color.pixel;H                   XChangeGC(display,magick_windows[i]->annotate_context,2                     context_mask,&context_values);F                   XChangeGC(display,magick_windows[i]->widget_context,2                     context_mask,&context_values);J                   context_values.background=pixel->foreground_color.pixel;J                   context_values.foreground=pixel->background_color.pixel;,                   context_values.plane_mask=J                     context_values.background ^ context_values.foreground;I                   XChangeGC(display,magick_windows[i]->highlight_context, @                     context_mask | GCPlaneMask,&context_values);A                   magick_windows[i]->attributes.background_pixel= 2                     pixel->background_color.pixel;=                   magick_windows[i]->attributes.border_pixel= .                     pixel->border_color.pixel;L                   magick_windows[i]->attributes.colormap=map_info->colormap;H                   XChangeWindowAttributes(display,magick_windows[i]->id,L                     magick_windows[i]->mask,&magick_windows[i]->attributes);                 } :                 if (windows->backdrop.id != (Window) NULL)?                   XInstallColormap(display,map_info->colormap);                  break;               } @             if (*event.xclient.data.l == (int) windows->im_exit)               { !                 state|=ExitState;                  break;               }              break;           } A         if (event.xclient.message_type == windows->dnd_protocols)            {              Atom               selection,               type;                int                format;                unsigned char                *data;               unsigned long                after,               length;                /*A               Display image named by the Drag-and-Drop selection.              */7             if (((int) (*event.xclient.data.l) != 2) && 7                 ((int) (*event.xclient.data.l) != 128))                break;@             selection=XInternAtom(display,"DndSelection",False);M             status=XGetWindowProperty(display,root_window,selection,0L,2047L, O               False,(Atom) AnyPropertyType,&type,&format,&length,&after,&data); 5             if ((status != Success) || (length == 0))                break;3             if ((int) (*event.xclient.data.l) == 2)                {                  /*                   Offix DND.                 */B                 (void) strcpy(resource_info->image_info->filename,!                   (char *) data);                }              else               {                  /*                   XDND.                  */<                 if (strncmp((char *) data, "file:", 5) != 0)                   { )                     XFree((void *) data);                      break;                   } B                 (void) strcpy(resource_info->image_info->filename,%                   ((char *) data)+5);                } >             loaded_image=ReadImage(resource_info->image_info);/             if (loaded_image != (Image *) NULL)                state|=ExitState; !             XFree((void *) data);              break;           } 
         /*0           If client window delete message, exit.
         */@         if (event.xclient.message_type != windows->wm_protocols)           break;B         if (*event.xclient.data.l == (int) windows->wm_take_focus)           { G             XSetInputFocus(display,event.xclient.window,RevertToParent, '               event.xclient.data.l[1]);              break;           } E         if (*event.xclient.data.l != (int) windows->wm_delete_window)            break;J         XWithdrawWindow(display,event.xclient.window,visual_info->screen);6         if (event.xclient.window == windows->image.id)           {              state|=ExitState;              break;           }          break;       }        case ConfigureNotify:        { !         if (resource_info->debug) K           (void) fprintf(stderr,"Configure Notify: 0x%lx %dx%d+%d+%d %d\n", ;             event.xconfigure.window,event.xconfigure.width, J             event.xconfigure.height,event.xconfigure.x,event.xconfigure.y,)             event.xconfigure.send_event); 9         if (event.xconfigure.window == windows->image.id)            { 1             if (event.xconfigure.send_event != 0)                {                  XWindowChanges!                   window_changes;                    /*N                   Position the transient windows relative of the Image window.                 */?                 if (windows->command.geometry == (char *) NULL) /                   if (!windows->command.mapped)                      { *                        windows->command.x=G                           event.xconfigure.x-windows->command.width-25; >                         windows->command.y=event.xconfigure.y;L                         XConstrainWindowPosition(display,&windows->command);<                         window_changes.x=windows->command.x;<                         window_changes.y=windows->command.y;I                         XReconfigureWMWindow(display,windows->command.id, M                           windows->command.screen,CWX | CWY,&window_changes);                      } >                 if (windows->widget.geometry == (char *) NULL).                   if (!windows->widget.mapped)                     { (                       windows->widget.x=E                         event.xconfigure.x+event.xconfigure.width/10; (                       windows->widget.y=F                         event.xconfigure.y+event.xconfigure.height/10;I                       XConstrainWindowPosition(display,&windows->widget); 9                       window_changes.x=windows->widget.x; 9                       window_changes.y=windows->widget.y; F                       XReconfigureWMWindow(display,windows->widget.id,J                         windows->widget.screen,CWX | CWY,&window_changes);                     }                }              /*3               Image window has a new configuration.              */8             windows->image.width=event.xconfigure.width;:             windows->image.height=event.xconfigure.height;             break;           } 8         if (event.xconfigure.window == windows->icon.id)           {              /*2               Icon window has a new configuration.             */7             windows->icon.width=event.xconfigure.width; 9             windows->icon.height=event.xconfigure.height;              break;           }          break;       }        case DestroyNotify:        { 
         /*"           Group leader has exited.
         */!         if (resource_info->debug) :           (void) fprintf(stderr,"Destroy Notify: 0x%lx\n",)             event.xdestroywindow.window); D         if (event.xdestroywindow.window == windows->group_leader.id)           {              state|=ExitState;              break;           }          break;       }        case EnterNotify:        { 
         /*'           Selectively install colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) 8             XInductColormap(display,map_info->colormap);         break;       }        case Expose:       { !         if (resource_info->debug) >           (void) fprintf(stderr,"Expose: 0x%lx %dx%d+%d+%d\n",J             event.xexpose.window,event.xexpose.width,event.xexpose.height,-             event.xexpose.x,event.xexpose.y); 
         /*/           Repaint windows that are now exposed. 
         */6         if (event.xexpose.window == windows->image.id)           { @             windows->image.pixmap=windows->image.pixmaps[scene];L             windows->image.matte_pixmap=windows->image.matte_pixmaps[scene];;             XRefreshWindow(display,&windows->image,&event);              break;           } 5         if (event.xexpose.window == windows->icon.id) '           if (event.xexpose.count == 0) 
             { <               XRefreshWindow(display,&windows->icon,&event);               break;
             }          break;       }        case KeyPress:       {          static int           length;   
         /*&           Respond to a user key press.
         */O         length=XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL);          *(command+length)='\0'; !         if (resource_info->debug) O           (void) fprintf(stderr,"Key press: 0x%lx (%c)\n",key_symbol,*command); !         command_type=NullCommand;          switch (key_symbol) 	         {            case XK_o:           { 2             if (!(event.xkey.state & ControlMask))               break;%             command_type=OpenCommand;            }            case XK_BackSpace:           { -             command_type=StepBackwardCommand;              break;           }            case XK_space:           { ,             command_type=StepForwardCommand;             break;           }            case XK_less:            { '             command_type=FasterCommand;              break;           }            case XK_greater:           { '             command_type=SlowerCommand;              break;           }            case XK_F1:            { %             command_type=HelpCommand;              break;           }            case XK_Find:            { 4             command_type=BrowseDocumentationCommand;             break;           }            case XK_question:            { %             command_type=InfoCommand;              break;           }            case XK_q:           case XK_Cancel:            { 2             if (!(event.xkey.state & ControlMask))               break;%             command_type=QuitCommand;              break;           }            default:             break;	         } (         if (command_type != NullCommand)D           loaded_image=XMagickCommand(display,resource_info,windows,(             command_type,&image,&state);         break;       }        case KeyRelease:       { 
         /*(           Respond to a user key release.
         */O         (void) XLookupString((XKeyEvent *) &event.xkey,command,sizeof(command), /           &key_symbol,(XComposeStatus *) NULL); !         if (resource_info->debug) G           (void) fprintf(stderr,"Key release: 0x%lx (%c)\n",key_symbol,              *command);         break;       }        case LeaveNotify:        { 
         /*)           Selectively uninstall colormap. 
         */P         if (map_info->colormap != XDefaultColormap(display,visual_info->screen))3           if (event.xcrossing.mode != NotifyUngrab) :             XUninductColormap(display,map_info->colormap);         break;       }        case MapNotify:        { !         if (resource_info->debug) I           (void) fprintf(stderr,"Map Notify: 0x%lx\n",event.xmap.window); 6         if (event.xmap.window == windows->backdrop.id)           { D             XSetInputFocus(display,event.xmap.window,RevertToParent,               CurrentTime); *             windows->backdrop.mapped=True;             break;           } 3         if (event.xmap.window == windows->image.id)            { 6             if (windows->backdrop.id != (Window) NULL);               XInstallColormap(display,map_info->colormap); =             if (Latin1Compare(images[0]->magick,"LOGO") == 0)                { M                 if (Latin1Compare(displayed_image->filename,"Untitled") == 0) L                   loaded_image=XMagickCommand(display,resource_info,windows,/                     OpenCommand,&image,&state);                  else#                   state|=ExitState;                } '             windows->image.mapped=True;              break;           } 2         if (event.xmap.window == windows->info.id)           { &             windows->info.mapped=True;             break;           } 2         if (event.xmap.window == windows->icon.id)           {              /*#               Create an icon image.              */E             XMakeStandardColormap(display,icon_visual,icon_resources, 3               displayed_image,icon_map,icon_pixel); D             (void) XMakeImage(display,icon_resources,&windows->icon,H               displayed_image,windows->icon.width,windows->icon.height);@             XSetWindowBackgroundPixmap(display,windows->icon.id,$               windows->icon.pixmap);3             XClearWindow(display,windows->icon.id); K             XWithdrawWindow(display,windows->info.id,windows->info.screen); &             windows->icon.mapped=True;             break;           } 5         if (event.xmap.window == windows->command.id)            { )             windows->command.mapped=True;              break;           } 3         if (event.xmap.window == windows->popup.id)            { '             windows->popup.mapped=True;              break;           } 4         if (event.xmap.window == windows->widget.id)           { (             windows->widget.mapped=True;             break;           }          break;       }        case MappingNotify:        { 1         XRefreshKeyboardMapping(&event.xmapping);          break;       }        case NoExpose:         break;       case PropertyNotify:       {          Atom           type;            int            format;            unsigned char            *data;           unsigned long            after,           length;   !         if (resource_info->debug) D           (void) fprintf(stderr,"Property Notify: 0x%lx 0x%lx %d\n",O             event.xproperty.window,event.xproperty.atom,event.xproperty.state); ?         if (event.xproperty.atom != windows->im_remote_command)            break;
         /*=           Display image named by the remote command protocol. 
         */A         status=XGetWindowProperty(display,event.xproperty.window, O           event.xproperty.atom,0L,MaxTextExtent-1,False,(Atom) AnyPropertyType, .           &type,&format,&length,&after,&data);1         if ((status != Success) || (length == 0))            break;I         (void) strcpy(resource_info->image_info->filename,(char *) data); :         loaded_image=ReadImage(resource_info->image_info);+         if (loaded_image != (Image *) NULL)            state|=ExitState;          XFree((void *) data);          break;       }        case ReparentNotify:       { !         if (resource_info->debug) B           (void) fprintf(stderr,"Reparent Notify: 0x%lx=>0x%lx\n",;             event.xreparent.parent,event.xreparent.window);          break;       }        case UnmapNotify:        { !         if (resource_info->debug) M           (void) fprintf(stderr,"Unmap Notify: 0x%lx\n",event.xunmap.window); 8         if (event.xunmap.window == windows->backdrop.id)           { +             windows->backdrop.mapped=False;              break;           } 5         if (event.xunmap.window == windows->image.id)            { (             windows->image.mapped=False;             break;           } 4         if (event.xunmap.window == windows->info.id)           { '             windows->info.mapped=False;              break;           } 4         if (event.xunmap.window == windows->icon.id)           { 9             if (map_info->colormap == icon_map->colormap) D               XConfigureImageColormap(display,resource_info,windows,!                 displayed_image); K             XFreeStandardColormap(display,icon_visual,icon_map,icon_pixel); '             windows->icon.mapped=False;              break;           } 7         if (event.xunmap.window == windows->command.id)            { *             windows->command.mapped=False;             break;           } 5         if (event.xunmap.window == windows->popup.id)            { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); (             windows->popup.mapped=False;             break;           } 6         if (event.xunmap.window == windows->widget.id)           { 6             if (windows->backdrop.id != (Window) NULL)F               XSetInputFocus(display,windows->image.id,RevertToParent,                 CurrentTime); )             windows->widget.mapped=False;              break;           }          break;       }        default:       { !         if (resource_info->debug) ?           (void) fprintf(stderr,"Event type: %d\n",event.type);          break;       }      }    }    while (!(state & ExitState)); 3   if ((windows->visual_info->class == GrayScale) || 5       (windows->visual_info->class == PseudoColor) || 3       (windows->visual_info->class == DirectColor))      {        /*         Withdraw windows.        */       if (windows->info.mapped) G         XWithdrawWindow(display,windows->info.id,windows->info.screen); "       if (windows->command.mapped)M         XWithdrawWindow(display,windows->command.id,windows->command.screen);      }    if (!resource_info->backdrop) !     if (windows->backdrop.mapped)        { O         XWithdrawWindow(display,windows->backdrop.id,windows->backdrop.screen); 5         XDestroyWindow(display,windows->backdrop.id); +         windows->backdrop.id=(Window) NULL; I         XWithdrawWindow(display,windows->image.id,windows->image.screen); 2         XDestroyWindow(display,windows->image.id);(         windows->image.id=(Window) NULL;       } (   XSetCursorState(display,windows,True);(   XCheckRefreshWindows(display,windows);5   for (scene=1; scene < (int) number_scenes; scene++)    { 7     if (windows->image.pixmaps[scene] != (Pixmap) NULL) 9       XFreePixmap(display,windows->image.pixmaps[scene]); 0     windows->image.pixmaps[scene]=(Pixmap) NULL;=     if (windows->image.matte_pixmaps[scene] != (Pixmap) NULL) ?       XFreePixmap(display,windows->image.matte_pixmaps[scene]); 6     windows->image.matte_pixmaps[scene]=(Pixmap) NULL;   } %   FreeMemory(windows->image.pixmaps); )   windows->image.pixmaps=(Pixmap *) NULL; +   FreeMemory(windows->image.matte_pixmaps); /   windows->image.matte_pixmaps=(Pixmap *) NULL; %   if (loaded_image == (Image *) NULL)      {        /*         Destroy X windows.       */        if (windows->image.mapped)I         XWithdrawWindow(display,windows->image.id,windows->image.screen); "       XDelay(display,SuspendTime);.       for (i=0; i < (int) number_windows; i++)       { 3         if (magick_windows[i]->id != (Window) NULL)            { 3             magick_windows[i]->shared_memory=False; F             (void) XMakeImage(display,resource_info,magick_windows[i],"               (Image *) NULL,1,1);:             XDestroyWindow(display,magick_windows[i]->id);           } 9         if (magick_windows[i]->ximage != (XImage *) NULL) 3           XDestroyImage(magick_windows[i]->ximage); 7         if (magick_windows[i]->pixmap != (Pixmap) NULL) 9           XFreePixmap(display,magick_windows[i]->pixmap);        }        /*         Free Standard Colormap.        */E       XFreeStandardColormap(display,icon_visual,icon_map,icon_pixel); 3       if (resource_info->map_type == (char *) NULL) B         XFreeStandardColormap(display,visual_info,map_info,pixel);       /*         Free X resources.        */"       if (resource_info->backdrop)6         XFreeCursor(display,windows->backdrop.cursor);=       if (windows->widget.highlight_stipple != (Pixmap) NULL) ?         XFreePixmap(display,windows->widget.highlight_stipple); =       if (windows->widget.highlight_stipple != (Pixmap) NULL) <         XFreePixmap(display,windows->widget.shadow_stipple);-       XFreeGC(display,pixel->widget_context); 0       XFreeGC(display,pixel->highlight_context);/       XFreeGC(display,pixel->annotate_context); 4       XFreeGC(display,icon_pixel->annotate_context);#       XFreeFont(display,font_info); "       XFree((void *) class_hints);$       XFree((void *) manager_hints);"       XFree((void *) icon_visual);"       XFree((void *) visual_info);       XFree((void *) icon_map);        XFree((void *) map_info); &       FreeMemory(windows->popup.name);'       FreeMemory(windows->widget.name); +       FreeMemory(windows->image.icon_name); &       FreeMemory(windows->image.name);*       FreeMemory(windows->icon_resources);&       FreeMemory(windows->icon_pixel);&       FreeMemory(windows->pixel_info);%       (void) signal(SIGSEGV,SIG_DFL); $       (void) signal(SIGINT,SIG_DFL);,       (void) XSetWindows((XWindows *) NULL);     }    XSync(display,False);    /*6     Restore our progress monitor and warning handlers.   */,   (void) SetMonitorHandler(monitor_handler);,   (void) SetWarningHandler(warning_handler);   /*     Change to home directory.    */3   (void) getcwd(working_directory,MaxTextExtent-1); .   (void) chdir(resource_info->home_directory);   return(loaded_image);  }  #endif