 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %           AAA   N   N  N   N   OOO   TTTTT   AAA   TTTTT  EEEEE             % O %          A   A  NN  N  NN  N  O   O    T    A   A    T    E                 % O %          AAAAA  N N N  N N N  O   O    T    AAAAA    T    EEE               % O %          A   A  N  NN  N  NN  O   O    T    A   A    T    E                 % O %          A   A  N   N  N   N   OOO     T    A   A    T    EEEEE             % O %                                                                             % O %                                                                             % O %                  ImageMagick Image Annotation Methods                       % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Constant declarations. */
 const char4   *Alphabet = "`-=[]\\;',./~!@#$%^&*()_+{}|:\"<>?" \;     "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n n o t a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method AnnotateImage annotates an image with text.  Optionally the K %  annotation can include the image filename, type, width, height, or scene 1 %  number by embedding special format characters.  % - %  The format of the AnnotateImage method is:  % I %      void AnnotateImage(Image *image,const AnnotateInfo *annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % > %    o annotate_info: The address of a AnnotateInfo structure. %  %  */I Export void AnnotateImage(Image *image,const AnnotateInfo *annotate_info)  {    AnnotateInfo     *local_info;     char     label[MaxTextExtent],      size[MaxTextExtent],
     *text,     **textlist;      Image      *box_image,      *annotate_image;     int      j,     x,     y;     register int     i;     unsigned int     height,      length,      number_lines, 
     width;     /*(     Ensure the annotation info is valid.   */"   assert(image != (Image *) NULL);1   assert(annotate_info != (AnnotateInfo *) NULL); +   if (annotate_info->text == (char *) NULL)      return; #   if (*annotate_info->text == '\0')      return;    /*7     Translate any embedded format characters (e.g. %f).    */H   local_info=CloneAnnotateInfo(annotate_info->image_info,annotate_info);@   text=TranslateText((ImageInfo *) NULL,image,local_info->text);   if (text == (char *) NULL)     { &       DestroyAnnotateInfo(local_info);
       return;      }    textlist=StringToList(text);   FreeMemory(text); !   if (textlist == (char **) NULL)      { &       DestroyAnnotateInfo(local_info);
       return;      }    length=Extent(textlist[0]); .   for (i=1; textlist[i] != (char *) NULL; i++)+     if (Extent(textlist[i]) > (int) length) !       length=Extent(textlist[i]);    number_lines=i; 5   text=(char *) AllocateMemory(length+MaxTextExtent);    if (text == (char *) NULL)     { D       MagickWarning(ResourceLimitWarning,"Unable to annotate image",$         "Memory allocation failed");&       DestroyAnnotateInfo(local_info);
       return;      }    width=image->columns;    height=image->rows;    x=0;   y=0;,   if (local_info->geometry != (char *) NULL)     { 	       int          flags;         /*+         User specified annotation geometry.        */E       flags=ParseGeometry(local_info->geometry,&x,&y,&width,&height); #       if ((flags & XNegative) != 0)          x+=image->columns;$       if ((flags & WidthValue) == 0)         width-=x; #       if ((flags & YNegative) != 0)          y+=image->rows; %       if ((flags & HeightValue) == 0)          height-=y;     }    /*     Annotate image.    */.   for (i=0; textlist[i] != (char *) NULL; i++)   {      if (*textlist[i] == '\0')        {           FreeMemory(textlist[i]);         continue;        }      /*       Convert text to image.     */.     FormatString(label,"%.1024s",textlist[i]);     FreeMemory(textlist[i]);"     for (j=strlen(label)-1; ; j--)     { <       (void) strcpy(local_info->image_info->filename,label);<       annotate_image=ReadLABELImage(local_info->image_info);+       if (annotate_image == (Image *) NULL) 	         { H           MagickWarning(ResourceLimitWarning,"Unable to annotate image",             (char *) NULL); 4           for ( ; textlist[i] != (char *) NULL; i++)$             FreeMemory(textlist[i]);           FreeMemory(textlist);            break;	         } D       if ((annotate_image->columns <= width) || (strlen(label) < 4))         break;#       DestroyImage(annotate_image); #       (void) strcpy(label+j,"...");      } 5     if (local_info->image_info->box != (char *) NULL)        { 
         /*,           Surround text with a bounding box.
         */C         FormatString(local_info->image_info->filename,"xc:%.1024s", '           local_info->image_info->box); P         FormatString(size,"%ux%u",annotate_image->columns,annotate_image->rows);?         (void) CloneString(&local_info->image_info->size,size); 4         box_image=ReadImage(local_info->image_info);(         if (box_image != (Image *) NULL)           { >             CompositeImage(image,ReplaceCompositeOp,box_image,9               local_info->bounds.x,local_info->bounds.y); $             DestroyImage(box_image);           }        } &     if (annotate_info->degrees != 0.0)       { 
         Image            *rotated_image;   
         /*           Rotate text.
         */I         rotated_image=RotateImage(annotate_image,annotate_info->degrees); ,         if (rotated_image != (Image *) NULL)           { )             DestroyImage(annotate_image); )             annotate_image=rotated_image;            } 7         local_info->bounds.height=annotate_image->rows;        }      /*$       Composite text onto the image.     */      switch (local_info->gravity)     {        case NorthWestGravity:       {          local_info->bounds.x=x; ;         local_info->bounds.y=i*local_info->bounds.height+y;          break;       }        case NorthGravity:       { E         local_info->bounds.x=(width/2)-(annotate_image->columns/2)+x; ;         local_info->bounds.y=i*local_info->bounds.height+y;          break;       }        case NorthEastGravity:       { =         local_info->bounds.x=width-annotate_image->columns+x; ;         local_info->bounds.y=i*local_info->bounds.height+y;          break;       }        case WestGravity:        {          local_info->bounds.x=x; 6         local_info->bounds.y=(height/2)-(number_lines*E           local_info->bounds.height/2)+i*local_info->bounds.height+y;          break;       }        case ForgetGravity:        case StaticGravity:        case CenterGravity:        default:       { E         local_info->bounds.x=(width/2)-(annotate_image->columns/2)+x; 6         local_info->bounds.y=(height/2)-(number_lines*E           local_info->bounds.height/2)+i*local_info->bounds.height+y;          break;       }        case EastGravity:        { =         local_info->bounds.x=width-annotate_image->columns-x; 6         local_info->bounds.y=(height/2)-(number_lines*E           local_info->bounds.height/2)+i*local_info->bounds.height-y;          break;       }        case SouthWestGravity:       {          local_info->bounds.x=x; F         local_info->bounds.y=height-(i+1)*local_info->bounds.height-y;         break;       }        case SouthGravity:       { E         local_info->bounds.x=(width/2)-(annotate_image->columns/2)-x; F         local_info->bounds.y=height-(i+1)*local_info->bounds.height-y;         break;       }        case SouthEastGravity:       { =         local_info->bounds.x=width-annotate_image->columns-x; F         local_info->bounds.y=height-(i+1)*local_info->bounds.height-y;         break;       }      } <     CompositeImage(image,AnnotateCompositeOp,annotate_image,1       local_info->bounds.x,local_info->bounds.y); !     DestroyImage(annotate_image);    } "   DestroyAnnotateInfo(local_info);   FreeMemory(text); ,   for ( ; textlist[i] != (char *) NULL; i++)     FreeMemory(textlist[i]);   FreeMemory(textlist);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o n e A n n o t a t e I n f o                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % O %  Method CloneAnnotateInfo makes a duplicate of the given annotate info, or if $ %  annotate info is NULL, a new one. % 1 %  The format of the CloneAnnotateInfo method is:  % C %      AnnotateInfo *CloneAnnotateInfo(const ImageInfo *image_info, + %        const AnnotateInfo *annotate_info)  % + %  A description of each parameter follows:  % M %    o cloned_info: Method CloneAnnotateInfo returns a duplicate of the given < %      annotate info, or if annotate info is NULL a new one. % , %    o image_info: a structure of type info. % / %    o annotate_info: a structure of type info.  %  %  */C Export AnnotateInfo *CloneAnnotateInfo(const ImageInfo *image_info, $   const AnnotateInfo *annotate_info) {    AnnotateInfo     *cloned_info;   D   cloned_info=(AnnotateInfo *) AllocateMemory(sizeof(AnnotateInfo));+   if (cloned_info == (AnnotateInfo *) NULL) E     MagickError(ResourceLimitWarning,"Unable to clone annotate info", "       "Memory allocation failed");-   if (annotate_info == (AnnotateInfo *) NULL)      { .       GetAnnotateInfo(image_info,cloned_info);       return(cloned_info);     }     *cloned_info=(*annotate_info);6   if (annotate_info->image_info != (ImageInfo *) NULL)F     cloned_info->image_info=CloneImageInfo(annotate_info->image_info);/   if (annotate_info->geometry != (char *) NULL) B     cloned_info->geometry=AllocateString(annotate_info->geometry);+   if (annotate_info->text != (char *) NULL) :     cloned_info->text=AllocateString(annotate_info->text);0   if (annotate_info->primitive != (char *) NULL)D     cloned_info->primitive=AllocateString(annotate_info->primitive);0   if (annotate_info->font_name != (char *) NULL)D     cloned_info->font_name=AllocateString(annotate_info->font_name);,   if (annotate_info->tile != (Image *) NULL)5     cloned_info->tile=CloneImage(annotate_info->tile, D       annotate_info->tile->columns,annotate_info->tile->rows,False);   return(cloned_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y A n n o t a t e I n f o                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method DestroyAnnotateInfo deallocates memory associated with an  %  AnnotateInfo structure. % 3 %  The format of the DestroyAnnotateInfo method is:  % < %      void DestroyAnnotateInfo(AnnotateInfo *annotate_info) % + %  A description of each parameter follows:  % G %    o annotate_info: Specifies a pointer to an AnnotateInfo structure.  %  %  */< Export void DestroyAnnotateInfo(AnnotateInfo *annotate_info) { 1   assert(annotate_info != (AnnotateInfo *) NULL); .   DestroyImageInfo(annotate_info->image_info);/   if (annotate_info->geometry != (char *) NULL) (     FreeMemory(annotate_info->geometry);(   annotate_info->geometry=(char *) NULL;+   if (annotate_info->text != (char *) NULL) $     FreeMemory(annotate_info->text);$   annotate_info->text=(char *) NULL;0   if (annotate_info->primitive != (char *) NULL))     FreeMemory(annotate_info->primitive); )   annotate_info->primitive=(char *) NULL; 0   if (annotate_info->font_name != (char *) NULL))     FreeMemory(annotate_info->font_name); )   annotate_info->font_name=(char *) NULL; ,   if (annotate_info->tile != (Image *) NULL)&     DestroyImage(annotate_info->tile);%   annotate_info->tile=(Image *) NULL;    FreeMemory(annotate_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t A n n o t a t e I n f o                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % A %  Method GetAnnotateInfo initializes the AnnotateInfo structure.  % / %  The format of the GetAnnotateInfo method is:  % 8 %      void GetAnnotateInfo(const ImageInfo *image_info,% %        AnnotateInfo *annotate_info)  % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % F %    o annotate_info: Specifies a pointer to a AnnotateInfo structure. %  %  */8 Export void GetAnnotateInfo(const ImageInfo *image_info,   AnnotateInfo *annotate_info) {    Image      *annotate_image;  +   assert(image_info != (ImageInfo *) NULL); 1   assert(annotate_info != (AnnotateInfo *) NULL); 7   annotate_info->image_info=CloneImageInfo(image_info); *   annotate_info->gravity=NorthWestGravity;(   annotate_info->geometry=(char *) NULL;$   annotate_info->text=(char *) NULL;)   annotate_info->primitive=(char *) NULL; )   annotate_info->font_name=(char *) NULL;    annotate_info->degrees=0.0; I   annotate_info->bounds.width=ceil(annotate_info->image_info->pointsize); J   annotate_info->bounds.height=ceil(annotate_info->image_info->pointsize);   annotate_info->bounds.x=0;   annotate_info->bounds.y=0;   /*
     Get tile.    */6   if (annotate_info->image_info->pen == (char *) NULL)B     (void) strcpy(annotate_info->image_info->filename,"xc:black");   else/     if (*annotate_info->image_info->pen == '@') 8       (void) strcpy(annotate_info->image_info->filename,*         annotate_info->image_info->pen+1);     elseK       (void) FormatString(annotate_info->image_info->filename,"xc:%.1024s", (         annotate_info->image_info->pen);;   annotate_info->tile=ReadImage(annotate_info->image_info); 7   if (annotate_info->image_info->font == (char *) NULL)      return;    /*     Get font bounds.   */G   FormatString(annotate_info->image_info->filename,"%.1024s",Alphabet); ;   annotate_image=ReadLABELImage(annotate_info->image_info); '   if (annotate_image == (Image *) NULL)      return; -   if (annotate_image->label != (char *) NULL) C     annotate_info->font_name=AllocateString(annotate_image->label);    annotate_info->bounds.width=G     (annotate_image->columns+(strlen(Alphabet) >> 1))/strlen(Alphabet); 4   annotate_info->bounds.height=annotate_image->rows;   DestroyImage(annotate_image);  } 