 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %          DDDD   EEEEE   CCCC   OOO   RRRR    AAA   TTTTT  EEEEE             % O %          D   D  E      C      O   O  R   R  A   A    T    E                 % O %          D   D  EEE    C      O   O  RRRR   AAAAA    T    EEE               % O %          D   D  E      C      O   O  R R    A   A    T    E                 % O %          DDDD   EEEEE   CCCC   OOO   R  R   A   A    T    EEEEE             % O %                                                                             % O %                                                                             % O %                   ImageMagick Image Decoration Methods                      % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   B o r d e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method BorderImage takes an image and puts a border around it of a I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % + %  The format of the BorderImage method is:  % N %      Image *BorderImage(const Image *image,const RectangleInfo *border_info) % + %  A description of each parameter follows:  % K %    o bordered_image: Method BorderImage returns a pointer to the bordered F %      image.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % N %    o border_info: Specifies a pointer to a structure of type Rectangle which! %      defines the border region.  %  */H Export Image *BorderImage(Image *image,const RectangleInfo *border_info) { 
   PixelPacket      matte_color;     Image      *bordered_image;     FrameInfo      frame_info;   "   assert(image != (Image *) NULL);0   assert(border_info != (RectangleInfo *) NULL);<   frame_info.width=image->columns+(border_info->width << 1);;   frame_info.height=image->rows+(border_info->height << 1); "   frame_info.x=border_info->width;#   frame_info.y=border_info->height;    frame_info.inner_bevel=0;    frame_info.outer_bevel=0; !   matte_color=image->matte_color; )   image->matte_color=image->border_color; /   bordered_image=FrameImage(image,&frame_info); *   bordered_image->matte_color=matte_color;!   image->matte_color=matte_color;    return(bordered_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   F r a m e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method FrameImage takes an image and puts a frame around it of a I %  particular color.  It allocates the memory necessary for the new Image 4 %  structure and returns a pointer to the new image. % * %  The format of the FrameImage method is: % B %      Image *FrameImage(Image *image,const FrameInfo *frame_info) % + %  A description of each parameter follows:  % E %    o frame_image: Method FrameImage returns a pointer to the framed F %      image.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % E %    o frame_info: Specifies a pointer to a FrameInfo structure which ! %      defines the framed region.  %  %  */B Export Image *FrameImage(Image *image,const FrameInfo *frame_info) { 6 #define FrameImageText  "  Adding frame to image...  "     Image      *frame_image;      int      height, 
     width,     y;     register int     x;     register PixelPacket     *p,      *q;   
   PixelPacket      accentuate,      highlight,
     matte,     shadow,      trough;      unsigned int     bevel_width;     /*     Check frame geometry.    */"   assert(image != (Image *) NULL);+   assert(frame_info != (FrameInfo *) NULL); E   if ((frame_info->outer_bevel < 0) || (frame_info->inner_bevel < 0))      { :       MagickWarning(OptionWarning,"Unable to frame image",#         "bevel width is negative");        return((Image *) NULL);      } >   bevel_width=frame_info->outer_bevel+frame_info->inner_bevel;:   width=(int) frame_info->width-frame_info->x-bevel_width;<   height=(int) frame_info->height-frame_info->y-bevel_width;E   if ((width < (int) image->columns) || (height < (int) image->rows))      { :       MagickWarning(OptionWarning,"Unable to frame image",)         "frame is less than image size");        return((Image *) NULL);      }    /*'     Initialize framed image attributes.    */J   frame_image=CloneImage(image,frame_info->width,frame_info->height,True);$   if (frame_image == (Image *) NULL)     { A       MagickWarning(ResourceLimitWarning,"Unable to frame image", $         "Memory allocation failed");       return((Image *) NULL);      } !   frame_image->class=DirectClass;    /*      Initialize 3D effects color.   */   matte=image->matte_color; +   accentuate.red=(Quantum) ((unsigned long) N     (matte.red*AccentuateModulate+(MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB);-   accentuate.green=(Quantum) ((unsigned long) P     (matte.green*AccentuateModulate+(MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB);,   accentuate.blue=(Quantum) ((unsigned long)O     (matte.blue*AccentuateModulate+(MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB); ?   accentuate.opacity=(Quantum) ((unsigned long) (matte.opacity* C     AccentuateModulate+(MaxRGB-AccentuateModulate)*MaxRGB)/MaxRGB); *   highlight.red=(Quantum) ((unsigned long)L     (matte.red*HighlightModulate+(MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB);,   highlight.green=(Quantum) ((unsigned long)N     (matte.green*HighlightModulate+(MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB);+   highlight.blue=(Quantum) ((unsigned long) M     (matte.blue*HighlightModulate+(MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB); .   highlight.opacity=(Quantum) ((unsigned long)P     (matte.opacity*HighlightModulate+(MaxRGB-HighlightModulate)*MaxRGB)/MaxRGB);K   shadow.red=(Quantum) ((unsigned long) (matte.red*ShadowModulate)/MaxRGB); O   shadow.green=(Quantum) ((unsigned long) (matte.green*ShadowModulate)/MaxRGB); M   shadow.blue=(Quantum) ((unsigned long) (matte.blue*ShadowModulate)/MaxRGB);    shadow.opacity=(Quantum)<     ((unsigned long) (matte.opacity*ShadowModulate)/MaxRGB);K   trough.red=(Quantum) ((unsigned long) (matte.red*TroughModulate)/MaxRGB); O   trough.green=(Quantum) ((unsigned long) (matte.green*TroughModulate)/MaxRGB); M   trough.blue=(Quantum) ((unsigned long) (matte.blue*TroughModulate)/MaxRGB);    trough.opacity=(Quantum)<     ((unsigned long) (matte.opacity*TroughModulate)/MaxRGB);   /*"     Draw top of ornamental border.   */=   height=frame_info->outer_bevel+(frame_info->y-bevel_width)+      frame_info->inner_bevel;F   q=SetPixelCache(frame_image,0,0,frame_image->columns,Max(height,1));    if (q == (PixelPacket *) NULL)     {         DestroyImage(frame_image);       return((Image *) NULL);      } -   for (y=0; y < frame_info->outer_bevel; y++)    { 6     for (x=0; x < (int) (frame_image->columns-y); x++)       if (x < y)         *q++=highlight; 
       else         *q++=accentuate;0     for ( ; x < (int) frame_image->columns; x++)       *q++=shadow;   } 7   for (y=0; y < (int) (frame_info->y-bevel_width); y++)    { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; N     for (x=0; x < (int) (frame_image->columns-2*frame_info->outer_bevel); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } -   for (y=0; y < frame_info->inner_bevel; y++)    { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 9     for (x=0; x < (int) (frame_info->x-bevel_width); x++)        *q++=matte; O     for (x=0; x < (int) (image->columns+(frame_info->inner_bevel << 1)-y); x++)        if (x < y)         *q++=shadow;
       else         *q++=trough;K     for ( ; x < (int) (image->columns+(frame_info->inner_bevel << 1)); x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } #   if (!SyncPixelCache(frame_image))      {         DestroyImage(frame_image);       return((Image *) NULL);      }    /*$     Draw sides of ornamental border.   */'   for (y=0; y < (int) image->rows; y++)    {      /*,       Initialize scanline with border color.     */0     p=GetPixelCache(image,0,y,image->columns,1);J     q=SetPixelCache(frame_image,0,frame_info->y+y,frame_image->columns,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;/     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 9     for (x=0; x < (int) (frame_info->x-bevel_width); x++)        *q++=matte; /     for (x=0; x < frame_info->inner_bevel; x++)        *q++=shadow;     /*       Transfer scanline.     */:     (void) memcpy(q,p,image->columns*sizeof(PixelPacket));     q+=image->columns;/     for (x=0; x < frame_info->inner_bevel; x++)        *q++=highlight; E     width=frame_info->width-frame_info->x-image->columns-bevel_width;      for (x=0; x < width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;%     if (!SyncPixelCache(frame_image))        break;#     if (QuantumTick(y,image->rows)) 4       ProgressMonitor(FrameImageText,y,image->rows);   }    /*%     Draw bottom of ornamental border.    */N   height=frame_info->inner_bevel+frame_info->height-frame_info->y-image->rows-(     bevel_width+frame_info->outer_bevel;@   q=SetPixelCache(frame_image,0,frame_image->rows-Max(height,1),(     frame_image->columns,Max(height,1));    if (q == (PixelPacket *) NULL)     {         DestroyImage(frame_image);       return((Image *) NULL);      } 0   for (y=frame_info->inner_bevel-1; y >= 0; y--)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; 9     for (x=0; x < (int) (frame_info->x-bevel_width); x++)        *q++=matte;      for (x=0; x < y; x++)        *q++=shadow;K     for ( ; x < (int) (image->columns+(frame_info->inner_bevel << 1)); x++) G       if (x >= (int) (image->columns+(frame_info->inner_bevel << 1)-y))          *q++=highlight; 
       else         *q++=accentuate;E     width=frame_info->width-frame_info->x-image->columns-bevel_width; #     for (x=0; x < (int) width; x++)        *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } B   height=frame_info->height-frame_info->y-image->rows-bevel_width;   for (y=0; y < height; y++)   { /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=highlight; N     for (x=0; x < (int) (frame_image->columns-2*frame_info->outer_bevel); x++)       *q++=matte; /     for (x=0; x < frame_info->outer_bevel; x++)        *q++=shadow;   } 0   for (y=frame_info->outer_bevel-1; y >= 0; y--)   {      for (x=0; x < y; x++)        *q++=highlight; 0     for ( ; x < (int) frame_image->columns; x++).       if (x >= (int) (frame_image->columns-y))         *q++=shadow;
       else         *q++=trough;   } #   if (!SyncPixelCache(frame_image))      {         DestroyImage(frame_image);       return((Image *) NULL);      }    return(frame_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R a i s e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method RaiseImage lightens and darkens the edges of an image to give a  %  3-D raised or lower effect. % * %  The format of the RaiseImage method is: % D %      void RaiseImage(Image *image,const RectangleInfo *raise_info, %        const int raised) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % H %    o raise_info: Specifies a pointer to a XRectangle which defines the %      raised region.  % L %    o raised: A value other than zero causes the image to have a 3-D raised1 %      effect, otherwise it has a lowered effect.  %  %  */D Export void RaiseImage(Image *image,const RectangleInfo *raise_info,   const int raised)  { & #define AccentuateFactor  UpScale(135)% #define HighlightFactor  UpScale(190) " #define ShadowFactor  UpScale(190). #define RaiseImageText  "  Raising image...  "" #define TroughFactor  UpScale(135)     int      y;  	   Quantum      foreground,      background;      register int     i,     x;     register PixelPacket     *q;      unsigned int     height;   "   assert(image != (Image *) NULL);/   assert(raise_info != (RectangleInfo *) NULL); 5   if ((image->columns <= (raise_info->width << 1)) || 1       (image->rows <= (raise_info->height << 1)))      { :       MagickWarning(OptionWarning,"Unable to raise image",.         "image size must exceed bevel width");
       return;      }    foreground=MaxRGB;   background=0;    if (!raised)     {        foreground=0;        background=MaxRGB;     }    i=0;   image->class=DirectClass; .   for (y=0; y < (int) raise_info->height; y++)   { 2     q=GetPixelCache(image,0,i++,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;     for (x=0; x < y; x++)      { '       q->red=(Quantum) ((unsigned long) M         (q->red*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB); )       q->green=(Quantum) ((unsigned long) O         (q->green*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB); (       q->blue=(Quantum) ((unsigned long)N         (q->blue*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB);
       q++;     } 7     for (x=0; x < (int) (image->columns-(y << 1)); x++)      { '       q->red=(Quantum) ((unsigned long) O         (q->red*AccentuateFactor+foreground*(MaxRGB-AccentuateFactor))/MaxRGB); 4       q->green=(Quantum) ((unsigned long) (q->green*G         AccentuateFactor+foreground*(MaxRGB-AccentuateFactor))/MaxRGB); (       q->blue=(Quantum) ((unsigned long)P         (q->blue*AccentuateFactor+foreground*(MaxRGB-AccentuateFactor))/MaxRGB);
       q++;     }      for (x=0; x < y; x++)      { '       q->red=(Quantum) ((unsigned long) G         (q->red*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB); )       q->green=(Quantum) ((unsigned long) I         (q->green*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB); (       q->blue=(Quantum) ((unsigned long)H         (q->blue*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB);
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(i,image->rows)) 4       ProgressMonitor(RaiseImageText,i,image->rows);   } /   height=image->rows-(raise_info->height << 1); "   for (y=0; y < (int) height; y++)   { 2     q=GetPixelCache(image,0,i++,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;/     for (x=0; x < (int) raise_info->width; x++)      { '       q->red=(Quantum) ((unsigned long) F 	(q->red*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB);)       q->green=(Quantum) ((unsigned long) H 	(q->green*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB);(       q->blue=(Quantum) ((unsigned long)G 	(q->blue*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB); 
       q++;     } G     for (x=0; x < (int) (image->columns-(raise_info->width << 1)); x++) 
       q++;/     for (x=0; x < (int) raise_info->width; x++)      { '       q->red=(Quantum) ((unsigned long) G         (q->red*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB); )       q->green=(Quantum) ((unsigned long) I         (q->green*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB); (       q->blue=(Quantum) ((unsigned long)H         (q->blue*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB);
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(i,image->rows)) 4       ProgressMonitor(RaiseImageText,i,image->rows);   } .   for (y=0; y < (int) raise_info->height; y++)   { 2     q=GetPixelCache(image,0,i++,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;3     for (x=0; x < (int) (raise_info->width-y); x++)      { '       q->red=(Quantum) ((unsigned long) F 	(q->red*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB);)       q->green=(Quantum) ((unsigned long) H 	(q->green*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB);(       q->blue=(Quantum) ((unsigned long)G 	(q->blue*HighlightFactor+foreground*(MaxRGB-HighlightFactor))/MaxRGB); 
       q++;     } K     for (x=0; x < (int) (image->columns-((raise_info->width-y) << 1)); x++)      { '       q->red=(Quantum) ((unsigned long) G         (q->red*TroughFactor+background*(MaxRGB-TroughFactor))/MaxRGB); )       q->green=(Quantum) ((unsigned long) I         (q->green*TroughFactor+background*(MaxRGB-TroughFactor))/MaxRGB); (       q->blue=(Quantum) ((unsigned long)H         (q->blue*TroughFactor+background*(MaxRGB-TroughFactor))/MaxRGB);
       q++;     } 3     for (x=0; x < (int) (raise_info->width-y); x++)      { '       q->red=(Quantum) ((unsigned long) G         (q->red*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB); )       q->green=(Quantum) ((unsigned long) I         (q->green*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB); (       q->blue=(Quantum) ((unsigned long)H         (q->blue*ShadowFactor+background*(MaxRGB-ShadowFactor))/MaxRGB);
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(i,image->rows)) 4       ProgressMonitor(RaiseImageText,i,image->rows);   } 	   return;  } 