 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        DDDD   RRRR    AAA   W   W                           % O %                        D   D  R   R  A   A  W   W                           % O %                        D   D  RRRR   AAAAA  W   W                           % O %                        D   D  R R    A   A  W W W                           % O %                        DDDD   R  R   A   A   W W                            % O %                                                                             % O %                                                                             % O %                     ImageMagick Image Drawing Methods                       % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Define declarations. */( #define MatteMatch(color,target,delta) \K   (ColorMatch(color,target,delta) && ((color).opacity == (target).opacity))  #define MaxStacksize  (1 << 15) # #define Push(up,left,right,delta) \ F   if ((s < (segment_stack+MaxStacksize)) && (((up)+(delta)) >= 0) && \-       (((up)+(delta)) < (int) image->rows)) \      { \        s->y1=(up); \        s->x1=(left); \        s->x2=(right); \       s->y2=(delta); \       s++; \     }    /*   Typedef declaractions. */ typedef struct _PrimitiveInfo  {    PrimitiveType      primitive;     unsigned int     coordinates;     double     x,     y;  
   PaintMethod      method;      char
     *text; } PrimitiveInfo;   /*   Forward declarations */ static unsigned short I   InsidePrimitive(PrimitiveInfo *,const AnnotateInfo *,const PointInfo *, 
     Image *);    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o l o r F l o o d f i l l I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method ColorFloodfillImage floodfills the designated area with a color.F %  The floodfill algorithm is strongly based on a similar algorithm in$ %  "Graphics Gems" by Paul Heckbert. % 3 %  The format of the ColorFloodfillImage method is:  % G %      void ColorFloodfillImage(Image *image,const PixelPacket *target, ; %        Image *tile,const int x_offset,const int y_offset, " %        const PaintMethod method) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % L %    o target: A PixelPacket structure.  This is the RGB value of the target
 %      color.  % I %    o tile: An image representing the image to tile onto the floodplane.  % K %    o x,y: Unsigned integers representing the current location of the pen.  % I %    o method: drawing method of type PrimitiveType: floodfill or fill to  %      border. %  %  */G Export void ColorFloodfillImage(Image *image,const PixelPacket *target, M   Image *tile,const int x_offset,const int y_offset,const PaintMethod method)  { 
   PixelPacket 
     color;     int      offset, 	     skip, 
     start,     x1,      x2,      y;     register int     i,     x;     register PixelPacket     *p,      *q;      register SegmentInfo     *s;   
   SegmentInfo      *segment_stack;      /*     Check boundary conditions.   */"   assert(image != (Image *) NULL);!   assert(tile != (Image *) NULL); ;   if ((x_offset < 0) || (x_offset >= (int) image->columns))      return; 8   if ((y_offset < 0) || (y_offset >= (int) image->rows))     return;    /*     Set floodfill color.   */,   (void) QueryColorDatabase("black",&color);"   if (GetPixelCache(tile,0,0,1,1))     color=(*tile->pixels);,   if (ColorMatch(color,*target,image->fuzz))     return;    segment_stack=(SegmentInfo *) 5     AllocateMemory(MaxStacksize*sizeof(SegmentInfo)); ,   if (segment_stack == (SegmentInfo *) NULL)     { E       MagickWarning(ResourceLimitWarning,"Unable to floodfill image", $         "Memory allocation failed");
       return;      }    /*4     Track "hot" pixels with the image index packets.   */   image->class=PseudoClass; '   for (y=0; y < (int) image->rows; y++)    { 3     if (!GetPixelCache(image,0,y,image->columns,1))        break;,     for (x=0; x < (int) image->columns; x++)       image->indexes[x]=False;     if (!SyncPixelCache(image))        break;   }    /*"     Push initial segment on stack.   */
   x=x_offset; 
   y=y_offset; 
   start=0;   s=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (s > segment_stack)    {      /*       Pop segment off stack.     */     s--;     x1=(int) s->x1;      x2=(int) s->x2;      offset=(int) s->y2;      y=(int) s->y1+offset;      /*!       Recolor neighboring pixels.      */&     q=GetPixelCache(image,0,y,x1+1,1);"     if (q == (PixelPacket *) NULL)       break;
     q+=x1;     for (x=x1; x >= 0 ; x--)     { $       if (method == FloodfillMethod)	         { 2           if (!ColorMatch(*q,*target,image->fuzz))             break;	         } 
       else1         if (ColorMatch(*q,*target,image->fuzz) || -             ColorMatch(*q,color,image->fuzz))            break;       image->indexes[x]=True;        *q=color; 
       q--;     }      if (!SyncPixelCache(image))        break;     skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         { !           if (x < image->columns) 
             { <               q=GetPixelCache(image,x,y,image->columns-x,1);,               if (q == (PixelPacket *) NULL)                 break;6               for (i=0; x < (int) image->columns; x++)               { .                 if (method == FloodfillMethod)                   { <                     if (!ColorMatch(*q,*target,image->fuzz))                       break;                   }                  else;                   if (ColorMatch(*q,*target,image->fuzz) || 7                       ColorMatch(*q,color,image->fuzz))                      break;)                 image->indexes[i++]=True;                  *q=color;                  q++;               } )               if (!SyncPixelCache(image))                  break;
             } #           Push(y,start,x-1,offset);            if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False; 
       x++;       if (x <= x2)	         { .           q=GetPixelCache(image,x,y,x2-x+1,1);(           if (q == (PixelPacket *) NULL)             break;           for ( ; x <= x2; x++)            { *             if (method == FloodfillMethod)               { 7                 if (ColorMatch(*q,*target,image->fuzz))                    break;               }              else8               if (!ColorMatch(*q,*target,image->fuzz) &&4                   !ColorMatch(*q,color,image->fuzz))                 break;             q++;           } 	         }        start=x;     } while (x <= x2);   }    /*     Tile image onto floodplane.    */'   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        if (image->indexes[x])	         { E           p=GetPixelCache(tile,x % tile->columns,y % tile->rows,1,1); (           if (p == (PixelPacket *) NULL)             break;           if (!tile->matte)              *q=(*p);           else
             { C               q->red=(Quantum) ((unsigned long) (p->red*p->opacity+ 4                 q->red*(Opaque-p->opacity))/Opaque);G               q->green=(Quantum) ((unsigned long) (p->green*p->opacity+ 6                 q->green*(Opaque-p->opacity))/Opaque);E               q->blue=(Quantum) ((unsigned long) (p->blue*p->opacity+ 5                 q->blue*(Opaque-p->opacity))/Opaque); @               q->opacity=(Quantum) ((unsigned long) (p->opacity*C                 p->opacity+q->opacity*(Opaque-p->opacity))/Opaque); 
             } 	         } 
       q++;     }      if (!SyncPixelCache(image))        break;   }    image->class=DirectClass;    FreeMemory(segment_stack); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D r a w I m a g e                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method DrawImage draws a primitive (line, rectangle, ellipse) on the 	 %  image.  % ) %  The format of the DrawImage method is:  % E %      void DrawImage(Image *image,const AnnotateInfo *annotate_info)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % : %    o annotate_info: The address of a DrawInfo structure. %  %  */E Export void DrawImage(Image *image,const AnnotateInfo *annotate_info)  { 0 #define DrawImageText  "  Drawing on image...  "     AnnotateInfo     *local_info;     char     keyword[MaxTextExtent],      *primitive;      double     mid;     int      j,     n,     y;     PointInfo 
     point,     target;      PrimitiveInfo      *primitive_info;     PrimitiveType      primitive_type;   
   SegmentInfo      bounds;      register char      *p;      register int     i,     x;     register PixelPacket     *q;      unsigned int     indirection,     length,      number_coordinates;      unsigned short     opacity;     /*(     Ensure the annotation info is valid.   */"   assert(image != (Image *) NULL);1   assert(annotate_info != (AnnotateInfo *) NULL); 4   assert(annotate_info->primitive != (char *) NULL);0   assert(annotate_info->tile != (Image *) NULL);(   if (*annotate_info->primitive == '\0')     return; H   local_info=CloneAnnotateInfo(annotate_info->image_info,annotate_info);"   primitive=local_info->primitive;"   indirection=(*primitive == '@');   if (indirection)     { 
       FILE         *file;  	       int 
         c;         register char          *q;          /*         Read text from a file.       */+       file=(FILE *) fopen(primitive+1,"r");         if (file == (FILE *) NULL)	         { H           MagickWarning(FileOpenWarning,"Unable to read primitive file",             primitive+1); *           DestroyAnnotateInfo(local_info);           return; 	         }        length=MaxTextExtent; 0       primitive=(char *) AllocateMemory(length);       q=primitive;(       while (primitive != (char *) NULL)       {          c=fgetc(file);         if (c == '#')            {              /*               Eat comments.              */8             for (c=fgetc(file); c != EOF; c=fgetc(file))-               if ((c == '\r') || (c == '\n'))                  break;             continue;            }          if (c == EOF)            break;,         if ((q-primitive+1) >= (int) length)           {              *q='\0';             length<<=1; B             primitive=(char *) ReallocateMemory(primitive,length);+             if (primitive == (char *) NULL)                break;*             q=primitive+Extent(primitive);           }          *q++=(unsigned char) c;        }        (void) fclose(file);%       if (primitive == (char *) NULL) 	         { D           MagickWarning(ResourceLimitWarning,"Unable to draw image",(             "Memory allocation failed");*           DestroyAnnotateInfo(local_info);           return; 	         }        *q='\0';     }    /*#     Allocate primitive info memory.    */   number_coordinates=2048;"   primitive_info=(PrimitiveInfo *)=     AllocateMemory(number_coordinates*sizeof(PrimitiveInfo)); K   local_info->geometry=(char *) AllocateMemory(MaxTextExtent*sizeof(char)); K   local_info->text=(char *) AllocateMemory(Extent(primitive)*sizeof(char)); 3   if ((primitive_info == (PrimitiveInfo *) NULL) || 0       (local_info->geometry == (char *) NULL) ||*       (local_info->text == (char *) NULL))     { @       MagickWarning(ResourceLimitWarning,"Unable to draw image",$         "Memory allocation failed");       if (indirection)         FreeMemory(primitive);&       DestroyAnnotateInfo(local_info);
       return;      }    /*#     Parse the primitive attributes.    */$   primitive_type=UndefinedPrimitive;   p=primitive;   bounds.x1=image->columns-1;    bounds.y1=image->rows-1;   bounds.x2=0;   bounds.y2=0;   for (i=0; *p != '\0'; )    {      /*       Define primitive.      */     while (isspace((int) (*p))) 
       p++;'     for (x=0; isalpha((int) (*p)); x++)        keyword[x]=(*p++);     keyword[x]='\0';     if (*keyword == '\0')        break;&     primitive_type=UndefinedPrimitive;,     if (Latin1Compare("Point",keyword) == 0)$       primitive_type=PointPrimitive;+     if (Latin1Compare("Line",keyword) == 0) #       primitive_type=LinePrimitive; 0     if (Latin1Compare("Rectangle",keyword) == 0)(       primitive_type=RectanglePrimitive;4     if (Latin1Compare("FillRectangle",keyword) == 0),       primitive_type=FillRectanglePrimitive;-     if (Latin1Compare("Circle",keyword) == 0) %       primitive_type=CirclePrimitive; 1     if (Latin1Compare("FillCircle",keyword) == 0) )       primitive_type=FillCirclePrimitive; .     if (Latin1Compare("Ellipse",keyword) == 0)&       primitive_type=EllipsePrimitive;2     if (Latin1Compare("FillEllipse",keyword) == 0)*       primitive_type=FillEllipsePrimitive;.     if (Latin1Compare("Polygon",keyword) == 0)&       primitive_type=PolygonPrimitive;2     if (Latin1Compare("FillPolygon",keyword) == 0)*       primitive_type=FillPolygonPrimitive;,     if (Latin1Compare("Color",keyword) == 0)$       primitive_type=ColorPrimitive;,     if (Latin1Compare("Matte",keyword) == 0)$       primitive_type=MattePrimitive;+     if (Latin1Compare("Text",keyword) == 0) #       primitive_type=TextPrimitive; ,     if (Latin1Compare("Image",keyword) == 0)$       primitive_type=ImagePrimitive;-     if (primitive_type == UndefinedPrimitive)        break;     j=i;     for (x=0; *p != '\0'; x++)     {        /*         Define points.       */!       while (isspace((int) (*p)))          p++;       if (!IsGeometry(p))          break;       point.x=0;       point.y=0;
       n=0;7       (void) sscanf(p,"%lf%lf%n",&point.x,&point.y,&n);        if (n == 0) :         (void) sscanf(p,"%lf,%lf%n",&point.x,&point.y,&n);       if (n == 0) ;         (void) sscanf(p,"%lf, %lf%n",&point.x,&point.y,&n);        if (n == 0) :         (void) sscanf(p,"%lf %lf%n",&point.x,&point.y,&n);       if (n == 0) 	         { &           MagickWarning(OptionWarning,=             "Non-conforming drawing primitive definition",p);            break;	         }        if (point.x < bounds.x1)         bounds.x1=point.x;       if (point.y < bounds.y1)         bounds.y1=point.y;       if (point.x > bounds.x2)         bounds.x2=point.x;       if (point.y > bounds.y2)         bounds.y2=point.y;1       primitive_info[i].primitive=primitive_type; &       primitive_info[i].coordinates=0;"       primitive_info[i].x=point.x;"       primitive_info[i].y=point.y;/       primitive_info[i].method=FloodfillMethod;        p+=n; 0       while (isspace((int) (*p)) || (*p == ','))         p++;
       i++;/       if (i < (int) (number_coordinates-360-1))          continue;        number_coordinates<<=1; G       primitive_info=(PrimitiveInfo *) ReallocateMemory(primitive_info, 2         number_coordinates*sizeof(PrimitiveInfo));3       if (primitive_info != (PrimitiveInfo *) NULL)          continue; @       MagickWarning(ResourceLimitWarning,"Unable to draw image",$         "Memory allocation failed");       if (indirection)         FreeMemory(primitive);&       DestroyAnnotateInfo(local_info);
       return;      } $     primitive_info[j].coordinates=x;-     primitive_info[j].method=FloodfillMethod; )     primitive_info[j].text=(char *) NULL;      switch (primitive_type)      {        case PointPrimitive:       default:       { /         if (primitive_info[j].coordinates != 1) ,           primitive_type=UndefinedPrimitive;         break;       }        case LinePrimitive:        case RectanglePrimitive:"       case FillRectanglePrimitive:       { /         if (primitive_info[j].coordinates != 2) ,           primitive_type=UndefinedPrimitive;         break;       }        case CirclePrimitive:        case FillCirclePrimitive:        {          double           radius;   /         if (primitive_info[j].coordinates != 2)            { .             primitive_type=UndefinedPrimitive;             break;           } 
         /*(           Determine circle bounding box.
         */<         x=(int) (primitive_info[j+1].x-primitive_info[j].x);<         y=(int) (primitive_info[j+1].y-primitive_info[j].y);         radius= M           sqrt((double) (x*x+y*y))+local_info->image_info->linewidth/2.0+0.5; 2         point.x=Max(primitive_info[j].x-radius,0);2         point.y=Max(primitive_info[j].y-radius,0);          if (point.x < bounds.x1)           bounds.x1=point.x;          if (point.y < bounds.y1)           bounds.y1=point.y;A         point.x=Min(primitive_info[j].x+radius,image->columns-1); >         point.y=Min(primitive_info[j].y+radius,image->rows-1);          if (point.x > bounds.x2)           bounds.x2=point.x;          if (point.y > bounds.y2)           bounds.y2=point.y;         break;       }        case EllipsePrimitive:        case FillEllipsePrimitive:       {          double           n;           PointInfo            degrees,           end,           start;  /         if (primitive_info[j].coordinates != 3)            { .             primitive_type=UndefinedPrimitive;             break;           } 
         /*2           Arc's are just short segmented polygons.
         */5         primitive_info[j].primitive=PolygonPrimitive; 3         if (primitive_type == FillEllipsePrimitive) ;           primitive_info[j].primitive=FillPolygonPrimitive; $         start.x=primitive_info[j].x;$         start.y=primitive_info[j].y;&         end.x=primitive_info[j+1].x/2;&         end.y=primitive_info[j+1].y/2;(         degrees.x=primitive_info[j+2].x;(         degrees.y=primitive_info[j+2].y;%         while (degrees.y < degrees.x)            degrees.y+=360;          i=j;7         if ((primitive_type == FillEllipsePrimitive) && 5             (fmod(degrees.y-degrees.x,360.0) != 0.0))            { $             if (start.x < bounds.x1)                bounds.x1=start.x;$             if (start.y < bounds.y1)                bounds.y1=start.y;"             if (end.x > bounds.x2)               bounds.x2=end.x;"             if (end.y > bounds.y2)               bounds.y2=end.y;,             primitive_info[j].coordinates++;             i++;           } 7         for (n=(degrees.x+1.0); n <= degrees.y; n+=1.0) 	         { E           point.x=cos(DegreesToRadians(fmod(n,360.0)))*end.x+start.x; E           point.y=sin(DegreesToRadians(fmod(n,360.0)))*end.y+start.y; "           if (point.x < bounds.x1)             bounds.x1=point.x;"           if (point.y < bounds.y1)             bounds.y1=point.y;"           if (point.x > bounds.x2)             bounds.x2=point.x;"           if (point.y > bounds.y2)             bounds.y2=point.y;*           primitive_info[i].coordinates=0;&           primitive_info[i].x=point.x;&           primitive_info[i].y=point.y;*           primitive_info[j].coordinates++;           i++;	         }          break;       }        case PolygonPrimitive:        case FillPolygonPrimitive:       { .         if (primitive_info[j].coordinates < 3),           primitive_type=UndefinedPrimitive;         break;       }        case ColorPrimitive:       case MattePrimitive:       { /         if (primitive_info[j].coordinates != 1)            { .             primitive_type=UndefinedPrimitive;             break;           } 
         /*           Define method.
         */#         while (isspace((int) (*p)))            p++;+         for (x=0; isalpha((int) (*p)); x++)            keyword[x]=(*p++);         keyword[x]='\0';         if (*keyword == '\0')            break;0         if (Latin1Compare("point",keyword) == 0)/           primitive_info[j].method=PointMethod;          else4           if (Latin1Compare("replace",keyword) == 0)3             primitive_info[j].method=ReplaceMethod;            else8             if (Latin1Compare("floodfill",keyword) == 0)7               primitive_info[j].method=FloodfillMethod;              else=               if (Latin1Compare("filltoborder",keyword) == 0) <                 primitive_info[j].method=FillToBorderMethod;               else8                 if (Latin1Compare("reset",keyword) == 0)7                   primitive_info[j].method=ResetMethod;                  else4                   primitive_type=UndefinedPrimitive;#         while (isspace((int) (*p)))            p++;         break;       }        case TextPrimitive:        { /         if (primitive_info[j].coordinates != 1)            { .             primitive_type=UndefinedPrimitive;             break;           }          if (*p != '\0')            { %             primitive_info[j].text=p;              if (*p == '"')               { *                 for (p++; *p != '\0'; p++)6                   if ((*p == '"') && (*(p-1) != '\\'))                     break;               }              else               if (*p == '\'')                  { ,                   for (p++; *p != '\0'; p++)9                     if ((*p == '\'') && (*(p-1) != '\\'))                        break;                 }                else+                 for (p++;  *p != '\0'; p++) <                   if (isspace((int) *p) && (*(p-1) != '\\'))                     break;             if (*p != '\0')                p++;           }          break;       }        case ImagePrimitive:       { 
         Image            *composite_image;            ImageInfo            composite_info;   /         if (primitive_info[j].coordinates != 1)            { .             primitive_type=UndefinedPrimitive;             break;           }          if (*p != '\0')            { %             primitive_info[j].text=p;              if (*p == '"')               { *                 for (p++; *p != '\0'; p++)6                   if ((*p == '"') && (*(p-1) != '\\'))                     break;               }              else               if (*p == '\'')                  { ,                   for (p++; *p != '\0'; p++)9                     if ((*p == '\'') && (*(p-1) != '\\'))                        break;                 }                else+                 for (p++;  *p != '\0'; p++) <                   if (isspace((int) *p) && (*(p-1) != '\\'))                     break;             if (*p != '\0')                p++;           } &         GetImageInfo(&composite_info);F         (void) strcpy(composite_info.filename,primitive_info[j].text);3         composite_image=ReadImage(&composite_info); .         if (composite_image == (Image *) NULL)           break;@         CompositeImage(image,ReplaceCompositeOp,composite_image,'           (int) point.x,(int) point.y); &         DestroyImage(composite_image);         break;       }      } -     if (primitive_type == UndefinedPrimitive)        break;   } 1   primitive_info[i].primitive=UndefinedPrimitive; +   if (primitive_type == UndefinedPrimitive)      { "       MagickWarning(OptionWarning,?         "Non-conforming drawing primitive definition",keyword); !       FreeMemory(primitive_info);        if (indirection)         FreeMemory(primitive);&       DestroyAnnotateInfo(local_info);
       return;      } C   for (i=0; primitive_info[i].primitive != UndefinedPrimitive; i++) 6     if ((primitive_info[i].method == ReplaceMethod) ||2         (primitive_info[i].method == ResetMethod))       { 
         /*<           Replace and reset methods affect the entire image.
         */         bounds.x1=0;         bounds.y1=0;#         bounds.x2=image->columns-1;           bounds.y2=image->rows-1;       }    /*     Account for linewidth.   */,   mid=local_info->image_info->linewidth/2.0;;   if ((bounds.x1 != bounds.x2) || (bounds.y1 != bounds.y2))      { %       bounds.x1=Max(bounds.x1-mid,0); %       bounds.y1=Max(bounds.y1-mid,0); :       bounds.x2=Min(bounds.x2+ceil(mid),image->columns-1);7       bounds.y2=Min(bounds.y2+ceil(mid),image->rows-1);      }    /*$     Draw the primitive on the image.   */   image->class=DirectClass; 4   for (y=(int) bounds.y1; y <= (int) bounds.y2; y++)   {      target.y=y; 6     for (x=(int) bounds.x1; x <= (int) bounds.x2; x++)     {        target.x=x; G       opacity=InsidePrimitive(primitive_info,local_info,&target,image); -       if (!local_info->image_info->antialias) #         if (opacity != Transparent)            opacity=Opaque; !       if (opacity != Transparent) 	         {            register PixelPacket             *p;   I           p=GetPixelCache(local_info->tile,x % local_info->tile->columns, ,             y % local_info->tile->rows,1,1);)           q=GetPixelCache(image,x,y,1,1); I           if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))              break;'           if (!local_info->tile->matte) 
             { /               q->red=(Quantum) ((unsigned long) A                 (p->red*opacity+q->red*(Opaque-opacity))/Opaque); 1               q->green=(Quantum) ((unsigned long) E                 (p->green*opacity+q->green*(Opaque-opacity))/Opaque); 0               q->blue=(Quantum) ((unsigned long)C                 (p->blue*opacity+q->blue*(Opaque-opacity))/Opaque); 
             }            else
             { /               q->red=(Quantum) ((unsigned long) G                 (p->red*p->opacity+q->red*(Opaque-p->opacity))/Opaque); G               q->green=(Quantum) ((unsigned long) (p->green*p->opacity+ 6                 q->green*(Opaque-p->opacity))/Opaque);E               q->blue=(Quantum) ((unsigned long) (p->blue*p->opacity+ 5                 q->blue*(Opaque-p->opacity))/Opaque); @               q->opacity=(Quantum) ((unsigned long) (p->opacity*C                 p->opacity+q->opacity*(Opaque-p->opacity))/Opaque); 
             } %           if (!SyncPixelCache(image))              break;	         }      } #     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(DrawImageText,y,image->rows);    } C   for (i=0; primitive_info[i].primitive != UndefinedPrimitive; i++) :     if ((primitive_info[i].primitive == MattePrimitive) &&+ 	(primitive_info[i].method == ResetMethod))        image->matte=False;    /*     Free resources.    */   FreeMemory(primitive_info);    if (indirection)     FreeMemory(primitive);"   DestroyAnnotateInfo(local_info); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   I n s i d e P r i m i t i v e                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method InsidePrimitive returns the opacity of the pen at the (x,y) positionK %  of the image.  The opacity is Opaque if the (x,y) position is within the J %  primitive as defined in primitive_info.  A value less than fully opaqueL %  and greater than fully transparent is returned for a primitive edge pixelH %  to allow for anti-aliasing.  Otherwise fully transparent is returned. % B %  Rick Mabry provided the algorithms for anti-aliased primitives. % / %  The format of the InsidePrimitive method is:  % D %      unsigned short InsidePrimitive(PrimitiveInfo *primitive_info,O %        const AnnotateInfo *annotate_info,const PointInfo *pixel,Image *image)  % + %  A description of each parameter follows:  % M %    o opacity:  Method InsidePrimitive returns a pen opacity associated with ' %      the (x,y) position of the image.  % H %    o primitive_info: Specifies a pointer to a PrimitiveInfo structure. % F %    o annotate_info: Specifies a pointer to a AnnotateInfo structure. % F %    o target: PointInfo representing the (x,y) location in the image. % 7 %    o image: The address of a structure of type Image.  %  %  */  L static double DistanceToLine(const PointInfo *pixel,const SegmentInfo *line) {    register double 
     alpha,	     beta,      dot_product,
     gamma,     v;     alpha=pixel->x-line->x1;   beta=pixel->y-line->y1; A   dot_product=alpha*(line->x2-line->x1)+beta*(line->y2-line->y1);    if (dot_product <= 0) "     return(alpha*alpha+beta*beta);,   v=(line->x2-line->x1)*(line->x2-line->x1)+,     (line->y2-line->y1)*(line->y2-line->y1);"   gamma=dot_product*dot_product/v;   if (gamma <= v) (     return(alpha*alpha+beta*beta-gamma);   alpha=pixel->x-line->x2;   beta=pixel->y-line->y2;     return(alpha*alpha+beta*beta); }   9 static unsigned short PixelOnLine(const PointInfo *pixel, H   const SegmentInfo *line,const double mid,const unsigned short opacity) {    register double 
     alpha,
     distance;   (   if ((mid == 0) || (opacity == Opaque))     return(opacity);7   if ((line->x1 == line->x2) && (line->y1 == line->y2)) P     return((pixel->x == line->x1) && (pixel->y == line->y1) ? Opaque : opacity);&   distance=DistanceToLine(pixel,line);   alpha=mid-0.5;    if (distance <= (alpha*alpha))     return(Opaque);    alpha=mid+0.5;    if (distance <= (alpha*alpha))     { #       alpha=sqrt(distance)-mid-0.5; E       return((unsigned short) Max((int) opacity,Opaque*alpha*alpha));      }    return(opacity); }   D static unsigned short InsidePrimitive(PrimitiveInfo *primitive_info,H   const AnnotateInfo *annotate_info,const PointInfo *pixel,Image *image) { 
   PixelPacket      border_color;      double
     alpha,	     beta, 
     distance,      mid,     radius;      register PrimitiveInfo     *p,      *q;      register unsigned short      opacity;  
   PixelPacket      target;   
   SegmentInfo 	     line;   3   assert(primitive_info != (PrimitiveInfo *) NULL); 1   assert(annotate_info != (AnnotateInfo *) NULL); "   assert(image != (Image *) NULL);   opacity=Transparent;/   mid=annotate_info->image_info->linewidth/2.0;    p=primitive_info; ,   while (p->primitive != UndefinedPrimitive)   {      q=p+p->coordinates-1;      switch (p->primitive)      {        case PointPrimitive:       default:       { M         if ((pixel->x == (int) (p->x+0.5)) && (pixel->y == (int) (p->y+0.5)))            opacity=Opaque;          break;       }        case LinePrimitive:        {          line.x1=p->x;          line.y1=p->y;          line.x2=q->x;          line.y2=q->y; 5         opacity=PixelOnLine(pixel,&line,mid,opacity);          break;       }        case RectanglePrimitive:       { @         if (((pixel->x >= (int) (Min(p->x-mid,q->x+mid)+0.5)) &&?              (pixel->x < (int) (Max(p->x-mid,q->x+mid)+0.5)) && @              (pixel->y >= (int) (Min(p->y-mid,q->y+mid)+0.5)) &&@              (pixel->y < (int) (Max(p->y-mid,q->y+mid)+0.5))) &&@            !((pixel->x >= (int) (Min(p->x+mid,q->x-mid)+0.5)) &&?              (pixel->x < (int) (Max(p->x+mid,q->x-mid)+0.5)) && @              (pixel->y >= (int) (Min(p->y+mid,q->y-mid)+0.5)) &&>              (pixel->y < (int) (Max(p->y+mid,q->y-mid)+0.5))))           opacity=Opaque;          break;       } "       case FillRectanglePrimitive:       { 7         if ((pixel->x >= (int) (Min(p->x,q->x)+0.5)) && 7             (pixel->x <= (int) (Max(p->x,q->x)+0.5)) && 7             (pixel->y >= (int) (Min(p->y,q->y)+0.5)) && 5             (pixel->y <= (int) (Max(p->y,q->y)+0.5)))            opacity=Opaque;          break;       }        case CirclePrimitive:        {          alpha=p->x-pixel->x;         beta=p->y-pixel->y; -         distance=sqrt(alpha*alpha+beta*beta);          alpha=p->x-q->x;         beta=p->y-q->y; +         radius=sqrt(alpha*alpha+beta*beta); #         beta=fabs(distance-radius);          if (beta < (mid+0.5))            { "             if (beta <= (mid-0.5))               opacity=Opaque;              else               { #                 alpha=mid-beta+0.5; H                 opacity=(Quantum) Max((int) opacity,Opaque*alpha*alpha);               }            }          break;       }        case FillCirclePrimitive:        {          alpha=p->x-pixel->x;         beta=p->y-pixel->y; -         distance=sqrt(alpha*alpha+beta*beta);          alpha=p->x-q->x;         beta=p->y-q->y; +         radius=sqrt(alpha*alpha+beta*beta); %         if (distance <= (radius-1.0))            opacity=Opaque;          else&           if (distance < (radius+1.0))
             { .               alpha=(radius-distance+1.0)/2.0;F               opacity=(Quantum) Max((int) opacity,Opaque*alpha*alpha);
             }          break;       }        case PolygonPrimitive:       {          unsigned short           poly_opacity;   !         poly_opacity=Transparent; 9         for ( ; (p < q) && (poly_opacity != Opaque); p++) 	         {            line.x1=p->x;            line.y1=p->y;            line.x2=(p+1)->x;            line.y2=(p+1)->y; C           poly_opacity=PixelOnLine(pixel,&line,mid,(unsigned short) '             Max(opacity,poly_opacity)); 	         } *         opacity=Max(opacity,poly_opacity);         break;       }         case FillPolygonPrimitive:       {          double           distance,            minimum_distance;            int            crossing,            crossings;           PrimitiveInfo 
           *r;            unsigned short           poly_opacity;            r=p;         crossings=0;3         if ((pixel->y < q->y) != (pixel->y < p->y))            { %             crossing=pixel->x < q->x; .             if (crossing != (pixel->x < p->x))#               crossings+=pixel->x < ?                 (q->x-(q->y-pixel->y)*(p->x-q->x)/(p->y-q->y));              else               if (crossing)                  crossings++;           }          for (p++; p <= q; p++)	         { "           if (pixel->y < (p-1)->y)
             { 3               while ((p <= q) && (pixel->y < p->y))                  p++;               if (p > q)                 break;+               crossing=pixel->x < (p-1)->x; 0               if (crossing != (pixel->x < p->x))D                 crossings+=pixel->x < ((p-1)->x-((p-1)->y-pixel->y)*3                   (p->x-(p-1)->x)/(p->y-(p-1)->y));                else                 if (crossing)                    crossings++;               continue; 
             } 0           while ((p <= q) && (pixel->y >= p->y))             p++;           if (p > q)             break;'           crossing=pixel->x < (p-1)->x; ,           if (crossing != (pixel->x < p->x))@             crossings+=pixel->x < ((p-1)->x-((p-1)->y-pixel->y)*/               (p->x-(p-1)->x)/(p->y-(p-1)->y));            else             if (crossing)                crossings++;	         } 
         /*'           Now find distance to polygon. 
         */         p=r;         line.x1=p->x;          line.y1=p->y;          line.x2=q->x;          line.y2=q->y; 5         minimum_distance=DistanceToLine(pixel,&line);          for ( ; p < q; p++) 	         {            line.x1=p->x;            line.y1=p->y;            line.x2=(p+1)->x;            line.y2=(p+1)->y; /           distance=DistanceToLine(pixel,&line); *           if (distance < minimum_distance)&             minimum_distance=distance;	         } 0         minimum_distance=sqrt(minimum_distance);         if (crossings & 0x01)            {               poly_opacity=Opaque;'             if (minimum_distance < 0.5)                { +                 alpha=0.5+minimum_distance; <                 poly_opacity=(Quantum) (Opaque*alpha*alpha);               } .             opacity=Max(opacity,poly_opacity);             break;           } !         poly_opacity=Transparent; #         if (minimum_distance < 0.5)            { '             alpha=0.5-minimum_distance; 8             poly_opacity=(Quantum) (Opaque*alpha*alpha);           } *         opacity=Max(opacity,poly_opacity);         break;       }        case ColorPrimitive:       {          switch (p->method)	         {            case PointMethod:            default:           { 1             if ((pixel->x != (int) (p->x+0.5)) && /                 (pixel->y != (int) (p->y+0.5)))                break;             opacity=Opaque;              break;           }            case ReplaceMethod:            {              PixelPacket                color;               static PixelPacket               target;   3             if ((pixel->x == 0) && (pixel->y == 0))                { C                 if (GetPixelCache(image,(int) p->x,(int) p->y,1,1)) *                   target=(*image->pixels);               } G             if (GetPixelCache(image,(int) pixel->x,(int) pixel->y,1,1)) %               color=(*image->pixels); ;             if (ColorMatch(color,target,(int) image->fuzz))                opacity=Opaque;              break;           }            case FloodfillMethod: "           case FillToBorderMethod:           { 1             if ((pixel->x != (int) (p->x+0.5)) && /                 (pixel->y != (int) (p->y+0.5)))                break;G             if (GetPixelCache(image,(int) pixel->x,(int) pixel->y,1,1)) &               target=(*image->pixels);0             if (p->method == FillToBorderMethod)               { E                 border_color=annotate_info->image_info->border_color; ,                 target.red=border_color.red;0                 target.green=border_color.green;.                 target.blue=border_color.blue;               } B             ColorFloodfillImage(image,&target,annotate_info->tile,7               (int) pixel->x,(int) pixel->y,p->method);              break;           }            case ResetMethod:            {              opacity=Opaque;              break;           } 	         }          break;       }        case MattePrimitive:       {          if (!image->matte)#           MatteImage(image,Opaque);          switch (p->method)	         {            case PointMethod:            default:           { 1             if ((pixel->x != (int) (p->x+0.5)) && /                 (pixel->y != (int) (p->y+0.5)))                break;G             if (GetPixelCache(image,(int) pixel->x,(int) pixel->y,1,1))                { 3                 image->pixels->opacity=Transparent; -                 (void) SyncPixelCache(image);                }              break;           }            case ReplaceMethod:            {              PixelPacket                color;               static PixelPacket               target;   3             if ((pixel->x == 0) && (pixel->y == 0))                { C                 if (GetPixelCache(image,(int) p->x,(int) p->y,1,1)) *                   target=(*image->pixels);               } G             if (GetPixelCache(image,(int) pixel->x,(int) pixel->y,1,1)) %               color=(*image->pixels); 5             if (ColorMatch(color,target,image->fuzz))                { 3                 image->pixels->opacity=Transparent; -                 (void) SyncPixelCache(image);                }              break;           }            case FloodfillMethod: "           case FillToBorderMethod:           { 1             if ((pixel->x != (int) (p->x+0.5)) && /                 (pixel->y != (int) (p->y+0.5)))                break;G             if (GetPixelCache(image,(int) pixel->x,(int) pixel->y,1,1)) &               target=(*image->pixels);0             if (p->method == FillToBorderMethod)               { E                 border_color=annotate_info->image_info->border_color; ,                 target.red=border_color.red;0                 target.green=border_color.green;.                 target.blue=border_color.blue;               } I             MatteFloodfillImage(image,&target,Transparent,(int) pixel->x, (               (int) pixel->y,p->method);             break;           }            case ResetMethod:            { G             if (GetPixelCache(image,(int) pixel->x,(int) pixel->y,1,1))                { .                 image->pixels->opacity=Opaque;-                 (void) SyncPixelCache(image);                }              break;           } 	         }          break;       }        case TextPrimitive:        {          register char 
           *r;   M         if ((pixel->x != (int) (p->x+0.5)) && (pixel->y != (int) (p->y+0.5)))            break;%         if (p->text == (char *) NULL)            break;         r=p->text;         if (*r == '"')           {              p->text++;&             for (r++; *r != '\0'; r++)2               if ((*r == '"') && (*(r-1) != '\\'))                 break;           }          else           if (*r == '\'') 
             {                p->text++;(               for (r++; *r != '\0'; r++)5                 if ((*r == '\'') && (*(r-1) != '\\'))                    break;
             }            else'             for (r++;  *r != '\0'; r++) 8               if (isspace((int) *r) && (*(r-1) != '\\'))                 break;>         (void) strncpy(annotate_info->text,p->text,r-p->text);,         annotate_info->text[r-p->text]='\0';M         FormatString(annotate_info->geometry,"%+d%+d",(int) p->x,(int) p->y); +         AnnotateImage(image,annotate_info);          break;       }        case ImagePrimitive:         break;     }      if (opacity == Opaque)       return(opacity);     while (p <= q)
       p++;   }    return(opacity); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M a t t e F l o o d f i l l I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method MatteFloodfillImage floodfills the designated area with a matte N %  value.  The floodfill algorithm is strongly based on a similar algorithm in$ %  "Graphics Gems" by Paul Heckbert. % 3 %  The format of the MatteFloodfillImage method is:  % G %      void MatteFloodfillImage(Image *image,const PixelPacket *target, H %        const unsigned int matte,const int x_offset,const int y_offset," %        const PaintMethod method) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % L %    o target: A PixelPacket structure.  This is the RGB value of the target
 %      color.  % F %    o matte: A integer value representing the amount of transparency. % K %    o x,y: Unsigned integers representing the current location of the pen.  % I %    o method: drawing method of type PrimitiveType: floodfill or fill to  %      border. %  %  */G Export void MatteFloodfillImage(Image *image,const PixelPacket *target, A   const unsigned int matte,const int x_offset,const int y_offset,    const PaintMethod method)  {    int      offset, 	     skip, 
     start,     x1,      x2,      y;     register int     x;     register PixelPacket     *q;      register SegmentInfo     *s;   
   SegmentInfo      *segment_stack;      /*     Check boundary conditions.   */"   assert(image != (Image *) NULL);;   if ((x_offset < 0) || (x_offset >= (int) image->columns))      return; 8   if ((y_offset < 0) || (y_offset >= (int) image->rows))     return; 0   if (target->opacity == (unsigned short) matte)     return; 2   if (!GetPixelCache(image,x_offset,y_offset,1,1))     return; 7   if (image->pixels->opacity == (unsigned short) matte)      return;    /*     Allocate segment stack.    */   segment_stack=(SegmentInfo *) 5     AllocateMemory(MaxStacksize*sizeof(SegmentInfo)); ,   if (segment_stack == (SegmentInfo *) NULL)     { C       MagickWarning(ResourceLimitWarning,"Unable to recolor image", $         "Memory allocation failed");
       return;      }    /*"     Push initial segment on stack.   */   image->class=DirectClass;    if (!image->matte)     MatteImage(image,Opaque); 
   x=x_offset; 
   y=y_offset; 
   start=0;   s=segment_stack;   Push(y,x,x,1);   Push(y+1,x,x,-1);    while (s > segment_stack)    {      /*       Pop segment off stack.     */     s--;     x1=(int) s->x1;      x2=(int) s->x2;      offset=(int) s->y2;      y=(int) s->y1+offset;      /*!       Recolor neighboring pixels.      */0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;
     q+=x1;     for (x=x1; x >= 0 ; x--)     { $       if (method == FloodfillMethod)	         { 2           if (!MatteMatch(*q,*target,image->fuzz))             break;	         } 
       else1         if (MatteMatch(*q,*target,image->fuzz) || 3             (q->opacity == (unsigned short) matte))            break;!       q->opacity=(Quantum) matte; 
       q--;     }      if (!SyncPixelCache(image))        break;     skip=x >= x1;      if (!skip)       {          start=x+1;         if (start < x1) %           Push(y,start,x1-1,-offset);          x=x1+1;        }      do     {        if (!skip)	         { 6           q=GetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;           q+=x; 0           for ( ; x < (int) image->columns; x++)           { *             if (method == FloodfillMethod)               { 8                 if (!MatteMatch(*q,*target,image->fuzz))                   break;               }              else7               if (MatteMatch(*q,*target,image->fuzz) || 9                   (q->opacity == (unsigned short) matte))                  break;'             q->opacity=(Quantum) matte;              q++;           } %           if (!SyncPixelCache(image))              break;#           Push(y,start,x-1,offset);            if (x > (x2+1)) %             Push(y,x2+1,x-1,-offset); 	         }        skip=False; 2       q=GetPixelCache(image,0,y,image->columns,1);$       if (q == (PixelPacket *) NULL)         break;       q+=x;        for (x++; x <= x2 ; x++)       {          q++;&         if (method == FloodfillMethod)           { 3             if (MatteMatch(*q,*target,image->fuzz))                break;           }          else4           if (!MatteMatch(*q,*target,image->fuzz) &&5               (q->opacity != (unsigned short) matte))              break;       }        start=x;     } while (x <= x2);   }    FreeMemory(segment_stack); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     O p a q u e I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method OpaqueImage changes the color of an opaque pixel to the pen color. % + %  The format of the OpaqueImage method is:  % > %      void OpaqueImage(Image *image,const char *opaque_color, %        const char *pen_color)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %    o opaque_color,F %      pen_color: A character string that contain an X11 color string. %  %  */> Export void OpaqueImage(Image *image,const char *opaque_color,   const char *pen_color) { C #define OpaqueImageText  "  Setting opaque color in the image...  "   
   PixelPacket      target,      target_color;      int      y;     register int     i,     x;     register PixelPacket     *q;      unsigned int     status;      /*-     Determine RGB values of the opaque color.    */"   assert(image != (Image *) NULL);2   status=QueryColorDatabase(opaque_color,&target);   if (status == False)     return; 5   status=QueryColorDatabase(pen_color,&target_color);    if (status == False)     return;    /*     Make image color opaque.   */   switch (image->class)    {      case DirectClass:      default:     {        /*&         Make DirectClass image opaque.       */+       for (y=0; y < (int) image->rows; y++)        { 4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { 0           if (ColorMatch(*q,target,image->fuzz))             *q=target_color;           q++;	         } #         if (!SyncPixelCache(image))            break;'         if (QuantumTick(y,image->rows)) 9           ProgressMonitor(OpaqueImageText,y,image->rows);        }        break;     }      case PseudoClass:      {        /*&         Make PseudoClass image opaque.       */-       for (i=0; i < (int) image->colors; i++)        { >         if (ColorMatch(image->colormap[i],target,image->fuzz))*           image->colormap[i]=target_color;)         if (QuantumTick(i,image->colors)) ;           ProgressMonitor(OpaqueImageText,i,image->colors);        }        SyncImage(image);        break;     }    }  } 