 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            EEEEE  PPPP   TTTTT                              % O %                            E      P   P    T                                % O %                            EEE    PPPP     T                                % O %                            E      P        T                                % O %                            EEEEE  P        T                                % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s E P T                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsEPT returns True if the image format type, identified by the %  magick string, is EPT.  % , %  The format of the ReadEPTImage method is: % 6 %      unsigned int IsEPT(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsEPT returns True if the image format type is EPT. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsEPT(const unsigned char *magick,const unsigned int length) {    if (length < 4)      return(False);9   if (strncmp((char *) magick,"\305\320\323\306",4) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e E P T I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method WriteEPTImage writes an image in the Adobe Encapsulated Postscript %  format with a TIFF preview. % - %  The format of the WriteEPTImage method is:  % K %      unsigned int WriteEPTImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteEPTImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteEPTImage(const ImageInfo *image_info,Image *image)  {    char     filename[MaxTextExtent];     FILE
     *ps_file,      *tiff_file;      int      c;     unsigned int     status;      unsigned long      eps_length,      tiff_length;     ps_file=(FILE *) NULL;2   if (Latin1Compare(image_info->magick,"PS") == 0)9     ps_file=fopen(image->magick_filename,ReadBinaryType);    if (ps_file != (FILE *) NULL)      {        /*.         Read existing Encapsulated Postscript.       */(       (void) fseek(ps_file,0L,SEEK_END);        eps_length=ftell(ps_file);(       (void) fseek(ps_file,0L,SEEK_SET);     }    else     {        /*C         Write image as Encapsulated Postscript to a temporary file.        */.       (void) strcpy(filename,image->filename);)       TemporaryFilename(image->filename); ,       status=WritePSImage(image_info,image);       if (status == False)         return(status); 7       status=OpenBlob(image_info,image,ReadBinaryType);        if (status == False)@         WriterExit(FileOpenWarning,"Unable to open file",image);%       (void) remove(image->filename); !       eps_length=image->filesize;        ps_file=image->file;        image->file=(FILE *) NULL;     }    /*,     Write image as TIFF to a temporary file.   */%   TemporaryFilename(image->filename); *   status=WriteTIFFImage(image_info,image);   if (status == False)     return(status); 3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);!   (void) remove(image->filename);    tiff_length=image->filesize;   tiff_file=image->file;   image->file=(FILE *) NULL;   /*     Write EPT image.   */*   (void) strcpy(image->filename,filename);4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);(   LSBFirstWriteLong(image,0xc6d3d0c5ul);   LSBFirstWriteLong(image,30);&   LSBFirstWriteLong(image,eps_length);   LSBFirstWriteLong(image,0);    LSBFirstWriteLong(image,0); )   LSBFirstWriteLong(image,eps_length+30); '   LSBFirstWriteLong(image,tiff_length); #   LSBFirstWriteShort(image,0xffff); 4   for (c=fgetc(ps_file); c != EOF; c=fgetc(ps_file))%     (void) WriteByte(image,(char) c); 8   for (c=fgetc(tiff_file); c != EOF; c=fgetc(tiff_file))%     (void) WriteByte(image,(char) c);    (void) fclose(tiff_file);    CloseBlob(image);    return(True);  } 