 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                           GGGG  EEEEE  M   M SSSSS                          % O %                          G      E      MM MM SS                             % O %                          G GG   EEE    M M M  SSS                           % O %                          G   G  E      M   M    SS                          % O %                           GGGG  EEEEE  M   M SSSSS                          % O %                                                                             % O %                                                                             % O %                    Graphic Gems - Graphic Support Methods                   % O %                                                                             % O %                                                                             % O %                               Software Design                               % O %                                 John Cristy                                 % O %                                 August 1996                                 % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o n s t r a s t                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method Contrast enhances the intensity differences between the lighter $ %  and darker elements of the image. % ( %  The format of the Contrast method is: % N %      void Contrast(const int sign,Quantum *red,Quantum *green,Quantum *blue) % + %  A description of each parameter follows:  % L %    o sign: A positive value enhances the contrast otherwise it is reduced. % H %    o red, green, blue: A pointer to a pixel component of type Quantum. %  %  */N Export void Contrast(const int sign,Quantum *red,Quantum *green,Quantum *blue) {    double     brightness,      hue,     saturation, 
     theta;     /*K     Enhance contrast: dark color become darker, light color become lighter.    */"   assert(red != (Quantum *) NULL);$   assert(green != (Quantum *) NULL);#   assert(blue != (Quantum *) NULL); ?   TransformHSL(*red,*green,*blue,&hue,&saturation,&brightness);    theta=(brightness-0.5)*M_PI;?   brightness+=(((((sin(theta)+1.0))*0.5)-brightness)*sign)*0.5;    if (brightness > 1.0)      brightness=1.0;    else     if (brightness < 0)        brightness=0.0; 9   HSLTransform(hue,saturation,brightness,red,green,blue);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e n e r a t e N o i s e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % . %  Method GenerateNoise adds noise to a pixel. % - %  The format of the GenerateNoise method is:  % L %      Quantum GenerateNoise(const Quantum pixel,const NoiseType noise_type) % + %  A description of each parameter follows:  % * %    o pixel: A structure of type Quantum. % I %    o noise_type:  The type of noise: Gaussian, multiplicative Gaussian, & %      impulse, laplacian, or Poisson. %  %  */L Export Quantum GenerateNoise(const Quantum pixel,const NoiseType noise_type) {  #define NoiseEpsilon  1.0e-5 #define NoiseMask  0x7fff  #define SigmaUniform  4.0  #define SigmaGaussian  4.0 #define SigmaImpulse  0.10 #define SigmaLaplacian 10.0 ( #define SigmaMultiplicativeGaussian  0.5 #define SigmaPoisson  0.05 #define TauGaussian  20.0      double
     alpha,	     beta, 
     sigma,
     value;  0   alpha=(double) (rand() & NoiseMask)/NoiseMask;   if (alpha == 0.0)      alpha=1.0;   switch (noise_type)    {      case UniformNoise:     default:     { 4       value=(double) pixel+SigmaUniform*(alpha-0.5);       break;     }      case GaussianNoise:      {        double         tau;  3       beta=(double) (rand() & NoiseMask)/NoiseMask; 5       sigma=sqrt(-2.0*log(alpha))*cos(2.0*M_PI*beta); 3       tau=sqrt(-2.0*log(alpha))*sin(2.0*M_PI*beta);        value=(double) pixel+ E         (sqrt((double) pixel)*SigmaGaussian*sigma)+(TauGaussian*tau);        break;     } %     case MultiplicativeGaussianNoise:      {         if (alpha <= NoiseEpsilon)         sigma=MaxRGB; 
       else$         sigma=sqrt(-2.0*log(alpha));*       beta=(rand() & NoiseMask)/NoiseMask;       value=(double) pixel+ C         pixel*SigmaMultiplicativeGaussian*sigma*cos(2.0*M_PI*beta);        break;     }      case ImpulseNoise:     { %       if (alpha < (SigmaImpulse/2.0))          value=0;        else /          if (alpha >= (1.0-(SigmaImpulse/2.0)))             value=MaxRGB;
          else             value=pixel;        break;     }      case LaplacianNoise:     {        if (alpha <= 0.5) 	         { $           if (alpha <= NoiseEpsilon)(             value=(double) pixel-MaxRGB;           else?             value=(double) pixel+SigmaLaplacian*log(2.0*alpha);            break;	         }        beta=1.0-alpha; %       if (beta <= (0.5*NoiseEpsilon)) $         value=(double) pixel+MaxRGB;
       else:         value=(double) pixel-SigmaLaplacian*log(2.0*beta);       break;     }      case PoissonNoise:     {        register int
         i;  6       for (i=0; alpha > exp(-SigmaPoisson*pixel); i++)       { 5         beta=(double) (rand() & NoiseMask)/NoiseMask;          alpha=alpha*beta;        }        value=i/SigmaPoisson;        break;     }    }    if (value < 0.0)     return(0);   if (value > MaxRGB)      return(MaxRGB);     return((Quantum) (value+0.5)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   H S L T r a n s f o r m                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method HSLTransform converts a (hue, saturation, luminosity) to a %  (red, green, blue) triple.  % 1 %  The format of the HSLTransformImage method is:  % B %      void HSLTransform(const double hue,const double saturation,K %        const double luminosity,Quantum *red,Quantum *green,Quantum *blue)  % + %  A description of each parameter follows:  % A %    o hue, saturation, luminosity: A double value representing a ( %      component of the HSL color space. % H %    o red, green, blue: A pointer to a pixel component of type Quantum. %  %  */B Export void HSLTransform(const double hue,const double saturation,D   const double luminosity,Quantum *red,Quantum *green,Quantum *blue) {    double     b,     g,     r,     v,     x,     y,     z;     /*"     Convert HSL to RGB colorspace.   */"   assert(red != (Quantum *) NULL);$   assert(green != (Quantum *) NULL);#   assert(blue != (Quantum *) NULL); 9   v=(luminosity <= 0.5) ? (luminosity*(1.0+saturation)) : 2     (luminosity+saturation-luminosity*saturation);+   if ((saturation == 0.0) || (hue == -1.0))      { =       *red=(Quantum) floor((luminosity*(double) MaxRGB)+0.5); ?       *green=(Quantum) floor((luminosity*(double) MaxRGB)+0.5); >       *blue=(Quantum) floor((luminosity*(double) MaxRGB)+0.5);
       return;      }    y=2*luminosity-v; &   x=y+(v-y)*(6.0*hue-(int) (6.0*hue));&   z=v-(v-y)*(6.0*hue-(int) (6.0*hue));   switch ((int) (6.0*hue))   { "     default: r=v; g=x; b=y; break;!     case 0: r=v; g=x; b=y; break; !     case 1: r=z; g=v; b=y; break; !     case 2: r=y; g=v; b=x; break; !     case 3: r=y; g=z; b=v; break; !     case 4: r=x; g=y; b=v; break; !     case 5: r=v; g=y; b=z; break;    } 0   *red=(Quantum) floor((r*(double) MaxRGB)+0.5);2   *green=(Quantum) floor((g*(double) MaxRGB)+0.5);1   *blue=(Quantum) floor((b*(double) MaxRGB)+0.5);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   H u l l                                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method Hull implements the eight hull algorithm described in Applied F %  Optics, Vol. 24, No. 10, 15 May 1985, "Geometric filter for SpeckleL %  Reduction", by Thomas R Crimmins.  Each pixel in the image is replaced byK %  one of its eight of its surrounding pixels using a polarity and negative  %  hull function.  % $ %  The format of the Hull method is: % J %      void Hull(const int x_offset,const int y_offset,const int polarity,R %        const unsigned int columns,const unsigned int rows,Quantum *f,Quantum *g) % + %  A description of each parameter follows:  % J %    o x_offset, y_offset: An integer value representing the offset of the& %      current pixel within the image. % ? %    o polarity: An integer value declaring the polarity (+,-).  % L %    o columns, rows: Specifies the number of rows and columns in the image. % B %    o f, g: A pointer to an image pixel and one of it's neighbor. %  %  */J Export void Hull(const int x_offset,const int y_offset,const int polarity,K   const unsigned int columns,const unsigned int rows,Quantum *f,Quantum *g)  {    int      y;     register int     x;     register Quantum     *p,      *q,      *r,      *s;   	   Quantum      v;      assert(f != (Quantum *) NULL);    assert(g != (Quantum *) NULL);   p=f+(columns+2);   q=g+(columns+2);,   r=p+(y_offset*((int) columns+2)+x_offset);    for (y=0; y < (int) rows; y++)   {      p++;     q++;     r++;     if (polarity > 0) '       for (x=0; x < (int) columns; x++)        {          v=(*p);          if (*r > v)            v++;
         *q=v;          p++;         q++;         r++;       }      else'       for (x=0; x < (int) columns; x++)        {          v=(*p); !         if (v > (Quantum) (*r+1))            v--;
         *q=v;          p++;         q++;         r++;       }      p++;     q++;     r++;   }    p=f+(columns+2);   q=g+(columns+2);,   r=q+(y_offset*((int) columns+2)+x_offset);,   s=q-(y_offset*((int) columns+2)+x_offset);    for (y=0; y < (int) rows; y++)   {      p++;     q++;     r++;     s++;     if (polarity > 0) '       for (x=0; x < (int) columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) > v) && (*r > v))            v++;
         *p=v;          p++;         q++;         r++;         s++;       }      else'       for (x=0; x < (int) columns; x++)        {          v=(*q); /         if (((Quantum) (*s+1) < v) && (*r < v))            v--;
         *p=v;          p++;         q++;         r++;         s++;       }      p++;     q++;     r++;     s++;   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I n t e r p o l a t e C o l o r                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method InterpolateColor applies bi-linear interpolation between a pixel and %  it's neighbors. % 0 %  The format of the InterpolateColor method is: % G %      PixelPacket InterpolateColor(Image *image,const double x_offset,  %        const double y_offset)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % M %    o x_offset,y_offset: A double representing the current (x,y) position of  %      the pixel.  %  %  */G Export PixelPacket InterpolateColor(Image *image,const double x_offset,    const double y_offset) {    double
     alpha,	     beta;   
   PixelPacket      p,     q,     r,     s;     register double      x,     y;  "   assert(image != (Image *) NULL);
   x=x_offset; 
   y=y_offset; J   if ((x < -1) || (x >= image->columns) || (y < -1) || (y >= image->rows))$     return(image->background_color);P   if ((x >= 0) && (y >= 0) && (x < (image->columns-1)) && (y < (image->rows-1)))     {        register PixelPacket         *t;   1       t=GetPixelCache(image,(int) x,(int) y,2,2); $       if (t == (PixelPacket *) NULL)(         return(image->background_color);       p=(*t++);        q=(*t++);        r=(*t++);        s=(*t++);      }    else     {         p=image->background_color;       if ((x >= 0) && (y >= 0)) 	         { 7           if (GetPixelCache(image,(int) x,(int) y,1,1))              p=(*image->pixels); 	         }         q=image->background_color;/       if (((x+1) < image->columns) && (y >= 0)) 	         { 9           if (GetPixelCache(image,(int) x+1,(int) y,1,1))              q=(*image->pixels); 	         }         r=image->background_color;,       if ((x >= 0) && ((y+1) < image->rows))	         { 9           if (GetPixelCache(image,(int) x,(int) y+1,1,1))              r=(*image->pixels); 	         }         s=image->background_color;<       if (((x+1) < image->columns) && ((y+1) < image->rows))	         { ;           if (GetPixelCache(image,(int) x+1,(int) y+1,1,1))              s=(*image->pixels); 	         }      }    x-=floor(x);   y-=floor(y);   alpha=1.0-x;
   beta=1.0-y; ;   p.red=beta*(alpha*p.red+x*q.red)+y*(alpha*r.red+x*s.red); E   p.green=beta*(alpha*p.green+x*q.green)+y*(alpha*r.green+x*s.green); @   p.blue=beta*(alpha*p.blue+x*q.blue)+y*(alpha*r.blue+x*s.blue);O   p.opacity=beta*(alpha*p.opacity+x*q.opacity)+y*(alpha*r.opacity+x*s.opacity);    return(p); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   M o d u l a t e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method Modulate modulates the hue, saturation, and brightness of an	 %  image.  % - %  The format of the ModulateImage method is:  % B %      void Modulate(double percent_hue,double percent_saturation,M %        double percent_brightness,Quantum *red,Quantum *green,Quantum *blue)  %        blue) % + %  A description of each parameter follows:  % J %    o percent_hue, percent_saturation, percent_brightness: A double valueM %      representing the percent change in a component of the HSL color space.  % H %    o red, green, blue: A pointer to a pixel component of type Quantum. %  %  */B Export void Modulate(double percent_hue,double percent_saturation,F   double percent_brightness,Quantum *red,Quantum *green,Quantum *blue) {    double     brightness,      hue,     saturation;      /*>     Increase or decrease color brightness, saturation, or hue.   */"   assert(red != (Quantum *) NULL);$   assert(green != (Quantum *) NULL);#   assert(blue != (Quantum *) NULL); ?   TransformHSL(*red,*green,*blue,&hue,&saturation,&brightness); '   brightness+=percent_brightness/100.0;    if (brightness < 0.0)      brightness=0.0;    else     if (brightness > 1.0)        brightness=1.0; '   saturation+=percent_saturation/100.0;    if (saturation < 0.0)      saturation=0.0;    else     if (saturation > 1.0)        saturation=1.0;    if (hue != -1.0)     {        hue+=percent_hue/100.0;        if (hue < 0.0)         hue+=1.0; 
       else         if (hue > 1.0)           hue-=1.0;      } 9   HSLTransform(hue,saturation,brightness,red,green,blue);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   T r a n s f o r m H S L                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method TransformHSL converts a (red, green, blue) to a (hue, saturation,  %  luminosity) triple. % , %  The format of the TransformHSL method is: % ? %      void TransformHSL(const Quantum red,const Quantum green, N %        const Quantum blue,double *hue,double *saturation,double *luminosity) % + %  A description of each parameter follows:  % I %    o red, green, blue: A Quantum value representing the red, green, and " %      blue component of a pixel.. % N %    o hue, saturation, luminosity: A pointer to a double value representing a( %      component of the HSL color space. %  %  */? Export void TransformHSL(const Quantum red,const Quantum green, G   const Quantum blue,double *hue,double *saturation,double *luminosity)  {    double     b,
     delta,     g,     max,     min,     r;     /*"     Convert RGB to HSL colorspace.   */!   assert(hue != (double *) NULL); (   assert(saturation != (double *) NULL);(   assert(luminosity != (double *) NULL);!   r=(double) red/(double) MaxRGB; #   g=(double) green/(double) MaxRGB; "   b=(double) blue/(double) MaxRGB;   max=Max(r,Max(g,b));   min=Min(r,Min(g,b));   *hue=(-1.0);   *saturation=0.0;   *luminosity=(min+max)/2.0;   delta=max-min;   if (delta == 0.0)      return; G   *saturation=delta/((*luminosity <= 0.5) ? (min+max) : (2.0-max-min));    if (r == max) <     *hue=(g == min ? 5.0+(max-b)/delta : 1.0-(max-g)/delta);   else     if (g == max) >       *hue=(b == min ? 1.0+(max-r)/delta : 3.0-(max-b)/delta);     else>       *hue=(r == min ? 3.0+(max-g)/delta : 5.0-(max-r)/delta);   *hue/=6.0; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   U p s a m p l e                                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 1 %  Method Upsample doubles the size of the image.  % ( %  The format of the UpSample method is: % H %      void Upsample(const unsigned int width,const unsigned int height,? %        const unsigned int scaled_width,unsigned char *pixels)  % + %  A description of each parameter follows:  % J %    o width,height:  Unsigned values representing the width and height of %      the image pixel array.  % M %    o scaled_width:  Specifies the final width of the upsampled pixel array.  % J %    o pixels:  An unsigned char containing the pixel data.  On output the* %      upsampled pixels are returned here. %  %  */H Export void Upsample(const unsigned int width,const unsigned int height,8   const unsigned int scaled_width,unsigned char *pixels) {    register int     x,     y;     register unsigned char     *p,      *q,      *r;      /*L     Create a new image that is a integral size greater than an existing one.   */+   assert(pixels != (unsigned char *) NULL); "   for (y=0; y < (int) height; y++)   { 1     p=pixels+(height-1-y)*scaled_width+(width-1); ?     q=pixels+((height-1-y) << 1)*scaled_width+((width-1) << 1);      *q=(*p);     *(q+1)=(*(p));#     for (x=1; x < (int) width; x++)      { 
       p--;       q-=2;        *q=(*p);0       *(q+1)=(((int) *p)+((int) *(p+1))+1) >> 1;     }    } &   for (y=0; y < (int) (height-1); y++)   { #     p=pixels+(y << 1)*scaled_width;      q=p+scaled_width;      r=q+scaled_width; '     for (x=0; x < (int) (width-1); x++)      { (       *q=(((int) *p)+((int) *r)+1) >> 1;J       *(q+1)=(((int) *p)+((int) *(p+2))+((int) *r)+((int) *(r+2))+2) >> 2;       q+=2;        p+=2;        r+=2;      } ,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;,     *q++=(((int) *p++)+((int) *r++)+1) >> 1;   } %   p=pixels+(2*height-2)*scaled_width; %   q=pixels+(2*height-1)*scaled_width; 3   (void) memcpy(q,p,2*width*sizeof(unsigned char));  } 