 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                         GGGG  RRRR    AAA   Y   Y                           % O %                        G      R   R  A   A   Y Y                            % O %                        G  GG  RRRR   AAAAA    Y                             % O %                        G   G  R R    A   A    Y                             % O %                         GGG   R  R   A   A    Y                             % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d G R A Y I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadGRAYImage reads an image of raw grayscale bytes and returns it. N %  It allocates the memory necessary for the new Image structure and returns a %  pointer to the new image. % - %  The format of the ReadGRAYImage method is:  % 8 %      Image *ReadGRAYImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method ReadGRAYImage returns a pointer to the image afterJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *ReadGRAYImage(const ImageInfo *image_info) {    Image      *image;      int 
     count,     y;     register int     i,     x;     unsigned char      *scanline;     unsigned int     packet_size,     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL); 2   if ((image->columns == 0) || (image->rows == 0))>     ReaderExit(OptionWarning,"Must specify image size",image);   /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);#   for (i=0; i < image->offset; i++)      (void) ReadByte(image);    /*#     Allocate memory for a scanline.    */'   packet_size=image->depth > 8 ? 2 : 1;    scanline=(unsigned char *)M     AllocateMemory(packet_size*image->tile_info.width*sizeof(unsigned char)); )   if (scanline == (unsigned char *) NULL) F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);    if (image_info->subrange != 0)/     while (image->scene < image_info->subimage)      {        /*         Skip to next image.        */       image->scene++; +       for (y=0; y < (int) image->rows; y++) K         (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);      } #   x=packet_size*image->tile_info.x;    do   {      /*       Create linear colormap.      */     image->class=PseudoClass; $     image->colors=1 << image->depth;#     image->colormap=(PixelPacket *) 8       AllocateMemory(image->colors*sizeof(PixelPacket));0     if (image->colormap == (PixelPacket *) NULL)H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);+     for (i=0; i < (int) image->colors; i++)      { )       image->colormap[i].red=(Quantum) i; +       image->colormap[i].green=(Quantum) i; *       image->colormap[i].blue=(Quantum) i;     }      /*,       Convert raster image to pixel packets.     */*     for (y=0; y < image->tile_info.y; y++)I       (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); )     for (y=0; y < (int) image->rows; y++)      { 9       if ((y > 0) || (image->previous == (Image *) NULL)) K         (void) ReadBlob(image,packet_size*image->tile_info.width,scanline); 5       if (!SetPixelCache(image,0,y,image->columns,1))          break;3       ReadPixelCache(image,GrayQuantum,scanline+x); !       if (!SyncPixelCache(image))          break;,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(LoadImageText,y,image->rows);      } A     count=image->tile_info.height-image->rows-image->tile_info.y;      for (y=0; y < count; y++) I       (void) ReadBlob(image,packet_size*image->tile_info.width,scanline);      if (EOFBlob(image)) M       MagickWarning(CorruptImageWarning,"not enough pixels",image->filename);      SyncImage(image);      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;F     count=ReadBlob(image,packet_size*image->tile_info.width,scanline);     if (count > 0)       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (count > 0);   FreeMemory(scanline); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e G R A Y I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method WriteGRAYImage writes an image to a file as gray scale intensity
 %  values. % . %  The format of the WriteGRAYImage method is: % L %      unsigned int WriteGRAYImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows.  % I %    o status: Method WriteGRAYImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L Export unsigned int WriteGRAYImage(const ImageInfo *image_info,Image *image) {    int      y;     unsigned char      *pixels;     unsigned int     packet_size,
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   /*2     Convert image to gray scale PseudoColor class.   */   image->depth=QuantumDepth;
   scene=0;   do   {      /*!       Allocate memory for pixels.      */+     TransformRGBImage(image,RGBColorspace); (     packet_size=image->depth > 8 ? 2: 1;     pixels=(unsigned char *)G       AllocateMemory(packet_size*image->columns*sizeof(unsigned char)); )     if (pixels == (unsigned char *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     /*)       Convert MIFF to GRAY raster pixels.      */)     for (y=0; y < (int) image->rows; y++)      { 5       if (!GetPixelCache(image,0,y,image->columns,1))          break;0       WritePixelCache(image,GrayQuantum,pixels);@       (void) WriteBlob(image,packet_size*image->columns,pixels);,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);      }      FreeMemory(pixels); &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 