 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            H   H  DDDD   FFFFF                              % O %                            H   H  D   D  F                                  % O %                            HHHHH  D   D  FFF                                % O %                            H   H  D   D  F                                  % O %                            H   H  DDDD   F                                  % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasHDF)  #include "hdf.h"
 #undef BSD #undef LOCAL #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s H D F                                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsHDF returns True if the image format type, identified by the %  magick string, is HDF.  % , %  The format of the ReadHDFImage method is: % 6 %      unsigned int IsHDF(const unsigned char *magick,# %        const unsigned int length)  % + %  A description of each parameter follows:  % J %    o status:  Method IsHDF returns True if the image format type is HDF. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */P Export unsigned int IsHDF(const unsigned char *magick,const unsigned int length) {    if (length < 4)      return(False);9   if (strncmp((char *) magick,"\016\003\023\001",4) == 0)      return(True);    return(False); }    #if defined(HasHDF)  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d H D F I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method ReadHDFImage reads a Hierarchical Data Format image file andM %  returns it.  It allocates the memory necessary for the new Image structure * %  and returns a pointer to the new image. % , %  The format of the ReadHDFImage method is: % 7 %      Image *ReadHDFImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadHDFImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadHDFImage(const ImageInfo *image_info)  {    ClassType 
     class;     Image      *image;      int      interlace,     is_palette,      status,      y;     int32      height,      length, 
     width;     register int     i,     x;     register unsigned char     *p;      register PixelPacket     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int     packet_size;     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read HDF image.    */   class=DirectClass;@   status=DF24getdims(image->filename,&width,&height,&interlace);   if (status == -1)      {        class=PseudoClass;E       status=DFR8getdims(image->filename,&width,&height,&is_palette);      }    if (status == -1) #     ReaderExit(CorruptImageWarning, =       "Image file or does not contain any image data",image);    do   {      /*!       Initialize image structure.      */     image->class=class;      image->columns=width;      image->rows=height; $     if (image->class == PseudoClass)       image->colors=256;     if (image_info->ping)        {          CloseBlob(image);          return(image);       } 4     packet_size=image->class == DirectClass ? 3 : 1;0     hdf_pixels=(unsigned char *) AllocateMemory(D       packet_size*image->columns*image->rows*sizeof(unsigned char));-     if (hdf_pixels == (unsigned char *) NULL) H       ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);$     if (image->class == PseudoClass)       {          unsigned char            *hdf_palette;   
         /*           Create colormap.
         */P         hdf_palette=(unsigned char *) AllocateMemory(768*sizeof(unsigned char));'         image->colormap=(PixelPacket *) <           AllocateMemory(image->colors*sizeof(PixelPacket));6         if ((hdf_palette == (unsigned char *) NULL) ||6             (image->colormap == (PixelPacket *) NULL))L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);L         (void) DFR8getimage(image->filename,hdf_pixels,(int) image->columns,)           (int) image->rows,hdf_palette);           reference=DFR8lastref();
         /*@           Convert HDF raster image to PseudoClass pixel packets.
         */         p=hdf_palette;         if (is_palette) !           for (i=0; i < 256; i++)            { 1             image->colormap[i].red=UpScale(*p++); 3             image->colormap[i].green=UpScale(*p++); 2             image->colormap[i].blue=UpScale(*p++);           }          else1           for (i=0; i < (int) image->colors; i++)            { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);            }           FreeMemory(hdf_palette);         p=hdf_pixels; -         for (y=0; y < (int) image->rows; y++) 	         { 9           if (!SetPixelCache(image,0,y,image->columns,1))              break;2           for (x=0; x < (int) image->columns; x++)%             image->indexes[x]=(*p++); %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }        }      else       { 
         /*@           Convert HDF raster image to DirectClass pixel packets.
         */O         (void) DF24getimage(image->filename,(void *) hdf_pixels,image->columns,            image->rows);           reference=DF24lastref();         p=hdf_pixels; B         image->interlace=interlace ? PlaneInterlace : NoInterlace;-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=SetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;           q=image->pixels;2           for (x=0; x < (int) image->columns; x++)           { !             q->red=UpScale(*p++); #             q->green=UpScale(*p++); "             q->blue=UpScale(*p++);             q++;           } %           if (!SyncPixelCache(image))              break;0           if (image->previous == (Image *) NULL)+             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(LoadImageText,y,image->rows); 	         }        } >     length=DFANgetlablen(image->filename,DFTAG_RIG,reference);     if (length > 0)        { 
         /*           Read the image label. 
         */         length+=MaxTextExtent;B         image->label=(char *) AllocateMemory(length*sizeof(char));*         if (image->label != (char *) NULL)P           DFANgetlabel(image->filename,DFTAG_RIG,reference,image->label,length);       } ?     length=DFANgetdesclen(image->filename,DFTAG_RIG,reference);      if (length > 0)        { 
         /*"           Read the image comments.
         */         length+=MaxTextExtent;E         image->comments=(char *) AllocateMemory(length*sizeof(char)); -         if (image->comments != (char *) NULL) J           DFANgetdesc(image->filename,DFTAG_RIG,reference,image->comments,             length);       }      FreeMemory(hdf_pixels); $     if (image->class == PseudoClass)       SyncImage(image);      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     class=DirectClass;B     status=DF24getdims(image->filename,&width,&height,&interlace);     if (status == -1)        {          class=PseudoClass;G         status=DFR8getdims(image->filename,&width,&height,&is_palette);        }      if (status != -1)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (status != -1); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }  #else 7 Export Image *ReadHDFImage(const ImageInfo *image_info)  { F   MagickWarning(MissingDelegateWarning,"HDF library is not available",     image_info->filename);   return((Image *) NULL);  }  #endif   #if defined(HasHDF)  /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H D F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method WriteHDFImage writes an image in the Hierarchial Data Format image
 %  format. % - %  The format of the WriteHDFImage method is:  % K %      unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteHDFImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  {    int      status,      y;     register int     i,     x;     register PixelPacket     *p;      register unsigned char     *q;      uint16     reference;     unsigned char      *hdf_pixels;     unsigned int     compression,     packet_size,
     scene;     /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   CloseBlob(image); 
   scene=0;   do   {      /*$       Initialize raster file header.     */+     TransformRGBImage(image,RGBColorspace); 5     packet_size=image->class == DirectClass ? 3 : 11; K     hdf_pixels=(unsigned char *) AllocateMemory(packet_size*image->columns* )       image->rows*sizeof(unsigned char)); -     if (hdf_pixels == (unsigned char *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);5     if (!IsPseudoClass(image) && !IsGrayImage(image))        { 
         /*3           Convert DirectClass packet to HDF pixels. 
         */         q=hdf_pixels; &         switch (image_info->interlace)	         {            case NoInterlace:            default:           {              /*4               No interlacing:  RGBRGBRGBRGBRGBRGB...             */"             DF24setil(DFIL_PIXEL);1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { '                 *q++=DownScale(p->red); )                 *q++=DownScale(p->green); (                 *q++=DownScale(p->blue);                 p++;               } 4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case LineInterlace:            {              /*E               Line interlacing:  RRR...GGG...BBB...RRR...GGG...BBB...              */!             DF24setil(DFIL_LINE); 1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { '                 *q++=DownScale(p->red);                  p++;               }                p=image->pixels;6               for (x=0; x < (int) image->columns; x++)               { )                 *q++=DownScale(p->green);                  p++;               }                p=image->pixels;6               for (x=0; x < (int) image->columns; x++)               { (                 *q++=DownScale(p->blue);                 p++;               } -               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows); 
             }              break;           }            case PlaneInterlace:"           case PartitionInterlace:           {              /*=               Plane interlacing:  RRRRRR...GGGGGG...BBBBBB...              */"             DF24setil(DFIL_PLANE);1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { '                 *q++=DownScale(p->red);                  p++;               } 
             } 3             ProgressMonitor(SaveImageText,100,400); 1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { )                 *q++=DownScale(p->green);                  p++;               } 
             } 3             ProgressMonitor(SaveImageText,250,400); 1             for (y=0; y < (int) image->rows; y++) 
             { :               p=GetPixelCache(image,0,y,image->columns,1);,               if (p == (PixelPacket *) NULL)                 break;6               for (x=0; x < (int) image->columns; x++)               { (                 *q++=DownScale(p->blue);                 p++;               } 
             } 3             ProgressMonitor(SaveImageText,400,400);              break;           } 	         }          if (scene == 0) B           status=DF24putimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);         elseB           status=DF24addimage(image->filename,(void *) hdf_pixels,(             image->columns,image->rows);          reference=DF24lastref();       }      else       { 
         /*3           Convert PseudoClass packet to HDF pixels. 
         */         q=hdf_pixels;          if (IsGrayImage(image)) /           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;4             for (x=0; x < (int) image->columns; x++)
             { ,               *q++=DownScale(Intensity(*p));               p++;
             } 2             if (image->previous == (Image *) NULL)-               if (QuantumTick(y,image->rows)) =                 ProgressMonitor(SaveImageText,y,image->rows);            }          else           {              unsigned char                *hdf_palette;   )             hdf_palette=(unsigned char *) 8               AllocateMemory(768*sizeof(unsigned char));6             if (hdf_palette == (unsigned char *) NULL)P               WriterExit(ResourceLimitWarning,"Memory allocation failed",image);             q=hdf_palette;3             for (i=0; i < (int) image->colors; i++) 
             { 5               *q++=DownScale(image->colormap[i].red); 7               *q++=DownScale(image->colormap[i].green); 6               *q++=DownScale(image->colormap[i].blue);
             } /             (void) DFR8setpalette(hdf_palette); $             FreeMemory(hdf_palette);             q=hdf_pixels; 1             for (y=0; y < (int) image->rows; y++) 
             { =               if (!GetPixelCache(image,0,y,image->columns,1))                  break;6               for (x=0; x < (int) image->columns; x++)               { '                 *q++=image->indexes[x];                  p++;               } 4               if (image->previous == (Image *) NULL)/                 if (QuantumTick(y,image->rows)) ?                   ProgressMonitor(SaveImageText,y,image->rows); 
             }            } M         compression=image_info->compression == NoCompression ? 0 : DFTAG_RLE;          if (scene == 0) B           status=DFR8putimage(image->filename,(void *) hdf_pixels,4             image->columns,image->rows,compression);         elseB           status=DFR8addimage(image->filename,(void *) hdf_pixels,4             image->columns,image->rows,compression);          reference=DFR8lastref();       } &     if (image->label != (char *) NULL)L       (void) DFANputlabel(image->filename,DFTAG_RIG,reference,image->label);)     if (image->comments != (char *) NULL) M       (void) DFANputdesc(image->filename,DFTAG_RIG,reference,image->comments, #         Extent(image->comments)+1);      FreeMemory(hdf_pixels); &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   return(status != -1);  }  #else K Export unsigned int WriteHDFImage(const ImageInfo *image_info,Image *image)  { F   MagickWarning(MissingDelegateWarning,"HDF library is not available",     image->filename);    return(False); }  #endif