 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        H   H  TTTTT  M   M  L                               % O %                        H   H    T    MM MM  L                               % O %                        HHHHH    T    M M M  L                               % O %                        H   H    T    M   M  L                               % O %                        H   H    T    M   M  LLLLL                           % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s H T M L                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method IsHTML returns True if the image format type, identified by the  %  magick string, is HTML. % - %  The format of the ReadHTMLImage method is:  % 7 %      unsigned int IsHTML(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % L %    o status:  Method IsHTML returns True if the image format type is HTML. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */7 Export unsigned int IsHTML(const unsigned char *magick,    const unsigned int length) {    if (length < 5)      return(False);.   if (strncmp((char *) magick,"<HTML",5) == 0)     return(True); .   if (strncmp((char *) magick,"<html",5) == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e H T M L I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method WriteHTMLImage writes an image in the HTML encoded image format. % . %  The format of the WriteHTMLImage method is: % L %      unsigned int WriteHTMLImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows.  % I %    o status: Method WriteHTMLImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */L Export unsigned int WriteHTMLImage(const ImageInfo *image_info,Image *image) {    char     buffer[MaxTextExtent],     filename[MaxTextExtent],     mapname[MaxTextExtent],      url[MaxTextExtent];      Image 
     *next;     ImageInfo      *local_info;     int      x,     y;     register char      *p;      unsigned int     height,      status, 
     width;     /*     Open image.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   CloseBlob(image); )   TransformRGBImage(image,RGBColorspace);    *url='\0';7   if ((Latin1Compare(image_info->magick,"FTP") == 0) || 6       (Latin1Compare(image_info->magick,"HTTP") == 0))     {        /*'         Extract URL base from filename.        */%       p=strrchr(image->filename,'/');        if (p)	         {            p++;0           (void) strcpy(url,image_info->magick);!           (void) strcat(url,":"); 2           url[Extent(url)+p-image->filename]='\0';@           (void) strncat(url,image->filename,p-image->filename);+           (void) strcpy(image->filename,p); 	         }      }    /*     Refer to image map file.   */*   (void) strcpy(filename,image->filename);$   AppendImageFormat("map",filename);0   (void) strcpy(mapname,BaseFilename(filename));6   (void) strcpy(image->filename,image_info->filename);*   (void) strcpy(filename,image->filename);(   local_info=CloneImageInfo(image_info);'   if (local_info == (ImageInfo *) NULL) B     WriterExit(FileOpenWarning,"Unable to allocate memory",image);   local_info->adjoin=True;   status=True;5   if (Latin1Compare(image_info->magick,"SHTML") != 0)      {        /*         Open output image file.        */8       status=OpenBlob(image_info,image,WriteBinaryType);       if (status == False)@         WriterExit(FileOpenWarning,"Unable to open file",image);       /*"         Write the HTML image file.       */7       (void) strcpy(buffer,"<html version=\"2.0\">\n"); 4       (void) WriteBlob(image,strlen(buffer),buffer);'       (void) strcpy(buffer,"<head>\n"); 4       (void) WriteBlob(image,strlen(buffer),buffer);7       (void) sprintf(buffer,"<title>%.1024s</title>\n", E         image->label ? image->label : BaseFilename(image->filename)); 4       (void) WriteBlob(image,strlen(buffer),buffer);(       (void) strcpy(buffer,"</head>\n");4       (void) WriteBlob(image,strlen(buffer),buffer);'       (void) strcpy(buffer,"<body>\n"); 4       (void) WriteBlob(image,strlen(buffer),buffer);)       (void) strcpy(buffer,"<center>\n"); 4       (void) WriteBlob(image,strlen(buffer),buffer);B       (void) sprintf(buffer,"<h1>%.1024s</h1>\n",image->filename);4       (void) WriteBlob(image,strlen(buffer),buffer);)       (void) strcpy(buffer,"<br><br>\n"); 4       (void) WriteBlob(image,strlen(buffer),buffer);.       (void) strcpy(filename,image->filename);(       AppendImageFormat("gif",filename);       (void) sprintf(buffer,A         "<img ismap usemap=#%.1024s src=\"%.1024s\" border=0>\n",          mapname,filename);4       (void) WriteBlob(image,strlen(buffer),buffer);       /*;         Determine the size and location of each image tile.        */       width=image->columns;        height=image->rows; 
       x=0;
       y=0;*       if (image->montage != (char *) NULL)B         (void) ParseGeometry(image->montage,&x,&y,&width,&height);       /*         Write an image map.        */<       (void) sprintf(buffer,"<map name=%.1024s>\n",mapname);4       (void) WriteBlob(image,strlen(buffer),buffer);<       (void) sprintf(buffer,"  <area href=""%.1024s""",url);4       (void) WriteBlob(image,strlen(buffer),buffer);,       if (image->directory == (char *) NULL)	         { I           (void) sprintf(buffer,"%.1024s shape=rect coords=0,0,%u,%u>\n", .             image->filename,width-1,height-1);8           (void) WriteBlob(image,strlen(buffer),buffer);	         } 
       else1         for (p=image->directory; *p != '\0'; p++)            if (*p != '\n') '             (void) WriteByte(image,*p);            else
             { H               (void) sprintf(buffer," shape=rect coords=%d,%d,%d,%d>\n",6                 x,y,x+(int) width-1,y+(int) height-1);<               (void) WriteBlob(image,strlen(buffer),buffer);!               if (*(p+1) != '\0')                  { H                   (void) sprintf(buffer,"  <area href=""%.1024s""",url);@                   (void) WriteBlob(image,strlen(buffer),buffer);                 }                x+=width; ,               if (x >= (int) image->columns)                 {                    x=0;                   y+=height;                 } 
             } '       (void) strcpy(buffer,"</map>\n"); 4       (void) WriteBlob(image,strlen(buffer),buffer);*       if (image->montage != (char *) NULL)	         {            char!             color[MaxTextExtent];              /*0             Make montage background transparent.           */,           FormatString(color,HexColorFormat,0             (unsigned int) image->pixels[0].red,2             (unsigned int) image->pixels[0].green,2             (unsigned int) image->pixels[0].blue);(           TransparentImage(image,color);	         } .       (void) strcpy(filename,image->filename);*       (void) strcpy(buffer,"</center>\n");4       (void) WriteBlob(image,strlen(buffer),buffer);(       (void) strcpy(buffer,"</body>\n");4       (void) WriteBlob(image,strlen(buffer),buffer);(       (void) strcpy(buffer,"</html>\n");4       status=WriteBlob(image,strlen(buffer),buffer);       CloseBlob(image);        /*+         Write the image as transparent GIF.        */.       (void) strcpy(image->filename,filename);/       AppendImageFormat("gif",image->filename);        next=image->next; !       image->next=(Image *) NULL; .       status|=WriteGIFImage(local_info,image);       image->next=next;        /*%         Determine image map filename.        */.       (void) strcpy(image->filename,filename);@       for (p=filename+Extent(filename)-1; p > (filename+1); p--)         if (*p == '.')           { @             (void) strncpy(image->filename,filename,p-filename);-             image->filename[p-filename]='\0';              break;           } 2       (void) strcat(image->filename,"_map.shtml");     }    /*     Open image map.    */4   status=OpenBlob(local_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   DestroyImageInfo(local_info);    /*7     Determine the size and location of each image tile.    */   width=image->columns;    height=image->rows;    x=0;   y=0;&   if (image->montage != (char *) NULL)>     (void) ParseGeometry(image->montage,&x,&y,&width,&height);   /*     Write an image map.    */8   (void) sprintf(buffer,"<map name=%.1024s>\n",mapname);0   (void) WriteBlob(image,strlen(buffer),buffer);8   (void) sprintf(buffer,"  <area href=""%.1024s""",url);0   (void) WriteBlob(image,strlen(buffer),buffer);(   if (image->directory == (char *) NULL)     { E       (void) sprintf(buffer,"%.1024s shape=rect coords=0,0,%u,%u>\n", *         image->filename,width-1,height-1);4       (void) WriteBlob(image,strlen(buffer),buffer);     }    else-     for (p=image->directory; *p != '\0'; p++)        if (*p != '\n') #         (void) WriteByte(image,*p); 
       else	         { H           (void) sprintf(buffer," shape=rect coords=%d,%d,%d,%d>\n",x,y,.             x+(int) width-1,y+(int) height-1);8           (void) WriteBlob(image,strlen(buffer),buffer);           if (*(p+1) != '\0') 
             { D               (void) sprintf(buffer,"  <area href=""%.1024s""",url);<               (void) WriteBlob(image,strlen(buffer),buffer);
             }            x+=width; (           if (x >= (int) image->columns)
             {                x=0;               y+=height;
             } 	         } #   (void) strcpy(buffer,"</map>\n"); 0   (void) WriteBlob(image,strlen(buffer),buffer);   CloseBlob(image); *   (void) strcpy(image->filename,filename);   return(status);  } 