 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            IIIII   CCCC   CCCC                              % O %                              I    C      C                                  % O %                              I    C      C                                  % O %                              I    C      C                                  % O %                            IIIII   CCCC   CCCC                              % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d I C C I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method ReadICCImage reads an image file in the ICC format and returns it.N %  It allocates the memory necessary for the new Image structure and returns aH %  pointer to the new image.  This method differs from the other decoderF %  methods in that only the color profile information is useful in the %  returned image. % , %  The format of the ReadICCImage method is: % 7 %      Image *ReadICCImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadICCImage returns a pointer to the image after L %      reading. A null image is returned if there is a memory shortage or if  %      the image cannot be read. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadICCImage(const ImageInfo *image_info)  {    Image      *image;      int      c;     register unsigned char     *q;      unsigned int     length,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read ICC image.    */   length=MaxTextExtent; -   image->color_profile.info=(unsigned char *) 1     AllocateMemory(length*sizeof(unsigned char)); *   for (q=image->color_profile.info; ; q++)   {      c=ReadByte(image);     if (c == EOF)        break;8     if ((q-image->color_profile.info+1) >= (int) length)       { @         image->color_profile.length=q-image->color_profile.info;         length<<=1; M         image->color_profile.info=(unsigned char *) ReallocateMemory((char *) B           image->color_profile.info,length*sizeof(unsigned char));@         if (image->color_profile.info == (unsigned char *) NULL)           break;@         q=image->color_profile.info+image->color_profile.length;       }      *q=(unsigned char) c;    }     image->color_profile.length=0;:   if (image->color_profile.info != (unsigned char *) NULL)<     image->color_profile.length=q-image->color_profile.info;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e I C C I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % : %  Method WriteICCImage writes an image in the ICC format. % - %  The format of the WriteICCImage method is:  % K %      unsigned int WriteICCImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteICCImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteICCImage(const ImageInfo *image_info,Image *image)  {    unsigned int     status;   '   if (image->color_profile.length == 0) C     WriterExit(FileOpenWarning,"No color profile available",image);    /*     Open image file.   */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);;   (void) WriteBlob(image,(int) image->color_profile.length, (     (char *) image->color_profile.info);   CloseBlob(image);    return(True);  } 