 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                     IIIII  M   M   AAA    GGGG  EEEEE                       % O %                       I    MM MM  A   A  G      E                           % O %                       I    M M M  AAAAA  G  GG  EEE                         % O %                       I    M   M  A   A  G   G  E                           % O %                     IIIII  M   M  A   A   GGGG  EEEEE                       % O %                                                                             % O %                                                                             % O %                          ImageMagick Image Methods                          % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasX11)  #include "xwindows.h"  #endif   /*   Constant declaration.  */
 const char   *DefaultPointSize = "12", "   *DefaultTileFrame = "15x15+3+3",&   *DefaultTileLabel = "%f\n%wx%h\n%b",(   *DefaultTileGeometry = "106x106+4+3>",*   *LoadImageText = "  Loading image...  ",,   *LoadImagesText = "  Loading images...  ",   *ReadBinaryType = "rb", $   *ReadBinaryUnbufferedType = "rbu",)   *SaveImageText = "  Saving image...  ", +   *SaveImagesText = "  Saving images...  ",    *WriteBinaryType = "wb";  
 const char+   *BackgroundColor = "#bdbdbd",  /* gray */ '   *BorderColor = "#bdbdbd",  /* gray */ )   *ForegroundColor = "#000",  /* black */ &   *MatteColor = "#bdbdbd";  /* gray */   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   A l l o c a t e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method AllocateImage allocates an Image structure and initializes each  %  field to a default value. % - %  The format of the AllocateImage method is:  % 8 %      Image *AllocateImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % J %    o allocated_image: Method AllocateImage returns a pointer to an imageL %      structure initialized to default values.  A null image is returned if" %      there is a memory shortage. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *AllocateImage(const ImageInfo *image_info) {    Image      *allocated_image;      int 
     flags;     /*     Allocate image structure.    */:   allocated_image=(Image *) AllocateMemory(sizeof(Image));(   if (allocated_image == (Image *) NULL)     { D       MagickWarning(ResourceLimitWarning,"Unable to allocate image",$         "Memory allocation failed");       return((Image *) NULL);      }    /*     Initialize Image structure.    */-   GetBlobInfo(&(allocated_image->blob_info)); &   allocated_image->file=(FILE *) NULL;    allocated_image->exempt=False;    allocated_image->status=False;#   allocated_image->temporary=False; "   *allocated_image->filename='\0';   allocated_image->filesize=0;   allocated_image->pipe=False;0   (void) strcpy(allocated_image->magick,"MIFF");*   allocated_image->comments=(char *) NULL;'   allocated_image->label=(char *) NULL; %   allocated_image->class=DirectClass;    allocated_image->matte=False; 4   allocated_image->compression=UndefinedCompression;   allocated_image->columns=0;    allocated_image->rows=0;&   allocated_image->depth=QuantumDepth;%   allocated_image->tile_info.width=0; &   allocated_image->tile_info.height=0;!   allocated_image->tile_info.x=0; !   allocated_image->tile_info.y=0;    allocated_image->offset=0;)   allocated_image->interlace=NoInterlace;    allocated_image->scene=0; -   allocated_image->units=UndefinedResolution; $   allocated_image->x_resolution=0.0;$   allocated_image->y_resolution=0.0;)   allocated_image->montage=(char *) NULL; +   allocated_image->directory=(char *) NULL; 1   allocated_image->colormap=(PixelPacket *) NULL;    allocated_image->colors=0;,   allocated_image->colorspace=RGBColorspace;4   allocated_image->rendering_intent=UndefinedIntent;   allocated_image->gamma=0.0; 2   allocated_image->chromaticity.red_primary.x=0.0;2   allocated_image->chromaticity.red_primary.y=0.0;4   allocated_image->chromaticity.green_primary.x=0.0;4   allocated_image->chromaticity.green_primary.y=0.0;3   allocated_image->chromaticity.blue_primary.x=0.0; 3   allocated_image->chromaticity.blue_primary.y=0.0; 2   allocated_image->chromaticity.white_point.x=0.0;2   allocated_image->chromaticity.white_point.y=0.0;*   allocated_image->color_profile.length=0;=   allocated_image->color_profile.info=(unsigned char *) NULL; )   allocated_image->iptc_profile.length=0; <   allocated_image->iptc_profile.info=(unsigned char *) NULL;1   GetCacheInfo(&(allocated_image->cache_handle)); "   allocated_image->cache_info.x=0;"   allocated_image->cache_info.y=0;&   allocated_image->cache_info.width=0;'   allocated_image->cache_info.height=0; /   allocated_image->pixels=(PixelPacket *) NULL; 0   allocated_image->indexes=(IndexPacket *) NULL;*   allocated_image->geometry=(char *) NULL;+   GetPageInfo(&allocated_image->page_info);    allocated_image->dispose=0;    allocated_image->delay=0;     allocated_image->iterations=1;   allocated_image->fuzz=0;(   allocated_image->filter=LanczosFilter;   allocated_image->blur=1.0;P   (void) QueryColorDatabase(BackgroundColor,&allocated_image->background_color);H   (void) QueryColorDatabase(BorderColor,&allocated_image->border_color);F   (void) QueryColorDatabase(MatteColor,&allocated_image->matte_color);-   allocated_image->normalized_mean_error=0.0; 0   allocated_image->normalized_maximum_error=0.0;*   allocated_image->mean_error_per_pixel=0;+   allocated_image->signature=(char *) NULL; )   *allocated_image->magick_filename='\0'; $   allocated_image->magick_columns=0;!   allocated_image->magick_rows=0; /   GetTimerInfo(&(allocated_image->timer_info)); !   allocated_image->tainted=False;     allocated_image->orphan=False;+   allocated_image->previous=(Image *) NULL; '   allocated_image->list=(Image *) NULL; '   allocated_image->next=(Image *) NULL; 0   allocated_image->restart_animation_here=False;'   if (image_info == (ImageInfo *) NULL)      return(allocated_image);   /*     Transfer image info.   */3   allocated_image->blob_info=image_info->blob_info; <   allocated_image->exempt=image_info->file != (FILE *) NULL;@   (void) strcpy(allocated_image->filename,image_info->filename);G   (void) strcpy(allocated_image->magick_filename,image_info->filename); <   (void) strcpy(allocated_image->magick,image_info->magick);(   if (image_info->size != (char *) NULL)     { 	       int 
         y;  -       (void) sscanf(image_info->size,"%ux%u", :         &allocated_image->columns,&allocated_image->rows);G       flags=ParseGeometry(image_info->size,&allocated_image->offset,&y, :         &allocated_image->columns,&allocated_image->rows);%       if ((flags & HeightValue) == 0) 7         allocated_image->rows=allocated_image->columns; @       allocated_image->tile_info.width=allocated_image->columns;>       allocated_image->tile_info.height=allocated_image->rows;     } (   if (image_info->tile != (char *) NULL),     if (!IsSubimage(image_info->tile,False))       { /         (void) sscanf(image_info->tile,"%ux%u", <           &allocated_image->columns,&allocated_image->rows);K         flags=ParseGeometry(image_info->tile,&allocated_image->tile_info.x, B           &allocated_image->tile_info.y,&allocated_image->columns,"           &allocated_image->rows);'         if ((flags & HeightValue) == 0) 9           allocated_image->rows=allocated_image->columns;        } 7   allocated_image->compression=image_info->compression; 3   allocated_image->interlace=image_info->interlace; +   allocated_image->units=image_info->units; +   if (image_info->density != (char *) NULL)      { 	       int          count;  P       count=sscanf(image_info->density,"%lfx%lf",&allocated_image->x_resolution,(         &allocated_image->y_resolution);       if (count != 2) D         allocated_image->y_resolution=allocated_image->x_resolution;     } (   if (image_info->page != (char *) NULL)<     ParseImageGeometry(PostscriptGeometry(image_info->page),B       &allocated_image->page_info.x,&allocated_image->page_info.y,L       &allocated_image->page_info.width,&allocated_image->page_info.height);+   if (image_info->dispose != (char *) NULL) 7     allocated_image->dispose=atoi(image_info->dispose); )   if (image_info->delay != (char *) NULL) 3     allocated_image->delay=atoi(image_info->delay); .   if (image_info->iterations != (char *) NULL)=     allocated_image->iterations=atoi(image_info->iterations); +   allocated_image->depth=image_info->depth; A   allocated_image->background_color=image_info->background_color; 9   allocated_image->border_color=image_info->border_color; 7   allocated_image->matte_color=image_info->matte_color;    return(allocated_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O +   A l l o c a t e N e x t I m a g e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method AllocateNextImage allocates an Image structure and initializes each  %  field to a default value. % 1 %  The format of the AllocateNextImage method is:  % G %      void AllocateNextImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  %  %  */G Export void AllocateNextImage(const ImageInfo *image_info,Image *image)  {    /*     Allocate image structure.    */"   assert(image != (Image *) NULL);'   ClosePixelCache(image->cache_handle); (   image->next=AllocateImage(image_info);$   if (image->next == (Image *) NULL)     return; 7   (void) strcpy(image->next->filename,image->filename); '   if (image_info != (ImageInfo *) NULL) >     (void) strcpy(image->next->filename,image_info->filename);*   image->next->blob_info=image->blob_info;(   image->next->filesize=image->filesize;    image->next->file=image->file;(   image->next->filesize=image->filesize;$   image->next->scene=image->scene+1;   image->next->previous=image; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   A n i m a t e I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method AnimateImages displays one or more images to an X window.  % - %  The format of the AnimateImages method is:  % K %      unsigned int AnimateImages(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows:  % L %    o status: Method AnimateImages returns True if the images are displayed3 %      in an X window, otherwise False is returned.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  %  %  */K Export unsigned int AnimateImages(const ImageInfo *image_info,Image *image)  {  #if defined(HasX11)    char     *client_name;   	   Display 
     *display;   
   XrmDatabase      resource_database;     XResourceInfo 
     resource;   &   display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     return(False);   XSetErrorHandler(XError); +   client_name=SetClientName((char *) NULL); >   resource_database=XGetResourceDatabase(display,client_name);<   XGetResourceInfo(resource_database,client_name,&resource);%   *resource.image_info=(*image_info);    resource.immutable=True;)   if (image_info->delay != (char *) NULL) +     resource.delay=atoi(image_info->delay); @   (void) XAnimateImages(display,&resource,&client_name,1,image);   XCloseDisplay(display);    return(True);  #else F   MagickWarning(MissingDelegateWarning,"X11 library is not available",     image->filename);    return(False); #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     A p p e n d I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method AppendImages appends a set of images.  All the input images mustG %  have the same width or height.  Images of the same width are stacked G %  top-to-bottom.  Images of the same height are stacked left-to-right. L %  If stack is false, rectangular images are stacked left-to-right otherwise %  top-to-bottom.  % + %  The format of the AppendImage method is:  % B %      Image *AppendImages(Image *images,const unsigned int stack) % + %  A description of each parameter follows:  % G %    o images: The address of a structure of type Image;  returned from  %      ReadImage.  % D %    o stack: An unsigned value other than stacks rectangular images- %      top-to-bottom otherwise left-to-right.  %  %  */B Export Image *AppendImages(Image *images,const unsigned int stack) { : #define AppendImageText  "  Appending image sequence...  "     Image      *appended_image,     *image;      register int     i;     unsigned int     height, 
     scene,
     width;     /*1     Ensure the images have the same column width.    */#   assert(images != (Image *) NULL); %   if (images->next == (Image *) NULL)      { ;       MagickWarning(OptionWarning,"Unable to append image", #         "image sequence required");        return((Image *) NULL);      } F   for (image=images->next; image != (Image *) NULL; image=image->next).     if ((image->columns != images->columns) &&&         (image->rows != images->rows))       { =         MagickWarning(OptionWarning,"Unable to append image", ,           "image widths or heights differ");         return((Image *) NULL);        }    width=images->columns;   height=images->rows;F   for (image=images->next; image != (Image *) NULL; image=image->next)   {      width+=image->columns;     height+=image->rows;   }    /*'     Initialize append image attributes.    */;   if ((images->columns != images->next->columns) || !stack) >     appended_image=CloneImage(images,width,images->rows,True);   elseB     appended_image=CloneImage(images,images->columns,height,True);'   if (appended_image == (Image *) NULL)      { B       MagickWarning(ResourceLimitWarning,"Unable to append image",$         "Memory allocation failed");       return((Image *) NULL);      } 
   scene=0;;   if ((images->columns != images->next->columns) || !stack)      {        register int
         x;         /*         Stack left-to-right.       */
       x=0;D       for (image=images; image != (Image *) NULL; image=image->next)       { (         if (image->class == DirectClass),           appended_image->class=DirectClass;D         CompositeImage(appended_image,ReplaceCompositeOp,image,x,0);         x+=image->columns;I         ProgressMonitor(AppendImageText,scene++,GetNumberScenes(images));        }      }    else     {        register int
         y;         /*         Stack top-to-bottom.       */
       y=0;D       for (image=images; image != (Image *) NULL; image=image->next)       { (         if (image->class == DirectClass),           appended_image->class=DirectClass;D         CompositeImage(appended_image,ReplaceCompositeOp,image,0,y);         y+=image->rows; G         ProgressMonitor(AppendImageText,scene,GetNumberScenes(images));          scene++;       }      } +   if (appended_image->class == PseudoClass)      {        unsigned int         global_colormap;         /*G         Determine if the sequence of images has the identical colormap.        */       global_colormap=True; D       for (image=images; image != (Image *) NULL; image=image->next)       { ,         if ((image->class == DirectClass) ||.             (image->colors != images->colors))           { "             global_colormap=False;             break;           } 0         for (i=0; i < (int) images->colors; i++)N           if (!ColorMatch(image->colormap[i],images->colormap[i],image->fuzz))
             { $               global_colormap=False;               break;
             }        }        if (!global_colormap) *         appended_image->class=DirectClass;     }    return(appended_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     A v e r a g e I m a g e s                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method AverageImages averages a set of images.  All the input images must %  be the same size in pixels. % , %  The format of the AverageImage method is: % 0 %      Image *AverageImages(const Image *images) % + %  A description of each parameter follows:  % H %    o averaged_image: Method AverageImages returns the mean pixel value %      for an image sequence.  % G %    o images: The address of a structure of type Image;  returned from  %      ReadImage.  %  %  */* Export Image *AverageImages(Image *images) { 9 #define AverageImageText  "  Average image sequence...  "      typedef struct _SumPacket    { 
     double
       red,       green,       blue,        opacity;   } SumPacket;     Image      *image;      Image      *averaged_image;     int      y;     register int     i,     x;     register PixelPacket     *p,      *q;      SumPacket 	     *sum;      unsigned int     number_scenes;  #   assert(images != (Image *) NULL); %   if (images->next == (Image *) NULL)      { <       MagickWarning(OptionWarning,"Unable to average image",#         "image sequence required");        return((Image *) NULL);      }    /*(     Ensure the images are the same size.   */@   for (image=images; image != (Image *) NULL; image=image->next)   { .     if ((image->columns != images->columns) ||&         (image->rows != images->rows))       { >         MagickWarning(OptionWarning,"Unable to average image",*           "images are not the same size");         return((Image *) NULL);        }    }    /*%     Allocate sum accumulation buffer.    */   sum=(SumPacket *) C     AllocateMemory(images->columns*images->rows*sizeof(SumPacket));     if (sum == (SumPacket *) NULL)     { C       MagickWarning(ResourceLimitWarning,"Unable to average image", $         "Memory allocation failed");       return((Image *) NULL);      } :   for (i=0; i < (int) (images->columns*images->rows); i++)   {      sum[i].red=0.0;      sum[i].green=0.0;      sum[i].blue=0.0;     sum[i].opacity=0.0;    }    /*(     Initialize average image attributes.   */F   averaged_image=CloneImage(images,images->columns,images->rows,True);'   if (averaged_image == (Image *) NULL)      { C       MagickWarning(ResourceLimitWarning,"Unable to average image", $         "Memory allocation failed");       FreeMemory(sum);       return((Image *) NULL);      } $   averaged_image->class=DirectClass;   /*0     Compute sum over each pixel color component.   */   number_scenes=0;@   for (image=images; image != (Image *) NULL; image=image->next)   {      i=0;)     for (y=0; y < (int) image->rows; y++)      { 2       p=GetPixelCache(image,0,y,image->columns,1);$       if (p == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       {          sum[i].red+=p->red;          sum[i].green+=p->green;          sum[i].blue+=p->blue; #         sum[i].opacity+=p->opacity;          p++;         i++;       }      }      number_scenes++;   }    /*     Average image pixels.    */   i=0;0   for (y=0; y < (int) averaged_image->rows; y++)   { B     q=SetPixelCache(averaged_image,0,y,averaged_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;5     for (x=0; x < (int) averaged_image->columns; x++)      { F       q->red=(Quantum) ((sum[i].red+number_scenes/2.0)/number_scenes);J       q->green=(Quantum) ((sum[i].green+number_scenes/2.0)/number_scenes);H       q->blue=(Quantum) ((sum[i].blue+number_scenes/2.0)/number_scenes);N       q->opacity=(Quantum) ((sum[i].opacity+number_scenes/2.0)/number_scenes);
       q++;
       i++;     } (     if (!SyncPixelCache(averaged_image))       break;,     if (QuantumTick(y,averaged_image->rows))?       ProgressMonitor(AverageImageText,y,averaged_image->rows);    }    FreeMemory(sum);   return(averaged_image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o n e I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method CloneImage returns a copy of all fields of the input image.  TheK %  image pixels are copied only if the columns and rows of the cloned image   %  are the same as the original. % * %  The format of the CloneImage method is: % A %      Image *CloneImage(Image *image,const unsigned int columns, ; %        const unsigned int rows,const unsigned int orphan)  % + %  A description of each parameter follows:  % J %    o clone_image: Method CloneImage returns a pointer to the image afterH %      copying.  A null image is returned if there is a memory shortage. % 7 %    o image: The address of a structure of type Image.  % M %    o columns: An integer that specifies the number of columns in the copied 
 %      image.  % G %    o rows: An integer that specifies the number of rows in the copied 
 %      image.  % 7 %    o orphan:  if true, consider this image an orphan.  %  %  */A Export Image *CloneImage(Image *image,const unsigned int columns, 4   const unsigned int rows,const unsigned int orphan) {    Image      *clone_image;      unsigned long      length;      /*     Allocate image structure.    */"   assert(image != (Image *) NULL);6   clone_image=(Image *) AllocateMemory(sizeof(Image));$   if (clone_image == (Image *) NULL)     return((Image *) NULL);    /*     Clone the image.   */   *clone_image=(*image);&   clone_image->comments=(char *) NULL;#   clone_image->label=(char *) NULL; %   clone_image->montage=(char *) NULL; '   clone_image->directory=(char *) NULL; '   clone_image->signature=(char *) NULL; '   if (image->comments != (char *) NULL) ?     (void) CloneString(&clone_image->comments,image->comments); $   if (image->label != (char *) NULL)9     (void) CloneString(&clone_image->label,image->label); .   if (image->colormap != (PixelPacket *) NULL)     {        /*-         Allocate and copy the image colormap.        *//       length=image->colors*sizeof(PixelPacket); C       clone_image->colormap=(PixelPacket *) AllocateMemory(length); 8       if (clone_image->colormap == (PixelPacket *) NULL)         return((Image *) NULL); B       (void) memcpy(clone_image->colormap,image->colormap,length);     } &   if (image->color_profile.length > 0)     {        /*0         Allocate and copy the image ICC profile.       */?       length=image->color_profile.length*sizeof(unsigned char); O       clone_image->color_profile.info=(unsigned char *) AllocateMemory(length); D       if (clone_image->color_profile.info == (unsigned char *) NULL)         return((Image *) NULL); N       (void) memcpy(clone_image->color_profile.info,image->color_profile.info,         length);     } %   if (image->iptc_profile.length > 0)      {        /*1         Allocate and copy the image IPTC profile.        */>       length=image->iptc_profile.length*sizeof(unsigned char);N       clone_image->iptc_profile.info=(unsigned char *) AllocateMemory(length);C       if (clone_image->iptc_profile.info == (unsigned char *) NULL)          return((Image *) NULL); L       (void) memcpy(clone_image->iptc_profile.info,image->iptc_profile.info,         length);     } '   GetBlobInfo(&clone_image->blob_info); +   GetCacheInfo(&clone_image->cache_handle);    clone_image->cache_info.x=0;   clone_image->cache_info.y=0;"   clone_image->cache_info.width=0;#   clone_image->cache_info.height=0; +   clone_image->pixels=(PixelPacket *) NULL; ,   clone_image->indexes=(IndexPacket *) NULL;;   if ((image->columns != columns) || (image->rows != rows))      { #       clone_image->columns=columns;        clone_image->rows=rows; %       clone_image->page_info.width=0; &       clone_image->page_info.height=0;     }    else     { 	       int 
         y;         /*         Clone pixel cache.       */+       for (y=0; y < (int) image->rows; y++)        { 7         if (!GetPixelCache(image,0,y,image->columns,1))            break;C         if (!SetPixelCache(clone_image,0,y,clone_image->columns,1))            break;(         if (image->class == PseudoClass)<           (void) memcpy(clone_image->indexes,image->indexes,0             image->columns*sizeof(IndexPacket));8         (void) memcpy(clone_image->pixels,image->pixels,.           image->columns*sizeof(PixelPacket));)         if (!SyncPixelCache(clone_image))            break;       } *       if (image->montage != (char *) NULL)A         (void) CloneString(&clone_image->montage,image->montage); ,       if (image->directory != (char *) NULL)E         (void) CloneString(&clone_image->directory,image->directory); ,       if (image->signature != (char *) NULL)E         (void) CloneString(&clone_image->signature,image->signature);      } 
   if (orphan)      {        clone_image->exempt=True; +       clone_image->previous=(Image *) NULL; '       clone_image->next=(Image *) NULL;      }    else     {        /*#         Link image into image list.        */2       if (clone_image->previous != (Image *) NULL)0         clone_image->previous->next=clone_image;.       if (clone_image->next != (Image *) NULL)0         clone_image->next->previous=clone_image;     }    return(clone_image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C l o n e I m a g e I n f o                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method CloneImageInfo makes a duplicate of the given image info, or if ! %  image info is NULL, a new one.  % . %  The format of the CloneImageInfo method is: % = %      ImageInfo *CloneImageInfo(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % I %    o clone_info: Method CloneImageInfo returns a duplicate of the given 6 %      image info, or if image info is NULL a new one. % , %    o image_info: a structure of type info. %  %  */= Export ImageInfo *CloneImageInfo(const ImageInfo *image_info)  {    ImageInfo      *clone_info;  =   clone_info=(ImageInfo *) AllocateMemory(sizeof(ImageInfo)); '   if (clone_info == (ImageInfo *) NULL) B     MagickError(ResourceLimitWarning,"Unable to clone image info","       "Memory allocation failed");'   if (image_info == (ImageInfo *) NULL)      {        GetImageInfo(clone_info);        return(clone_info);      }    *clone_info=(*image_info);(   if (image_info->size != (char *) NULL)6     clone_info->size=AllocateString(image_info->size);(   if (image_info->tile != (char *) NULL)6     clone_info->tile=AllocateString(image_info->tile);(   if (image_info->page != (char *) NULL)6     clone_info->page=AllocateString(image_info->page);/   if (image_info->server_name != (char *) NULL) D     clone_info->server_name=AllocateString(image_info->server_name);'   if (image_info->box != (char *) NULL) 4     clone_info->box=AllocateString(image_info->box);(   if (image_info->font != (char *) NULL)6     clone_info->font=AllocateString(image_info->font);'   if (image_info->pen != (char *) NULL) 4     clone_info->pen=AllocateString(image_info->pen);+   if (image_info->texture != (char *) NULL) <     clone_info->texture=AllocateString(image_info->texture);+   if (image_info->density != (char *) NULL) <     clone_info->density=AllocateString(image_info->density);+   if (image_info->dispose != (char *) NULL) <     clone_info->dispose=AllocateString(image_info->dispose);)   if (image_info->delay != (char *) NULL) 8     clone_info->delay=AllocateString(image_info->delay);.   if (image_info->iterations != (char *) NULL)B     clone_info->iterations=AllocateString(image_info->iterations);(   if (image_info->view != (char *) NULL)6     clone_info->view=AllocateString(image_info->view);   return(clone_info);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m m e n t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % D %  Method CommentImage initializes an image comment.  Optionally theH %  comment can include the image filename, type, width, height, or scene1 %  number by embedding special format characters.  % , %  The format of the CommentImage method is: % ; %      void CommentImage(Image *image,const char *comments)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % I %    o comments: The address of a character string containing the comment  %      format. %  %  */; Export void CommentImage(Image *image,const char *comments)  { '   if (image->comments != (char *) NULL)       FreeMemory(image->comments);C   image->comments=TranslateText((ImageInfo *) NULL,image,comments);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C o m p o s i t e I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method CompositeImage returns the second image composited onto the " %  first at the specified offsets. % . %  The format of the CompositeImage method is: % H %      void CompositeImage(Image *image,const CompositeOperator compose,F %        Image *composite_image,const int x_offset,const int y_offset) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 6 %    o compose: Specifies an image composite operator. % A %    o composite_image: The address of a structure of type Image.  % N %    o x_offset: An integer that specifies the column offset of the composited
 %      image.  % K %    o y_offset: An integer that specifies the row offset of the composited 
 %      image.  %  %  */H Export void CompositeImage(Image *image,const CompositeOperator compose,?   Image *composite_image,const int x_offset,const int y_offset)  {    int      height, 
     width,     y;     long	     blue, 
     green,     opacity,     red;  	   Quantum 
     midpoint, 
     shade;  
   PixelPacket 
     color;     register int     x;     register PixelPacket     *p,      *q;      double     saturation_scale,      brightness_scale,      brightness,      hue,     saturation;      /*     Check composite geometry.    */"   assert(image != (Image *) NULL);,   assert(composite_image != (Image *) NULL);.   if (((x_offset+(int) image->columns) < 0) ||+       ((y_offset+(int) image->rows) < 0) || J       (x_offset > (int) image->columns) || (y_offset > (int) image->rows))     { E       MagickWarning(ResourceLimitWarning,"Unable to composite image", +         "geometry does not contain image"); 
       return;      }    /*     Image must be uncompressed.    */   red=0;
   green=0;	   blue=0; 
   midpoint=0;    switch (compose)   {      case XorCompositeOp:     case PlusCompositeOp:      case MinusCompositeOp:     case AddCompositeOp:     case SubtractCompositeOp:      case DifferenceCompositeOp:      case BumpmapCompositeOp:     case BlendCompositeOp:     case ReplaceRedCompositeOp: !     case ReplaceGreenCompositeOp:       case ReplaceBlueCompositeOp:     {        image->class=DirectClass;        break;     } !     case ReplaceMatteCompositeOp:      {        if (!image->matte)!         MatteImage(image,Opaque);        break;     }      case DisplaceCompositeOp:      {        double         x_displace,          y_displace;          double         horizontal_scale,          vertical_scale;          Image          *displace_image;         register PixelPacket         *r;          /*$         Allocate the displace image.       */I       displace_image=CloneImage(composite_image,composite_image->columns, $         composite_image->rows,True);+       if (displace_image == (Image *) NULL) 	         { G           MagickWarning(ResourceLimitWarning,"Unable to display image", (             "Memory allocation failed");           return; 	         }        horizontal_scale=20.0;       vertical_scale=20.0;5       if (composite_image->geometry != (char *) NULL) 	         { 
           int              count;             /*E             Determine the horizontal and vertical displacement scale.            */=           count=sscanf(composite_image->geometry,"%lfx%lf\n", /             &horizontal_scale,&vertical_scale);            if (count == 1) ,             vertical_scale=horizontal_scale;	         }        /*<         Shift image pixels as defined by a displacement map.       */5       for (y=0; y < (int) composite_image->rows; y++)        { F         if (((y+y_offset) < 0) || ((y+y_offset) >= (int) image->rows))           continue; H         p=GetPixelCache(composite_image,0,y,composite_image->columns,1);=         q=GetPixelCache(image,0,y+y_offset,image->columns,1); F         r=GetPixelCache(displace_image,0,y,displace_image->columns,1);I         if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL) || (             (r == (PixelPacket *) NULL))           break;         q+=x_offset;:         for (x=0; x < (int) composite_image->columns; x++)	         { K           if (((x_offset+x) < 0) || ((x_offset+x) >= (int) image->columns)) 
             {                p++;               q++;               continue; 
             } ?           x_displace=(horizontal_scale*((double) Intensity(*p)- 2             ((MaxRGB+1) >> 1)))/((MaxRGB+1) >> 1);            y_displace=x_displace;%           if (composite_image->matte) <             y_displace=(vertical_scale*((double) p->opacity-4               ((MaxRGB+1) >> 1)))/((MaxRGB+1) >> 1);:           *r=InterpolateColor(image,x_offset+x+x_displace,#             y_offset+y+y_displace);            p++;           q++;           r++;	         } ,         if (!SyncPixelCache(displace_image))           break;       } %       composite_image=displace_image;        break;     }      case ModulateCompositeOp:      {        midpoint=MaxRGB/2;       saturation_scale=50.0;       brightness_scale=50.0;5       if (composite_image->geometry != (char *) NULL) 	         { 
           int              count;             /*:             Determine the brightness and saturation scale.           */=           count=sscanf(composite_image->geometry,"%lfx%lf\n", 1             &brightness_scale,&saturation_scale);            if (count == 1) .             saturation_scale=brightness_scale;	         }        brightness_scale/=100.0;       saturation_scale/=100.0;       break;     }      case ReplaceCompositeOp:     {        /*9         Promote image to DirectClass if colormaps differ.        */&       if (image->class == PseudoClass)	         { 8           if ((composite_image->class == DirectClass) ||9               (composite_image->colors != image->colors)) %             image->class=DirectClass;            else
             { 5               for (x=0; x < (int) image->colors; x++) 3                 if (!ColorMatch(image->colormap[x], 5                      composite_image->colormap[x],0))                    { -                     image->class=DirectClass;                      break;                   } 
             } 	         } 2       if (image->matte && !composite_image->matte)+         MatteImage(composite_image,Opaque);        break;     }      default:     {        /*$         Initialize image matte data.       */       if (!image->matte)	         { #           image->class=DirectClass; -           if (compose != AnnotateCompositeOp) %             MatteImage(image,Opaque); 	         } "       if (!composite_image->matte)	         { 4           (void) IsMonochromeImage(composite_image);9           for (y=0; y < (int) composite_image->rows; y++)            { L             p=GetPixelCache(composite_image,0,y,composite_image->columns,1);*             if (p == (PixelPacket *) NULL)               break;             if (y == 0)                {                  red=p->red;                  green=p->green;                  blue=p->blue; 7                 if (IsMonochromeImage(composite_image))                    { >                     red=composite_image->background_color.red;B                     green=composite_image->background_color.green;@                     blue=composite_image->background_color.blue;                   }                } >             for (x=0; x < (int) composite_image->columns; x++)
             {                 p->opacity=Opaque;;               if ((p->red == red) && (p->green == green) && $                   (p->blue == blue))'                 p->opacity=Transparent;                p++;
             } 1             if (!SyncPixelCache(composite_image))                break;           } -           composite_image->class=DirectClass; &           composite_image->matte=True;	         }        break;     }    }    /*      Initialize composited image.   */>   width=Min(composite_image->columns,image->columns-x_offset);9   height=Min(composite_image->rows,image->rows-y_offset);    for (y=0; y < height; y++)   {      if ((y+y_offset) < 0)        continue; 1     p=GetPixelCache(composite_image,0,y,width,1); >     q=GetPixelCache(image,Max(x_offset,0),y+y_offset,width,1);C     if ((p == (PixelPacket *) NULL) || (q == (PixelPacket *) NULL))        break;     for (x=0; x < width; x++)      {        if ((x+x_offset) < 0)          {              p++;           continue; 	         }        switch (compose)       { !         case AnnotateCompositeOp:          case OverCompositeOp:          default:	         { (           if (p->opacity == Transparent)
             {                red=q->red;                green=q->green;                blue=q->blue; !               opacity=q->opacity; 
             }            else%             if (p->opacity == Opaque)                {                  red=p->red;                  green=p->green;                  blue=p->blue; #                 opacity=p->opacity;                }              else               { #                 red=(unsigned long) H                   (p->red*p->opacity+q->red*(Opaque-p->opacity))/Opaque;%                 green=(unsigned long) L                   (p->green*p->opacity+q->green*(Opaque-p->opacity))/Opaque;$                 blue=(unsigned long)J                   (p->blue*p->opacity+q->blue*(Opaque-p->opacity))/Opaque;?                 opacity=(unsigned long) (p->opacity*p->opacity+ 9                   q->opacity*(Opaque-p->opacity))/Opaque;                }            break;	         }          case InCompositeOp: 	         { 9           red=(unsigned long) (p->red*q->opacity)/Opaque; =           green=(unsigned long) (p->green*q->opacity)/Opaque; ;           blue=(unsigned long) (p->blue*q->opacity)/Opaque; A           opacity=(unsigned long) (p->opacity*q->opacity)/Opaque;            break;	         }          case OutCompositeOp:	         { B           red=(unsigned long) (p->red*(Opaque-q->opacity))/Opaque;F           green=(unsigned long) (p->green*(Opaque-q->opacity))/Opaque;D           blue=(unsigned long) (p->blue*(Opaque-q->opacity))/Opaque;J           opacity=(unsigned long) (p->opacity*(Opaque-q->opacity))/Opaque;           break;	         }          case AtopCompositeOp: 	         {            red=(unsigned long) B             (p->red*q->opacity+q->red*(Opaque-p->opacity))/Opaque;           green=(unsigned long) F             (p->green*q->opacity+q->green*(Opaque-p->opacity))/Opaque;           blue=(unsigned long)D             (p->blue*q->opacity+q->blue*(Opaque-p->opacity))/Opaque;!           opacity=(unsigned long) J             (p->opacity*q->opacity+q->opacity*(Opaque-p->opacity))/Opaque;           break;	         }          case XorCompositeOp:	         {            red=(unsigned long) K             (p->red*(Opaque-q->opacity)+q->red*(Opaque-p->opacity))/Opaque;            green=(unsigned long) O             (p->green*(Opaque-q->opacity)+q->green*(Opaque-p->opacity))/Opaque;            blue=(unsigned long)M             (p->blue*(Opaque-q->opacity)+q->blue*(Opaque-p->opacity))/Opaque; B           opacity=(unsigned long) (p->opacity*(Opaque-q->opacity)+3             q->opacity*(Opaque-p->opacity))/Opaque;            break;	         }          case PlusCompositeOp: 	         {            red=p->red+q->red;"           green=p->green+q->green;           blue=p->blue+q->blue; (           opacity=p->opacity+q->opacity;           break;	         }          case MinusCompositeOp:	         { "           red=p->red-(int) q->red;(           green=p->green-(int) q->green;%           blue=p->blue-(int) q->blue;            opacity=Opaque;            break;	         }          case AddCompositeOp:	         {            red=p->red+q->red;           if (red > MaxRGB)              red-=(MaxRGB+1);"           green=p->green+q->green;           if (green > MaxRGB)              green-=(MaxRGB+1);           blue=p->blue+q->blue;            if (blue > MaxRGB)             blue-=(MaxRGB+1); (           opacity=p->opacity+q->opacity;           if (opacity > Opaque)               opacity-=(Opaque+1);           break;	         } !         case SubtractCompositeOp: 	         { "           red=p->red-(int) q->red;           if (red < 0)             red+=(MaxRGB+1);(           green=p->green-(int) q->green;           if (green < 0)             green+=(MaxRGB+1);%           blue=p->blue-(int) q->blue;            if (blue < 0)              blue+=(MaxRGB+1); .           opacity=p->opacity-(int) q->opacity;           if (opacity < 0)              opacity+=(MaxRGB+1);           break;	         } #         case DifferenceCompositeOp: 	         { 1           red=AbsoluteValue(p->red-(int) q->red); 7           green=AbsoluteValue(p->green-(int) q->green); 4           blue=AbsoluteValue(p->blue-(int) q->blue);=           opacity=AbsoluteValue(p->opacity-(int) q->opacity);            break;	         }           case BumpmapCompositeOp:	         {            shade=Intensity(*p);6           red=((unsigned long) (q->red*shade)/Opaque);:           green=((unsigned long) (q->green*shade)/Opaque);8           blue=((unsigned long) (q->blue*shade)/Opaque);>           opacity=((unsigned long) (q->opacity*shade)/Opaque);           break;	         }           case ReplaceCompositeOp:	         {            red=p->red;            green=p->green;            blue=p->blue;            opacity=p->opacity;            break;	         } #         case ReplaceRedCompositeOp: 	         { '           red=DownScale(Intensity(*p));            green=q->green;            blue=q->blue;            opacity=q->opacity;            break;	         } %         case ReplaceGreenCompositeOp: 	         {            red=q->red; )           green=DownScale(Intensity(*p));            blue=q->blue;            opacity=q->opacity;            break;	         } $         case ReplaceBlueCompositeOp:	         {            red=q->red;            green=q->green; (           blue=DownScale(Intensity(*p));           opacity=q->opacity;            break;	         } %         case ReplaceMatteCompositeOp: 	         {            red=q->red;            green=q->green;            blue=q->blue; +           opacity=DownScale(Intensity(*p));            break;	         }          case BlendCompositeOp:	         {            red=((unsigned long):             (p->red*p->opacity+q->red*q->opacity)/Opaque);            green=((unsigned long)>             (p->green*p->opacity+q->green*q->opacity)/Opaque);           blue=((unsigned long) <             (p->blue*p->opacity+q->blue*q->opacity)/Opaque);           opacity=Opaque;            break;	         } !         case DisplaceCompositeOp: 	         {            red=p->red;            green=p->green;            blue=p->blue;            opacity=p->opacity;            break;	         } !         case ModulateCompositeOp: 	         { (           if (Intensity(*p) != midpoint)
             {                double#                 percent_brightness;                  /*(                 Pixel is not at 0 point.               */               color.red=q->red; #               color.green=q->green; !               color.blue=q->blue; M               TransformHSL(color.red,color.green,color.blue,&hue,&saturation,                  &brightness); 3               percent_brightness=(brightness_scale* <                 ((double) Intensity(*p)-midpoint))/midpoint;-               brightness+=percent_brightness; #               if (brightness < 0.0)                  brightness=0.0;                else%                 if (brightness > 1.0) !                   brightness=1.0; M               HSLTransform(hue,saturation,brightness,&color.red,&color.green,                  &color.blue);                red=color.red;                green=color.green;               blue=color.blue;!               opacity=q->opacity;                break;
             }            red=q->red;            green=q->green;            blue=q->blue;            opacity=q->opacity;            break;	         }        } ;       q->red=(red < 0) ? 0 : (red > MaxRGB) ? MaxRGB : red; C       q->green=(green < 0) ? 0 : (green > MaxRGB) ? MaxRGB : green; ?       q->blue=(blue < 0) ? 0 : (blue > MaxRGB) ? MaxRGB : blue; 8       q->opacity=(opacity < Transparent) ? Transparent :.         (opacity > Opaque) ? Opaque : opacity;*       if ((image->class == PseudoClass) &&2           (composite_image->class == PseudoClass))6         image->indexes[x]=composite_image->indexes[x];
       p++;
       q++;     }      if (!SyncPixelCache(image))        break;   } "   if (compose == BlendCompositeOp)     image->matte=False; %   if (compose == DisplaceCompositeOp)      {        image->matte=False; $       DestroyImage(composite_image);     }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   C r e a t e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method CreateImage is a convenience routine that creates an image from the K %  pixel data you supply and returns it.  It allocates the memory necessary K %  for the new Image structure and returns a pointer to the new image.  The G %  pixel data must be in scanline order top-to-bottom.  The data can be M %  character, short int, integer, float, or double.  Float and double require M %  the pixels to be normalized [0..1].  The other types are [0..MaxRGB].  For L %  example, to create a 640x480 image from unsigned red-green-blue character %  data, use % 1 %      image=CreateImage(640,480,"RGB",0,pixels);  % + %  The format of the CreateImage method is:  % M %      Image *CreateImage(const unsigned int width,const unsigned int height, C %        const char *map,const StorageType type,const void *pixels)  % + %  A description of each parameter follows:  % I %    o image:  Method CreateImage returns a pointer to the image.  A null M %      image is returned if there is a memory shortage or if the image cannot  %      be read.  % 9 %    o width: Specifies the width in pixels of the image.  % ; %    o height: Specifies the height in pixels of the image.  % F %    o map:  This character string can be any combination or order of E %      R = red, G = green, B = blue, A = alpha, C = cyan, Y = yellow, J %      M = magenta, and K = black.  The ordering reflects the order of the* %      pixels in the supplied pixel array. % H %    o type: pixel type where 0 = unsigned char, 1 = short int, 2 = int,L %      3 = float, and 4 = double.  Float and double types are expected to be/ %      normalized [0..1] otherwise [0..MaxRGB].  % K %    o pixels: This array of values contain the pixel components as defined E %      by the map and type parameters.  The length of the arrays must G %      equal the area specified by the width and height values and type  %      parameters. %  %  */M Export Image *CreateImage(const unsigned int width,const unsigned int height, <   const char *map,const StorageType type,const void *pixels) {    Image      *image;      int      y;     register int     i,     x;  
   PixelPacket      *q;      /*     Allocate image structure.    */"   assert(pixels != (void *) NULL);   if ((width*height) == 0)     { O       MagickWarning(CorruptImageWarning,"impossible image size",(char *) NULL);        return((Image *) NULL);      } *   image=AllocateImage((ImageInfo *) NULL);   if (image == (Image *) NULL)     return((Image *) NULL);    image->columns=width;    image->rows=height; !   for (i=0; i < strlen(map); i++)      switch (map[i])      {        case 'a':        case 'A':        {          image->matte=True;         break;       }        case 'c':        case 'C':        case 'm':        case 'M':        case 'y':        case 'Y':        case 'k':        case 'K':        { )         image->colorspace=CMYKColorspace;          break;       }        default:         break;     }    /*?     Transfer the pixels from the pixel data array to the image.    */   switch (type)    {      case CharPixel:      {        register char          *p;          p=(char *) pixels;+       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { )           for (i=0; i < strlen(map); i++)            {              switch (map[i]) 
             {                case 'r':                case 'R':                case 'c':                case 'C':                {                  q->red=(*p++);                 break;               }                case 'g':                case 'G':                case 'y':                case 'Y':                {                   q->green=(*p++);                 break;               }                case 'b':                case 'B':                case 'm':                case 'M':                {                  q->blue=(*p++);                  break;               }                case 'a':                case 'A':                case 'k':                case 'K':                { "                 q->opacity=(*p++);                 break;               }                default:               { E                 MagickWarning(OptionWarning,"Invalid pixel map",map); $                 DestroyImage(image);'                 return((Image *) NULL);                } 
             }            }            q++;	         } #         if (!SyncPixelCache(image))            break;       }        break;     }      case ShortPixel:     {        register unsigned short          *p;   "       p=(unsigned short *) pixels;+       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { )           for (i=0; i < strlen(map); i++)            {              switch (map[i]) 
             {                case 'r':                case 'R':                case 'c':                case 'C':                {                  q->red=(*p++);                 break;               }                case 'g':                case 'G':                case 'y':                case 'Y':                {                   q->green=(*p++);                 break;               }                case 'b':                case 'B':                case 'm':                case 'M':                {                  q->blue=(*p++);                  break;               }                case 'a':                case 'A':                case 'k':                case 'K':                { "                 q->opacity=(*p++);                 break;               }                default:               { E                 MagickWarning(OptionWarning,"Invalid pixel map",map); $                 DestroyImage(image);'                 return((Image *) NULL);                } 
             }            }            q++;	         } #         if (!SyncPixelCache(image))            break;       }        break;     }      case IntegerPixel:     {        register unsigned int          *p;           p=(unsigned int *) pixels;+       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { )           for (i=0; i < strlen(map); i++)            {              switch (map[i]) 
             {                case 'r':                case 'R':                case 'c':                case 'C':                {                  q->red=(*p++);                 break;               }                case 'g':                case 'G':                case 'y':                case 'Y':                {                   q->green=(*p++);                 break;               }                case 'b':                case 'B':                case 'm':                case 'M':                {                  q->blue=(*p++);                  break;               }                case 'a':                case 'A':                case 'k':                case 'K':                { "                 q->opacity=(*p++);                 break;               }                default:               { E                 MagickWarning(OptionWarning,"Invalid pixel map",map); $                 DestroyImage(image);'                 return((Image *) NULL);                } 
             }            }            q++;	         } #         if (!SyncPixelCache(image))            break;       }        break;     }      case FloatPixel:     {        register float         *p;          p=(float *) pixels; +       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { )           for (i=0; i < strlen(map); i++)            {              switch (map[i]) 
             {                case 'r':                case 'R':                case 'c':                case 'C':                { %                 q->red=MaxRGB*(*p++);                  break;               }                case 'g':                case 'G':                case 'y':                case 'Y':                { '                 q->green=MaxRGB*(*p++);                  break;               }                case 'b':                case 'B':                case 'm':                case 'M':                { &                 q->blue=MaxRGB*(*p++);                 break;               }                case 'a':                case 'A':                case 'k':                case 'K':                { )                 q->opacity=MaxRGB*(*p++);                  break;               }                default:               { E                 MagickWarning(OptionWarning,"Invalid pixel map",map); $                 DestroyImage(image);'                 return((Image *) NULL);                } 
             }            }            q++;	         } #         if (!SyncPixelCache(image))            break;       }        break;     }      case DoublePixel:      {        register double          *p;          p=(double *) pixels;+       for (y=0; y < (int) image->rows; y++)        { 4         q=SetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { )           for (i=0; i < strlen(map); i++)            {              switch (map[i]) 
             {                case 'r':                case 'R':                case 'c':                case 'C':                { %                 q->red=MaxRGB*(*p++);                  break;               }                case 'g':                case 'G':                case 'y':                case 'Y':                { '                 q->green=MaxRGB*(*p++);                  break;               }                case 'b':                case 'B':                case 'm':                case 'M':                { &                 q->blue=MaxRGB*(*p++);                 break;               }                case 'a':                case 'A':                case 'k':                case 'K':                { )                 q->opacity=MaxRGB*(*p++);                  break;               }                default:               { E                 MagickWarning(OptionWarning,"Invalid pixel map",map); $                 DestroyImage(image);'                 return((Image *) NULL);                } 
             }            }            q++;	         } #         if (!SyncPixelCache(image))            break;       }        break;     }      default:     { F       MagickWarning(OptionWarning,"Invalid pixel type",(char *) NULL);       DestroyImage(image);       return((Image *) NULL);      }    }    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     C y c l e C o l o r m a p I m a g e                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method CycleColormapImage cycles the image colormap by a specified 
 %  amount. % 2 %  The format of the CycleColormapImage method is: % ' %      CycleColormapImage(image,amount)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % L %    o amount:  An unsigned value that specifies the offset of the colormap. %  %  */= Export void CycleColormapImage(Image *image,const int amount)  { 6 #define CycleColormapImageText  "  Cycling image...  "       int 
     index,     y;     register int     x;  "   assert(image != (Image *) NULL);"   if (image->class == DirectClass)     {        QuantizeInfo         quantize_info;  &       GetQuantizeInfo(&quantize_info);2       quantize_info.number_colors=MaxColormapSize;1       (void) QuantizeImage(&quantize_info,image);      } '   for (y=0; y < (int) image->rows; y++)    { 3     if (!GetPixelCache(image,0,y,image->columns,1))        break;,     for (x=0; x < (int) image->columns; x++)     { =       index=((int) image->indexes[x]+amount) % image->colors;        if (index < 0)         index+=image->colors; ,       image->indexes[x]=(IndexPacket) index;     }      if (!SyncPixelCache(image))        break;   }    SyncImage(image);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s c r i b e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method DescribeImage describes an image by printing its attributes to
 %  stdout. % - %  The format of the DescribeImage method is:  % M %      void DescribeImage(Image *image,FILE *file,const unsigned int verbose)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % 4 %    o file: send the image attributes to this file. % M %    o verbose: an unsigned value other than zero prints detailed information  %      about the image.  %  %  */M Export void DescribeImage(Image *image,FILE *file,const unsigned int verbose)  {    char     color[MaxTextExtent],      **textlist;      double     elapsed_time,      user_time;     Image      *p;      int      y;     MagickInfo     *magick_info;      register int     i,     x;     unsigned int
     count;     unsigned long      number_colors;  "   assert(image != (Image *) NULL);    assert(file != (FILE *) NULL);2   elapsed_time=GetElapsedTime(&image->timer_info);,   user_time=GetUserTime(&image->timer_info);$   ContinueTimer(&image->timer_info);   if (!verbose)      {        /*.         Display detailed info about the image.       */*       if (*image->magick_filename != '\0')G         if (Latin1Compare(image->magick_filename,image->filename) != 0) B           (void) fprintf(file,"%.1024s=>",image->magick_filename);1        if ((image->previous == (Image *) NULL) && B            (image->next == (Image *) NULL) && (image->scene == 0))8         (void) fprintf(file,"%.1024s ",image->filename);
       elseI         (void) fprintf(file,"%.1024s[%u] ",image->filename,image->scene); D       if ((image->magick_columns != 0) || (image->magick_rows != 0))8         if ((image->magick_columns != image->columns) ||0             (image->magick_rows != image->rows))>           (void) fprintf(file,"%ux%u=>",image->magick_columns,              image->magick_rows);J       if ((image->page_info.width <= 1) || (image->page_info.height <= 1))A         (void) fprintf(file,"%ux%u ",image->columns,image->rows); 
       elseB         (void) fprintf(file,"%ux%u%+d%+d ",image->page_info.width,I           image->page_info.height,image->page_info.x,image->page_info.y); &       if (image->class == DirectClass)	         { .           (void) fprintf(file,"DirectClass ");'           if (image->total_colors != 0) =             (void) fprintf(file,"%luc ",image->total_colors); 	         } 
       else1         if (image->total_colors <= image->colors) @           (void) fprintf(file,"PseudoClass %uc ",image->colors);         else           { L             (void) fprintf(file,"PseudoClass %lu=>%uc ",image->total_colors,               image->colors); M             (void) fprintf(file,"%u/%.6f/%.6fe ",image->mean_error_per_pixel, L               image->normalized_mean_error,image->normalized_maximum_error);           }        if (image->filesize != 0) 	         { +           if (image->filesize >= (1 << 24)) C             (void) fprintf(file,"%dmb ",image->filesize/1024/1024);            else-             if (image->filesize >= (1 << 14)) @               (void) fprintf(file,"%dkb ",image->filesize/1024);             else:               (void) fprintf(file,"%db ",image->filesize);	         } L       (void) fprintf(file,"%.1024s %.1fu %d:%02d\n",image->magick,user_time,K         (int) ((elapsed_time+0.5)/60.0),(int) fmod(elapsed_time+0.5,60.0)); 
       return;      }    /*)     Display verbose info about the image.    */5   number_colors=GetNumberColors(image,(FILE *) NULL); :   (void) fprintf(file,"Image: %.1024s\n",image->filename);:   magick_info=(MagickInfo *) GetMagickInfo(image->magick);-   if ((magick_info == (MagickInfo *) NULL) || *       (*magick_info->description == '\0'))=     (void) fprintf(file,"  format: %.1024s\n",image->magick);    elseA     (void) fprintf(file,"  format: %.1024s (%s)\n",image->magick,         magick_info->description);"   (void) fprintf(file,"  type: ");   switch (GetImageType(image))   { <     case BilevelType: (void) fprintf(file,"bilevel"); break;@     case GrayscaleType: (void) fprintf(file,"grayscale"); break;<     case PaletteType: (void) fprintf(file,"palette"); break;     case PaletteMatteType:>       (void) fprintf(file,"palette with transparency"); break;A     case TrueColorType: (void) fprintf(file,"true color"); break;      case TrueColorMatteType:A       (void) fprintf(file,"true color with transparency"); break; L     case ColorSeparationType: (void) fprintf(file,"color separated"); break;5     default: (void) fprintf(file,"undefined"); break;    }    (void) fprintf(file,"\n");"   if (image->class == DirectClass)2     (void) fprintf(file,"  class: DirectClass\n");   else2     (void) fprintf(file,"  class: PseudoClass\n");   x=0;   p=(Image *) NULL;    if (!image->matte),     (void) fprintf(file,"  matte: False\n");   else=     if ((strcmp(image->magick,"GIF") != 0) || image->tainted) -       (void) fprintf(file,"  matte: True\n");      else       {          PixelPacket 
           *p;            p=(PixelPacket *) NULL; -         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { *             if (p->opacity == Transparent)               break;             p++;           } '           if (x < (int) image->columns)              break;	         } B         if ((x < (int) image->columns) || (y < (int) image->rows))           { "             if (image->depth == 8)K               (void) fprintf(file,"  matte: (%3d,%3d,%3d) #%02x%02x%02x\n", A                 p->red,p->green,p->blue,p->red,p->green,p->blue);              elseK               (void) fprintf(file,"  matte: (%5d,%5d,%5d) #%04x%04x%04x\n", A                 p->red,p->green,p->blue,p->red,p->green,p->blue);            }        } "   if (image->class == DirectClass)9     (void) fprintf(file,"  colors: %lu\n",number_colors);    else'     if (number_colors <= image->colors) :       (void) fprintf(file,"  colors: %u\n",image->colors);     elseM       (void) fprintf(file,"  colors: %lu=>%u\n",number_colors,image->colors); "   if (image->class == DirectClass)     {        if (number_colors < 1024) +         (void) GetNumberColors(image,file);      }    else     { 
       char         name[MaxTextExtent];         register PixelPacket         *p;          /*         Display image colormap.        */       p=image->colormap;-       for (i=0; i < (int) image->colors; i++)        { O         (void) fprintf(file,"    %d: (%3d,%3d,%3d)",i,p->red,p->green,p->blue); "         (void) fprintf(file,"  ");&         (void) QueryColorName(p,name);.         (void) fprintf(file,"  %.1024s",name);"         (void) fprintf(file,"\n");         p++;       }      } '   if (image->mean_error_per_pixel != 0) 7     (void) fprintf(file,"  mean error per pixel: %d\n", #       image->mean_error_per_pixel); (   if (image->normalized_mean_error != 0):     (void) fprintf(file,"  normalized mean error: %.6f\n",$       image->normalized_mean_error);+   if (image->normalized_maximum_error != 0) =     (void) fprintf(file,"  normalized maximum error: %.6f\n", '       image->normalized_maximum_error); 2   if (image->rendering_intent == SaturationIntent)<     (void) fprintf(file,"  rendering-intent: saturation\n");   else4     if (image->rendering_intent == PerceptualIntent)>       (void) fprintf(file,"  rendering-intent: perceptual\n");     else4       if (image->rendering_intent == AbsoluteIntent)>         (void) fprintf(file,"  rendering-intent: absolute\n");     else4       if (image->rendering_intent == RelativeIntent)>         (void) fprintf(file,"  rendering-intent: relative\n");   if (image->gamma != 0.0)6     (void) fprintf(file,"  gamma: %g\n",image->gamma);/   if (image->chromaticity.white_point.x != 0.0)      {        /*#         Display image chromaticity.        *//       (void) fprintf(file,"  chromaticity:\n"); 7       (void) fprintf(file,"    red primary: (%g,%g)\n", M         image->chromaticity.red_primary.x,image->chromaticity.red_primary.y); 9       (void) fprintf(file,"    green primary: (%g,%g)\n", ,         image->chromaticity.green_primary.x,-         image->chromaticity.green_primary.y); 8       (void) fprintf(file,"    blue primary: (%g,%g)\n",O         image->chromaticity.blue_primary.x,image->chromaticity.blue_primary.y); 7       (void) fprintf(file,"    white point: (%g,%g)\n", M         image->chromaticity.white_point.x,image->chromaticity.white_point.y);      } &   if (image->color_profile.length > 0)6     (void) fprintf(file,"  color profile: %u bytes\n",#       image->color_profile.length); %   if (image->iptc_profile.length > 0)      { 
       char
         *tag;   	       int 
         c;         register int
         j;         unsigned short         length;          /*         Describe IPTC data.        */7       (void) fprintf(file,"  IPTC profile: %u bytes\n", $         image->iptc_profile.length);4       for (i=0; i < image->iptc_profile.length; i++)       { 0         if (image->iptc_profile.info[i] != 0x1c)           continue; %         i++;  /* skip dataset byte */ .         switch (image->iptc_profile.info[++i])	         { *           case 5: tag="Image Name"; break;+           case 7: tag="Edit Status"; break; )           case 10: tag="Priority"; break; )           case 15: tag="Category"; break; 6           case 20: tag="Supplemental Category"; break;3           case 22: tag="Fixture Identifier"; break; (           case 25: tag="Keyword"; break;-           case 30: tag="Release Date"; break; -           case 35: tag="Release Time"; break; 5           case 40: tag="Special Instructions"; break; 2           case 45: tag="Reference Service"; break;/           case 47: tag="Reference Date"; break; 1           case 50: tag="Reference Number"; break; -           case 55: tag="Created Date"; break; -           case 60: tag="Created Time"; break; 4           case 65: tag="Originating Program"; break;0           case 70: tag="Program Version"; break;-           case 75: tag="Object Cycle"; break; '           case 80: tag="Byline"; break; -           case 85: tag="Byline Title"; break; %           case 90: tag="City"; break; /           case 95: tag="Province State"; break; .           case 100: tag="Country Code"; break;)           case 101: tag="Country"; break; A           case 103: tag="Original Transmission Reference"; break; *           case 105: tag="Headline"; break;(           case 110: tag="Credit"; break;(           case 115: tag="Source"; break;2           case 116: tag="Copyright String"; break;)           case 120: tag="Caption"; break; /           case 121: tag="Local Caption"; break; 0           case 122: tag="Caption Writer"; break;0           case 200: tag="Custom Field 1"; break;0           case 201: tag="Custom Field 2"; break;0           case 202: tag="Custom Field 3"; break;0           case 203: tag="Custom Field 4"; break;0           case 204: tag="Custom Field 5"; break;0           case 205: tag="Custom Field 6"; break;0           case 206: tag="Custom Field 7"; break;0           case 207: tag="Custom Field 8"; break;0           case 208: tag="Custom Field 9"; break;1           case 209: tag="Custom Field 10"; break; 1           case 210: tag="Custom Field 11"; break; 1           case 211: tag="Custom Field 12"; break; 1           case 212: tag="Custom Field 13"; break; 1           case 213: tag="Custom Field 14"; break; 1           case 214: tag="Custom Field 15"; break; 1           case 215: tag="Custom Field 16"; break; 1           case 216: tag="Custom Field 17"; break; 1           case 217: tag="Custom Field 18"; break; 1           case 218: tag="Custom Field 19"; break; 1           case 219: tag="Custom Field 20"; break; (           default: tag="unknown"; break;	         } ,         (void) fprintf(file,"    %s: ",tag);2         length=image->iptc_profile.info[++i] << 8;.         length|=image->iptc_profile.info[++i];"         for (j=0; j < length; j++)	         {            i++;(           c=image->iptc_profile.info[i];,           if ((c >= 32) || isspace((int) c))(             (void) fprintf(file,"%c",c);	         } "         (void) fprintf(file,"\n");       }      } @   if ((image->magick_columns != 0) || (image->magick_rows != 0))4     if ((image->magick_columns != image->columns) ||,         (image->magick_rows != image->rows))K       (void) fprintf(file,"  base geometry: %ux%u\n",image->magick_columns,          image->magick_rows);H   (void) fprintf(file,"  geometry: %ux%u\n",image->columns,image->rows);<   if ((image->tile_info.width*image->tile_info.height) != 0)P     (void) fprintf(file,"  tile geometry: %ux%u%+d%+d\n",image->tile_info.width,E       image->tile_info.height,image->tile_info.x,image->tile_info.y); C   if ((image->x_resolution != 0.0) && (image->y_resolution != 0.0))      {        /*!         Display image resolution.        */D       (void) fprintf(file,"  resolution: %gx%g",image->x_resolution,         image->y_resolution); .       if (image->units == UndefinedResolution))         (void) fprintf(file," pixels\n"); 
       else4         if (image->units == PixelsPerInchResolution)0           (void) fprintf(file," pixels/inch\n");         else<           if (image->units == PixelsPerCentimeterResolution)8             (void) fprintf(file," pixels/centimeter\n");           else&             (void) fprintf(file,"\n");     } 4   (void) fprintf(file,"  depth: %u\n",image->depth);   if (image->filesize != 0)      { '       if (image->filesize >= (1 << 24)) L         (void) fprintf(file,"  filesize: %dmb\n",image->filesize/1024/1024);
       else)         if (image->filesize >= (1 << 14)) I           (void) fprintf(file,"  filesize: %dkb\n",image->filesize/1024);          elseC           (void) fprintf(file,"  filesize: %db\n",image->filesize);      } &   if (image->interlace == NoInterlace)/     (void) fprintf(file,"  interlace: None\n");    else*     if (image->interlace == LineInterlace)1       (void) fprintf(file,"  interlace: Line\n");      else-       if (image->interlace == PlaneInterlace) 4         (void) fprintf(file,"  interlace: Plane\n");     else1       if (image->interlace == PartitionInterlace) 8         (void) fprintf(file,"  interlace: Partition\n");8   (void) QueryColorName(&image->background_color,color);=   (void) fprintf(file,"  background-color: %.1024s\n",color); 4   (void) QueryColorName(&image->border_color,color);9   (void) fprintf(file,"  border-color: %.1024s\n",color); 3   (void) QueryColorName(&image->matte_color,color); 8   (void) fprintf(file,"  matte-color: %.1024s\n",color);F   if ((image->page_info.width != 0) && (image->page_info.height != 0))P     (void) fprintf(file,"  page geometry: %ux%u%+d%+d\n",image->page_info.width,E       image->page_info.height,image->page_info.x,image->page_info.y);    if (image->dispose != 0)A     (void) fprintf(file,"  dispose method: %d\n",image->dispose);    if (image->delay != 0)6     (void) fprintf(file,"  delay: %d\n",image->delay);   if (image->iterations != 1) @     (void) fprintf(file,"  iterations: %d\n",image->iterations);
   p=image;'   while (p->previous != (Image *) NULL)      p=p->previous;3   for (count=1; p->next != (Image *) NULL; count++)      p=p->next;   if (count > 1)B     (void) fprintf(file,"  scene: %u of %u\n",image->scene,count);   else     if (image->scene != 0)8       (void) fprintf(file,"  scene: %u\n",image->scene);$   if (image->label != (char *) NULL);     (void) fprintf(file,"  label: %.1024s\n",image->label); )   (void) fprintf(file,"  compression: ");    switch (image->compression)    { =     case NoCompression: (void) fprintf(file,"None\n"); break; ?     case BZipCompression: (void) fprintf(file,"BZip\n"); break; =     case FaxCompression: (void) fprintf(file,"Fax\n"); break; D     case Group4Compression: (void) fprintf(file,"Group 4\n"); break;?     case JPEGCompression: (void) fprintf(file,"JPEG\n"); break; =     case LZWCompression: (void) fprintf(file,"LZW\n"); break; %     case RunlengthEncodedCompression: 8       (void) fprintf(file,"Runlength Encoded\n"); break;=     case ZipCompression: (void) fprintf(file,"Zip\n"); break; /     default: (void) fprintf(file,"\n");  break;    }    if (image->tainted) -     (void) fprintf(file,"  tainted: True\n");    else.     (void) fprintf(file,"  tainted: False\n");   SignatureImage(image);A   (void) fprintf(file,"  signature: %.1024s\n",image->signature);    if (user_time != 0.0) :     (void) fprintf(file,"  user time: %.1fu\n",user_time);   if (elapsed_time != 0.0)4     (void) fprintf(file,"  elapsed time: %d:%02d\n",C       (int) (elapsed_time/60.0),(int) fmod(elapsed_time+0.5,60.0)); '   if (image->comments != (char *) NULL)      {        /*         Display image comment.       */+       (void) fprintf(file,"  comments:\n"); -       textlist=StringToList(image->comments); %       if (textlist != (char **) NULL) 	         { 6           for (i=0; textlist[i] != (char *) NULL; i++)           { ;             (void) fprintf(file,"  %.1024s\n",textlist[i]); $             FreeMemory(textlist[i]);           }            FreeMemory(textlist); 	         }      } &   if (image->montage != (char *) NULL)?     (void) fprintf(file,"  montage: %.1024s\n",image->montage); (   if (image->directory != (char *) NULL)     {        ErrorHandler         handler;         Image          *tile;         ImageInfo          image_info;          register char          *p,          *q;          /*'         Display visual image directory.        */        GetImageInfo(&image_info);3       (void) CloneString(&image_info.size,"64x64"); ,       (void) fprintf(file,"  directory:\n");/       for (p=image->directory; *p != '\0'; p++)        {          q=p;,         while ((*q != '\n') && (*q != '\0'))           q++;2         (void) strncpy(image_info.filename,p,q-p);&         image_info.filename[q-p]='\0';         p=q;?         (void) fprintf(file,"    %.1024s",image_info.filename); 7         handler=SetWarningHandler((ErrorHandler) NULL); $         tile=ReadImage(&image_info);*         (void) SetWarningHandler(handler);#         if (tile == (Image *) NULL)            { &             (void) fprintf(file,"\n");             continue;            } D         (void) fprintf(file," %ux%u %.1024s\n",tile->magick_columns,*           tile->magick_rows,tile->magick);,         if (tile->comments != (char *) NULL)           {              /*#               Display tile comment.              */2             textlist=StringToList(tile->comments);+             if (textlist != (char **) NULL)                { <                 for (i=0; textlist[i] != (char *) NULL; i++)                 { C                   (void) fprintf(file,"    %.1024s\n",textlist[i]); *                   FreeMemory(textlist[i]);                 } %                 FreeMemory(textlist);                }            }          DestroyImage(tile);        }      }    (void) fflush(file); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method DestroyImage deallocates memory associated with an image.  % , %  The format of the DestroyImage method is: % & %      void DestroyImage(Image *image) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */& Export void DestroyImage(Image *image) {    /*     Close image.   */"   assert(image != (Image *) NULL);%   DestroyBlobInfo(&image->blob_info); (   DestroyCacheInfo(image->cache_handle);#   if (image->file != (FILE *) NULL)      {        CloseBlob(image);        if (image->temporary) '         (void) remove(image->filename);      }    /*"     Deallocate the image comments.   */'   if (image->comments != (char *) NULL)       FreeMemory(image->comments);   /*     Deallocate the image label.    */$   if (image->label != (char *) NULL)     FreeMemory(image->label);    /*+     Deallocate the image montage directory.    */&   if (image->montage != (char *) NULL)     FreeMemory(image->montage); (   if (image->directory != (char *) NULL)!     FreeMemory(image->directory);    /*"     Deallocate the image colormap.   */.   if (image->colormap != (PixelPacket *) NULL)      FreeMemory(image->colormap);   /*%     Deallocate the image ICC profile.    */&   if (image->color_profile.length > 0)*     FreeMemory(image->color_profile.info);   /*&     Deallocate the image IPTC profile.   */%   if (image->iptc_profile.length > 0) )     FreeMemory(image->iptc_profile.info);    /*#     Deallocate the image signature.    */(   if (image->signature != (char *) NULL)!     FreeMemory(image->signature);    /*      Deallocate the image pixels.   */,   if (image->pixels != (PixelPacket *) NULL)     FreeMemory(image->pixels);-   if (image->indexes != (IndexPacket *) NULL)      FreeMemory(image->indexes);    if (!image->orphan)      {        /*          Unlink from linked list.       */,       if (image->previous != (Image *) NULL)	         { ,           if (image->next != (Image *) NULL).             image->previous->next=image->next;           else1             image->previous->next=(Image *) NULL; 	         } (       if (image->next != (Image *) NULL)	         { 0           if (image->previous != (Image *) NULL)2             image->next->previous=image->previous;           else1             image->next->previous=(Image *) NULL; 	         }      }    /*#     Deallocate the image structure.    */   FreeMemory(image);   image=(Image *) NULL;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e I n f o                                           % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % J %  Method DestroyImageInfo deallocates memory associated with an ImageInfo
 %  structure.  % 0 %  The format of the DestroyImageInfo method is: % 3 %      void DestroyImageInfo(ImageInfo *image_info)  % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */3 Export void DestroyImageInfo(ImageInfo *image_info)  { +   assert(image_info != (ImageInfo *) NULL); /   if (image_info->server_name != (char *) NULL) (     FreeMemory(image_info->server_name);(   image_info->server_name=(char *) NULL;(   if (image_info->size != (char *) NULL)!     FreeMemory(image_info->size); !   image_info->size=(char *) NULL; (   if (image_info->tile != (char *) NULL)!     FreeMemory(image_info->tile); !   image_info->tile=(char *) NULL; (   if (image_info->page != (char *) NULL)!     FreeMemory(image_info->page); !   image_info->page=(char *) NULL; +   if (image_info->density != (char *) NULL) $     FreeMemory(image_info->density);$   image_info->density=(char *) NULL;+   if (image_info->dispose != (char *) NULL) $     FreeMemory(image_info->dispose);$   image_info->dispose=(char *) NULL;)   if (image_info->delay != (char *) NULL) "     FreeMemory(image_info->delay);"   image_info->delay=(char *) NULL;.   if (image_info->iterations != (char *) NULL)'     FreeMemory(image_info->iterations); '   image_info->iterations=(char *) NULL; +   if (image_info->texture != (char *) NULL) $     FreeMemory(image_info->texture);$   image_info->texture=(char *) NULL;'   if (image_info->box != (char *) NULL)       FreeMemory(image_info->box);    image_info->box=(char *) NULL;(   if (image_info->font != (char *) NULL)!     FreeMemory(image_info->font); !   image_info->font=(char *) NULL; '   if (image_info->pen != (char *) NULL)       FreeMemory(image_info->pen);    image_info->pen=(char *) NULL;(   if (image_info->view != (char *) NULL)!     FreeMemory(image_info->view); !   image_info->view=(char *) NULL; '   FreeMemory((ImageInfo *) image_info);     image_info=(ImageInfo *) NULL; }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D e s t r o y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method DestroyImages deallocates memory associated with a linked list
 %  of images.  % - %  The format of the DestroyImages method is:  % ' %      void DestroyImages(Image *image)  % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  %  %  */' Export void DestroyImages(Image *image)  {    Image      *next_image;     /*)     Proceed to the top of the image list.    */   if (image == (Image *) NULL)     return; +   while (image->previous != (Image *) NULL)      image=image->previous;   do   {      /*       Destroy this image.      */     next_image=image->next; $     if (next_image != (Image *)NULL))       next_image->previous=(Image *)NULL;      DestroyImage(image);     image=next_image; $   } while (image != (Image *) NULL); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   D i s p l a y I m a g e s                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method DisplayImages displays one or more images to an X window.  % 1 %  The format of the AllocateNextImage method is:  % K %      unsigned int DisplayImages(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows:  % L %    o status: Method DisplayImages returns True if the images are displayed3 %      in an X window, otherwise False is returned.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 7 %    o image: The address of a structure of type Image.  %  %  */K Export unsigned int DisplayImages(const ImageInfo *image_info,Image *image)  {  #if defined(HasX11)    char     *client_name;   	   Display 
     *display;      Image 
     *next;     unsigned long 
     state;  
   XrmDatabase      resource_database;     XResourceInfo 
     resource;   &   display=XOpenDisplay((char *) NULL);"   if (display == (Display *) NULL)     return(False);   XSetErrorHandler(XError); +   client_name=SetClientName((char *) NULL); >   resource_database=XGetResourceDatabase(display,client_name);<   XGetResourceInfo(resource_database,client_name,&resource);%   *resource.image_info=(*image_info);    resource.immutable=True;)   if (image_info->delay != (char *) NULL) +     resource.delay=atoi(image_info->delay); )   for (next=image; next; next=next->next)    {      state=DefaultState; H     (void) XDisplayImage(display,&resource,&client_name,1,&next,&state);     if (state & ExitState)       break;   }    XCloseDisplay(display);    return(True);  #else F   MagickWarning(MissingDelegateWarning,"X11 library is not available",     image->filename);    return(False); #endif }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t I m a g e I n f o                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method GetImageInfo initializes the ImageInfo structure.  % , %  The format of the GetImageInfo method is: % / %      void GetImageInfo(ImageInfo *image_info)  % + %  A description of each parameter follows:  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  *// Export void GetImageInfo(ImageInfo *image_info)  {    /*%     File and image dimension members.    */+   assert(image_info != (ImageInfo *) NULL); (   GetBlobInfo(&(image_info->blob_info));!   image_info->file=(FILE *) NULL;    *image_info->filename='\0';    *image_info->magick='\0'; (   TemporaryFilename(image_info->unique);(   (void) strcat(image_info->unique,"u");&   TemporaryFilename(image_info->zero);   image_info->temporary=False;   image_info->adjoin=True;   image_info->subimage=0;    image_info->subrange=0; !   image_info->depth=QuantumDepth;    image_info->ping=False; !   image_info->size=(char *) NULL; !   image_info->tile=(char *) NULL; !   image_info->page=(char *) NULL; $   image_info->interlace=NoInterlace;(   image_info->units=UndefinedResolution;   /*     Compression members.   *//   image_info->compression=UndefinedCompression;    image_info->quality=75;    /*     Annotation members.    */(   image_info->server_name=(char *) NULL;    image_info->box=(char *) NULL;!   image_info->font=(char *) NULL;     image_info->pen=(char *) NULL;$   image_info->texture=(char *) NULL;$   image_info->density=(char *) NULL;   image_info->linewidth=1;/   image_info->pointsize=atof(DefaultPointSize);    image_info->antialias=True;    image_info->fuzz=0; K   (void) QueryColorDatabase(BackgroundColor,&image_info->background_color); C   (void) QueryColorDatabase(BorderColor,&image_info->border_color); A   (void) QueryColorDatabase(MatteColor,&image_info->matte_color);    /*     Color reduction members.   */   image_info->dither=True;   image_info->monochrome=False; -   image_info->colorspace=UndefinedColorspace;    /*     Animation members.   */$   image_info->dispose=(char *) NULL;"   image_info->delay=(char *) NULL;'   image_info->iterations=(char *) NULL; +   image_info->decode_all_MNG_objects=False; $   image_info->coalesce_frames=False;%   image_info->insert_backdrops=False;    /*     Miscellaneous members.   */   image_info->verbose=False;'   image_info->preview_type=JPEGPreview; !   image_info->view=(char *) NULL;    image_info->group=0L;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t I m a g e T y p e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % N %  Method GetImageType returns the type of image (e.g. bilevel, palette, etc). % , %  The format of the GetImageType method is: % + %      ImageType GetImageType(Image *image)  % + %  A description of each parameter follows:  % L %    o type: Method GetImageType returns a ImageType enum that specifies the@ %      type of the specified image (e.g. bilevel, palette, etc). % 7 %    o image: The address of a structure of type Image.  %  %  */+ Export ImageType GetImageType(Image *image)  { "   assert(image != (Image *) NULL);*   if (image->colorspace == CMYKColorspace)      return(ColorSeparationType);   if (IsMonochromeImage(image))      return(BilevelType);   if (IsGrayImage(image))      return(GrayscaleType);+   if (IsPseudoClass(image) && image->matte)      return(PaletteMatteType);    if (IsPseudoClass(image))      return(PaletteType);   if (image->matte)      return(TrueColorMatteType);    return(TrueColorType); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t N e x t I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method GetNextImage returns the next image in an image sequence.  % , %  The format of the GetNextImage method is: % ( %      Image *GetNextImage(Image *image) % + %  A description of each parameter follows:  % M %    o next: Method GetNextImage returns the next image in an image sequence.  % 7 %    o image: The address of a structure of type Image.  %  %  */( Export Image *GetNextImage(Image *image) { "   assert(image != (Image *) NULL);*   image->next->blob_info=image->blob_info;    image->next->file=image->file;   return(image->next); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t N u m b e r S c e n e s                                             % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method GetNumberScenes returns the number of scenes in an image sequence. % / %  The format of the GetNumberScenes method is:  % 7 %      unsigned int GetNumberScenes(const Image *image)  % + %  A description of each parameter follows:  % I %    o scenes:  Method GetNumberScenes returns the number of scenes in an  %      image sequence. % 7 %    o image: The address of a structure of type Image.  %  %  */7 Export unsigned int GetNumberScenes(const Image *image)  { 
   const Image      *next_image;     unsigned int     number_scenes;     /*.     Compute the number of scenes in the image.   */(   assert(image != (const Image *) NULL);+   while (image->previous != (Image *) NULL)      image=image->previous;   next_image=image; F   for (number_scenes=0; next_image != (Image *) NULL; number_scenes++)      next_image=next_image->next;   return(number_scenes); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t P a g e I n f o                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ; %  Method GetPageInfo initializes the image page structure.  % + %  The format of the GetPageInfo method is:  % 1 %      void GetPageInfo(RectangleInfo *page_info)  % + %  A description of each parameter follows:  % C %    o page_info: Specifies a pointer to a RectangleInfo structure.  %  %  */1 Export void GetPageInfo(RectangleInfo *page_info)  { .   assert(page_info != (RectangleInfo *) NULL);   page_info->width=0;    page_info->height=0;   page_info->x=0;    page_info->y=0;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t P i x e l s                                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method GetPixels is a convenience routine.  Use it to extract pixel data H %  from an image and place it in a buffer you supply.  The data is savedJ %  either as char, short int, integer, float or double format in the orderD %  specified by the type parameter.  For example, we want to extractK %  scanline 1 of a 640x480 image as character data in red-green-blue order:  % 1 %      GetPixels(image,0,0,640,1,"RGB",0,pixels);  % ) %  The format of the GetPixels method is:  % ; %      void GetPixels(Image *image,const int x,const int y, < %        const unsigned int columns,const unsigned int rows,= %        const char *map,const StorageType type,void *pixels)  % + %  A description of each parameter follows:  % F %    o image: Specifies a pointer to a Image structure;  returned from %      ReadImage.  % J %    o x,y,columns,rows:  These values define the perimeter of a region of" %      pixels you want to extract. % F %    o map:  This character string can be any combination or order of E %      R = red, G = green, B = blue, A = alpha, C = cyan, Y = yellow, J %      M = magenta, and K = black.  The ordering reflects the order of the* %      pixels in the supplied pixel array. % H %    o type: pixel type where 0 = unsigned char, 1 = short int, 2 = int,I %      3 = float, and 4 = double.  Float and double types are expected to 2 %      be normalized [0..1] otherwise [0..MaxRGB]. % K %    o pixels: This array of values contain the pixel components as defined E %      by the map and type parameters.  The length of the arrays must G %      equal the area specified by the width and height values and type  %      parameters. %  %  */; Export void GetPixels(Image *image,const int x,const int y, E   const unsigned int columns,const unsigned int rows,const char *map, &   const StorageType type,void *pixels) {    register int     i,     j;     register PixelPacket     *p;   "   assert(image != (Image *) NULL);!   for (i=0; i < strlen(map); i++)      switch (map[i])      {        case 'c':        case 'C':        case 'm':        case 'M':        case 'y':        case 'Y':        case 'k':        case 'K':        { 0         if (image->colorspace != CMYKColorspace)2           RGBTransformImage(image,CMYKColorspace);         break;       }        default:         break;     }    switch (type)    {      case CharPixel:      {        register unsigned char         *q;   .       p=GetPixelCache(image,x,y,columns,rows);$       if (p == (PixelPacket *) NULL)         break;!       q=(unsigned char *) pixels; (       for (i=0; i < (columns*rows); i++)       { '         for (j=0; j < strlen(map); j++) 	         {            switch (map[j])            {              case 'r':              case 'R':              case 'c':              case 'C': 
             {                *q++=p->red;               break;
             }              case 'g':              case 'G':              case 'y':              case 'Y': 
             {                *q++=p->green;               break;
             }              case 'b':              case 'B':              case 'm':              case 'M': 
             {                *q++=p->blue;                break;
             }              case 'a':              case 'A':              case 'k':              case 'K': 
             {                *q++=p->opacity;               break;
             }              default:
             { C               MagickWarning(OptionWarning,"Invalid pixel map",map);                return; 
             }            } 	         }          p++;       }        break;     }      case ShortPixel:     {        register unsigned short          *q;   .       p=GetPixelCache(image,x,y,columns,rows);$       if (p == (PixelPacket *) NULL)         break;"       q=(unsigned short *) pixels;(       for (i=0; i < (columns*rows); i++)       { '         for (j=0; j < strlen(map); j++) 	         {            switch (map[j])            {              case 'r':              case 'R':              case 'c':              case 'C': 
             {                *q++=p->red;               break;
             }              case 'g':              case 'G':              case 'y':              case 'Y': 
             {                *q++=p->green;               break;
             }              case 'b':              case 'B':              case 'm':              case 'M': 
             {                *q++=p->blue;                break;
             }              case 'a':              case 'A':              case 'k':              case 'K': 
             {                *q++=p->opacity;               break;
             }              default:
             { C               MagickWarning(OptionWarning,"Invalid pixel map",map);                return; 
             }            } 	         }          p++;       }        break;     }      case IntegerPixel:     {        register unsigned int          *q;   .       p=GetPixelCache(image,x,y,columns,rows);$       if (p == (PixelPacket *) NULL)         break;        q=(unsigned int *) pixels;(       for (i=0; i < (columns*rows); i++)       { '         for (j=0; j < strlen(map); j++) 	         {            switch (map[j])            {              case 'r':              case 'R':              case 'c':              case 'C': 
             {                *q++=p->red;               break;
             }              case 'g':              case 'G':              case 'y':              case 'Y': 
             {                *q++=p->green;               break;
             }              case 'b':              case 'B':              case 'm':              case 'M': 
             {                *q++=p->blue;                break;
             }              case 'a':              case 'A':              case 'k':              case 'K': 
             {                *q++=p->opacity;               break;
             }              default:
             { C               MagickWarning(OptionWarning,"Invalid pixel map",map);                return; 
             }            } 	         }          p++;       }        break;     }      case FloatPixel:     {        register float         *q;   .       p=GetPixelCache(image,x,y,columns,rows);$       if (p == (PixelPacket *) NULL)         break;       q=(float *) pixels; (       for (i=0; i < (columns*rows); i++)       { '         for (j=0; j < strlen(map); j++) 	         {            switch (map[j])            {              case 'r':              case 'R':              case 'c':              case 'C': 
             { !               *q++=p->red/MaxRGB;                break;
             }              case 'g':              case 'G':              case 'y':              case 'Y': 
             { #               *q++=p->green/MaxRGB;                break;
             }              case 'b':              case 'B':              case 'm':              case 'M': 
             { "               *q++=p->blue/MaxRGB;               break;
             }              case 'a':              case 'A':              case 'k':              case 'K': 
             { %               *q++=p->opacity/MaxRGB;                break;
             }              default:
             { C               MagickWarning(OptionWarning,"Invalid pixel map",map);                return; 
             }            } 	         }          p++;       }        break;     }      case DoublePixel:      {        register double          *q;   .       p=GetPixelCache(image,x,y,columns,rows);$       if (p == (PixelPacket *) NULL)         break;       q=(double *) pixels;(       for (i=0; i < (columns*rows); i++)       { '         for (j=0; j < strlen(map); j++) 	         {            switch (map[j])            {              case 'r':              case 'R':              case 'c':              case 'C': 
             { !               *q++=p->red/MaxRGB;                break;
             }              case 'g':              case 'G':              case 'y':              case 'Y': 
             { #               *q++=p->green/MaxRGB;                break;
             }              case 'b':              case 'B':              case 'm':              case 'M': 
             { "               *q++=p->blue/MaxRGB;               break;
             }              case 'a':              case 'A':              case 'k':              case 'K': 
             { %               *q++=p->opacity/MaxRGB;                break;
             }              default:
             { C               MagickWarning(OptionWarning,"Invalid pixel map",map);                return; 
             }            } 	         }          p++;       }        break;     }      default:     { F       MagickWarning(OptionWarning,"Invalid pixel type",(char *) NULL);
       return;      }    }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   G e t P i x e l P a c k e t                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % ? %  Method GetPixelPacket initializes the PixelPacket structure.  % . %  The format of the GetPixelPacket method is: % . %      void GetPixelPacket(PixelPacket *pixel) % + %  A description of each parameter follows:  % = %    o pixel: Specifies a pointer to a PixelPacket structure.  %  %  */. Export void GetPixelPacket(PixelPacket *pixel) { (   assert(pixel != (PixelPacket *) NULL);   pixel->red=0;    pixel->green=0;    pixel->blue=0;   pixel->opacity=Transparent;  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I s G e o m e t r y                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method IsGeometry returns True if the geometry specification is valid" %  as determined by ParseGeometry. % * %  The format of the IsGeometry method is: % 4 %      unsigned int IsGeometry(const char *geometry) % + %  A description of each parameter follows:  % K %    o status: Method IsGeometry returns True if the geometry specification , %      is valid otherwise False is returned. % ; %    o geometry: This string is the geometry specification.  %  %  */4 Export unsigned int IsGeometry(const char *geometry) {    double
     value;     int      x,     y;     unsigned int
     flags,     height, 
     width;  &   if (geometry == (const char *) NULL)     return(False);>   flags=ParseGeometry((char *) geometry,&x,&y,&width,&height);>   return((flags != NoValue) || sscanf(geometry,"%lf",&value)); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I s S u b i m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method IsSubimage returns True if the geometry is a valid subimage , %  specification (e.g. [1], [1-9], [1,7,4]). % * %  The format of the IsSubimage method is: % P %      unsigned int IsSubimage(const char *geometry,const unsigned int pedantic) % + %  A description of each parameter follows:  % H %    o status: Method IsSubimage returns True if the geometry is a valid: %      subimage specification otherwise False is returned. % ; %    o geometry: This string is the geometry specification.  % G %    o pedantic: A value other than 0 invokes a more restriction set of E %      conditions for a valid specification (e.g. [1], [1-4], [4-1]).  %  %  */P Export unsigned int IsSubimage(const char *geometry,const unsigned int pedantic) {    int      x,     y;     unsigned int
     flags,     height, 
     width;  &   if (geometry == (const char *) NULL)     return(False);>   flags=ParseGeometry((char *) geometry,&x,&y,&width,&height);   if (pedantic) 9     return((flags != NoValue) && !(flags & HeightValue)); 9   return(IsGeometry(geometry) && !(flags & HeightValue));  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     I s T a i n t e d                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % G %  Method IsTainted returns True if the image has been altered since it K %  was first read or if any image in the sequence has a difference magic or  %  filename. % ) %  The format of the IsTainted method is:  % 1 %      unsigned int IsTainted(const Image *image)  % + %  A description of each parameter follows:  % J %    o status: Method IsTainted returns True if the image has been altered %      since it was first read.  % 7 %    o image: The address of a structure of type Image.  %  %  */1 Export unsigned int IsTainted(const Image *image)  {    char     magick[MaxTextExtent],     filename[MaxTextExtent];     register const Image     *p;   "   assert(image != (Image *) NULL);&   (void) strcpy(magick,image->magick);*   (void) strcpy(filename,image->filename);/   for (p=image; p != (Image *) NULL; p=p->next)    {      if (p->tainted)        return(True); -     if (Latin1Compare(p->magick,magick) != 0)        return(True); 1     if (Latin1Compare(p->filename,filename) != 0)        return(True);    }    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   L a b e l I m a g e                                                       % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method LabelImage initializes an image label.  Optionally the labelJ %  can include the image filename, type, width, height, or scene number by' %  embedding special format characters.  % * %  The format of the LabelImage method is: % 6 %      void LabelImage(Image *image,const char *label) % + %  A description of each parameter follows:  % 7 %    o image: The address of a structure of type Image.  % L %    o label: The address of a character string containing the label format. %  %  */6 Export void LabelImage(Image *image,const char *label) { $   if (image->label != (char *) NULL)     FreeMemory(image->label); =   image->label=TranslateText((ImageInfo *) NULL,image,label);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     L a y e r I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method LayerImage extracts the specified layer from the references image. % * %  The format of the LayerImage method is: % : %      void LayerImage(Image *image,const LayerType layer) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % O %    o layer: A value of type LayerType that identifies which layer to extract.  %  %  */: Export void LayerImage(Image *image,const LayerType layer) { D #define LayerImageText  "  Extracting the layer from the image...  "     int      y;     register int     x;     register PixelPacket     *q;   "   assert(image != (Image *) NULL);-   if ((layer == MatteLayer) && !image->matte)      { <       MagickWarning(OptionWarning,"Unable to extract layer",-         "image does not have a matte layer"); 
       return;      }    /*     Layer DirectClass packets.   */   image->class=DirectClass;    image->matte=False; '   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        switch (layer)       {          case RedLayer:	         {            q->green=q->red;           q->blue=q->red;            break;	         }          case GreenLayer:	         {            q->red=q->green;           q->blue=q->green;            break;	         }          case BlueLayer: 	         {            q->red=q->blue;            q->green=q->blue;            break;	         }          case MatteLayer:         default:	         {            q->red=q->opacity;           q->green=q->opacity;           q->blue=q->opacity;            break;	         }        } 
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 4       ProgressMonitor(LayerImageText,y,image->rows);   }    (void) IsGrayImage(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     L i s t T o G r o u p I m a g e                                         % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ListToGroupImage converts a linked list of images to a sequential 	 %  array.  % 0 %  The format of the ListToGroupImage method is: % O %      Image **ListToGroupImage(const Image *image,unsigned int *number_images)  % + %  A description of each parameter follows:  % J %    o images: Method ListToGroupImage converts a linked list of images to1 %      a sequential array and returns the array..  % G %    o images: The address of a structure of type Image;  returned from  %      ReadImage.  % N %    o number_images:  A pointer to an unsigned integer.  The number of images+ %      in the image array is returned here.  %  %  */O Export Image **ListToGroupImage(const Image *image,unsigned int *number_images)  {    Image 
     **images,      *next_image;     register int     i;     /*/     Determine the number of images in the list.    */"   assert(image != (Image *) NULL);1   assert(number_images != (unsigned int *) NULL);    next_image=(Image *) image; .   for (i=0; next_image != (Image *) NULL; i++)      next_image=next_image->next;6   images=(Image **) AllocateMemory(i*sizeof(Image *));    if (images == (Image **) NULL)     { H       MagickWarning(ResourceLimitWarning,"Unable to convert image list",$         "Memory allocation failed");       return((Image **) NULL);     }    *number_images=i;    /*3     Add each image in the linked list to the group.    */   next_image=(Image *) image; .   for (i=0; next_image != (Image *) NULL; i++)   {      images[i]=next_image;       next_image=next_image->next;   }    return(images);  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %     M a t t e I m a g e                                                     % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % L %  Method MatteImage initializes the matte channel of the reference image to
 %  opaque. % * %  The format of the MatteImage method is: % 4 %      void MatteImage(Image *image,Quantum opacity) % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  % * %    o opacity: The level of transparency. %  %  */4 Export void MatteImage(Image *image,Quantum opacity) {    int      y;     register int     x;     register PixelPacket     *q;   "   assert(image != (Image *) NULL);   image->class=DirectClass;    image->matte=True;'   for (y=0; y < (int) image->rows; y++)    { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        q->opacity=opacity; 
       q++;     }      if (!SyncPixelCache(image))        break;   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%O %                                                                             % O %                                                                             % O %     M o g r i f y I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % F %  Method MogrifyImage applies image processing options to an image as& %  prescribed by command line options. % , %  The format of the MogrifyImage method is: % P %      void MogrifyImage(const ImageInfo *image_info,const int argc,char **argv, %        Image **image)  % + %  A description of each parameter follows:I %eA %    o image_info: Specifies a pointer to an ImageInfo structure.  % G %    o argc: Specifies a pointer to an integer describing the number of ' %      elements in the argument vector.  % L %    o argv: Specifies a pointer to a text array containing the command line %      arguments.  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.  %  %  */P Export void MogrifyImage(const ImageInfo *image_info,const int argc,char **argv,   Image **image) {    char     *geometry,     *option;  
   PixelPacket      target_color;      Image      *map_image,      *region_image;     ImageInfo0     *local_info;     int-
     flags,     x,     y;     QuantizeInfo     quantize_info;     RectangleInfol     region_info;     register int     i;     unsigned int     gravity,
     matte,     height, 
     width;     /*     Verify option length.    */+   assert(image_info != (ImageInfo *) NULL); #   assert(image != (Image **) NULL);e   for (i=1; i < argc; i++).     if (Extent(argv[i]) > (MaxTextExtent/2-1))       {cI         MagickWarning(ResourceLimitWarning,"Option length exceeds limit",p           argv[i]);u         return;        }e   /*      Initialize method variables.   */(   local_info=CloneImageInfo(image_info);"   GetQuantizeInfo(&quantize_info);   geometry=(char *) NULL;    gravity=ForgetGravity;   map_image=(Image *) NULL;     quantize_info.number_colors=0;   quantize_info.tree_depth=0;p   quantize_info.dither=True;   if (local_info->monochrome)b#     if (!IsMonochromeImage(*image))        { &         quantize_info.number_colors=2;#         quantize_info.tree_depth=8; 0         quantize_info.colorspace=GRAYColorspace;       }o   region_image=(Image *) NULL;&   region_info.width=(*image)->columns;$   region_info.height=(*image)->rows;   region_info.x=0;   region_info.y=0;   /*     Transmogrify the image.    */   for (i=1; i < argc; i++)   {      option=argv[i];iH     if ((Extent(option) <= 1) || ((*option != '-') && (*option != '+')))       continue;e-     if (strncmp("antialias",option+1,3) == 0)        {e/         local_info->antialias=(*option == '-');          continue;        } -     if (strncmp("-background",option,6) == 0)        { ;         (void) QueryColorDatabase(argv[++i],&target_color); 2         local_info->background_color=target_color;0         (*image)->background_color=target_color;         continue;        }n'     if (strncmp("-blur",option,4) == 0)r       {o         double           factor;t  
         Imaget           *blurred_image;I  
         /*           Blur an image.
         */         factor=atof(argv[++i]); /         blurred_image=BlurImage(*image,factor); ,         if (blurred_image != (Image *) NULL)           {%!             DestroyImage(*image);%!             *image=blurred_image;            }r         continue;u       }k-     if (Latin1Compare("-border",option) == 0)        {e
         Image            *bordered_image;           RectangleInfoh           border_info;  
         /*6           Surround image with a border of solid color.
         */         border_info.width=0;         border_info.height=0;t         border_info.x=0;         border_info.y=0;D         flags=ParseGeometry(argv[++i],&border_info.x,&border_info.y,2           &border_info.width,&border_info.height);'         if ((flags & HeightValue) == 0)m/           border_info.height=border_info.width; 8         bordered_image=BorderImage(*image,&border_info);-         if (bordered_image != (Image *) NULL)n           {0!             DestroyImage(*image);#.             bordered_image->class=DirectClass;"             *image=bordered_image;           }%         continue;        } .     if (strncmp("-bordercolor",option,8) == 0)       { ;         (void) QueryColorDatabase(argv[++i],&target_color); .         local_info->border_color=target_color;,         (*image)->border_color=target_color;         continue;        } *     if (Latin1Compare("-box",option) == 0)       { 7         (void) CloneString(&local_info->box,argv[++i]);          continue;        } +     if (strncmp("-charcoal",option,3) == 0)        {          char           *commands[7];            QuantizeInfo           quantize_info;  
         /*           Charcoal drawing.%
         */         i++;(         GetQuantizeInfo(&quantize_info);0         quantize_info.dither=image_info->dither;0         quantize_info.colorspace=GRAYColorspace;4         (void) QuantizeImage(&quantize_info,*image);1         commands[0]=SetClientName((char *) NULL);          commands[1]="-edge";         commands[2]=argv[i];         commands[3]="-blur";         commands[4]=argv[i];!         commands[5]="-normalize";c         commands[6]="-negate";2         MogrifyImage(local_info,7,commands,image);4         (void) QuantizeImage(&quantize_info,*image);         continue;n       }u+     if (strncmp("-colorize",option,8) == 0)(       {g
         Imagef           *colorized_image;t  
         /*           Colorize the image. 
         */H         colorized_image=ColorizeImage(*image,argv[++i],local_info->pen);.         if (colorized_image != (Image *) NULL)           { !             DestroyImage(*image);g#             *image=colorized_image;            }a         continue;        }(+     if (strncmp("-compress",option,6) == 0)e       {r         if (*option == '-')(           {m             CompressionTypee               compression;               option=argv[++i];;-             compression=UndefinedCompression;_2             if (Latin1Compare("None",option) == 0)(               compression=NoCompression;2             if (Latin1Compare("BZip",option) == 0)*               compression=BZipCompression;1             if (Latin1Compare("Fax",option) == 0)b)               compression=FaxCompression;s4             if (Latin1Compare("Group4",option) == 0),               compression=Group4Compression;2             if (Latin1Compare("JPEG",option) == 0)*               compression=JPEGCompression;1             if (Latin1Compare("LZW",option) == 0)l)               compression=LZWCompression;a>             if (Latin1Compare("RunlengthEncoded",option) == 0)6               compression=RunlengthEncodedCompression;1             if (Latin1Compare("Zip",option) == 0)l)               compression=ZipCompression; 4             if (compression == UndefinedCompression)I               MagickError(OptionError,"Invalid compression type",option);e.             (*image)->compression=compression;           }a         continue;U       }l-     if (Latin1Compare("-colors",option) == 0)l       {G4         quantize_info.number_colors=atoi(argv[++i]);         continue;o       }g-     if (strncmp("-colorspace",option,8) == 0).       {r         option=argv[++i];-.         if (Latin1Compare("cmyk",option) == 0)           {c5             RGBTransformImage(*image,CMYKColorspace);t4             quantize_info.colorspace=CMYKColorspace;           }y.         if (Latin1Compare("gray",option) == 0)           { 4             quantize_info.colorspace=GRAYColorspace;1             if (quantize_info.number_colors == 0) .               quantize_info.number_colors=256;'             quantize_info.tree_depth=8;e           }L.         if (Latin1Compare("ohta",option) == 0)2           quantize_info.colorspace=OHTAColorspace;-         if (Latin1Compare("rgb",option) == 0)h           { 4             TransformRGBImage(*image,RGBColorspace);3             quantize_info.colorspace=RGBColorspace;=           }e.         if (Latin1Compare("srgb",option) == 0)2           quantize_info.colorspace=sRGBColorspace;5         if (Latin1Compare("transparent",option) == 0)e9           quantize_info.colorspace=TransparentColorspace;f-         if (Latin1Compare("xyz",option) == 0)e1           quantize_info.colorspace=XYZColorspace;;/         if (Latin1Compare("ycbcr",option) == 0)f3           quantize_info.colorspace=YCbCrColorspace; -         if (Latin1Compare("ycc",option) == 0)c1           quantize_info.colorspace=YCCColorspace;D-         if (Latin1Compare("yiq",option) == 0)l1           quantize_info.colorspace=YIQColorspace;a/         if (Latin1Compare("ypbpr",option) == 0)a3           quantize_info.colorspace=YPbPrColorspace;_-         if (Latin1Compare("yuv",option) == 0)o1           quantize_info.colorspace=YUVColorspace;*8         local_info->colorspace=quantize_info.colorspace;         continue;c       }=+     if (strncmp("comment",option+1,4) == 0)T       {&         if (*option == '-')))           CommentImage(*image,argv[++i]);l         else-           CommentImage(*image,(char *) NULL);a         continue;o       }g,     if (strncmp("contrast",option+1,3) == 0)       {e>         ContrastImage(*image,(unsigned int) (*option == '-'));         continue;I       }*'     if (strncmp("-crop",option,3) == 0)        {r6         TransformImage(image,argv[++i],(char *) NULL);         continue;o       }o(     if (strncmp("-cycle",option,3) == 0)       {L
         /*"           Cycle an image colormap.
         */3         CycleColormapImage(*image,atoi(argv[++i]));e         continue;l       } *     if (strncmp("-density",option,4) == 0)       {a         int(           count;  
         /*           Set image density.
         */;         (void) CloneString(&local_info->density,argv[++i]);d3         count=sscanf(local_info->density,"%lfx%lf",=;           &(*image)->x_resolution,&(*image)->y_resolution);          if (count != 2)>8           (*image)->y_resolution=(*image)->x_resolution;       }=(     if (strncmp("-depth",option,4) == 0)       {-6         (*image)->depth=atoi(argv[++i]) <= 8 ? 8 : 16;         continue;;       }l,     if (strncmp("-despeckle",option,4) == 0)       { 
         Imagem           *despeckled_image;  
         /*.           Reduce the speckles within an image.
         */0         despeckled_image=DespeckleImage(*image);/         if (despeckled_image != (Image *) NULL)            {a!             DestroyImage(*image);a$             *image=despeckled_image;           }e         continue;c       }e*     if (strncmp("-display",option,6) == 0)       { ?         (void) CloneString(&local_info->server_name,argv[++i]);w         continue;c       } *     if (strncmp("dither",option+1,3) == 0)       {c,         local_info->dither=(*option == '-');.         quantize_info.dither=(*option == '-');         continue;        }g'     if (strncmp("-draw",option,3) == 0)        {n         AnnotateInfo           *annotate_info;f  
         /*           Draw image.-
         */J         annotate_info=CloneAnnotateInfo(local_info,(AnnotateInfo *) NULL);@         (void) CloneString(&annotate_info->primitive,argv[++i]);&         if (geometry != (char *) NULL)@           (void) CloneString(&annotate_info->geometry,geometry);%         if (gravity != ForgetGravity),)           annotate_info->gravity=gravity;c(         DrawImage(*image,annotate_info);+         DestroyAnnotateInfo(annotate_info);p         continue;L       }l'     if (strncmp("-edge",option,3) == 0)i       {          double           factor;   
         Imagea           *edged_image;g  
         /*$           Detect edges in the image.
         */         factor=atof(argv[++i]);=-         edged_image=EdgeImage(*image,factor);g*         if (edged_image != (Image *) NULL)           {n!             DestroyImage(*image);r             *image=edged_image;o           }>         continue;l       }m)     if (strncmp("-emboss",option,3) == 0)        {a
         Image;           *embossed_image;  
         /*           Emboss image.%
         */+         embossed_image=EmbossImage(*image); -         if (embossed_image != (Image *) NULL)            { !             DestroyImage(*image); "             *image=embossed_image;           }          continue;        } *     if (strncmp("-enhance",option,3) == 0)       { 
         Image            *enhanced_image;  
         /*           Enhance image.
         */,         enhanced_image=EnhanceImage(*image);-         if (enhanced_image != (Image *) NULL)            { !             DestroyImage(*image); "             *image=enhanced_image;           }          continue;        }%+     if (strncmp("-equalize",option,3) == 0)%       {%
         /*           Equalize image.e
         */         EqualizeImage(*image);         continue;        } *     if (strncmp("filter",option+1,3) == 0)       {x         if (*option == '-')            {e             FilterType               filter;a               option=argv[++i];h!             filter=LanczosFilter;a3             if (Latin1Compare("Point",option) == 0)e!               filter=PointFilter;f1             if (Latin1Compare("Box",option) == 0)i               filter=BoxFilter;f6             if (Latin1Compare("Triangle",option) == 0)$               filter=TriangleFilter;5             if (Latin1Compare("Hermite",option) == 0)l#               filter=HermiteFilter;g5             if (Latin1Compare("Hanning",option) == 0)u#               filter=HanningFilter;l5             if (Latin1Compare("Hamming",option) == 0)o#               filter=HammingFilter;n6             if (Latin1Compare("Blackman",option) == 0)$               filter=BlackmanFilter;6             if (Latin1Compare("Gaussian",option) == 0)$               filter=GaussianFilter;7             if (Latin1Compare("Quadratic",option) == 0)-%               filter=QuadraticFilter;%3             if (Latin1Compare("Cubic",option) == 0)%!               filter=CubicFilter; 4             if (Latin1Compare("Catrom",option) == 0)"               filter=CatromFilter;6             if (Latin1Compare("Mitchell",option) == 0)$               filter=MitchellFilter;5             if (Latin1Compare("Lanczos",option) == 0) #               filter=LanczosFilter; 4             if (Latin1Compare("Bessel",option) == 0)"               filter=BesselFilter;2             if (Latin1Compare("Sinc",option) == 0)                filter=SincFilter;$             (*image)->filter=filter;           }          continue;        } '     if (strncmp("-flip",option,4) == 0)%       {%
         Image%           *flipped_image;%  
         /*           Flip image scanlines.s
         */(         flipped_image=FlipImage(*image);,         if (flipped_image != (Image *) NULL)           { !             DestroyImage(*image);e!             *image=flipped_image;r           }h         continue;        } '     if (strncmp("-flop",option,4) == 0)r       { 
         Imagel           *flopped_image;,  
         /*           Flop image scanlines.e
         */(         flopped_image=FlopImage(*image);,         if (flopped_image != (Image *) NULL)           {e!             DestroyImage(*image); !             *image=flopped_image;e           }i         continue;i       }1,     if (Latin1Compare("-frame",option) == 0)       {l
         Imaget           *framed_image;           FrameInfof           frame_info;   
         /*3           Surround image with an ornamental border.N
         */         frame_info.width=0;l         frame_info.height=0;!         frame_info.outer_bevel=0;o!         frame_info.inner_bevel=0;d>         flags=ParseGeometry(argv[++i],&frame_info.outer_bevel,H           &frame_info.inner_bevel,&frame_info.width,&frame_info.height);'         if ((flags & HeightValue) == 0)(-           frame_info.height=frame_info.width;n"         if ((flags & XValue) == 0);           frame_info.outer_bevel=(frame_info.width >> 2)+1;i"         if ((flags & YValue) == 0)8           frame_info.inner_bevel=frame_info.outer_bevel;&         frame_info.x=frame_info.width;'         frame_info.y=frame_info.height;%C         frame_info.width=(*image)->columns+(frame_info.width << 1);%B         frame_info.height=(*image)->rows+(frame_info.height << 1);4         framed_image=FrameImage(*image,&frame_info);+         if (framed_image != (Image *) NULL)            { !             DestroyImage(*image); ,             framed_image->class=DirectClass;              *image=framed_image;           }          continue;        } '     if (strncmp("-fuzz",option,3) == 0)        { '         (*image)->fuzz=atoi(argv[++i]);          continue;        } +     if (Latin1Compare("-font",option) == 0)%       {%8         (void) CloneString(&local_info->font,argv[++i]);         continue;d       }p)     if (strncmp("gamma",option+1,2) == 0)        {h         if (*option == '+') *           (*image)->gamma=atof(argv[++i]);         else'           GammaImage(*image,argv[++i]);f         continue;        }f+     if (strncmp("-geometry",option,4) == 0)r       {r
         Image-           *zoomed_image;  
         /*           Resize image. 
         */          width=(*image)->columns;         height=(*image)->rows;         x=0;         y=0;0         (void) CloneString(&geometry,argv[++i]);A         (void) ParseImageGeometry(geometry,&x,&y,&width,&height);o4         zoomed_image=ZoomImage(*image,width,height);+         if (zoomed_image != (Image *) NULL)-           { !             DestroyImage(*image);s              *image=zoomed_image;           }d         continue;x       }e+     if (strncmp("gravity",option+1,2) == 0)a       {m!         gravity=NorthWestGravity;t         if (*option == '-')            {              option=argv[++i]; 7             if (Latin1Compare("NorthWest",option) == 0) '               gravity=NorthWestGravity;(3             if (Latin1Compare("North",option) == 0)k#               gravity=NorthGravity;n7             if (Latin1Compare("NorthEast",option) == 0)e'               gravity=NorthEastGravity;a2             if (Latin1Compare("West",option) == 0)"               gravity=WestGravity;4             if (Latin1Compare("Center",option) == 0)$               gravity=CenterGravity;2             if (Latin1Compare("East",option) == 0)"               gravity=EastGravity;7             if (Latin1Compare("SouthWest",option) == 0)g'               gravity=SouthWestGravity;o3             if (Latin1Compare("South",option) == 0)=#               gravity=SouthGravity;>7             if (Latin1Compare("SouthEast",option) == 0)a'               gravity=SouthEastGravity;f           }l         continue;t       })*     if (strncmp("-implode",option,4) == 0)       {d         double           amount;   
         Imageo           *imploded_image;  
         /*           Implode image.
         */         amount=atof(argv[++i]);n3         imploded_image=ImplodeImage(*image,amount); -         if (imploded_image != (Image *) NULL)(           {)!             DestroyImage(*image);e"             *image=imploded_image;           }          continue;t       } )     if (strncmp("label",option+1,3) == 0)-       {          if (*option == '-') '           LabelImage(*image,argv[++i]);m         else+           LabelImage(*image,(char *) NULL);e         continue;        }i)     if (strncmp("layer",option+1,3) == 0)I       {n         LayerTypem           layer;           layer=UndefinedLayer;          if (*option == '-')m           {+             option=argv[++i]; 1             if (Latin1Compare("Red",option) == 0)                layer=RedLayer; 3             if (Latin1Compare("Green",option) == 0)                layer=GreenLayer; 2             if (Latin1Compare("Blue",option) == 0)               layer=BlueLayer;3             if (Latin1Compare("Matte",option) == 0)s               layer=MatteLayer;m           }e!         LayerImage(*image,layer);          continue;o       }m,     if (strncmp("-linewidth",option,3) == 0)       {+.         local_info->linewidth=atoi(argv[++i]);         continue;        } *     if (Latin1Compare("-map",option) == 0)       {*
         /*=           Transform image colors to match this set of colors. 
         */6         (void) strcpy(local_info->filename,argv[++i]);(         map_image=ReadImage(local_info);         continue;f       }>-     if (Latin1Compare("matte",option+1) == 0)o       {m         if (*option == '-')            if (!(*image)->matte);&             MatteImage(*image,Opaque);)         (*image)->matte=(*option == '-');)         continue;l       }m-     if (strncmp("-mattecolor",option,7) == 0)z       { ;         (void) QueryColorDatabase(argv[++i],&target_color); -         local_info->matte_color=target_color;o+         (*image)->matte_color=target_color;=         continue;        }n)     if (strncmp("-median",option,4) == 0)%       {%
         Image%           *median_image;  
         /*           Median filter image.
         */?         median_image=MedianFilterImage(*image,atoi(argv[++i])); +         if (median_image != (Image *) NULL)            { !             DestroyImage(*image);               *image=median_image;           }          continue;        } +     if (strncmp("-modulate",option,4) == 0)        { (         ModulateImage(*image,argv[++i]);         continue;        } -     if (strncmp("-monochrome",option,4) == 0)        { $         local_info->monochrome=True;&         quantize_info.number_colors=2;#         quantize_info.tree_depth=8;M0         quantize_info.colorspace=GRAYColorspace;         continue;u       } *     if (strncmp("negate",option+1,3) == 0)       {e+         NegateImage(*image,*option == '+');g         continue;        } )     if (strncmp("noise",option+1,4) == 0)o       { 
         Image_           *noisy_image;e  
         /*            Reduce noise in image.
         */         if (*option == '-')d/           noisy_image=ReduceNoiseImage(*image);          else           {              NoiseTyper               noise_type;                option=argv[++i];e$             noise_type=UniformNoise;6             if (Latin1Compare("Gaussian",option) == 0)'               noise_type=GaussianNoise; <             if (Latin1Compare("multiplicative",option) == 0)5               noise_type=MultiplicativeGaussianNoise; 5             if (Latin1Compare("impulse",option) == 0) &               noise_type=ImpulseNoise;7             if (Latin1Compare("laplacian",option) == 0)L(               noise_type=LaplacianNoise;5             if (Latin1Compare("Poisson",option) == 0)o&               noise_type=PoissonNoise;9             noisy_image=AddNoiseImage(*image,noise_type);*           }t*         if (noisy_image != (Image *) NULL)           {i!             DestroyImage(*image);-             *image=noisy_image;u           }-         continue;        }>,     if (strncmp("-normalize",option,4) == 0)       {(         NormalizeImage(*image);i         continue;i       } )     if (strncmp("-opaque",option,3) == 0)        { 6         OpaqueImage(*image,argv[++i],local_info->pen);         continue;=       }t(     if (strncmp("-paint",option,4) == 0)       {w
         Imagek           *paint_image;P  
         /*           Oil paint image.
         */:         paint_image=OilPaintImage(*image,atoi(argv[++i]));*         if (paint_image != (Image *) NULL)           { !             DestroyImage(*image);m             *image=paint_image;            }0         continue;n       } *     if (Latin1Compare("-pen",option) == 0)       { 7         (void) CloneString(&local_info->pen,argv[++i]);r         continue;g       }i-     if (strncmp("pointsize",option+1,2) == 0)g       {=.         local_info->pointsize=atof(argv[++i]);         continue;g       }t+     if (strncmp("profile",option+1,4) == 0)n       {;
         Imageo           *profile;n           if (*option == '+')v           {>             /*:               Remove a ICC or IPTC profile from the image.             */             option=argv[++i];i1             if (Latin1Compare("icc",option) == 0)                {y8                 if ((*image)->color_profile.length != 0);                   FreeMemory((*image)->color_profile.info);e1                 (*image)->color_profile.length=0;tD                 (*image)->color_profile.info=(unsigned char *) NULL;               }-2             if (Latin1Compare("8bim",option) == 0)               {o7                 if ((*image)->iptc_profile.length != 0) :                   FreeMemory((*image)->iptc_profile.info);0                 (*image)->iptc_profile.length=0;C                 (*image)->iptc_profile.info=(unsigned char *) NULL;m               } 2             if (Latin1Compare("iptc",option) == 0)               {i7                 if ((*image)->iptc_profile.length != 0)(:                   FreeMemory((*image)->iptc_profile.info);0                 (*image)->iptc_profile.length=0;C                 (*image)->iptc_profile.info=(unsigned char *) NULL;s               }_             continue;i           }(
         /*1           Add a ICC or IPTC profile to the image. 
         */6         (void) strcpy(local_info->filename,argv[++i]);&         profile=ReadImage(local_info);&         if (profile == (Image *) NULL)           continue;e6         if (Latin1Compare("icc",profile->magick) == 0)           { 4             if ((*image)->color_profile.length != 0)7               FreeMemory((*image)->color_profile.info); I             (*image)->color_profile.length=profile->color_profile.length; E             (*image)->color_profile.info=profile->color_profile.info; ,             profile->color_profile.length=0;?             profile->color_profile.info=(unsigned char *) NULL;            } 7         if (Latin1Compare("8bim",profile->magick) == 0)            { 3             if ((*image)->iptc_profile.length != 0) 6               FreeMemory((*image)->iptc_profile.info);G             (*image)->iptc_profile.length=profile->iptc_profile.length; C             (*image)->iptc_profile.info=profile->iptc_profile.info;%+             profile->iptc_profile.length=0; >             profile->iptc_profile.info=(unsigned char *) NULL;           }i7         if (Latin1Compare("iptc",profile->magick) == 0)e           { 3             if ((*image)->iptc_profile.length != 0) 6               FreeMemory((*image)->iptc_profile.info);G             (*image)->iptc_profile.length=profile->iptc_profile.length; C             (*image)->iptc_profile.info=profile->iptc_profile.info;t+             profile->iptc_profile.length=0;C>             profile->iptc_profile.info=(unsigned char *) NULL;           }          DestroyImage(profile);         continue;        } )     if (strncmp("raise",option+1,2) == 0)        {o         RectangleInfoa           raise_info;o  
         /*5           Surround image with a raise of solid color. 
         */         raise_info.width=0;c         raise_info.height=0;         raise_info.x=0;n         raise_info.y=0;nB         flags=ParseGeometry(argv[++i],&raise_info.x,&raise_info.y,0           &raise_info.width,&raise_info.height);'         if ((flags & HeightValue) == 0)o-           raise_info.height=raise_info.width; 6         RaiseImage(*image,&raise_info,*option == '-');         continue;L       }n*     if (strncmp("region",option+1,3) == 0)       {f
         Image=           *cropped_image;n  +         if (region_image != (Image *) NULL)            {e             /*               Composite region.)             */&             matte=region_image->matte;(             CompositeImage(region_image,L               (*image)->matte ? OverCompositeOp : ReplaceCompositeOp,*image,+               region_info.x,region_info.y);)!             DestroyImage(*image);,              *image=region_image;"             (*image)->matte=matte;           }l         if (*option == '+'))           continue;r
         /*B           Apply transformations to a selected region of the image.
         */,         region_info.width=(*image)->columns;*         region_info.height=(*image)->rows;         region_info.x=0;         region_info.y=0;E         (void) ParseGeometry(argv[++i],&region_info.x,&region_info.y, 2           &region_info.width,&region_info.height);5         cropped_image=CropImage(*image,&region_info);p,         if (cropped_image == (Image *) NULL)           continue;          region_image=(*image);         *image=cropped_image;.         continue;n       } '     if (strncmp("-roll",option,4) == 0)u       {h
         Imagee           *rolled_image;  
         /*           Roll image.n
         */         x=0;         y=0;<         flags=ParseGeometry(argv[++i],&x,&y,&width,&height);+         rolled_image=RollImage(*image,x,y);g+         if (rolled_image != (Image *) NULL)h           { !             DestroyImage(*image);p              *image=rolled_image;           }g         continue;i       }*)     if (strncmp("-rotate",option,4) == 0)i       {l         double           degrees;  
         Image            *rotated_image;f  
         /*/           Check for conditional image rotation.N
         */         i++;1         if (strchr(argv[i],'>') != (char *) NULL)e2           if ((*image)->columns <= (*image)->rows)             break;1         if (strchr(argv[i],'<') != (char *) NULL) 2           if ((*image)->columns >= (*image)->rows)             break;
         /*           Rotate image.g
         */         degrees=atof(argv[i]);2         rotated_image=RotateImage(*image,degrees);,         if (rotated_image != (Image *) NULL)           {(!             DestroyImage(*image); !             *image=rotated_image;            }g         continue;        }m)     if (strncmp("-sample",option,3) == 0)-       {o
         Image            *sampled_image;n  
         /*.           Sample image with pixel replication.
         */          width=(*image)->columns;         height=(*image)->rows;         x=0;         y=0;B         (void) ParseImageGeometry(argv[++i],&x,&y,&width,&height);7         sampled_image=SampleImage(*image,width,height); ,         if (sampled_image != (Image *) NULL)           {l!             DestroyImage(*image); !             *image=sampled_image;n           }          continue;p       }m(     if (strncmp("sans",option+1,2) == 0)       if (*option == '-')e         i++;,     if (Latin1Compare("-scene",option) == 0)       { (         (*image)->scene=atoi(argv[++i]);         continue;v       }e*     if (strncmp("-segment",option,4) == 0)       {          double           cluster_threshold,           smoothing_threshold;  
         /*           Segment image.
         */         cluster_threshold=1.0;          smoothing_threshold=1.5;=         (void) sscanf(argv[++i],"%lfx%lf",&cluster_threshold,             &smoothing_threshold);P         (void) SegmentImage(*image,quantize_info.colorspace,local_info->verbose,C           (double) cluster_threshold,(double) smoothing_threshold);g         continue;        }()     if (strncmp("shade",option+1,5) == 0)        {n         double           azimuth,           elevation;  
         Image            *shaded_image;  
         /*           Shade image.
         */         azimuth=30.0;          elevation=30.0;%
         /*A           The following prevents shading an image using the color 0           algorithm from programs like "convert"
         */$ #ifdef PREVENT_MINUS_OPTION_ON_SHADE         if (*option == '-')  #endifA           (void) sscanf(argv[++i],"%lfx%lf",&azimuth,&elevation); G         shaded_image=ShadeImage(*image,*option == '-',(double) azimuth,            (double) elevation);+         if (shaded_image != (Image *) NULL)            { !             DestroyImage(*image);               *image=shaded_image;           }          continue;        } *     if (strncmp("-sharpen",option,5) == 0)       {          double           factor;%  
         Image%           *sharpened_image;%  
         /*           Sharpen an image.k
         */         factor=atof(argv[++i]); 4         sharpened_image=SharpenImage(*image,factor);.         if (sharpened_image != (Image *) NULL)           {n!             DestroyImage(*image);n#             *image=sharpened_image;r           }s         continue;e       }t(     if (strncmp("-shear",option,4) == 0)       {          double           x_shear,           y_shear;  
         Imagee           *shear_image;e  
         /*           Shear image.
         */         x_shear=0.0;         y_shear=0.0;=         (void) sscanf(argv[++i],"%lfx%lf",&x_shear,&y_shear);MI         shear_image=ShearImage(*image,(double) x_shear,(double) y_shear);a*         if (shear_image != (Image *) NULL)           {o!             DestroyImage(*image);"+             shear_image->class=DirectClass;              *image=shear_image;i           }          continue;        } +     if (strncmp("-solarize",option,3) == 0)o       { .         SolarizeImage(*image,atof(argv[++i]));         continue;e       }()     if (strncmp("-spread",option,3) == 0)n       {i         unsigned int           amount;f  
         Imagee           *spread_image;  
         /*           Spread an image.
         */         amount=atoi(argv[++i]);r0         spread_image=SpreadImage(*image,amount);+         if (spread_image != (Image *) NULL)n           {h!             DestroyImage(*image);l              *image=spread_image;           }o         continue;N       } (     if (strncmp("-swirl",option,3) == 0)       {          double           degrees;  
         Imagen           *swirled_image;e  
         /*           Swirl image.
         */          degrees=atof(argv[++i]);1         swirled_image=SwirlImage(*image,degrees);n,         if (swirled_image != (Image *) NULL)           {o!             DestroyImage(*image); !             *image=swirled_image;            }l         continue;l       }i,     if (strncmp("-threshold",option,3) == 0)       {h         double           threshold;  
         /*           Threshold image.
         */"         threshold=atof(argv[++i]);)         ThresholdImage(*image,threshold);o         continue;f       }n.     if (strncmp("-transparent",option,4) == 0)       {S+         TransparentImage(*image,argv[++i]);)         continue;%       }%,     if (strncmp("-treedepth",option,4) == 0)       {%1         quantize_info.tree_depth=atoi(argv[++i]);          continue;        } )     if (strncmp("units",option+1,3) == 0)        { ,         (*image)->units=UndefinedResolution;         if (*option == '-')            {              option=argv[++i]; ;             if (Latin1Compare("PixelsPerInch",option) == 0) 6               (*image)->units=PixelsPerInchResolution;A             if (Latin1Compare("PixelsPerCentimeter",option) == 0) <               (*image)->units=PixelsPerCentimeterResolution;           }          continue;        } +     if (strncmp("verbose",option+1,3) == 0)%       {%-         local_info->verbose=(*option == '-');%5         quantize_info.measure_error=(*option == '-');          continue;i       }e,     if (Latin1Compare("wave",option+1) == 0)       {h         double           amplitude,           wavelength;r  
         ImageT           *waved_image;m  
         /*           Wave image.n
         */         amplitude=25.0;n         wavelength=150.0;o         if (*option == '-') D           (void) sscanf(argv[++i],"%lfx%lf",&amplitude,&wavelength);M         waved_image=WaveImage(*image,(double) amplitude,(double) wavelength);r*         if (waved_image != (Image *) NULL)           {o!             DestroyImage(*image);g             *image=waved_image;            }i         continue;        }m   }=%   if (region_image != (Image *) NULL)c     {)       /*0         Composite transformed region onto image.       */        matte=region_image->matte;"       CompositeImage(region_image,F         (*image)->matte ? OverCompositeOp : ReplaceCompositeOp,*image,%         region_info.x,region_info.y);        DestroyImage(*image);        *image=region_image;       (*image)->matte=matte;     } +   if ((quantize_info.number_colors != 0) || 3       (quantize_info.colorspace == GRAYColorspace))      {        /*1         Reduce the number of colors in the image.        */-       if (((*image)->class == DirectClass) || =           ((*image)->colors > quantize_info.number_colors) || 7           (quantize_info.colorspace == GRAYColorspace))%4         (void) QuantizeImage(&quantize_info,*image);
       else!         CompressColormap(*image);n     } "   if (map_image != (Image *) NULL)     {f=       (void) MapImage(*image,map_image,quantize_info.dither);:       DestroyImage(map_image);     }*   /*     Free resources.o   */    if (geometry != (char *) NULL)     FreeMemory(geometry);t   DestroyImageInfo(local_info);i*   ClosePixelCache((*image)->cache_handle); }e h /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%oO %                                                                             %aO %                                                                             %pO %     M o g r i f y I m a g e s                                               %fO %                                                                             %aO %                                                                             %oO %                                                                             %gO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %hI %  Method MogrifyImages applies image processing options to a sequence ofP0 %  images as prescribed by command line options. %a, %  The format of the MogrifyImage method is: %eE %      void MogrifyImages(const ImageInfo *image_info,const int argc, $ %        char **argv,Image **images) %;+ %  A description of each parameter follows:; % A %    o image_info: Specifies a pointer to an ImageInfo structure.) %aG %    o argc: Specifies a pointer to an integer describing the number of>' %      elements in the argument vector.k %nL %    o argv: Specifies a pointer to a text array containing the command line %      arguments.) % G %    o images: The address of a structure of type Image;  returned frome %      ReadImage.  %e %  */E Export void MogrifyImages(const ImageInfo *image_info,const int argc,a   char **argv,Image **images)M {s6 #define MogrifyImageText  "  Transforming images...  "     Imagep     *image,D     *mogrify_image;      register int     i;     MonitorHandler     handler;     unsigned int     number_images;  +   assert(image_info != (ImageInfo *) NULL);e$   assert(images != (Image **) NULL);   image=(*images);G   for (number_images=1; image->next != (Image *) NULL; number_images++)      image=image->next;4   ProgressMonitor(MogrifyImageText,0,number_images);3   handler=SetMonitorHandler((MonitorHandler) NULL); ,   MogrifyImage(image_info,argc,argv,images);$   (void) SetMonitorHandler(handler);   image=(*images);    mogrify_image=(*images)->next;   if (image_info->verbose)&     DescribeImage(image,stdout,False);1   for (i=1; mogrify_image != (Image *) NULL; i++)/   { 5     handler=SetMonitorHandler((MonitorHandler) NULL);m6     MogrifyImage(image_info,argc,argv,&mogrify_image);     image->next=mogrify_image;      image->next->previous=image;     image=image->next;     if (image_info->verbose)0       DescribeImage(mogrify_image,stdout,False);&     mogrify_image=mogrify_image->next;&     (void) SetMonitorHandler(handler);6     ProgressMonitor(MogrifyImageText,i,number_images);   }U }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%hO %                                                                             %aO %                                                                             %aO %     M o s a i c I m a g e s                                                 %lO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%1 % J %  Method MosaicImages inlays a number of images to form a single coherent %  picture.i %a+ %  The format of the MosaicImage method is:  % / %      Image *MosaicImages(const Image *images)c % + %  A description of each parameter follows:* %UG %    o images: The address of a structure of type Image;  returned from  %      ReadImage.l %s %+ */) Export Image *MosaicImages(Image *images)) { : #define MosaicImageText  "  Creating an image mosaic...  "     Image      *image,      *mosaic_image;     intt     y;     RectangleInfo      page_info;     register int     x;     register PixelPacket     *q;a     unsigned int
     scene;  #   assert(images != (Image *) NULL); %   if (images->next == (Image *) NULL)      { >       MagickWarning(OptionWarning,"Unable to create a mosaic",#         "image sequence required");>       return((Image *) NULL);o     }g   /*!     Determine image bounding box.f   */"   page_info.width=images->columns;    page_info.height=images->rows;   page_info.x=0;   page_info.y=0;@   for (image=images; image != (Image *) NULL; image=image->next)   {a#     page_info.x=image->page_info.x; #     page_info.y=image->page_info.y; 7     if ((image->columns+page_info.x) > page_info.width) 1       page_info.width=image->columns+page_info.x;-5     if ((image->rows+page_info.y) > page_info.height) /       page_info.height=image->rows+page_info.y;    }m   /*     Allocate image structure.l   */1   mosaic_image=AllocateImage((ImageInfo *) NULL);>%   if (mosaic_image == (Image *) NULL)i     return((Image *) NULL);l   /*     Initialize colormap.   */(   mosaic_image->columns=page_info.width;&   mosaic_image->rows=page_info.height;.   for (y=0; y < (int) mosaic_image->rows; y++)   { >     q=SetPixelCache(mosaic_image,0,y,mosaic_image->columns,1);"     if (q == (PixelPacket *) NULL)       break;3     for (x=0; x < (int) mosaic_image->columns; x++)      { (       *q=mosaic_image->background_color;
       q++;     } &     if (!SyncPixelCache(mosaic_image))       break;   } 
   scene=0;@   for (image=images; image != (Image *) NULL; image=image->next)   {oL     CompositeImage(mosaic_image,ReplaceCompositeOp,image,image->page_info.x,       image->page_info.y);E     ProgressMonitor(MosaicImageText,scene++,GetNumberScenes(images));    }    return(mosaic_image);c }a   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             %OO %                                                                             %eO %                                                                             %gO %   P a r s e I m a g e G e o m e t r y                                       % O %                                                                             % O %                                                                             % O %                                                                             %(O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%e %)L %  Method ParseImageGeometry parses a geometry specification and returns theH %  width, height, x, and y values.  It also returns flags that indicatesJ %  which of the four values (width, height, xoffset, yoffset) were locatedL %  in the string, and whether the x and y values are negative.  In addition,B %  there are flags to report any meta characters (%, !, <, and >). %e2 %  The format of the ParseImageGeometry method is: %dA %      int ParseImageGeometry(const char *geometry,int *x,int *y,o2 %        unsigned int *width,unsigned int *height) % + %  A description of each parameter follows:  % I %    o flags:  Method ParseImageGeometry returns a bitmask that indicatespD %      which of the four values were located in the geometry string. % N %    o image_geometry:  Specifies a character string representing the geometry %      specification.  % J %    o x,y:  A pointer to an integer.  The x and y offset as determined by3 %      the geometry specification is returned here.  %*M %    o width,height:  A pointer to an unsigned integer.  The width and heightiD %      as determined by the geometry specification is returned here. %y %f */A Export int ParseImageGeometry(const char *geometry,int *x,int *y, +   unsigned int *width,unsigned int *height)t {m   int,
     delta,
     flags;     RectangleInfo_     media_info;s     unsigned int     former_height,     former_width;=     /*'     Ensure the image geometry is valid.x   */   assert(x != (int *) NULL);   assert(y != (int *) NULL);)   assert(width != (unsigned int *) NULL); *   assert(height != (unsigned int *) NULL);9   if ((geometry == (char *) NULL) || (*geometry == '\0'))m     return(NoValue);   /*'     Parse geometry using ParseGeometry.    */   former_width=(*width);   former_height=(*height);/   flags=GetGeometry(geometry,x,y,width,height);q   if (flags & PercentValue)t     {a	       int          count;         double         x_scale,         y_scale;         /*3         Geometry is a percentage of the image size.r       */       x_scale=(*width);e       y_scale=(*height);;       count=sscanf(geometry,"%lf%%x%lf",&x_scale,&y_scale);        if (count != 2) ;         count=sscanf(geometry,"%lfx%lf",&x_scale,&y_scale);a       if (count == 1)o         y_scale=x_scale;B       *width=Max((unsigned int) ((x_scale*former_width)/100.0),1);D       *height=Max((unsigned int) ((y_scale*former_height)/100.0),1);       former_width=(*width);       former_height=(*height);     }a   if (!(flags & AspectValue))      {=       double         scale_factor;y         /**         Respect aspect ratio of the image.       */       scale_factor=1.0; ,       if ((former_width*former_height) != 0)	         { H           if (((flags & WidthValue) != 0) && (flags & HeightValue) != 0)
             { 8               scale_factor=(double) *width/former_width;B               if (scale_factor > ((double) *height/former_height))<                 scale_factor=(double) *height/former_height;
             }            else*             if ((flags & WidthValue) != 0)8               scale_factor=(double) *width/former_width;             else:               scale_factor=(double) *height/former_height;	         }(.       *width=Max(scale_factor*former_width,1);0       *height=Max(scale_factor*former_height,1);     }O   if ((flags & XValue) == 0)     *width-=(*x) << 1;   if ((flags & YValue) == 0)     *height-=(*y) << 1;g   if (flags & GreaterValue)a     {>        if (former_width < *width)         *width=former_width;"       if (former_height < *height)         *height=former_height;     }    if (flags & LessValue)     {         if (former_width > *width)         *width=former_width;"       if (former_height > *height)         *height=former_height;     }q   media_info.width=(*width);   media_info.height=(*height);   media_info.x=(*x);   media_info.y=(*y);L   (void) GetGeometry(geometry,&media_info.x,&media_info.y,&media_info.width,     &media_info.height);   if ((flags & XValue) == 0)     {        /*(         Center image in the X direction.       */&       delta=media_info.width-(*width);       if (delta >= 0)          *x=delta >> 1;     }c   else!     if ((flags & XNegative) != 0) $       *x+=media_info.width-(*width);   if ((flags & YValue) == 0)     {        /*(         Center image in the Y direction.       */(       delta=media_info.height-(*height);       if (delta >= 0)          *y=delta >> 1;     }    else!     if ((flags & YNegative) != 0)>&       *y+=media_info.height-(*height);   if (flags & GreaterValue)r     { 2       if ((*width+((*x) << 1)) > media_info.width)	         { )           if ((int) *width > ((*x) << 1))-             *width-=(*x) << 1;*           if ((int) *height > ((*y) << 1))             *height-=(*y) << 1; 	         } 4       if ((*height+((*y) << 1)) > media_info.height)	         {>)           if ((int) *width > ((*x) << 1))              *width-=(*x) << 1;*           if ((int) *height > ((*y) << 1))             *height-=(*y) << 1;(	         }      }    return(flags); }e   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%aO %                                                                             %1O %                                                                             % O %                                                                             %RO %   P i n g I m a g e                                                         % O %                                                                             %lO %                                                                             %pO %                                                                             %rO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%= %oK %  Method PingImage returns the image size in bytes if it exists and can be)M %  read (at %  least up until it reveals it's size).  The width and height ofpN %  the image is returned as well.  Note, only the first image in a multi-frame %  image file is pinged. %t) %  The format of the PingImage method is:( %;4 %      Image *PingImage(const ImageInfo *image_info) % + %  A description of each parameter follows:a %/E %    o Image: Method PingImage returns the image size in bytes if the C %      image file exists and it size can be determined otherwise 0.  %aA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %= */4 Export Image *PingImage(const ImageInfo *image_info) {    Image      *image;o     ImageInfo      *ping_info;   '   ping_info=CloneImageInfo(image_info);    ping_info->ping=True;=   ping_info->verbose=False;    ping_info->subimage=0;   ping_info->subrange=0;   image=ReadImage(ping_info);    DestroyImageInfo(ping_info);   if (image == (Image *) NULL)     return((Image *) NULL);e   if (image_info->verbose)&     DescribeImage(image,stdout,False);   return(image); }  p /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%:O %                                                                             %DO %                                                                             % O %                                                                             % O %   R e a d I m a g e                                                         %(O %                                                                             % O %                                                                             %-O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %>@ %  Method ReadImage reads an image and returns it.  It allocatesL %  the memory necessary for the new Image structure and returns a pointer toJ %  the new image.  By default, the image format is determined by its magicM %  number. To specify a particular image format, precede the filename with an M %  explicit image format name and a colon (i.e.  ps:image) or as the filename) %  suffix  (i.e. image.ps).  %o) %  The format of the ReadImage method is:  % . %      Image *ReadImage(ImageInfo *image_info) %o+ %  A description of each parameter follows:e %-C %    o image: Method ReadImage returns a pointer to the image aftereJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.h %sA %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */. Export Image *ReadImage(ImageInfo *image_info) {    char     filename[MaxTextExtent];     DelegateInfo     delegate_info;     Image      *image,s     *next_image;     MagickInfo     *magick_info;t     register char      *p;      /*I     Determine image type from filename prefix or suffix (e.g. image.jpg).,   */+   assert(image_info != (ImageInfo *) NULL); 0   assert(image_info->filename != (char *) NULL);#   if (*image_info->filename == '@')u#     return(ReadImages(image_info)); !   SetImageInfo(image_info,False); /   (void) strcpy(filename,image_info->filename);e   /*6     Call appropriate image reader based on image type.   */   image=(Image *) NULL; ?   magick_info=(MagickInfo *) GetMagickInfo(image_info->magick);r-   if ((magick_info != (MagickInfo *) NULL) && E       (magick_info->decoder != (Image *(*)(const ImageInfo *)) NULL))G-     image=(magick_info->decoder)(image_info);    elseJ     if (!GetDelegateInfo(image_info->magick,(char *) NULL,&delegate_info))O       MagickWarning(MissingDelegateWarning,"no delegate for this image format",d         image_info->magick);     else       {g         unsigned int           status;   
         /*6           Let our decoding delegate process the image.
         */(         image=AllocateImage(image_info);$         if (image == (Image *) NULL)!           return((Image *) NULL); <         (void) strcpy(image->filename,image_info->filename);0         TemporaryFilename(image_info->filename);         status=%L           InvokeDelegate(image_info,image,image_info->magick,(char *) NULL);         DestroyImages(image);          image=(Image *) NULL;          if (status == False)%           image_info->temporary=True; '         SetImageInfo(image_info,False); E         magick_info=(MagickInfo *) GetMagickInfo(image_info->magick); 3         if ((magick_info != (MagickInfo *) NULL) && K             (magick_info->decoder != (Image *(*)(const ImageInfo *)) NULL)) 3           image=(magick_info->decoder)(image_info);          else/           MagickWarning(MissingDelegateWarning, D             "no delegate for this image format",image_info->magick);       }%   if (image_info->temporary)     {s*       (void) remove(image_info->filename);"       image_info->temporary=False;"       if (image != (Image *) NULL)0         (void) strcpy(image->filename,filename);     }r   if (image == (Image *) NULL)     return(image);   if (image->temporary) (     (void) remove(image_info->filename);)   if (IsSubimage(image_info->tile,False))      {a	       inte         count,         offset,l         quantum;         Image          *subimages;          unsigned int
         last,r         target;r         /*@         User specified subimages (e.g. image.miff[1,3-5,7-6,2]).       */       subimages=(Image *) NULL;I$       target=atoi(image_info->tile);<       for (p=image_info->tile; *p != '\0'; p+=Max(offset,1))       {          offset=0;nB         count=sscanf(p,"%u%n-%u%n",&target,&offset,&last,&offset);         if (count == 0)            continue;o         if (count == 1)o           last=target;'         quantum=target > last ? -1 : 1;s:         for ( ; target != (last+quantum); target+=quantum)	         {oI           for (next_image=image; next_image; next_image=next_image->next)e           {i             Imagee               *clone_image;i  ,             if (next_image->scene != target)               continue;              /*"               Clone this subimage.             */B             clone_image=CloneImage(next_image,next_image->columns,%               next_image->rows,True); .             if (clone_image == (Image *) NULL)               { N                 MagickWarning(ResourceLimitWarning,"Memory allocation failed",(                   image_info->filename);                 break;               }r,             if (subimages == (Image *) NULL)               {b&                 subimages=clone_image;                 continue;                } (             subimages->next=clone_image;0             subimages->next->previous=subimages;&             subimages=subimages->next;           }g	         }g       }o       DestroyImages(image);p       image=(Image *) NULL; &       if (subimages == (Image *) NULL)	         {i&           MagickWarning(OptionWarning,M             "Subimage specification returns no images",image_info->filename);(!           return((Image *) NULL);)	         } 3       while (subimages->previous != (Image *) NULL)l&         subimages=subimages->previous;       image=subimages;     }    elseG     if ((image_info->subrange != 0) && (image->next != (Image *) NULL))e       {g         int            retain;d  
         /*8           User specified subimages (e.g. image.miff[1]).
         */         for ( ; ; )e	         { :           retain=(image->scene >= image_info->subimage) &&L             (image->scene <= (image_info->subimage+image_info->subrange-1));,           if (image->next != (Image *) NULL)
             {'                image=image->next;               if (!retain).                 DestroyImage(image->previous);               continue; 
             } 0           if (image->previous != (Image *) NULL)
             {/$               image=image->previous;               if (!retain)*                 DestroyImage(image->next);               break;
             }m           if (!retain)
             {e"               DestroyImage(image);#               image=(Image *) NULL;)
             }            break;	         } $         if (image == (Image *) NULL)           { (             MagickWarning(OptionWarning,O               "Subimage specification returns no images",image_info->filename); #             return((Image *) NULL);a           } 1         while (image->previous != (Image *) NULL)             image=image->previous;       }    if (image->status)K     MagickWarning(CorruptImageWarning,"An error has occurred reading file",        image->filename); A   for (next_image=image; next_image; next_image=next_image->next)a   { '     DestroyBlobInfo(&image->blob_info);      next_image->tainted=False;D     (void) strcpy(next_image->magick_filename,image_info->filename);     if (image->temporary) ?       (void) strcpy(next_image->filename,image_info->filename); (     if (next_image->magick_columns == 0)5       next_image->magick_columns=next_image->columns; %     if (next_image->magick_rows == 0) /       next_image->magick_rows=next_image->rows; )     if (next_image->class == PseudoClass) (       if (IsMonochromeImage(next_image))	         {)2           next_image->background_color.red=MaxRGB;4           next_image->background_color.green=MaxRGB;3           next_image->background_color.blue=MaxRGB; 	         }(   }P   return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%tO %                                                                             % O %                                                                             %mO %                                                                             % O %   R e a d I m a g e s                                                       %tO %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadImages reads a list of image names from a file and then returns  %  the images as a linked list.  %a) %  The format of the ReadImage method is:' % / %      Image *ReadImages(ImageInfo *image_info)  % + %  A description of each parameter follows:  % C %    o image: Method ReadImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  *// Export Image *ReadImages(ImageInfo *image_info)  {    char
     *command,n
     **images;d     FILE
     *file;     Image      *image,e     *next_image;     inte     c,     length,      number_images;     register char      *p;      register int     i;     /*      Read image list from a file.   */2   file=(FILE *) fopen(image_info->filename+1,"r");   if (file == (FILE *) NULL)     {u@       MagickWarning(FileOpenWarning,"Unable to read image list",         image_info->filename);       return(False);     }    length=MaxTextExtent;,*   command=(char *) AllocateMemory(length);0   for (p=command; command != (char *) NULL; p++)   {      c=fgetc(file);     if (c == EOF)        break;      if ((p-command+1) >= length)       {          *p='\0';         length<<=1; C         command=(char *) ReallocateMemory((char *) command,length); %         if (command == (char *) NULL)            break;"         p=command+Extent(command);       }      *p=(unsigned char) c;    }    (void) fclose(file);   if (command == (char *) NULL)      {'E       MagickWarning(ResourceLimitWarning,"Unable to read image list",e$         "Memory allocation failed");       return(False);     } 
   *p='\0';   Strip(command);'.   images=StringToArgv(command,&number_images);   FreeMemory(command);   /*'     Read the images into a linked list.    */   image=(Image *) NULL; #   for (i=1; i < number_images; i++)    {e2     (void) strcpy(image_info->filename,images[i]);%     next_image=ReadImage(image_info); %     if (next_image == (Image *) NULL)r       continue;       if (image == (Image *) NULL)       image=next_image;      else       {p         register Image
           *q;   
         /*%           Link image into image list. 
         */<         for (q=image; q->next != (Image *) NULL; q=q->next);         next_image->previous=q;          q->next=next_image;        }    }a   return(image); }r ; /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%=O %                                                                             % O %                                                                             %NO %     R G B T r a n s f o r m I m a g e                                       % O %                                                                             %(O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%a %'D %  Method RGBTransformImage converts the reference image from RGB toM %  an alternate colorspace.  The transformation matrices are not the standard L %  ones: the weights are rescaled to normalized the range of the transformed %  values to be [0..MaxRGB]. % 1 %  The format of the RGBTransformImage method is:  % K %      void RGBTransformImage(Image *image,const ColorspaceType colorspace)  % + %  A description of each parameter follows:  % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.x %*L %    o colorspace: An unsigned integer value that indicates which colorspace %      to transform the image. %i %a */K Export void RGBTransformImage(Image *image,const ColorspaceType colorspace)e { A #define RGBTransformImageText  "  Transforming image colors...  "  #define X 0  #define Y (MaxRGB+1) #define Z (MaxRGB+1)*2     double	     blue,)
     green,     red,     tx,      ty,a     tz;      inte     y;     register double      *x_map,l     *y_map,p     *z_map;=     register int     i,     x;     register PixelPacket     *p,      *q;   "   assert(image != (Image *) NULL);M   if ((colorspace == RGBColorspace) || (colorspace == TransparentColorspace))o     return;i#   if (colorspace == CMYKColorspace)      { 
       Quantum          black,
         cyan,          magenta,         yellow;          /*'         Convert RGB to CMYK colorspace.a       */'       image->colorspace=CMYKColorspace;a+       for (y=0; y < (int) image->rows; y++)-       {G4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {            cyan=MaxRGB-q->red;G"           magenta=MaxRGB-q->green;            yellow=MaxRGB-q->blue;           black=cyan;            if (magenta < black)             black=magenta;           if (yellow < black)              black=yellow;;           q->red=cyan;           q->green=magenta;            q->blue=yellow;            q->opacity=black;a           q++;	         }e#         if (!SyncPixelCache(image))            break;       })
       return;      }a   x=0;#   if (colorspace == GRAYColorspace)      {        /*1         Return if the image is already grayscale.d       */+       for (y=0; y < (int) image->rows; y++);       { 4         p=GetPixelCache(image,0,y,image->columns,1);&         if (p == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         { <           if ((p->red != p->green) || (p->green != p->blue))             break;           p++;	         } %         if (x < (int) image->columns)            break;       } B       if ((x == (int) image->columns) && (y == (int) image->rows))         return;%     }%   /*     Allocate the tables.   */?   x_map=(double *) AllocateMemory(3*(MaxRGB+1)*sizeof(double)); ?   y_map=(double *) AllocateMemory(3*(MaxRGB+1)*sizeof(double)); ?   z_map=(double *) AllocateMemory(3*(MaxRGB+1)*sizeof(double)); A   if ((x_map == (double *) NULL) || (y_map == (double *) NULL) || !       (z_map == (double *) NULL))      { K       MagickWarning(ResourceLimitWarning,"Unable to transform color space", $         "Memory allocation failed");
       return;      }    tx=0;    ty=0;    tz=0;    switch (colorspace)%   {%     case GRAYColorspace:     {%       /*         Initialize GRAY tables:C  +           G = 0.29900*R+0.58700*G+0.11400*Bc       */!       for (i=0; i <= MaxRGB; i++)C       {m         x_map[i+X]=0.299*i;          y_map[i+X]=0.587*i;u         z_map[i+X]=0.114*i;          x_map[i+Y]=0.299*i;          y_map[i+Y]=0.587*i;a         z_map[i+Y]=0.114*i;t         x_map[i+Z]=0.299*i;          y_map[i+Z]=0.587*i;g         z_map[i+Z]=0.114*i;o       }t       break;     }      case OHTAColorspace:     {e       /*         Initialize OHTA tables:n  ,           I1 = 0.33333*R+0.33334*G+0.33333*B,           I2 = 0.50000*R+0.00000*G-0.50000*B,           I3 =-0.25000*R+0.50000*G-0.25000*B  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0          through MaxRGB.e       */       ty=(MaxRGB+1) >> 1;        tz=(MaxRGB+1) >> 1;=!       for (i=0; i <= MaxRGB; i++)t       {&         x_map[i+X]=0.33333*i;          y_map[i+X]=0.33334*i;w         z_map[i+X]=0.33333*i;e         x_map[i+Y]=0.5*i;u         y_map[i+Y]=0.0;          z_map[i+Y]=(-0.5)*i;         x_map[i+Z]=(-0.25)*i;e         y_map[i+Z]=0.5*i;a         z_map[i+Z]=(-0.25)*i;        }        break;     }i     case sRGBColorspace:     {x       /*         Initialize sRGB tables:(  ,           Y =  0.29900*R+0.58700*G+0.11400*B,           C1= -0.29900*R-0.58700*G+0.88600*B,           C2=  0.70100*R-0.58700*G-0.11400*B  C         sRGB is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.        */       ty=UpScale(156);       tz=UpScale(137);/       for (i=0; i <= (int) (0.018*MaxRGB); i++)        { 1         x_map[i+X]=0.003962014134275617*MaxRGB*i; 1         y_map[i+X]=0.007778268551236748*MaxRGB*i; 1         z_map[i+X]=0.001510600706713781*MaxRGB*i; 4         x_map[i+Y]=(-0.002426619775463276)*MaxRGB*i;4         y_map[i+Y]=(-0.004763965913702149)*MaxRGB*i;1         z_map[i+Y]=0.007190585689165425*MaxRGB*i; 1         x_map[i+Z]=0.006927257754597858*MaxRGB*i; 4         y_map[i+Z]=(-0.005800713697502058)*MaxRGB*i;2         z_map[i+Z]=(-0.0011265440570958)*MaxRGB*i;       }%       for ( ; i <= MaxRGB; i++)e       {n6         x_map[i+X]=0.2201118963486454*(1.099*i-0.099);6         y_map[i+X]=0.4321260306242638*(1.099*i-0.099);7         z_map[i+X]=0.08392226148409894*(1.099*i-0.099);d9         x_map[i+Y]=(-0.1348122097479598)*(1.099*i-0.099);o9         y_map[i+Y]=(-0.2646647729834528)*(1.099*i-0.099);I6         z_map[i+Y]=0.3994769827314126*(1.099*i-0.099);6         x_map[i+Z]=0.3848476530332144*(1.099*i-0.099);9         y_map[i+Z]=(-0.3222618720834477)*(1.099*i-0.099);e:         z_map[i+Z]=(-0.06258578094976668)*(1.099*i-0.099);       }s       break;     }e     case XYZColorspace:[     {E       /*"         Initialize CIE XYZ tables:  .           X = 0.412453*X+0.357580*Y+0.180423*Z.           Y = 0.212671*X+0.715160*Y+0.072169*Z.           Z = 0.019334*X+0.119193*Y+0.950227*Z       */!       for (i=0; i <= MaxRGB; i++)        {c         x_map[i+X]=0.412453*i;         y_map[i+X]=0.35758*i;(         z_map[i+X]=0.180423*i;         x_map[i+Y]=0.212671*i;         y_map[i+Y]=0.71516*i;a         z_map[i+Y]=0.072169*i;         x_map[i+Z]=0.019334*i;         y_map[i+Z]=0.119193*i;         z_map[i+Z]=0.950227*i;       }.       break;     }(     case YCbCrColorspace:'     {        /*          Initialize YCbCr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*Bf/           Cb= -0.168736*R-0.331264*G+0.500000*B /           Cr=  0.500000*R-0.418688*G-0.083168*B   K         Cb and Cr, normally -0.5 through 0.5, are normalized to the range 0f         through MaxRGB.a       */       ty=(MaxRGB+1) >> 1;v       tz=(MaxRGB+1) >> 1;%!       for (i=0; i <= MaxRGB; i++)        {f         x_map[i+X]=0.299*i;)         y_map[i+X]=0.587*i;)         z_map[i+X]=0.114*i;c          x_map[i+Y]=(-0.16873)*i;!         y_map[i+Y]=(-0.331264)*i;e         z_map[i+Y]=0.500000*i;         x_map[i+Z]=0.500000*i;!         y_map[i+Z]=(-0.418688)*i;_!         z_map[i+Z]=(-0.081312)*i;.       }1       break;     }o     case YCCColorspace:v     {r       /*         Initialize YCC tables:  ,           Y =  0.29900*R+0.58700*G+0.11400*B,           C1= -0.29900*R-0.58700*G+0.88600*B,           C2=  0.70100*R-0.58700*G-0.11400*B  B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */       ty=UpScale(156);       tz=UpScale(137);/       for (i=0; i <= (int) (0.018*MaxRGB); i++)        {r1         x_map[i+X]=0.003962014134275617*MaxRGB*i; 1         y_map[i+X]=0.007778268551236748*MaxRGB*i;a1         z_map[i+X]=0.001510600706713781*MaxRGB*i;C4         x_map[i+Y]=(-0.002426619775463276)*MaxRGB*i;4         y_map[i+Y]=(-0.004763965913702149)*MaxRGB*i;1         z_map[i+Y]=0.007190585689165425*MaxRGB*i;r1         x_map[i+Z]=0.006927257754597858*MaxRGB*i;e4         y_map[i+Z]=(-0.005800713697502058)*MaxRGB*i;2         z_map[i+Z]=(-0.0011265440570958)*MaxRGB*i;       }        for ( ; i <= MaxRGB; i++)z       { 6         x_map[i+X]=0.2201118963486454*(1.099*i-0.099);6         y_map[i+X]=0.4321260306242638*(1.099*i-0.099);7         z_map[i+X]=0.08392226148409894*(1.099*i-0.099);l9         x_map[i+Y]=(-0.1348122097479598)*(1.099*i-0.099);k9         y_map[i+Y]=(-0.2646647729834528)*(1.099*i-0.099); 6         z_map[i+Y]=0.3994769827314126*(1.099*i-0.099);6         x_map[i+Z]=0.3848476530332144*(1.099*i-0.099);9         y_map[i+Z]=(-0.3222618720834477)*(1.099*i-0.099);0:         z_map[i+Z]=(-0.06258578094976668)*(1.099*i-0.099);       }*       break;     }      case YIQColorspace:      {u       /*         Initialize YIQ tables:  +           Y = 0.29900*R+0.58700*G+0.11400*B\+           I = 0.59600*R-0.27400*G-0.32200*Bf+           Q = 0.21100*R-0.52300*G+0.31200*Bg  I         I and Q, normally -0.5 through 0.5, are normalized to the range 0'         through MaxRGB.l       */       ty=(MaxRGB+1) >> 1;)       tz=(MaxRGB+1) >> 1;n!       for (i=0; i <= MaxRGB; i++)i       {i         x_map[i+X]=0.299*i;r         y_map[i+X]=0.587*i;l         z_map[i+X]=0.114*i;I         x_map[i+Y]=0.596*i;a         y_map[i+Y]=(-0.274)*i;         z_map[i+Y]=(-0.322)*i;         x_map[i+Z]=0.211*i;f         y_map[i+Z]=(-0.523)*i;         z_map[i+Z]=0.312*i;n       }p       break;     }      case YPbPrColorspace:      {)       /*          Initialize YPbPr tables:  /           Y =  0.299000*R+0.587000*G+0.114000*B,/           Pb= -0.168736*R-0.331264*G+0.500000*Bp/           Pr=  0.500000*R-0.418688*G-0.081312*Ba  K         Pb and Pr, normally -0.5 through 0.5, are normalized to the range 0s         through MaxRGB.e       */       ty=(MaxRGB+1) >> 1;"       tz=(MaxRGB+1) >> 1;f!       for (i=0; i <= MaxRGB; i++)a       {e         x_map[i+X]=0.299*i;f         y_map[i+X]=0.587*i;;         z_map[i+X]=0.114*i;f!         x_map[i+Y]=(-0.168736)*i;=!         y_map[i+Y]=(-0.331264)*i;a         z_map[i+Y]=0.5*i;n         x_map[i+Z]=0.5*i;;!         y_map[i+Z]=(-0.418688)*i;g!         z_map[i+Z]=(-0.081312)*i;        }v       break;     }m     case YUVColorspace:e     default:     {i       /*         Initialize YUV tables:  ,           Y =  0.29900*R+0.58700*G+0.11400*B,           U = -0.14740*R-0.28950*G+0.43690*B,           V =  0.61500*R-0.51500*G-0.10000*B  I         U and V, normally -0.5 through 0.5, are normalized to the range 00D         through MaxRGB.  Note that U = 0.493*(B-Y), V = 0.877*(R-Y).       */       ty=(MaxRGB+1) >> 1;r       tz=(MaxRGB+1) >> 1; !       for (i=0; i <= MaxRGB; i++)m       {m         x_map[i+X]=0.299*i;          y_map[i+X]=0.587*i;)         z_map[i+X]=0.114*i;)         x_map[i+Y]=(-0.1474)*i;          y_map[i+Y]=(-0.2895)*i;          z_map[i+Y]=0.4369*i;         x_map[i+Z]=0.615*i;2         y_map[i+Z]=(-0.515)*i;         z_map[i+Z]=(-0.1)*i;       },       break;     }    }e   /*     Convert from RGB.f   */   switch (image->class)%   {4     case DirectClass:      default:     {-       /*"         Convert DirectClass image.       */+       for (y=0; y < (int) image->rows; y++)i       {f4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {)D           red=x_map[q->red+X]+y_map[q->green+X]+z_map[q->blue+X]+tx;F           green=x_map[q->red+Y]+y_map[q->green+Y]+z_map[q->blue+Y]+ty;E           blue=x_map[q->red+Z]+y_map[q->green+Z]+z_map[q->blue+Z]+tz; ;           q->red=red < 0 ? 0 : red > MaxRGB ? MaxRGB : red;PC           q->green=green < 0 ? 0 : green > MaxRGB ? MaxRGB : green; ?           q->blue=blue < 0 ? 0 : blue > MaxRGB ? MaxRGB : blue;m           q++;	         } #         if (!SyncPixelCache(image)):           break;'         if (QuantumTick(y,image->rows)))?           ProgressMonitor(RGBTransformImageText,y,image->rows);        })       break;     }2     case PseudoClass:i     {n       /*"         Convert PseudoClass image.       */-       for (i=0; i < (int) image->colors; i++)r       {,N         red=x_map[image->colormap[i].red+X]+y_map[image->colormap[i].green+X]+.           z_map[image->colormap[i].blue+X]+tx;P         green=x_map[image->colormap[i].red+Y]+y_map[image->colormap[i].green+Y]+.           z_map[image->colormap[i].blue+Y]+ty;O         blue=x_map[image->colormap[i].red+Z]+y_map[image->colormap[i].green+Z]+a.           z_map[image->colormap[i].blue+Z]+tz;I         image->colormap[i].red=red < 0 ? 0 : red > MaxRGB ? MaxRGB : red;t!         image->colormap[i].green=-:           green < 0 ? 0 : green > MaxRGB ? MaxRGB : green;M         image->colormap[i].blue=blue < 0 ? 0 : blue > MaxRGB ? MaxRGB : blue;g       }=       SyncImage(image);        break;     }    }e   /*     Free allocated memory.   */   FreeMemory(z_map);   FreeMemory(y_map);   FreeMemory(x_map); }r f /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %=O %                                                                             %vO %   S e t I m a g e                                                           %aO %                                                                             %eO %                                                                             % O %                                                                             %.O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %tK %  Method SetImage initializes the reference image to the background color.n %f( %  The format of the SetImage method is: %m" %      void SetImage(Image *image) %c+ %  A description of each parameter follows:m %-F %    o image: The address of a structure of type Image;  returned from %      ReadImage.m %- %l */" Export void SetImage(Image *image) {f   intg     y;     register int     x;     register PixelPacket     *q;;  "   assert(image != (Image *) NULL);'   for (y=0; y < (int) image->rows; y++)    { 0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {0!       *q=image->background_color;+       q->opacity=Opaque;
       q++;     }.$     if (image->class == PseudoClass).       for (x=0; x < (int) image->columns; x++)         image->indexes[x]=0;     if (!SyncPixelCache(image))        break;   }N }" r /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%;O %                                                                             %pO %                                                                             % O %                                                                             %bO %   S e t I m a g e I n f o                                                   %pO %                                                                             % O %                                                                             %cO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %;F %  Method SetImageInfo initializes the `magick' field of the ImageInfoI %  structure.  It is set to a type of image format based on the prefix or I %  suffix of the filename.  For example, `ps:image' returns PS indicatingeH %  a Postscript image.  JPEG is returned for this filename: `image.jpg'.N %  The filename prefix has precendence over the suffix.  Use an optional indexL %  enclosed in brackets after a file name to specify a desired subimage of aE %  multi-resolution image format like Photo CD (e.g. img0001.pcd[4]).  % , %  The format of the SetImageInfo method is: %eJ %      void SetImageInfo(ImageInfo *image_info,const unsigned int rectify) % + %  A description of each parameter follows:e % A %    o image_info: Specifies a pointer to an ImageInfo structure.2 % M %    o rectify: an unsigned value other than zero rectifies the attribute for N %      multi-frame support (user may want multi-frame but image format may not %      support it).  %  %  */J Export void SetImageInfo(ImageInfo *image_info,const unsigned int rectify) {r   char     magick[MaxTextExtent];     Image      *image;      register charC     *p,l     *q;a     register MagickInfoa     *r;      unsigned int     affirm,e     status;s     /*(     Look for 'image.format' in filename.   */+   assert(image_info != (ImageInfo *) NULL);C   *magick='\0';b8   p=image_info->filename+Extent(image_info->filename)-1;   if (*p == ']').     for (q=p-1; q > image_info->filename; q--)     { 
       char         *tile;         /*?         Look for sub-image specification (e.g. img0001.pcd[4]).a       */       if (*q != '[')         continue;a       if (!IsGeometry(q+1))          break;7       tile=(char *) AllocateMemory((p-q)*sizeof(char));a        if (tile == (char *) NULL)         break;%       (void) strncpy(tile,q+1,p-q-1);        tile[p-q-1]='\0';        *q='\0';
       p=q;1       (void) CloneString(&image_info->tile,tile);h       FreeMemory(tile);o-       if (!IsSubimage(image_info->tile,True))          break;       /*"         Determine sub-image range.       */2       image_info->subimage=atoi(image_info->tile);2       image_info->subrange=atoi(image_info->tile);C       (void) sscanf(image_info->tile,"%u-%u",&image_info->subimage,m         &image_info->subrange);=6       if (image_info->subrange < image_info->subimage)8         Swap(image_info->subimage,image_info->subrange);
       else	         {s'           FreeMemory(image_info->tile);s)           image_info->tile=(char *) NULL;f	         },3       image_info->subrange-=image_info->subimage-1;        break;     }.7   while ((*p != '.') && (p > (image_info->filename+1)))f     p--;F   if ((Latin1Compare(p,".gz") == 0) || (Latin1Compare(p,".Z") == 0) ||%       (Latin1Compare(p,".bz2") == 0))e     do     {f
       p--;<     } while ((*p != '.') && (p > (image_info->filename+1)));8   if ((*p == '.') && (Extent(p) < (int) sizeof(magick)))     {i       /*$         User specified image format.       */        (void) strcpy(magick,p+1);%       for (q=magick; *q != '\0'; q++)l         if (*q == '.')           {              *q='\0';             break;           }i       Latin1Upper(magick);       /*?         SGI and RGB are ambiguous;  TMP must be set explicitly.m       */8       if (((strncmp(image_info->magick,"SGI",3) != 0) ||0           (Latin1Compare(magick,"RGB") != 0)) &&-           (Latin1Compare(magick,"TMP") != 0)) 1         (void) strcpy(image_info->magick,magick);h     }f   /*1     Look for explicit 'format:image' in filename.z   */   affirm=False;    p=image_info->filename;l   while (isalnum((int) *p))e     p++; #if defined(vms)   if (*(p+1) == '[')     p++; #endifG   if ((*p == ':') && ((p-image_info->filename) < (int) sizeof(magick))))     {        /*$         User specified image format.       */I       (void) strncpy(magick,image_info->filename,p-image_info->filename);v*       magick[p-image_info->filename]='\0';       Latin1Upper(magick);( #if defined(macintosh) || defined(WIN32)'       if (!ImageFormatConflict(magick))e #endif	         {i           /**             Strip off image format prefix.           */           p++;0           (void) strcpy(image_info->filename,p);4           if (Latin1Compare(magick,"IMPLICIT") != 0)
             {v7               (void) strcpy(image_info->magick,magick);v3               if (Latin1Compare(magick,"TMP") != 0)o                 affirm=True;               else+                 image_info->temporary=True;o
             }o	         }v     }e   if (rectify)     {t
       char          filename[MaxTextExtent];         MagickInfo         *magick_info;>         /*)         Rectify multi-image file support.)       */4       FormatString(filename,image_info->filename,0);@       if ((Latin1Compare(filename,image_info->filename) != 0) &&2           (strchr(filename,'%') == (char *) NULL))!         image_info->adjoin=False;e7       magick_info=(MagickInfo *) GetMagickInfo(magick);)-       if (magick_info != (MagickInfo *) NULL)-0         image_info->adjoin&=magick_info->adjoin;
       return;,     }a
   if (affirm)a     return;s   /*     Allocate image structure.!   */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return;t   /*D     Determine the image format from the first few bytes of the file.   */6   (void) strcpy(image->filename,image_info->filename);3   status=OpenBlob(image_info,image,ReadBinaryType);-   if (status == False)     return; B   if ((image->blob_info.data != (char *) NULL)  || !image->exempt)0     (void) ReadBlob(image,MaxTextExtent,magick);   else     {c
       FILE         *file;         register int
         c,
         i;         /*6         Copy standard input or pipe to temporary file.       */%       image_info->file=(FILE *) NULL;i)       TemporaryFilename(image->filename);s!       image_info->temporary=True;nC       FormatString(image_info->filename,"%.1024s",image->filename);b2       file=fopen(image->filename,WriteBinaryType);        if (file == (FILE *) NULL)	         {CP           MagickWarning(FileOpenWarning,"Unable to write file",image->filename);           return;d	         }i
       i=0;@       for (c=fgetc(image->file); c != EOF; c=fgetc(image->file))       {g         if (i < MaxTextExtent)           magick[i++]=c;         (void) putc(c,file);       }t       (void) fclose(file);     }e   DestroyImage(image);   magick[MaxTextExtent-1]='\0';i%   if (strncmp(magick,"BEGMF",3) == 0)0,     (void) strcpy(image_info->magick,"CGM");'   if (strncmp(magick,"digraph",7) == 0) ,     (void) strcpy(image_info->magick,"DOT");$   if (strncmp(magick,"#FIG",4) == 0),     (void) strcpy(image_info->magick,"FIG");9   if (strncmp(magick,"#!/usr/local/bin/gnuplot",24) == 0) -     (void) strcpy(image_info->magick,"GPLT"); #   if (strncmp(magick,"IN;",3) == 0) -     (void) strcpy(image_info->magick,"HPGL"); &   if (strncmp(magick+8,"ILBM",2) == 0)-     (void) strcpy(image_info->magick,"ILBM");=1   if ((magick[0] == 0x00) && (magick[1] == 0x00))iC     if ((magick[2] == 0x01) && ((unsigned char) magick[3] == 0xb3))t.       (void) strcpy(image_info->magick,"M2V");+   if (strncmp(magick,"#?RADIANCE",10) == 0)-,     (void) strcpy(image_info->magick,"RAD");.   if (strncmp(magick,"gimp xcf file",13) == 0),     (void) strcpy(image_info->magick,"XCF");K   for (r=GetMagickInfo((char *) NULL); r != (MagickInfo *) NULL; r=r->next)      if (r->magick)<       if (r->magick((unsigned char *) magick,MaxTextExtent))1         (void) strcpy(image_info->magick,r->tag);r }o   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%zO %                                                                             %iO %                                                                             %&O %                                                                             %;O %   S o r t C o l o r m a p B y I n t e n t s i t y                           %lO %                                                                             %aO %                                                                             %nO %                                                                             %vO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %fK %  Method SortColormapByIntensity sorts the colormap of a PseudoClass imagei! %  by decreasing color intensity.m %s7 %  The format of the SortColormapByIntensity method is:  % 1 %      void SortColormapByIntensity(Image *image)  %e+ %  A description of each parameter follows:  % - %    o image: A pointer to a Image structure.  %  %  */  8 static int IntensityCompare(const void *x,const void *y) { 
   PixelPacket 
     *color_1,i
     *color_2;,     color_1=(PixelPacket *) x;   color_2=(PixelPacket *) y;>   return((int) Intensity(*color_2)-(int) Intensity(*color_1)); }s  1 Export void SortColormapByIntensity(Image *image)I {e   int      y;     register int     i,     x;     register PixelPacket     *q;%     register unsigned short%
     index;     unsigned short     *pixels;  "   assert(image != (Image *) NULL);"   if (image->class != PseudoClass)     return;    /*&     Allocate memory for pixel indexes.   */   pixels=(unsigned short *) 9     AllocateMemory(image->colors*sizeof(unsigned short)); (   if (pixels == (unsigned short *) NULL)     { C       MagickWarning(ResourceLimitWarning,"Unable to sort colormap", $         "Memory allocation failed");
       return;      }    /*,     Assign index values to colormap entries.   */)   for (i=0; i < (int) image->colors; i++) 2     image->colormap[i].opacity=(unsigned short) i;   /*7     Sort image colormap by decreasing color popularity.%   */I   qsort((void *) image->colormap,(int) image->colors,sizeof(PixelPacket), <     (int (*)(const void *, const void *)) IntensityCompare);   /*;     Update image colormap indexes to sorted colormap order.m   */)   for (i=0; i < (int) image->colors; i++)a:     pixels[image->colormap[i].opacity]=(unsigned short) i;'   for (y=0; y < (int) image->rows; y++)m   { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     { &       index=pixels[image->indexes[x]];       image->indexes[x]=index;"       *q++=image->colormap[index];     }    }    FreeMemory(pixels);e }a c /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %)O %                                                                             %rO %                                                                             %tO %   S y n c I m a g e                                                         %)O %                                                                             %eO %                                                                             %eO %                                                                             %eO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%( %gL %  Method SyncImage initializes the red, green, and blue intensities of each* %  pixel as defined by the colormap index. % ) %  The format of the SyncImage method is:  %e# %      void SyncImage(Image *image)  %l+ %  A description of each parameter follows:p %l7 %    o image: The address of a structure of type Image.; %  %( */# Export void SyncImage(Image *image)  { 
   IndexPackete
     index;     inti     y;     register int     x;     register PixelPacket     *q;   "   assert(image != (Image *) NULL);"   if (image->class == DirectClass)     return;n'   for (y=0; y < (int) image->rows; y++)-   {i0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {        index=image->indexes[x];"       *q++=image->colormap[index];     }x     if (!SyncPixelCache(image))        break;   }  }  g /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%eO %                                                                             %%O %                                                                             % O %     T e x t u r e I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % H %  Method TextureImage layers a texture onto the background of an image. % , %  The format of the TextureImage method is: % 5 %      void TextureImage(Image *image,Image *texture)% %%+ %  A description of each parameter follows:% % F %    o image: The address of a structure of type Image;  returned from %      ReadImage.u % K %    o texture: This image contains the texture to layer on the background.o %a %n */5 Export void TextureImage(Image *image,Image *texture)r {t8 #define TextureImageText  "  Appling image texture...  "     inte     x,     y;  "   assert(image != (Image *) NULL);&   if (texture == (const Image *) NULL)     return;    /*+     Tile texture onto the image background.n   */4   for (y=0; y < (int) image->rows; y+=texture->rows)   { <     for (x=0; x < (int) image->columns; x+=texture->columns);       CompositeImage(image,ReplaceCompositeOp,texture,x,y);m#     if (QuantumTick(y,image->rows))(6       ProgressMonitor(TextureImageText,y,image->rows);   }- }l   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%rO %                                                                             %oO %                                                                             %>O %     T r a n s f o r m R G B I m a g e                                       %oO %                                                                             %>O %                                                                             %=O %                                                                             %aO %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%o %eJ %  Method TransformRGBImage converts the reference image from an alternateK %  colorspace.  The transformation matrices are not the standard ones:  theeK %  weights are rescaled to normalize the range of the transformed values too %  be [0..MaxRGB]. % 1 %  The format of the TransformRGBImage method is:t %hK %      void TransformRGBImage(Image *image,const ColorspaceType colorspace)i %-+ %  A description of each parameter follows:f %mF %    o image: The address of a structure of type Image;  returned from %      ReadImage.h %*H %    o colorspace: An unsigned integer value defines which colorspace to %      transform the image to. %% %% */K Export void TransformRGBImage(Image *image,const ColorspaceType colorspace)  {  #define B (MaxRGB+1)*2 #define G (MaxRGB+1) #define R 0 A #define TransformRGBImageText  "  Transforming image colors...  "      static const Quantum     sRGBMap[351] =     { K         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13, K        14,  15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27, K        28,  29,  29,  30,  31,  32,  33,  34,  35,  36,  37,  38,  39,  40, K        41,  42,  43,  44,  45,  46,  47,  48,  49,  50,  51,  52,  53,  54, K        55,  56,  57,  58,  59,  60,  61,  62,  63,  65,  66,  67,  68,  69,%K        70,  71,  72,  73,  74,  75,  76,  77,  78,  79,  80,  81,  82,  83, K        84,  85,  86,  87,  88,  89,  90,  91,  92,  93,  95,  96,  97,  98, K        99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112,IK       114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, K       128, 129, 130, 131, 132, 133, 135, 136, 137, 138, 139, 140, 141, 142,iK       143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156,rK       157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, K       171, 172, 173, 174, 175, 175, 176, 177, 178, 179, 180, 181, 182, 183,eK       184, 185, 186, 187, 187, 188, 189, 190, 191, 192, 193, 194, 194, 195,eK       196, 197, 198, 199, 199, 200, 201, 202, 203, 203, 204, 205, 206, 207,oK       207, 208, 209, 210, 210, 211, 212, 213, 213, 214, 215, 215, 216, 217,lK       218, 218, 219, 220, 220, 221, 222, 222, 223, 223, 224, 225, 225, 226,%K       227, 227, 228, 228, 229, 229, 230, 230, 231, 232, 232, 233, 233, 234, K       234, 235, 235, 235, 236, 236, 237, 237, 238, 238, 238, 239, 239, 240, K       240, 240, 241, 241, 242, 242, 242, 243, 243, 243, 243, 244, 244, 244, K       245, 245, 245, 245, 246, 246, 246, 247, 247, 247, 247, 247, 248, 248, K       248, 248, 249, 249, 249, 249, 249, 249, 250, 250, 250, 250, 250, 250, K       251, 251, 251, 251, 251, 251, 252, 252, 252, 252, 252, 252, 252, 252, K       252, 253, 253, 253, 253, 253, 253, 253, 253, 253, 254, 254, 254, 254, K       254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, 255, 255, 255,%	       255%     },J     YCCMap[351] =  /* Photo CD information beyond 100% white, Gamma 2.2 */     {eK         0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,cK         14, 15,  16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,fK         28, 29,  30,  32,  33,  34,  35,  36,  37,  38,  39,  40,  41,  42, K         43, 45,  46,  47,  48,  49,  50,  51,  52,  53,  54,  56,  57,  58,lK         59, 60,  61,  62,  63,  64,  66,  67,  68,  69,  70,  71,  72,  73,iK         74, 76,  77,  78,  79,  80,  81,  82,  83,  84,  86,  87,  88,  89,dK         90, 91,  92,  93,  94,  95,  97,  98,  99, 100, 101, 102, 103, 104,IK       105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, K       120, 121, 122, 123, 124, 125, 126, 127, 129, 130, 131, 132, 133, 134,;K       135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, K       149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, K       163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176,oK       176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189,eK       190, 191, 192, 193, 193, 194, 195, 196, 197, 198, 199, 200, 201, 201,iK       202, 203, 204, 205, 206, 207, 207, 208, 209, 210, 211, 211, 212, 213,tK       214, 215, 215, 216, 217, 218, 218, 219, 220, 221, 221, 222, 223, 224,oK       224, 225, 226, 226, 227, 228, 228, 229, 230, 230, 231, 232, 232, 233, K       234, 234, 235, 236, 236, 237, 237, 238, 238, 239, 240, 240, 241, 241,,K       242, 242, 243, 243, 244, 244, 245, 245, 245, 246, 246, 247, 247, 247,pK       248, 248, 248, 249, 249, 249, 249, 250, 250, 250, 250, 251, 251, 251,iK       251, 251, 252, 252, 252, 252, 252, 253, 253, 253, 253, 253, 253, 253, K       253, 253, 253, 253, 253, 253, 254, 254, 254, 254, 254, 254, 254, 254,%K       254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 254, 255, 255, 255, K       255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, K       255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 	       255      };     double	     blue,      *blue_map,
     green,     *green_map,      red,
     *red_map;      int      y;     register int     i,     x;     register PixelPacket     *q;   "   assert(image != (Image *) NULL);M   if ((image->colorspace == CMYKColorspace) && (colorspace == RGBColorspace))      {        unsigned int         black,
         cyan,%         magenta,         yellow;%         /*)         Transform image from CMYK to RGB.i       */&       image->colorspace=RGBColorspace;+       for (y=0; y < (int) image->rows; y++)        {e4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {o           cyan=q->red;           magenta=q->green;*           yellow=q->blue;i           black=q->opacity;i$           if ((cyan+black) > MaxRGB)             q->red=0;o           else'             q->red=MaxRGB-(cyan+black);a'           if ((magenta+black) > MaxRGB)m             q->green=0;F           else,             q->green=MaxRGB-(magenta+black);&           if ((yellow+black) > MaxRGB)             q->blue=0;           else*             q->blue=MaxRGB-(yellow+black);           q->opacity=0;o           q++;	         }o#         if (!SyncPixelCache(image))>           break;       }>
       return;U     } H   if ((colorspace == RGBColorspace) || (colorspace == GRAYColorspace) ||,       (colorspace == TransparentColorspace))     return;i   /*     Allocate the tables.   */A   red_map=(double *) AllocateMemory(3*(MaxRGB+1)*sizeof(double)); C   green_map=(double *) AllocateMemory(3*(MaxRGB+1)*sizeof(double));gB   blue_map=(double *) AllocateMemory(3*(MaxRGB+1)*sizeof(double));G   if ((red_map == (double *) NULL) || (green_map == (double *) NULL) || $       (blue_map == (double *) NULL))     {nK       MagickWarning(ResourceLimitWarning,"Unable to transform color space",z$         "Memory allocation failed");
       return;r     }    switch (colorspace)    {)     case OHTAColorspace:     {o       /*         Initialize OHTA tables:)  &           R = I1+1.00000*I2-0.66668*I3&           G = I1+0.00000*I2+1.33333*I3&           B = I1-1.00000*I2-0.66668*I3  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0m         through MaxRGB.e       */!       for (i=0; i <= MaxRGB; i++)a       {*         red_map[i+R]=i; *         green_map[i+R]=0.5*(2.0*i-MaxRGB);0         blue_map[i+R]=(-0.33334)*(2.0*i-MaxRGB);         red_map[i+G]=i;          green_map[i+G]=0.0;G.         blue_map[i+G]=0.666665*(2.0*i-MaxRGB);         red_map[i+B]=i;e-         green_map[i+B]=(-0.5)*(2.0*i-MaxRGB);e0         blue_map[i+B]=(-0.33334)*(2.0*i-MaxRGB);       }r       break;     }w     case sRGBColorspace:     {U       /*         Initialize sRGB tables:   '           R = Y            +1.032096*C2%'           G = Y-0.326904*C1-0.704445*C2            B = Y+1.685070*C1   C         sRGB is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.        */!       for (i=0; i <= MaxRGB; i++)        {          red_map[i+R]=1.40200*i;          green_map[i+R]=0.0; 8         blue_map[i+R]=1.88000*(i-(double) UpScale(137));         red_map[i+G]=1.40200*i; =         green_map[i+G]=(-0.444066)*(i-(double) UpScale(156)); ;         blue_map[i+G]=(-0.95692)*(i-(double) UpScale(137));          red_map[i+B]=1.40200*i; 9         green_map[i+B]=2.28900*(i-(double) UpScale(156));          blue_map[i+B]=0.0;       }%       break;     }%     case XYZColorspace:%     {%       /*"         Initialize CIE XYZ tables:  /           R =  3.240479*R-1.537150*G-0.498535*Bt/           G = -0.969256*R+1.875992*G+0.041556*Be/           B =  0.055648*R-0.204043*G+1.057311*B        */!       for (i=0; i <= MaxRGB; i++)t       {s          red_map[i+R]=3.240479*i;%         green_map[i+R]=(-1.537150)*i;e$         blue_map[i+R]=(-0.498535)*i;#         red_map[i+G]=(-0.969256)*i;."         green_map[i+G]=1.875992*i;!         blue_map[i+G]=0.041556*i;           red_map[i+B]=0.055648*i;%         green_map[i+B]=(-0.204043)*i;I!         blue_map[i+B]=1.057311*i;p       }Y       break;     }u     case YCbCrColorspace:      {o       /*          Initialize YCbCr tables:  '           R = Y            +1.402000*Crn'           G = Y-0.344136*Cb-0.714136*Crg           B = Y+1.772000*Cbu  O         Cb and Cr, normally -0.5 through 0.5, must be normalized to the range 0f         through MaxRGB.u       */!       for (i=0; i <= MaxRGB; i++)y       {          red_map[i+R]=i;%         green_map[i+R]=0.0;%4         blue_map[i+R]=(1.402000*0.5)*(2.0*i-MaxRGB);         red_map[i+G]=i; 6         green_map[i+G]=(-0.344136*0.5)*(2.0*i-MaxRGB);5         blue_map[i+G]=(-0.714136*0.5)*(2.0*i-MaxRGB);          red_map[i+B]=i; 5         green_map[i+B]=(1.772000*0.5)*(2.0*i-MaxRGB);          blue_map[i+B]=0.0;       }        break;     }      case YCCColorspace:      {        /*         Initialize YCC tables:  '           R = Y            +1.340762*C2 '           G = Y-0.317038*C1-0.682243*C2            B = Y+1.632639*C1   B         YCC is scaled by 1.3584.  C1 zero is 156 and C2 is at 137.       */!       for (i=0; i <= MaxRGB; i++)%       {%         red_map[i+R]=1.3584*i;         green_map[i+R]=0.0;a7         blue_map[i+R]=1.8215*(i-(double) UpScale(137));T         red_map[i+G]=1.3584*i;>         green_map[i+G]=(-0.4302726)*(i-(double) UpScale(156));=         blue_map[i+G]=(-0.9271435)*(i-(double) UpScale(137));o         red_map[i+B]=1.3584*i;8         green_map[i+B]=2.2179*(i-(double) UpScale(156));         blue_map[i+B]=0.0;       }        break;     }*     case YIQColorspace:)     {        /*         Initialize YIQ tables:  #           R = Y+0.95620*I+0.62140*Qm#           G = Y-0.27270*I-0.64680*Qn#           B = Y-1.10370*I+1.70060*Q%  M         I and Q, normally -0.5 through 0.5, must be normalized to the range 0          through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)        {          red_map[i+R]=i; -         green_map[i+R]=0.4781*(2.0*i-MaxRGB); ,         blue_map[i+R]=0.3107*(2.0*i-MaxRGB);         red_map[i+G]=i; 1         green_map[i+G]=(-0.13635)*(2.0*i-MaxRGB); /         blue_map[i+G]=(-0.3234)*(2.0*i-MaxRGB);          red_map[i+B]=i; 1         green_map[i+B]=(-0.55185)*(2.0*i-MaxRGB); ,         blue_map[i+B]=0.8503*(2.0*i-MaxRGB);       }        break;     }      case YPbPrColorspace:      {        /*          Initialize YPbPr tables:  '           R = Y            +1.402000*C2%'           G = Y-0.344136*C1+0.714136*C2            B = Y+1.772000*C1n  O         Pb and Pr, normally -0.5 through 0.5, must be normalized to the range 0n         through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)a       {          red_map[i+R]=i;p         green_map[i+R]=0.0;o+         blue_map[i+R]=0.701*(2.0*i-MaxRGB);n         red_map[i+G]=i; 2         green_map[i+G]=(-0.172068)*(2.0*i-MaxRGB);.         blue_map[i+G]=0.357068*(2.0*i-MaxRGB);         red_map[i+B]=i;S,         green_map[i+B]=0.886*(2.0*i-MaxRGB);         blue_map[i+B]=0.0;       }        break;     }      case YUVColorspace:b     default:     {m       /*         Initialize YUV tables:  #           R = Y          +1.13980*V #           G = Y-0.39380*U-0.58050*Ve           B = Y+2.02790*U   M         U and V, normally -0.5 through 0.5, must be normalized to the range 0t         through MaxRGB.        */!       for (i=0; i <= MaxRGB; i++)%       {%         red_map[i+R]=i;%         green_map[i+R]=0.0;%,         blue_map[i+R]=0.5699*(2.0*i-MaxRGB);         red_map[i+G]=i; 0         green_map[i+G]=(-0.1969)*(2.0*i-MaxRGB);0         blue_map[i+G]=(-0.29025)*(2.0*i-MaxRGB);         red_map[i+B]=i; .         green_map[i+B]=1.01395*(2.0*i-MaxRGB);         blue_map[i+B]=0;       }        break;     }    }    /*     Convert to RGB.    */   switch (image->class)    {      case DirectClass:      default:     {        /*"         Convert DirectClass image.       */+       for (y=0; y < (int) image->rows; y++)        { 4         q=GetPixelCache(image,0,y,image->columns,1);&         if (q == (PixelPacket *) NULL)           break;0         for (x=0; x < (int) image->columns; x++)	         {mJ           red=red_map[q->red+R]+green_map[q->green+R]+blue_map[q->blue+R];L           green=red_map[q->red+G]+green_map[q->green+G]+blue_map[q->blue+G];K           blue=red_map[q->red+B]+green_map[q->green+B]+blue_map[q->blue+B];g;           q->red=red < 0 ? 0 : red > MaxRGB ? MaxRGB : red;nC           q->green=green < 0 ? 0 : green > MaxRGB ? MaxRGB : green;L?           q->blue=blue < 0 ? 0 : blue > MaxRGB ? MaxRGB : blue;x           q++;	         } #         if (!SyncPixelCache(image))%           break;'         if (QuantumTick(y,image->rows)) ?           ProgressMonitor(TransformRGBImageText,y,image->rows);        }        break;     }      case PseudoClass:      {        /*"         Convert PseudoClass image.       */-       for (i=0; i < (int) image->colors; i++)        { .         red=red_map[image->colormap[i].red+R]+0           green_map[image->colormap[i].green+R]+.           blue_map[image->colormap[i].blue+R];0         green=red_map[image->colormap[i].red+G]+0           green_map[image->colormap[i].green+G]+.           blue_map[image->colormap[i].blue+G];/         blue=red_map[image->colormap[i].red+B]+%0           green_map[image->colormap[i].green+B]+.           blue_map[image->colormap[i].blue+B];I         image->colormap[i].red=red < 0 ? 0 : red > MaxRGB ? MaxRGB : red; !         image->colormap[i].green=s:           green < 0 ? 0 : green > MaxRGB ? MaxRGB : green;M         image->colormap[i].blue=blue < 0 ? 0 : blue > MaxRGB ? MaxRGB : blue;n       }a       SyncImage(image);0       break;     }e   }a   /*     Free allocated memory.   */   FreeMemory(blue_map);"   FreeMemory(green_map);   FreeMemory(red_map); }m o /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%nO %                                                                             %SO %                                                                             % O %     T r a n s p a r e n t I m a g e                                         % O %                                                                             %aO %                                                                             %tO %                                                                             %=O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%r %eD %  Method TransparentImage creates a matte image associated with theF %  image.  All pixel locations are initially set to opaque.  Any pixel; %  that matches the specified color are set to transparent.r %x0 %  The format of the TransparentImage method is: %.< %      void TransparentImage(Image *image,const char *color) %e+ %  A description of each parameter follows:n %yF %    o image: The address of a structure of type Image;  returned from %      ReadImage.h %dB %    o color: A character string that contain an X11 color string. %e %x */< Export void TransparentImage(Image *image,const char *color) {mM #define TransparentImageText  "  Setting transparent color in the image...  "x  
   PixelPackett     target;,     int      y;     register int     x;     register PixelPacket     *q;L     unsigned int     status;;     /*2     Determine RGB values of the transparent color.   */"   assert(image != (Image *) NULL);+   status=QueryColorDatabase(color,&target);    if (status == False)     return;    /*!     Make image color transparent.Y   */   if (!image->matte)     MatteImage(image,Opaque);a'   for (y=0; y < (int) image->rows; y++)a   { 0     q=GetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;,     for (x=0; x < (int) image->columns; x++)     {,,       if (ColorMatch(*q,target,image->fuzz))         q->opacity=Transparent;=
       q++;     }i     if (!SyncPixelCache(image))m       break;#     if (QuantumTick(y,image->rows))l:       ProgressMonitor(TransparentImageText,y,image->rows);   }  }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%'O %                                                                             % O %                                                                             % O %                                                                             %rO %   W r i t e I m a g e                                                       % O %                                                                             % O %                                                                             %'O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method WriteImage writes an image to a file as defined by image->filename. K %  You can specify a particular image format by prefixing the file with the J %  image type and a colon (i.e. ps:image) or specify the image type as theJ %  filename suffix (i.e. image.ps).  The image may be modified to adapt itL %  to the requirements of the image format.  For example, DirectClass images= %  must be color-reduced to PseudoClass if the format is GIF.  % * %  The format of the WriteImage method is: % H %      unsigned int WriteImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows:  % E %    o status: Method WriteImage return True if the image is written. K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.' %  %  */H Export unsigned int WriteImage(const ImageInfo *image_info,Image *image) {    DelegateInfo     delegate_info;     ImageInfoa     *local_info;     MagickInfo     *magick_info;      unsigned int     status;'     /*I     Determine image type from filename prefix or suffix (e.g. image.jpg).    */+   assert(image_info != (ImageInfo *) NULL);:0   assert(image_info->filename != (char *) NULL);"   assert(image != (Image *) NULL);(   local_info=CloneImageInfo(image_info);6   (void) strcpy(local_info->filename,image->filename);2   (void) strcpy(local_info->magick,image->magick);    SetImageInfo(local_info,True);6   (void) strcpy(image->filename,local_info->filename);<   if ((image->next == (Image *) NULL) || local_info->adjoin)A     if ((image->previous == (Image *) NULL) && !IsTainted(image)) /       if (IsAccessible(image->magick_filename)) M         if (GetDelegateInfo(image->magick,local_info->magick,&delegate_info))            {a             /*@               Let our bi-directional delegate process the image.             */B             (void) strcpy(image->filename,image->magick_filename);             status= P               InvokeDelegate(local_info,image,image->magick,local_info->magick);)             DestroyImageInfo(local_info);              return(status);            }a   /*6     Call appropriate image writer based on image type.   */   status=False; ?   magick_info=(MagickInfo *) GetMagickInfo(local_info->magick); -   if ((magick_info != (MagickInfo *) NULL) &&        (magick_info->encoder !=:       (unsigned int (*)(const ImageInfo *,Image *)) NULL))4     status=(magick_info->encoder)(local_info,image);   elseJ     if (!GetDelegateInfo((char *) NULL,local_info->magick,&delegate_info))       { -         MagickWarning(MissingDelegateWarning, I           "no encode delegate for this image format",local_info->magick);:@         magick_info=(MagickInfo *) GetMagickInfo(image->magick);3         if ((magick_info != (MagickInfo *) NULL) &&c$             (magick_info->encoder !=@             (unsigned int (*)(const ImageInfo *,Image *)) NULL)):           status=(magick_info->encoder)(local_info,image);         else/           MagickWarning(MissingDelegateWarning, F             "no encode delegate for this image format",image->magick);       }      else       { 
         /*6           Let our encoding delegate process the image.
         */+         TemporaryFilename(image->filename);e         status= L           InvokeDelegate(local_info,image,(char *) NULL,local_info->magick);'         (void) remove(image->filename);a%         DestroyImageInfo(local_info);          return(status);        }'   if (image->status)     { P       MagickWarning(CorruptImageWarning,"An error has occurred writing to file",         image->filename);'#       DestroyImageInfo(local_info);        return(False);     } 2   (void) strcpy(image->magick,local_info->magick);   DestroyImageInfo(local_info);    return(status);  } 