 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        JJJJJ  PPPP   EEEEE   GGGG                           % O %                          J    P   P  E      G                               % O %                          J    PPPP   EEE    G  GG                           % O %                        J J    P      E      G   G                           % O %                        JJJ    P      EEEEE   GGG                            % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K % This software is based in part on the work of the Independent JPEG Group. I % See ftp://ftp.uu.net/graphics/jpeg/jpegsrc.v6b.tar.gz for copyright and M % licensing restrictions.  Blob support contributed by Glenn Randers-Pehrson.  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*   Define declarations. */! #define ICC_MARKER  (JPEG_APP0+2) # #define IPTC_MARKER  (JPEG_APP0+13)  #define MaxBufferExtent  8192    #if defined(HasJPEG) #include <setjmp.h>  #define JPEG_INTERNAL_OPTIONS  #include "jpeglib.h" #include "jerror.h"   " typedef struct _DestinationManager {    struct jpeg_destination_mgr      manager;     Image      *image;      JOCTET     *buffer; } DestinationManager;    typedef struct _SourceManager  {    struct jpeg_source_mgr     manager;     Image      *image;      JOCTET     *buffer;  	   boolean      start_of_blob; } SourceManager;   static Image	   *image;    static jmp_buf   error_recovery;    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s J P E G                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method IsJPEG returns True if the image format type, identified by the  %  magick string, is JPEG. % - %  The format of the ReadJPEGImage method is:  % 7 %      unsigned int IsJPEG(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % L %    o status:  Method IsJPEG returns True if the image format type is JPEG. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */7 Export unsigned int IsJPEG(const unsigned char *magick,    const unsigned int length) {    if (length < 3)      return(False);5   if (strncmp((char *) magick,"\377\330\377",3) == 0)      return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d J P E G I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % M %  Method ReadJPEGImage reads a JPEG image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % - %  The format of the ReadJPEGImage method is:  % 8 %      Image *ReadJPEGImage(const ImageInfo *image_info) % + %  A description of each parameter follows:  % H %    o image:  Method ReadJPEGImage returns a pointer to the image afterJ %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % ? %    o filename:  Specifies the name of the jpeg image to read.  %  %  */  9 static void EmitMessage(j_common_ptr jpeg_info,int level)  {    char     message[JMSG_LENGTH_MAX];   6   (jpeg_info->err->format_message)(jpeg_info,message);   if (level < 0)     { 0       if ((jpeg_info->err->num_warnings == 0) ||-           (jpeg_info->err->trace_level >= 3)) H         MagickWarning(DelegateWarning,(char *) message,image->filename);%       jpeg_info->err->num_warnings++;      }    else-     if (jpeg_info->err->trace_level >= level) F       MagickWarning(DelegateWarning,(char *) message,image->filename); }   6 static boolean FillInputBuffer(j_decompress_ptr cinfo) {    SourceManager      *source;  &   source=(SourceManager *) cinfo->src;"   source->manager.bytes_in_buffer=D     ReadBlob(source->image,MaxBufferExtent,(char *) source->buffer);+   if (source->manager.bytes_in_buffer == 0)      {         if (source->start_of_blob)(         ERREXIT(cinfo,JERR_INPUT_EMPTY);"       WARNMS(cinfo,JWRN_JPEG_EOF);&       source->buffer[0]=(JOCTET) 0xff;*       source->buffer[1]=(JOCTET) JPEG_EOI;(       source->manager.bytes_in_buffer=2;     } 1   source->manager.next_input_byte=source->buffer;    source->start_of_blob=FALSE;   return(TRUE);  }   < static unsigned int GetCharacter(j_decompress_ptr jpeg_info) { +   if (jpeg_info->src->bytes_in_buffer == 0) 4     (*jpeg_info->src->fill_input_buffer)(jpeg_info);$   jpeg_info->src->bytes_in_buffer--;8   return(GETJOCTET(*jpeg_info->src->next_input_byte++)); }   4 static void InitializeSource(j_decompress_ptr cinfo) {    SourceManager      *source;  &   source=(SourceManager *) cinfo->src;   source->start_of_blob=TRUE;  }   4 static void JPEGErrorHandler(j_common_ptr jpeg_info) {    EmitMessage(jpeg_info,0);    longjmp(error_recovery,1); }   ; static boolean ReadColorProfile(j_decompress_ptr jpeg_info)  {    char     magick[12];   
   long int     length;      register unsigned char     *p;      register int     i;     /*&     Determine length of color profile.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;   for (i=0; i < 12; i++)&     magick[i]=GetCharacter(jpeg_info);/   if (Latin1Compare(magick,"ICC_PROFILE") != 0)      {        /*"         Not a ICC profile, return.       */#       for (i=0; i < length-12; i++) '         (void) GetCharacter(jpeg_info);        return(True);      } +   (void) GetCharacter(jpeg_info);  /* id */ 0   (void) GetCharacter(jpeg_info);  /* markers */
   length-=14; '   if (image->color_profile.length == 0) /     image->color_profile.info=(unsigned char *) B       AllocateMemory((unsigned int) length*sizeof(unsigned char));   elseI     image->color_profile.info=(unsigned char *) ReallocateMemory((char *) E       image->color_profile.info,(image->color_profile.length+length)*        sizeof(unsigned char)); :   if (image->color_profile.info == (unsigned char *) NULL)     { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    /*     Read color profile.    */:   p=image->color_profile.info+image->color_profile.length;&   image->color_profile.length+=length;   while (--length >= 0) !     *p++=GetCharacter(jpeg_info);    return(True);  }   6 static boolean ReadComment(j_decompress_ptr jpeg_info) { 
   long int     length;      register char      *p;      /*      Determine length of comment.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2;'   if (image->comments != (char *) NULL) G     image->comments=(char *) ReallocateMemory((char *) image->comments, F       (unsigned int) (Extent(image->comments)+length+1)*sizeof(char));   else     {        image->comments=(char *)?         AllocateMemory((unsigned int) (length+1)*sizeof(char)); +       if (image->comments != (char *) NULL)          *image->comments='\0';     } '   if (image->comments == (char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    /*     Read comment.    */,   p=image->comments+Extent(image->comments);   while (--length >= 0) !     *p++=GetCharacter(jpeg_info); 
   *p='\0';   return(True);  }   : static boolean ReadNewsProfile(j_decompress_ptr jpeg_info) { 
   long int     taglen,      length;      register unsigned char     *p;      register int     i;   #ifdef GET_ONLY_IPTC_DATA    unsigned char      tag[2];  #else    char     magick[11];  #endif     /*0     Determine length of binary data stored here.   */&   length=GetCharacter(jpeg_info) << 8;"   length+=GetCharacter(jpeg_info);   length-=2; #ifdef GET_ONLY_IPTC_DATA    /*0     The following tries to find the beginning of'     the IPTC portion of the binary data     */    for (*tag='\0'; length > 0; )    { !     *tag=GetCharacter(jpeg_info); %     *(tag+1)=GetCharacter(jpeg_info);      length-=2;-     if ((*tag == 0x1c) && (*(tag+1) == 0x02))        break;   }    taglen=2;  #else    /*1     The following validates that this was written '     as a Photoshop resource format slug     */    for (i=0; i < 10; i++)&     magick[i]=GetCharacter(jpeg_info);   magick[10]='\0';
   length-=10; .   if (Latin1Compare(magick,"Photoshop ") != 0)     {        /*"         Not a ICC profile, return.       */        for (i=0; i < length; i++)'         (void) GetCharacter(jpeg_info);        return(True);      } !   /* remove the version number */    for (i=0; i < 4; i++) #     (void) GetCharacter(jpeg_info);    length-=4;   taglen=0;  #endif   if (length <= 0)     return(True); &   if (image->iptc_profile.length != 0)H     image->iptc_profile.info=(unsigned char *) ReallocateMemory((char *)       image->iptc_profile.info, >         (unsigned int) (length+taglen)*sizeof(unsigned char));   else     { 0       image->iptc_profile.info=(unsigned char *)M         AllocateMemory((unsigned int) (length+taglen)*sizeof(unsigned char)); =       if (image->iptc_profile.info != (unsigned char *) NULL) %         image->iptc_profile.length=0;      } 9   if (image->iptc_profile.info == (unsigned char *) NULL)      { D       MagickWarning(ResourceLimitWarning,"Memory allocation failed",         (char *) NULL);        return(False);     }    /*2     Read the payload of this binary data, decoding/     is left as a excercise for the application.     */    p=image->iptc_profile.info; +   image->iptc_profile.length=length+taglen;  #ifdef GET_ONLY_IPTC_DATA    *p++=0x1c;   *p++=0x02; #endif   while (--length >= 0) !     *p++=GetCharacter(jpeg_info);    return(True);  }   C static void SkipInputData(j_decompress_ptr cinfo,long number_bytes)  {    SourceManager      *source;     if (number_bytes <= 0)     return; &   source=(SourceManager *) cinfo->src;?   while (number_bytes > (long) source->manager.bytes_in_buffer)    { 9     number_bytes-=(long) source->manager.bytes_in_buffer; "     (void) FillInputBuffer(cinfo);   } 9   source->manager.next_input_byte+=(size_t) number_bytes; 9   source->manager.bytes_in_buffer-=(size_t) number_bytes;  }   3 static void TerminateSource(j_decompress_ptr cinfo)  {  }   B static void JPEGSourceManager(j_decompress_ptr cinfo,Image *image) {    SourceManager      *source;  "   if (cinfo->src == (JOCTET) NULL)     { F       cinfo->src=(struct jpeg_source_mgr *) (*cinfo->mem->alloc_small)E         ((j_common_ptr) cinfo,JPOOL_PERMANENT,sizeof(SourceManager)); *       source=(SourceManager *) cinfo->src;:       source->buffer=(JOCTET *) (*cinfo->mem->alloc_small)N         ((j_common_ptr) cinfo,JPOOL_PERMANENT,MaxBufferExtent*sizeof(JOCTET));     } &   source=(SourceManager *) cinfo->src;/   source->manager.init_source=InitializeSource; 4   source->manager.fill_input_buffer=FillInputBuffer;0   source->manager.skip_input_data=SkipInputData;;   source->manager.resync_to_restart=jpeg_resync_to_restart; .   source->manager.term_source=TerminateSource;$   source->manager.bytes_in_buffer=0;'   source->manager.next_input_byte=NULL;    source->image=image; }   8 Export Image *ReadJPEGImage(const ImageInfo *image_info) {    int      x,     y;  	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];     register int     i;     struct jpeg_decompress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      register JSAMPLE     *p;      register PixelPacket     *q;      unsigned int     status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Initialize image structure.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);*   jpeg_info.err->emit_message=EmitMessage;-   jpeg_info.err->error_exit=JPEGErrorHandler; %   image->pixels=(PixelPacket *) NULL;    jpeg_pixels=(JSAMPLE *) NULL;    if (setjmp(error_recovery))      {        /*         JPEG image is corrupt.       */*       if (jpeg_pixels != (JSAMPLE *) NULL)          FreeMemory(jpeg_pixels);*       jpeg_destroy_decompress(&jpeg_info);       DestroyImage(image);       return((Image *) NULL);      } %   jpeg_create_decompress(&jpeg_info); &   JPEGSourceManager(&jpeg_info,image);=   jpeg_set_marker_processor(&jpeg_info,JPEG_COM,ReadComment); D   jpeg_set_marker_processor(&jpeg_info,ICC_MARKER,ReadColorProfile);D   jpeg_set_marker_processor(&jpeg_info,IPTC_MARKER,ReadNewsProfile);+   (void) jpeg_read_header(&jpeg_info,True); ,   if (jpeg_info.out_color_space == JCS_CMYK)%     image->colorspace=CMYKColorspace;     if (jpeg_info.saw_JFIF_marker)     { J       if ((jpeg_info.density_unit != 0) || (jpeg_info.X_density != 1.0) ||'           (jpeg_info.Y_density != 1.0)) 	         {            /*!             Set image resolution.            */2           image->x_resolution=jpeg_info.X_density;2           image->y_resolution=jpeg_info.Y_density;*           if (jpeg_info.density_unit == 1)1             image->units=PixelsPerInchResolution; *           if (jpeg_info.density_unit == 2)7             image->units=PixelsPerCentimeterResolution; 	         }      } (   if ((image->columns*image->rows) != 0)     {        double         scale_factor;          /*.         Let the JPEG library subsample for us.       */.       jpeg_calc_output_dimensions(&jpeg_info);3       image->magick_columns=jpeg_info.output_width; 1       image->magick_rows=jpeg_info.output_height; B       scale_factor=(double) jpeg_info.output_width/image->columns;H       if (scale_factor > ((double) jpeg_info.output_height/image->rows))B         scale_factor=(double) jpeg_info.output_height/image->rows;)       jpeg_info.scale_denom=scale_factor; .       jpeg_calc_output_dimensions(&jpeg_info);     }     if (image_info->subrange != 0)     { 1       jpeg_info.scale_denom=image_info->subrange; .       jpeg_calc_output_dimensions(&jpeg_info);     } > #if (JPEG_LIB_VERSION >= 61) && !defined(D_LOSSLESS_SUPPORTED)M   image->interlace=jpeg_info.progressive_mode ? PlaneInterlace : NoInterlace;  #endif$   jpeg_start_decompress(&jpeg_info);%   image->compression=JPEGCompression; (   image->columns=jpeg_info.output_width;&   image->rows=jpeg_info.output_height;   if (image_info->ping)      { *       jpeg_destroy_decompress(&jpeg_info);       CloseBlob(image);        return(image);     } 1   if (jpeg_info.out_color_space == JCS_GRAYSCALE)      {        /*&         Initialize grayscale colormap.       */       image->class=PseudoClass;        image->colors=MaxRGB+1; %       image->colormap=(PixelPacket *) :         AllocateMemory(image->colors*sizeof(PixelPacket));2       if (image->colormap == (PixelPacket *) NULL)J         ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);-       for (i=0; i < (int) image->colors; i++)        { *         image->colormap[i].red=UpScale(i);,         image->colormap[i].green=UpScale(i);+         image->colormap[i].blue=UpScale(i);        }      }    jpeg_pixels=(JSAMPLE *) O     AllocateMemory(jpeg_info.output_components*image->columns*sizeof(JSAMPLE));    image->pixels=(PixelPacket *) C     AllocateMemory(image->columns*image->rows*sizeof(PixelPacket)); 0   if ((image->pixels == (PixelPacket *) NULL) ||(       (jpeg_pixels == (JSAMPLE *) NULL))F     ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);   /*)     Convert JPEG pixels to pixel packets.    */%   scanline[0]=(JSAMPROW) jpeg_pixels; '   for (y=0; y < (int) image->rows; y++)    {      p=jpeg_pixels;0     q=SetPixelCache(image,0,y,image->columns,1);"     if (q == (PixelPacket *) NULL)       break;6     (void) jpeg_read_scanlines(&jpeg_info,scanline,1);,     for (x=0; x < (int) image->columns; x++)     { 2       if (jpeg_info.data_precision > QuantumDepth)	         { 9           if (jpeg_info.out_color_space == JCS_GRAYSCALE) 4             image->indexes[x]=GETJSAMPLE(*p++) >> 4;           else
             { 7               q->red=(Quantum) (GETJSAMPLE(*p++) >> 4); 9               q->green=(Quantum) (GETJSAMPLE(*p++) >> 4); 8               q->blue=(Quantum) (GETJSAMPLE(*p++) >> 4);6               if (image->colorspace == CMYKColorspace)=                 q->opacity=(Quantum) (GETJSAMPLE(*p++) >> 4); 
             } 	         } 
       else7         if (jpeg_info.out_color_space == JCS_GRAYSCALE) -           image->indexes[x]=GETJSAMPLE(*p++);          else           { 7             q->red=(Quantum) UpScale(GETJSAMPLE(*p++)); 9             q->green=(Quantum) UpScale(GETJSAMPLE(*p++)); 8             q->blue=(Quantum) UpScale(GETJSAMPLE(*p++));4             if (image->colorspace == CMYKColorspace)=               q->opacity=(Quantum) UpScale(GETJSAMPLE(*p++));            } 
       q++;     }      if (!SyncPixelCache(image))        break;#     if (QuantumTick(y,image->rows)) 3       ProgressMonitor(LoadImageText,y,image->rows);    } "   if (image->class == PseudoClass)     SyncImage(image);    else,     if (image->colorspace == CMYKColorspace)       { 
         /*           Correct CMYK levels.
         */-         for (y=0; y < (int) image->rows; y++) 	         { 6           q=GetPixelCache(image,0,y,image->columns,1);(           if (q == (PixelPacket *) NULL)             break;2           for (x=0; x < (int) image->columns; x++)           { !             q->red=MaxRGB-q->red; %             q->green=MaxRGB-q->green; #             q->blue=MaxRGB-q->blue; )             q->opacity=MaxRGB-q->opacity;              q++;           } %           if (!SyncPixelCache(image))              break;	         }        }    /*     Free jpeg resources.   */,   (void) jpeg_finish_decompress(&jpeg_info);&   jpeg_destroy_decompress(&jpeg_info);   FreeMemory(jpeg_pixels);   CloseBlob(image);    return(image); }  #else 8 Export Image *ReadJPEGImage(const ImageInfo *image_info) { G   MagickWarning(MissingDelegateWarning,"JPEG library is not available",      image_info->filename);   return((Image *) NULL);  }  #endif   #if defined(HasJPEG) /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %  W r i t e J P E G I m a g e                                                % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % E %  Method WriteJPEGImage writes a JPEG image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % . %  The format of the WriteJPEGImage method is: % L %      unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) % + %  A description of each parameter follows:  % J %    o status:  Method WriteJPEGImage return True if the image is written.I %      False is returned is there is of a memory shortage or if the image ) %      file cannot be opened for writing.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % 3 %    o jpeg_image:  A pointer to a Image structure.  %  %  */  6 static boolean EmptyOutputBuffer(j_compress_ptr cinfo) {    DestinationManager     *destination;   1   destination=(DestinationManager *) cinfo->dest; C   destination->manager.free_in_buffer=WriteBlob(destination->image, 2     MaxBufferExtent,(char *) destination->buffer);=   if (destination->manager.free_in_buffer != MaxBufferExtent) #     ERREXIT(cinfo,JERR_FILE_WRITE); <   destination->manager.next_output_byte=destination->buffer;   return(TRUE);  }   7 static void InitializeDestination(j_compress_ptr cinfo)  {    DestinationManager     *destination;   1   destination=(DestinationManager *) cinfo->dest; ;   destination->buffer=(JOCTET *) (*cinfo->mem->alloc_small) F     ((j_common_ptr) cinfo,JPOOL_IMAGE,MaxBufferExtent*sizeof(JOCTET));<   destination->manager.next_output_byte=destination->buffer;6   destination->manager.free_in_buffer=MaxBufferExtent; }   @ static void JPEGWarningHandler(j_common_ptr jpeg_info,int level) {    char     message[JMSG_LENGTH_MAX];   6   (jpeg_info->err->format_message)(jpeg_info,message);   if (level < 0)     { 0       if ((jpeg_info->err->num_warnings == 0) ||-           (jpeg_info->err->trace_level >= 3)) F         MagickWarning(DelegateWarning,(char *) message,(char *) NULL);%       jpeg_info->err->num_warnings++;      }    else-     if (jpeg_info->err->trace_level >= level) D       MagickWarning(DelegateWarning,(char *) message,(char *) NULL); }   6 static void TerminateDestination(j_compress_ptr cinfo) {    DestinationManager     *destination;   1   destination=(DestinationManager *) cinfo->dest; @   if ((MaxBufferExtent-destination->manager.free_in_buffer) > 0)     {        unsigned long          number_bytes;   @       number_bytes=WriteBlob(destination->image,MaxBufferExtent-J         destination->manager.free_in_buffer,(char *) destination->buffer);P       if (number_bytes != (MaxBufferExtent-destination->manager.free_in_buffer))'         ERREXIT(cinfo,JERR_FILE_WRITE);      } #   if (SyncBlob(destination->image)) #     ERREXIT(cinfo,JERR_FILE_WRITE);  }   D static void WriteColorProfile(j_compress_ptr jpeg_info,Image *image) {    register int     i,     j;     unsigned char 
     *profile;      unsigned int     length;      /*'     Save color profile as a APP marker.    */<   for (i=0; i < (int) image->color_profile.length; i+=65519)   { 4     length=Min(image->color_profile.length-i,65519);P     profile=(unsigned char *) AllocateMemory((length+14)*sizeof(unsigned char));*     if (profile == (unsigned char *) NULL)       break;2     (void) strcpy((char *) profile,"ICC_PROFILE");     profile[12]=(i/65519)+1;6     profile[13]=(image->color_profile.length/65519)+1;$     for (j=0; j < (int) length; j++)3       profile[j+14]=image->color_profile.info[i+j]; M     jpeg_write_marker(jpeg_info,ICC_MARKER,profile,(unsigned int) length+14);      FreeMemory(profile);   }  }   C static void WriteNewsProfile(j_compress_ptr jpeg_info,Image *image)  {    int      roundup;     register int     i;     unsigned char 
     *profile;      unsigned int     taglen,      length;      /*<     Save binary Photoshop resource data using an APP marker.   */ #ifdef GET_ONLY_IPTC_DATA    taglen=26; #else    taglen=14; #endif;   for (i=0; i < (int) image->iptc_profile.length; i+=65500)    { 3     length=Min(image->iptc_profile.length-i,65500); 9     roundup=(length & 0x01); /* round up for Photoshop */      profile=(unsigned char *) D       AllocateMemory((length+roundup+taglen)*sizeof(unsigned char));*     if (profile == (unsigned char *) NULL)       break; #ifdef GET_ONLY_IPTC_DATA J     (void) memcpy((char *) profile,"Photoshop 3.0 8BIM\04\04\0\0\0\0",24);     profile[13]=0x00;      profile[24]=length >> 8;     profile[25]=length & 0xff; #else 8     (void) memcpy((char *) profile,"Photoshop 3.0 ",14);     profile[13]=0x00;  #endifM     (void) memcpy((char *) &(profile[taglen]),&(image->iptc_profile.info[i]),        length);     if (roundup)       profile[length+taglen]=0; B     jpeg_write_marker(jpeg_info,IPTC_MARKER,profile,(unsigned int)       length+roundup+taglen);      FreeMemory(profile);   }  }   F static void JPEGDestinationManager(j_compress_ptr cinfo,Image * image) {    DestinationManager     *destination;   #   if (cinfo->dest == (JOCTET) NULL) J     cinfo->dest=(struct jpeg_destination_mgr *) (*cinfo->mem->alloc_small)H       ((j_common_ptr) cinfo,JPOOL_PERMANENT,sizeof(DestinationManager));1   destination=(DestinationManager *) cinfo->dest; >   destination->manager.init_destination=InitializeDestination;=   destination->manager.empty_output_buffer=EmptyOutputBuffer; =   destination->manager.term_destination=TerminateDestination;    destination->image=image;  }   L Export unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) {    int 
     flags,     sans_offset,     y;  	   JSAMPLE      *jpeg_pixels;   
   JSAMPROW     scanline[1];     register int     i,     x;     register JSAMPLE     *q;      register PixelPacket     *p;      struct jpeg_compress_struct      jpeg_info;     struct jpeg_error_mgr      jpeg_error;      unsigned int     status,      x_resolution,      y_resolution;      /*     Open image file.   */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   /*     Initialize JPEG parameters.    */,   jpeg_info.err=jpeg_std_error(&jpeg_error);1   jpeg_info.err->emit_message=JPEGWarningHandler; #   jpeg_create_compress(&jpeg_info); +   JPEGDestinationManager(&jpeg_info,image); '   jpeg_info.image_width=image->columns; %   jpeg_info.image_height=image->rows;    jpeg_info.input_components=3; #   jpeg_info.in_color_space=JCS_RGB; 6   if (Latin1Compare(image_info->magick,"JPEG24") != 0)     if (IsGrayImage(image))        { %         jpeg_info.input_components=1; /         jpeg_info.in_color_space=JCS_GRAYSCALE;        } 9   if (((image_info->colorspace != UndefinedColorspace) || 0        (image->colorspace != CMYKColorspace)) &&2        (image_info->colorspace != CMYKColorspace))+     TransformRGBImage(image,RGBColorspace);    else     { #       jpeg_info.input_components=4; (       jpeg_info.in_color_space=JCS_CMYK;.       if (image->colorspace != CMYKColorspace)0         RGBTransformImage(image,CMYKColorspace);     }     jpeg_set_defaults(&jpeg_info);   flags=NoValue;   x_resolution=72;   y_resolution=72;+   if (image_info->density != (char *) NULL) F     flags=ParseGeometry(image_info->density,&sans_offset,&sans_offset,#       &x_resolution,&y_resolution);    if (flags & WidthValue) %     image->x_resolution=x_resolution;    if (flags & HeightValue)%     image->y_resolution=y_resolution; 1   jpeg_info.density_unit=1;  /* default to DPI */ ?   if ((image->x_resolution != 0) && (image->y_resolution != 0))      {        /*         Set image resolution.        */6       jpeg_info.X_density=(short) image->x_resolution;6       jpeg_info.Y_density=(short) image->y_resolution;2       if (image->units == PixelsPerInchResolution)!         jpeg_info.density_unit=1; 8       if (image->units == PixelsPerCentimeterResolution)!         jpeg_info.density_unit=2;      }    /*/      Allow user to ask for no color subsampling    */*   if (image->compression == NoCompression)&     for (i=0; i < MAX_COMPONENTS; i++)     { -       jpeg_info.comp_info[i].h_samp_factor=1; -       jpeg_info.comp_info[i].v_samp_factor=1;      } 8   jpeg_set_quality(&jpeg_info,image_info->quality,True);!   jpeg_info.optimize_coding=True; > #if (JPEG_LIB_VERSION >= 61) && !defined(C_LOSSLESS_SUPPORTED)+   if (image_info->interlace != NoInterlace) (     jpeg_simple_progression(&jpeg_info); #endif'   jpeg_start_compress(&jpeg_info,True); '   if (image->comments != (char *) NULL) 4     for (i=0; i < Extent(image->comments); i+=65533)P       jpeg_write_marker(&jpeg_info,JPEG_COM,(unsigned char *) image->comments+i,=         (unsigned int) Min(Extent(image->comments+i),65533)); &   if (image->color_profile.length > 0)'    WriteColorProfile(&jpeg_info,image); %   if (image->iptc_profile.length > 0) '     WriteNewsProfile(&jpeg_info,image);    /*'     Convert MIFF to JPEG raster pixels.    */   jpeg_pixels=(JSAMPLE *) N     AllocateMemory(jpeg_info.input_components*image->columns*sizeof(JSAMPLE));&   if (jpeg_pixels == (JSAMPLE *) NULL)F     WriterExit(ResourceLimitWarning,"Memory allocation failed",image);%   scanline[0]=(JSAMPROW) jpeg_pixels; ;   if ((jpeg_info.data_precision > 8) && (QuantumDepth > 8))      { 4       if (jpeg_info.in_color_space == JCS_GRAYSCALE)-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;           q=jpeg_pixels;2           for (x=0; x < (int) image->columns; x++)           { 0             *q++=(JSAMPLE) (Intensity(*p) >> 4);             p++;           } =           (void) jpeg_write_scanlines(&jpeg_info,scanline,1); )           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(SaveImageText,y,image->rows); 	         } 
       else0         if (jpeg_info.in_color_space == JCS_RGB)/           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;             q=jpeg_pixels;4             for (x=0; x < (int) image->columns; x++)
             { +               *q++=(JSAMPLE) (p->red >> 4); -               *q++=(JSAMPLE) (p->green >> 4); ,               *q++=(JSAMPLE) (p->blue >> 4);               p++;
             } ?             (void) jpeg_write_scanlines(&jpeg_info,scanline,1); +             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows);            }          else/           for (y=0; y < (int) image->rows; y++)            { 8             p=GetPixelCache(image,0,y,image->columns,1);*             if (p == (PixelPacket *) NULL)               break;             q=jpeg_pixels;4             for (x=0; x < (int) image->columns; x++)
             {                /*I                 Convert DirectClass packets to contiguous CMYK scanlines.                */4               *q++=(JSAMPLE) (MaxRGB-(p->red >> 4));6               *q++=(JSAMPLE) (MaxRGB-(p->green >> 4));5               *q++=(JSAMPLE) (MaxRGB-(p->blue >> 4)); 8               *q++=(JSAMPLE) (MaxRGB-(p->opacity >> 4));               p++;
             } ?             (void) jpeg_write_scanlines(&jpeg_info,scanline,1); +             if (QuantumTick(y,image->rows)) ;               ProgressMonitor(SaveImageText,y,image->rows);            }      }    else2     if (jpeg_info.in_color_space == JCS_GRAYSCALE)+       for (y=0; y < (int) image->rows; y++)        { 4         p=GetPixelCache(image,0,y,image->columns,1);&         if (p == (PixelPacket *) NULL)           break;         q=jpeg_pixels;0         for (x=0; x < (int) image->columns; x++)	         { 2           *q++=(JSAMPLE) DownScale(Intensity(*p));           p++;	         } ;         (void) jpeg_write_scanlines(&jpeg_info,scanline,1); '         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);        }      else.       if (jpeg_info.in_color_space == JCS_RGB)-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;           q=jpeg_pixels;2           for (x=0; x < (int) image->columns; x++)           { -             *q++=(JSAMPLE) DownScale(p->red); /             *q++=(JSAMPLE) DownScale(p->green); .             *q++=(JSAMPLE) DownScale(p->blue);             p++;           } =           (void) jpeg_write_scanlines(&jpeg_info,scanline,1); )           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(SaveImageText,y,image->rows); 	         } 
       else-         for (y=0; y < (int) image->rows; y++) 	         { 6           p=GetPixelCache(image,0,y,image->columns,1);(           if (p == (PixelPacket *) NULL)             break;           q=jpeg_pixels;2           for (x=0; x < (int) image->columns; x++)           {              /*G               Convert DirectClass packets to contiguous CMYK scanlines.              */4             *q++=(JSAMPLE) DownScale(MaxRGB-p->red);6             *q++=(JSAMPLE) DownScale(MaxRGB-p->green);5             *q++=(JSAMPLE) DownScale(MaxRGB-p->blue); 8             *q++=(JSAMPLE) DownScale(MaxRGB-p->opacity);             p++;           } =           (void) jpeg_write_scanlines(&jpeg_info,scanline,1); )           if (QuantumTick(y,image->rows)) 9             ProgressMonitor(SaveImageText,y,image->rows); 	         } #   jpeg_finish_compress(&jpeg_info);    /*     Free memory.   */$   jpeg_destroy_compress(&jpeg_info);   FreeMemory(jpeg_pixels);   CloseBlob(image);    return(True);  }  #else L Export unsigned int WriteJPEGImage(const ImageInfo *image_info,Image *image) { G   MagickWarning(MissingDelegateWarning,"JPEG library is not available",      image->filename);    return(False); }  #endif  