 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                        M   M  IIIII  FFFFF  FFFFF                           % O %                        MM MM    I    F      F                               % O %                        M M M    I    FFF    FFF                             % O %                        M   M    I    F      F                               % O %                        M   M  IIIII  F      F                               % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h" #if defined(HasBZLIB)  #include "bzlib.h" #endif #if defined(HasZLIB) #include "zlib.h"  #endif   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   I s M I F F                                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method IsMIFF returns True if the image format type, identified by the  %  magick string, is MIFF. % - %  The format of the ReadMIFFImage method is:  % 7 %      unsigned int IsMIFF(const unsigned char *magick, # %        const unsigned int length)  % + %  A description of each parameter follows:  % L %    o status:  Method IsMIFF returns True if the image format type is MIFF. % L %    o magick: This string is generally the first few bytes of an image file %      or blob.  % 9 %    o length: Specifies the length of the magick string.  %  %  */7 Export unsigned int IsMIFF(const unsigned char *magick,    const unsigned int length) {    if (length < 14)     return(False);8   if (strncmp((char *) magick,"id=ImageMagick",14) == 0)     return(True);    return(False); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M I F F I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % C %  Method ReadMIFFImage reads a MIFF image file and returns it.  It K %  allocates the memory necessary for the new Image structure and returns a  %  pointer to the new image. % - %  The format of the ReadMIFFImage method is:  % 8 %      Image *ReadMIFFImage(const ImageInfo *image_info) % 2 %  Decompression code contributed by Kyle Shorter. % + %  A description of each parameter follows:  % G %    o image: Method ReadMIFFImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */8 Export Image *ReadMIFFImage(const ImageInfo *image_info) {  #if defined(HasBZLIB)    bz_stream      bzip_info; #endif     char     id[MaxTextExtent],     keyword[MaxTextExtent],      values[MaxTextExtent];     Image      *image;   
   IndexPacket 
     index;     int      c,     length,      y;  
   PixelPacket 
     pixel;     register int     i,     x;     register PixelPacket     *q;      register unsigned char     *p;      unsigned char      *compressed_pixels,      *pixels;     unsigned int     packet_size,     status;    #if defined(HasZLIB)
   z_stream
     zip_info;  #endif     /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   image->depth=8;    /*G     Decode image header;  header terminates one character beyond a ':'.    */   c=ReadByte(image);   if (c == EOF)      {        DestroyImage(image);       return((Image *) NULL);      }    *id='\0';    do   {      /*I       Decode image header;  header terminates one character beyond a ':'.      */%     image->compression=NoCompression; $     while (isgraph(c) && (c != ':'))     {        register char          *p;          if (c == '{') 	         {            /*0             Read comment-- any text between { }.           *//           if (image->comments != (char *) NULL) 
             { -               length=Extent(image->comments); '               p=image->comments+length; 
             }            else
             { #               length=MaxTextExtent; K               image->comments=(char *) AllocateMemory(length*sizeof(char));                 p=image->comments;
             } 8           for ( ; image->comments != (char *) NULL; p++)           {              c=ReadByte(image);)             if ((c == EOF) || (c == '}'))                break;6             if ((p-image->comments+1) >= (int) length)               {                  *p='\0';                 length<<=1; B                 image->comments=(char *) ReallocateMemory((char *)7                   image->comments,length*sizeof(char)); 5                 if (image->comments == (char *) NULL)                    break;:                 p=image->comments+Extent(image->comments);               } !             *p=(unsigned char) c;            } /           if (image->comments == (char *) NULL) N             ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);           *p='\0';           c=ReadByte(image);	         } 
       else         if (isalnum(c))            {              /*0               Determine a keyword and its value.             */             p=keyword;             do
             { 2               if ((p-keyword) < (MaxTextExtent-1))                 *p++=(char) c;                c=ReadByte(image);/             } while (isalnum(c) || (c == '-'));              *p='\0';,             while (isspace(c) || (c == '='))                c=ReadByte(image);             p=values;              if (c != '"') /               while (!isspace(c) && (c != EOF))                { 3                 if ((p-values) < (MaxTextExtent-1))                     *p++=(char) c;"                 c=ReadByte(image);               }              else               { "                 c=ReadByte(image);0                 while ((c != '"') && (c != EOF))                 { 5                   if ((p-values) < (MaxTextExtent-1)) "                     *p++=(char) c;$                   c=ReadByte(image);                 }                }              *p='\0';             /*6               Assign a value to the specified keyword.             */?             if (Latin1Compare(keyword,"background-color") == 0) I               (void) QueryColorDatabase(values,&image->background_color); ;             if (Latin1Compare(keyword,"blue-primary") == 0) -               (void) sscanf(values,"%lf,%lf", 4                 &image->chromaticity.blue_primary.x,5                 &image->chromaticity.blue_primary.y); ;             if (Latin1Compare(keyword,"border-color") == 0) E               (void) QueryColorDatabase(values,&image->border_color); 4             if (Latin1Compare(keyword,"class") == 0)               { =                 if (Latin1Compare(values,"PseudoClass") == 0) +                   image->class=PseudoClass;                  else?                   if (Latin1Compare(values,"DirectClass") == 0) -                     image->class=DirectClass;                    else0                     image->class=UndefinedClass;               } 5             if (Latin1Compare(keyword,"colors") == 0) 8               image->colors=(unsigned int) atoi(values);<             if (Latin1Compare(keyword,"color-profile") == 0)F               image->color_profile.length=(unsigned int) atoi(values);9             if (Latin1Compare(keyword,"colorspace") == 0)                { 6                 if (Latin1Compare(values,"CMYK") == 0)3                   image->colorspace=CMYKColorspace;                  else7                   if (Latin1Compare(values,"RGB") == 0) 4                     image->colorspace=RGBColorspace;               } :             if (Latin1Compare(keyword,"compression") == 0)               { 5                 if (Latin1Compare(values,"Zip") == 0) 4                   image->compression=ZipCompression;                 else8                   if (Latin1Compare(values,"BZip") == 0)7                     image->compression=BZipCompression;                    elseF                     if (Latin1Compare(values,"RunlengthEncoded") == 0)E                       image->compression=RunlengthEncodedCompression;                      else>                       image->compression=UndefinedCompression;               } 6             if (Latin1Compare(keyword,"columns") == 0)9               image->columns=(unsigned int) atoi(values); 4             if (Latin1Compare(keyword,"delay") == 0)               { 7                 if (image_info->delay == (char *) NULL) ,                   image->delay=atoi(values);               } 4             if (Latin1Compare(keyword,"depth") == 0)6               image->depth=atoi(values) <= 8 ? 8 : 16;6             if (Latin1Compare(keyword,"dispose") == 0)               { 9                 if (image_info->dispose == (char *) NULL) .                   image->dispose=atoi(values);               } 4             if (Latin1Compare(keyword,"gamma") == 0)(               image->gamma=atof(values);<             if (Latin1Compare(keyword,"green-primary") == 0)-               (void) sscanf(values,"%lf,%lf", 5                 &image->chromaticity.green_primary.x, 6                 &image->chromaticity.green_primary.y);1             if (Latin1Compare(keyword,"id") == 0) '               (void) strcpy(id,values); 9             if (Latin1Compare(keyword,"iterations") == 0)                { <                 if (image_info->iterations == (char *) NULL)1                   image->iterations=atoi(values);                } 4             if (Latin1Compare(keyword,"label") == 0)7               (void) CloneString(&image->label,values); 4             if (Latin1Compare(keyword,"matte") == 0)A               image->matte=(Latin1Compare(values,"True") == 0) || 4                 (Latin1Compare(values,"true") == 0);:             if (Latin1Compare(keyword,"matte-color") == 0)D               (void) QueryColorDatabase(values,&image->matte_color);6             if (Latin1Compare(keyword,"montage") == 0)9               (void) CloneString(&image->montage,values); 3             if (Latin1Compare(keyword,"page") == 0) <               ParseImageGeometry(PostscriptGeometry(values),8                 &image->page_info.x,&image->page_info.y,B                 &image->page_info.width,&image->page_info.height);:             if (Latin1Compare(keyword,"red-primary") == 0)P               (void) sscanf(values,"%lf,%lf",&image->chromaticity.red_primary.x,4                 &image->chromaticity.red_primary.y);?             if (Latin1Compare(keyword,"rendering-intent") == 0)                { <                 if (Latin1Compare(values,"saturation") == 0);                   image->rendering_intent=SaturationIntent;                  else>                   if (Latin1Compare(values,"perceptual") == 0)=                     image->rendering_intent=PerceptualIntent;                    else>                     if (Latin1Compare(values,"absolute") == 0)=                       image->rendering_intent=AbsoluteIntent;                      else@                       if (Latin1Compare(values,"relative") == 0)?                         image->rendering_intent=RelativeIntent;                        else@                         image->rendering_intent=UndefinedIntent;               } 9             if (Latin1Compare(keyword,"resolution") == 0) B               (void) sscanf(values,"%lfx%lf",&image->x_resolution,&                 &image->y_resolution);3             if (Latin1Compare(keyword,"rows") == 0) 6               image->rows=(unsigned int) atoi(values);4             if (Latin1Compare(keyword,"scene") == 0)7               image->scene=(unsigned int) atoi(values); 8             if (Latin1Compare(keyword,"signature") == 0);               (void) CloneString(&image->signature,values); 4             if (Latin1Compare(keyword,"units") == 0)               { ;                 if (Latin1Compare(values,"undefined") == 0) 3                   image->units=UndefinedResolution;                  elseC                   if (Latin1Compare(values,"pixels-per-inch") == 0) 9                     image->units=PixelsPerInchResolution;                    elseK                     if (Latin1Compare(values,"pixels-per-centimeter") == 0) A                       image->units=PixelsPerCentimeterResolution;                } :             if (Latin1Compare(keyword,"white-point") == 0)P               (void) sscanf(values,"%lf,%lf",&image->chromaticity.white_point.x,4                 &image->chromaticity.white_point.y);           }          else           c=ReadByte(image);       while (isspace(c))         c=ReadByte(image);     }      (void) ReadByte(image);      /*8       Verify that required image information is defined.     */N     if ((strcmp(id,"ImageMagick") != 0) || (image->class == UndefinedClass) ||P         (image->compression == UndefinedCompression) || (image->columns == 0) ||         (image->rows == 0)) M       ReaderExit(CorruptImageWarning,"Incorrect image header in file",image);      if (image_info->ping)        {          CloseBlob(image);          return(image);       } (     if (image->montage != (char *) NULL)       {          register char 
           *p;   
         /*           Image directory.
         */M         image->directory=(char *) AllocateMemory(MaxTextExtent*sizeof(char)); .         if (image->directory == (char *) NULL)L           ReaderExit(CorruptImageWarning,"Unable to read image data",image);         p=image->directory; 
         do	         {            *p='\0';B           if (((Extent(image->directory)+1) % MaxTextExtent) == 0)
             {                /*=                 Allocate more memory for the image directory.                */A               image->directory=(char *) ReallocateMemory((char *) L                 image->directory,(Extent(image->directory)+MaxTextExtent+1)*                 sizeof(char));4               if (image->directory == (char *) NULL)K                 ReaderExit(CorruptImageWarning,"Unable to read image data",                    image); :               p=image->directory+Extent(image->directory);
             }            c=ReadByte(image);!           *p++=(unsigned char) c;          } while (c != '\0');       } (     if (image->color_profile.length > 0)       { 
         /*           Color profile.
         */3         image->color_profile.info=(unsigned char *) L           AllocateMemory(image->color_profile.length*sizeof(unsigned char));@         if (image->color_profile.info == (unsigned char *) NULL)O           ReaderExit(CorruptImageWarning,"Unable to read color profile",image); :         (void) ReadBlob(image,image->color_profile.length,%           image->color_profile.info);        } $     if (image->class == PseudoClass)       { 
         /*            Create image colormap.
         */'         image->colormap=(PixelPacket *) E           AllocateMemory(Max(image->colors,256)*sizeof(PixelPacket)); 4         if (image->colormap == (PixelPacket *) NULL)L           ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);         if (image->colors == 0) !           for (i=0; i < 256; i++)            { 8             image->colormap[i].red=(Quantum) UpScale(i);:             image->colormap[i].green=(Quantum) UpScale(i);9             image->colormap[i].blue=(Quantum) UpScale(i);              image->colors++;           }          else           {              unsigned char                *colormap;               unsigned int               packet_size;               /*,               Read image colormap from file.             */4             packet_size=image->colors > 256 ? 6 : 3;&             colormap=(unsigned char *)N               AllocateMemory(packet_size*image->colors*sizeof(unsigned char));3             if (colormap == (unsigned char *) NULL) P               ReaderExit(ResourceLimitWarning,"Memory allocation failed",image);F             (void) ReadBlob(image,packet_size*image->colors,colormap);             p=colormap; %             if (image->colors <= 256) 5               for (i=0; i < (int) image->colors; i++)                { 5                 image->colormap[i].red=UpScale(*p++); 7                 image->colormap[i].green=UpScale(*p++); 6                 image->colormap[i].blue=UpScale(*p++);               }              else5               for (i=0; i < (int) image->colors; i++)                { 3                 image->colormap[i].red=(*p++ << 8); /                 image->colormap[i].red|=(*p++); 5                 image->colormap[i].green=(*p++ << 8); 1                 image->colormap[i].green|=(*p++); 4                 image->colormap[i].blue=(*p++ << 8);0                 image->colormap[i].blue|=(*p++);               } !             FreeMemory(colormap);            }        }      /*       Allocate image pixels.     */$     if (image->class == DirectClass)+       packet_size=image->depth > 8 ? 6 : 3;      else.       packet_size=image->colors > 256 ? 2 : 1;>     if (image->matte || (image->colorspace == CMYKColorspace)),       packet_size+=image->depth > 8 ? 2 : 1;:     if (image->compression == RunlengthEncodedCompression),       packet_size+=image->depth > 8 ? 2 : 1;     pixels=(unsigned char *)G       AllocateMemory(packet_size*image->columns*sizeof(unsigned char)); E     compressed_pixels=(unsigned char *) AllocateMemory((unsigned int) C       (1.01*packet_size*image->columns+600)*sizeof(unsigned char)); -     if ((pixels == (unsigned char *) NULL) || 6         (compressed_pixels == (unsigned char *) NULL))H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     /*       Read image pixels.     */     index=0;
     length=0; )     for (y=0; y < (int) image->rows; y++)      { 2       q=SetPixelCache(image,0,y,image->columns,1);$       if (q == (PixelPacket *) NULL)         break; #if defined(HasZLIB)1         if (image->compression == ZipCompression)            {              if (y == 0)                { %                 zip_info.zalloc=NULL; $                 zip_info.zfree=NULL;%                 zip_info.opaque=NULL; .                 (void) inflateInit(&zip_info);$                 zip_info.avail_in=0;               } %             zip_info.next_out=pixels; :             zip_info.avail_out=packet_size*image->columns;             do
             { )               if (zip_info.avail_in == 0)                  { 5                   zip_info.next_in=compressed_pixels; <                   length=1.01*packet_size*image->columns+12;L                   zip_info.avail_in=ReadBlob(image,length,zip_info.next_in);                 } @               if (inflate(&zip_info,Z_NO_FLUSH) == Z_STREAM_END)                 break;-             } while (zip_info.avail_out > 0); +             if (y == (int) (image->rows-1))                { M                 (void) SeekBlob(image,-((off_t) zip_info.avail_in),SEEK_CUR); .                 status=!inflateEnd(&zip_info);               }            }          else #endif #if defined(HasBZLIB) 2         if (image->compression == BZipCompression)           {              if (y == 0)                { '                 bzip_info.bzalloc=NULL; &                 bzip_info.bzfree=NULL;&                 bzip_info.opaque=NULL;N                 (void) bzDecompressInit(&bzip_info,image_info->verbose,False);%                 bzip_info.avail_in=0;                } /             bzip_info.next_out=(char *) pixels; ;             bzip_info.avail_out=packet_size*image->columns;              do
             { *               if (bzip_info.avail_in == 0)                 { ?                   bzip_info.next_in=(char *) compressed_pixels; <                   length=1.01*packet_size*image->columns+12;N                   bzip_info.avail_in=ReadBlob(image,length,bzip_info.next_in);                 } <               if (bzDecompress(&bzip_info) == BZ_STREAM_END)                 break;.             } while (bzip_info.avail_out > 0);+             if (y == (int) (image->rows-1))                { N                 (void) SeekBlob(image,-((off_t) bzip_info.avail_in),SEEK_CUR);4                 status=!bzDecompressEnd(&bzip_info);               }            }          else #endif@           if (image->compression != RunlengthEncodedCompression)E             (void) ReadBlob(image,packet_size*image->columns,pixels); <       if (image->compression != RunlengthEncodedCompression)	         { *           if (image->class == PseudoClass)
             {                 if (!image->matte):                 ReadPixelCache(image,IndexQuantum,pixels);               elseA                 ReadPixelCache(image,IndexOpacityQuantum,pixels); 
             }            else4             if (image->colorspace == CMYKColorspace)7               ReadPixelCache(image,CMYKQuantum,pixels);              else                if (!image->matte)8                 ReadPixelCache(image,RGBQuantum,pixels);               else9                 ReadPixelCache(image,RGBAQuantum,pixels); 	         } 
       else	         {            if (y == 0) #             GetPixelPacket(&pixel);            p=pixels; 2           for (x=0; x < (int) image->columns; x++)           {              if (length == 0)               { 0                 if (image->class != DirectClass)                   { *                     index=ReadByte(image);,                     if (image->colors > 256)9                       index=(index << 8)+ReadByte(image); /                     if (index >= image->colors) N                       ReaderExit(CorruptImageWarning,"invalid colormap index",                         image); 1                     pixel=image->colormap[index];                    }                  else                   { *                     if (image->depth <= 8)                       { ;                         pixel.red=UpScale(ReadByte(image)); =                         pixel.green=UpScale(ReadByte(image)); <                         pixel.blue=UpScale(ReadByte(image));+                         if (image->matte || B                             (image->colorspace == CMYKColorspace))A                           pixel.opacity=UpScale(ReadByte(image));                        }                      else                       { =                         pixel.red=MSBFirstReadShort(image) >> 6                           (image->depth-QuantumDepth);?                         pixel.green=MSBFirstReadShort(image) >> 6                           (image->depth-QuantumDepth);>                         pixel.blue=MSBFirstReadShort(image) >>6                           (image->depth-QuantumDepth);+                         if (image->matte || B                             (image->colorspace == CMYKColorspace))C                           pixel.opacity=MSBFirstReadShort(image) >> 8                             (image->depth-QuantumDepth);                       }                    } )                 length=ReadByte(image)+1;                }              length--; ,             if (image->class == PseudoClass)&               image->indexes[x]=index;             *q++=pixel;            } 	         } !       if (!SyncPixelCache(image))          break;     }      FreeMemory(pixels); "     FreeMemory(compressed_pixels);     if (status == False)       {          DestroyImages(image);          return((Image *) NULL);        }      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     do     {        c=ReadByte(image);(     } while (!isgraph(c) && (c != EOF));     if (c != EOF)        { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (c != EOF); +   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M I F F I m a g e                                               % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % 3 %  Method WriteMIFFImage writes an image to a file.  % . %  The format of the WriteMIFFImage method is: % L %      unsigned int WriteMIFFImage(const ImageInfo *image_info,Image *image) % 0 %  Compression code contributed by Kyle Shorter. % + %  A description of each parameter follows:  % I %    o status: Method WriteMIFFImage return True if the image is written. K %      False is returned if there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % - %    o image: A pointer to a Image structure.  %  %  */L Export unsigned int WriteMIFFImage(const ImageInfo *image_info,Image *image) {  #if defined(HasBZLIB)    bz_stream      bzip_info; #endif     char     buffer[MaxTextExtent],     color[MaxTextExtent];      CompressionType      compression;  
   IndexPacket 
     index;     int      length,      y;  
   PixelPacket 
     pixel;     register PixelPacket     *p;      register int     i,     x;     register unsigned char     *q;      unsigned char      *compressed_pixels,      *pixels;     unsigned int     packet_size,
     scene,     status, 
     value;   #if defined(HasZLIB)
   z_stream
     zip_info;  #endif     /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);   (void) IsPseudoClass(image);4   (void) strcpy((char *) image_info->magick,"MIFF");!   compression=image->compression; 6   if (image_info->compression != UndefinedCompression)(     compression=image_info->compression;
   scene=0;   do   {      /*       Allocate image pixels.     */$     if (image->class == DirectClass)+       packet_size=image->depth > 8 ? 6 : 3;      else.       packet_size=image->colors > 256 ? 2 : 1;>     if (image->matte || (image->colorspace == CMYKColorspace)),       packet_size+=image->depth > 8 ? 2 : 1;3     if (compression == RunlengthEncodedCompression) ,       packet_size+=image->depth > 8 ? 2 : 1;     pixels=(unsigned char *)G       AllocateMemory(packet_size*image->columns*sizeof(unsigned char)); E     compressed_pixels=(unsigned char *) AllocateMemory((unsigned int) C       (1.01*packet_size*image->columns+600)*sizeof(unsigned char)); -     if ((pixels == (unsigned char *) NULL) || 6         (compressed_pixels == (unsigned char *) NULL))H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     /*       Write MIFF header.     */;     if (((image_info->colorspace != UndefinedColorspace) || 2          (image->colorspace != CMYKColorspace)) &&4          (image_info->colorspace != CMYKColorspace))-       TransformRGBImage(image,RGBColorspace);      else.       if (image->colorspace != CMYKColorspace)0         RGBTransformImage(image,CMYKColorspace);-     (void) strcpy(buffer,"id=ImageMagick\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);$     if (image->class == PseudoClass)G       (void) sprintf(buffer,"class=PseudoClass  colors=%u  matte=%s\n", 7         image->colors,image->matte ? "True" : "False");      else.       if (image->colorspace != CMYKColorspace)>         (void) sprintf(buffer,"class=DirectClass  matte=%s\n",+           image->matte ? "True" : "False"); 
       elseE         (void) strcpy(buffer,"class=DirectClass  colorspace=CMYK\n"); 2     (void) WriteBlob(image,strlen(buffer),buffer);     *buffer='\0'; 3     if (compression == RunlengthEncodedCompression) >       (void) sprintf(buffer,"compression=RunlengthEncoded\n");     else)       if (compression == BZipCompression) 4         (void) sprintf(buffer,"compression=BZip\n");
       else*         if (compression == ZipCompression)5           (void) sprintf(buffer,"compression=Zip\n");      if (*buffer != '\0')4       (void) WriteBlob(image,strlen(buffer),buffer);K     (void) sprintf(buffer,"columns=%u  rows=%u  depth=%u\n",image->columns,         image->rows,image->depth);2     (void) WriteBlob(image,strlen(buffer),buffer);A     if ((image->x_resolution != 0) && (image->y_resolution != 0))        {          char           units[MaxTextExtent];   
         /*           Set image resolution. 
         */)         (void) strcpy(units,"undefined"); 4         if (image->units == PixelsPerInchResolution)1           (void) strcpy(units,"pixels-per-inch"); :         if (image->units == PixelsPerCentimeterResolution)7           (void) strcpy(units,"pixels-per-centimeter"); B         (void) sprintf(buffer,"resolution=%gx%g  units=%.1024s\n",9           image->x_resolution,image->y_resolution,units); 6         (void) WriteBlob(image,strlen(buffer),buffer);       }      SignatureImage(image);*     if (image->signature != (char *) NULL)       { F         (void) sprintf(buffer,"signature=%.1024s\n",image->signature);6         (void) WriteBlob(image,strlen(buffer),buffer);       } H     if ((image->page_info.width != 0) && (image->page_info.height != 0))       { J         (void) sprintf(buffer,"page=%ux%u%+d%+d\n",image->page_info.width,I           image->page_info.height,image->page_info.x,image->page_info.y); 6         (void) WriteBlob(image,strlen(buffer),buffer);       } :     (void) QueryColorName(&image->background_color,color);>     (void) sprintf(buffer,"background-color=%.1024s  ",color);2     (void) WriteBlob(image,strlen(buffer),buffer);6     (void) QueryColorName(&image->border_color,color);:     (void) sprintf(buffer,"border-color=%.1024s  ",color);2     (void) WriteBlob(image,strlen(buffer),buffer);5     (void) QueryColorName(&image->matte_color,color); 9     (void) sprintf(buffer,"matte-color=%.1024s\n",color); 2     (void) WriteBlob(image,strlen(buffer),buffer);O     if ((image->next != (Image *) NULL) || (image->previous != (Image *) NULL))        { P         (void) sprintf(buffer,"scene=%u  iterations=%u  delay=%u  dispose=%u\n",F           image->scene,image->iterations,image->delay,image->dispose);6         (void) WriteBlob(image,strlen(buffer),buffer);       }      else       {          if (image->scene != 0)           { =             (void) sprintf(buffer,"scene=%u\n",image->scene); :             (void) WriteBlob(image,strlen(buffer),buffer);           } #         if (image->iterations != 1)            { G             (void) sprintf(buffer,"iterations=%u\n",image->iterations); :             (void) WriteBlob(image,strlen(buffer),buffer);           }          if (image->delay != 0)           { =             (void) sprintf(buffer,"delay=%u\n",image->delay); :             (void) WriteBlob(image,strlen(buffer),buffer);           }           if (image->dispose != 0)           { A             (void) sprintf(buffer,"dispose=%u\n",image->dispose); :             (void) WriteBlob(image,strlen(buffer),buffer);           }        } 3     if (image->rendering_intent != UndefinedIntent)        { 8         if (image->rendering_intent == SaturationIntent)@           (void) strcpy(buffer,"rendering-intent=saturation\n");         else:           if (image->rendering_intent == PerceptualIntent)B             (void) strcpy(buffer,"rendering-intent=perceptual\n");           else:             if (image->rendering_intent == AbsoluteIntent)B               (void) strcpy(buffer,"rendering-intent=absolute\n");             elseB               (void) strcpy(buffer,"rendering-intent=relative\n");6         (void) WriteBlob(image,strlen(buffer),buffer);       }      if (image->gamma != 0.0)       { 9         (void) sprintf(buffer,"gamma=%g\n",image->gamma); 6         (void) WriteBlob(image,strlen(buffer),buffer);       } 1     if (image->chromaticity.white_point.x != 0.0)        { 
         /*"           Note chomaticity points.
         */         (void) sprintf(buffer,I           "red-primary=%g,%g  green-primary=%g,%g  blue-primary=%g,%g\n", N           image->chromaticity.red_primary.x,image->chromaticity.red_primary.y,.           image->chromaticity.green_primary.x,.           image->chromaticity.green_primary.y,-           image->chromaticity.blue_primary.x, .           image->chromaticity.blue_primary.y);6         (void) WriteBlob(image,strlen(buffer),buffer);4         (void) sprintf(buffer,"white-point=%g,%g\n",O           image->chromaticity.white_point.x,image->chromaticity.white_point.y); 6         (void) WriteBlob(image,strlen(buffer),buffer);       } (     if (image->color_profile.length > 0)       { P         (void) sprintf(buffer,"color-profile=%u\n",image->color_profile.length);6         (void) WriteBlob(image,strlen(buffer),buffer);       } (     if (image->montage != (char *) NULL)       { B         (void) sprintf(buffer,"montage=%.1024s\n",image->montage);6         (void) WriteBlob(image,strlen(buffer),buffer);       } &     if (image->label != (char *) NULL)       { B         (void) sprintf(buffer,"label=\"%.1024s\"\n",image->label);6         (void) WriteBlob(image,strlen(buffer),buffer);       } )     if (image->comments != (char *) NULL)        { $         (void) WriteByte(image,'{');%         (void) WriteByte(image,'\n'); H         (void) WriteBlob(image,strlen(image->comments),image->comments);$         (void) WriteByte(image,'}');%         (void) WriteByte(image,'\n');        } &     (void) strcpy(buffer,"\f\n:\032");2     (void) WriteBlob(image,strlen(buffer),buffer);(     if (image->montage != (char *) NULL)       { 
         /*'           Write montage tile directory. 
         */.         if (image->directory != (char *) NULL)L           (void) WriteBlob(image,strlen(image->directory),image->directory);%         (void) WriteByte(image,'\0');        } (     if (image->color_profile.length > 0)?       (void) WriteBlob(image,(int) image->color_profile.length, ,         (char *) image->color_profile.info);$     if (image->class == PseudoClass)       {          register unsigned char
           *q;            unsigned char            *colormap;           unsigned int           packet_size;  
         /*           Allocate colormap.
         */0         packet_size=image->colors > 256 ? 6 : 3;"         colormap=(unsigned char *)J           AllocateMemory(packet_size*image->colors*sizeof(unsigned char));/         if (colormap == (unsigned char *) NULL) L           WriterExit(ResourceLimitWarning,"Memory allocation failed",image);
         /*!           Write colormap to file. 
         */         q=colormap; !         if (image->colors <= 256) 1           for (i=0; i < (int) image->colors; i++)            { (             *q++=image->colormap[i].red;*             *q++=image->colormap[i].green;)             *q++=image->colormap[i].blue;            }          else1           for (i=0; i < (int) image->colors; i++)            { -             *q++=image->colormap[i].red >> 8; /             *q++=image->colormap[i].red & 0xff; /             *q++=image->colormap[i].green >> 8; 2             *q++=image->colormap[i].green  & 0xff;.             *q++=image->colormap[i].blue >> 8;1             *q++=image->colormap[i].blue  & 0xff;            } C         (void) WriteBlob(image,packet_size*image->colors,colormap);          FreeMemory(colormap);        }      /*!       Write image pixels to file.      */     status=True;)     for (y=0; y < (int) image->rows; y++)      { 2       p=GetPixelCache(image,0,y,image->columns,1);$       if (p == (PixelPacket *) NULL)         break;       q=pixels; 5       if (compression != RunlengthEncodedCompression) 	         { *           if (image->class == PseudoClass)
             {                 if (!image->matte);                 WritePixelCache(image,IndexQuantum,pixels);                elseB                 WritePixelCache(image,IndexOpacityQuantum,pixels);
             }            else4             if (image->colorspace == CMYKColorspace)8               WritePixelCache(image,CMYKQuantum,pixels);             else                if (!image->matte)9                 WritePixelCache(image,RGBQuantum,pixels);                else:                 WritePixelCache(image,RGBAQuantum,pixels);	         } 
       else	         { !           pixel=(*image->pixels);            index=0;*           if (image->class == PseudoClass)$             index=(*image->indexes);           length=0; 2           for (x=0; x < (int) image->columns; x++)           { F             if ((p->red == pixel.red) && (p->green == pixel.green) && K                 (p->blue == pixel.blue) && (p->opacity == pixel.opacity) && ;                 (length < 255) && (x < (image->columns-1)))                length++;              else               { 0                 if (image->class != DirectClass)                   { ,                     if (image->colors > 256)&                       *q++=index >> 8;                     *q++=index;                    }                  else                   { *                     if (image->depth <= 8)                       { 2                         *q++=DownScale(pixel.red);4                         *q++=DownScale(pixel.green);3                         *q++=DownScale(pixel.blue); +                         if (image->matte || B                             (image->colorspace == CMYKColorspace))8                           *q++=DownScale(pixel.opacity);                       }                      else                       { (                         value=pixel.red;<                         if ((QuantumDepth-image->depth) > 0)%                           value*=257; (                         *q++=value >> 8;*                         *q++=value & 0xff;*                         value=pixel.green;<                         if ((QuantumDepth-image->depth) > 0)%                           value*=257; (                         *q++=value >> 8;*                         *q++=value & 0xff;)                         value=pixel.blue; <                         if ((QuantumDepth-image->depth) > 0)%                           value*=257; (                         *q++=value >> 8;*                         *q++=value & 0xff;+                         if (image->matte || B                             (image->colorspace == CMYKColorspace))                           { 0                             value=pixel.opacity;@                             if ((QuantumDepth-image->depth) > 0))                               value*=257; ,                             *q++=value >> 8;.                             *q++=value & 0xff;                           }                        }                    } ,                 *q++=(unsigned char) length;                 length=0;                } ,             if (image->class == PseudoClass)&               index=image->indexes[x];             pixel=(*p);              p++;           } 	         }  #if defined(HasZLIB)*         if (compression == ZipCompression)           {              if (y == 0)                { %                 zip_info.zalloc=NULL; $                 zip_info.zfree=NULL;%                 zip_info.opaque=NULL; L                 (void) deflateInit(&zip_info,Min(image_info->quality/10,9));               } $             zip_info.next_in=pixels;9             zip_info.avail_in=packet_size*image->columns;              do
             { 2               zip_info.next_out=compressed_pixels;D               zip_info.avail_out=1.01*packet_size*image->columns+12;4               status=!deflate(&zip_info,Z_NO_FLUSH);9               length=zip_info.next_out-compressed_pixels; 9               if (zip_info.next_out != compressed_pixels) A                 (void) WriteBlob(image,length,compressed_pixels); ,             } while (zip_info.avail_in > 0);+             if (y == (int) (image->rows-1))                {                  for ( ; ; )                  { 6                   zip_info.next_out=compressed_pixels;H                   zip_info.avail_out=1.01+packet_size*image->columns+12;6                   status=!deflate(&zip_info,Z_FINISH);=                   if (zip_info.next_out == compressed_pixels)                      break;=                   length=zip_info.next_out-compressed_pixels; C                   (void) WriteBlob(image,length,compressed_pixels);                  } .                 status=!deflateEnd(&zip_info);               }            }          else #endif #if defined(HasBZLIB) +         if (compression == BZipCompression)            {              if (y == 0)                { '                 bzip_info.bzalloc=NULL; &                 bzip_info.bzfree=NULL;&                 bzip_info.opaque=NULL;O                 (void) bzCompressInit(&bzip_info,Min(image_info->quality/10,9), )                   image_info->verbose,0);                } .             bzip_info.next_in=(char *) pixels;:             bzip_info.avail_in=packet_size*image->columns;             do
             { <               bzip_info.next_out=(char *) compressed_pixels;A               bzip_info.avail_out=packet_size*image->columns+600; 3               (void) bzCompress(&bzip_info,BZ_RUN); C               length=bzip_info.next_out-(char *) compressed_pixels; C               if (bzip_info.next_out != (char *) compressed_pixels) A                 (void) WriteBlob(image,length,compressed_pixels); -             } while (bzip_info.avail_in > 0); +             if (y == (int) (image->rows-1))                {                  for ( ; ; )                  { @                   bzip_info.next_out=(char *) compressed_pixels;E                   bzip_info.avail_out=packet_size*image->columns+600; :                   (void) bzCompress(&bzip_info,BZ_FINISH);G                   if (bzip_info.next_out == (char *) compressed_pixels)                      break;G                   length=bzip_info.next_out-(char *) compressed_pixels; C                   (void) WriteBlob(image,length,compressed_pixels);                  } 2                 status=!bzCompressEnd(&bzip_info);               }            }          else #endif9           if (compression == RunlengthEncodedCompression) 4             status=WriteBlob(image,q-pixels,pixels);           elseF             status=WriteBlob(image,packet_size*image->columns,pixels);,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);      }      FreeMemory(pixels); "     FreeMemory(compressed_pixels);&     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(status);  } 