 /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %                            M   M  TTTTT  V   V                              % O %                            MM MM    T    V   V                              % O %                            M M M    T    V   V                              % O %                            M   M    T     V V                               % O %                            M   M    T      V                                % O %                                                                             % O %                                                                             % O %                    Read/Write ImageMagick Image Format.                     % O %                                                                             % O %                                                                             % O %                              Software Design                                % O %                                John Cristy                                  % O %                                 July 1992                                   % O %                                                                             % O %                                                                             % O %  Copyright (C) 2000 ImageMagick Studio, a non-profit organization dedicated % O %  to making software imaging solutions freely available.                     % O %                                                                             % O %  Permission is hereby granted, free of charge, to any person obtaining a    % O %  copy of this software and associated documentation files ("ImageMagick"),  % O %  to deal in ImageMagick without restriction, including without limitation   % O %  the rights to use, copy, modify, merge, publish, distribute, sublicense,   % O %  and/or sell copies of ImageMagick, and to permit persons to whom the       % O %  ImageMagick is furnished to do so, subject to the following conditions:    % O %                                                                             % O %  The above copyright notice and this permission notice shall be included in % O %  all copies or substantial portions of ImageMagick.                         % O %                                                                             % O %  The software is provided "as is", without warranty of any kind, express or % O %  implied, including but not limited to the warranties of merchantability,   % O %  fitness for a particular purpose and noninfringement.  In no event shall   % O %  ImageMagick Studio be liable for any claim, damages or other liability,    % O %  whether in an action of contract, tort or otherwise, arising from, out of  % O %  or in connection with ImageMagick or the use or other dealings in          % O %  ImageMagick.                                                               % O %                                                                             % O %  Except as contained in this notice, the name of the ImageMagick Studio     % O %  shall not be used in advertising or otherwise to promote the sale, use or  % O %  other dealings in ImageMagick without prior written authorization from the % O %  ImageMagick Studio.                                                        % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  %  %  */   /*   Include declarations.  */ #include "magick.h"  #include "defines.h"   /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   R e a d M T V I m a g e                                                   % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % K %  Method ReadMTVImage reads a MTV image file and returns it.  It allocates L %  the memory necessary for the new Image structure and returns a pointer to %  the new image.  % , %  The format of the ReadMTVImage method is: % 7 %      Image *ReadMTVImage(const ImageInfo *image_info)  % + %  A description of each parameter follows:  % G %    o image:  Method ReadMTVImage returns a pointer to the image after J %      reading.  A null image is returned if there is a memory shortage or# %      if the image cannot be read.  % A %    o image_info: Specifies a pointer to an ImageInfo structure.  %  %  */7 Export Image *ReadMTVImage(const ImageInfo *image_info)  {    char     buffer[MaxTextExtent];     Image      *image;      int 
     count,     y;     register int     x;     register PixelPacket     *q;      unsigned int     columns,	     rows,      status;      /*     Allocate image structure.    */"   image=AllocateImage(image_info);   if (image == (Image *) NULL)     return((Image *) NULL);    /*     Open image file.   */3   status=OpenBlob(image_info,image,ReadBinaryType);    if (status == False)<     ReaderExit(FileOpenWarning,"Unable to open file",image);   /*     Read MTV image.    */%   (void) GetStringBlob(image,buffer); 0   count=sscanf(buffer,"%u %u\n",&columns,&rows);   if (count == 0) A     ReaderExit(CorruptImageWarning,"Not a MTV image file",image);    do   {      /*!       Initialize image structure.      */     image->columns=columns;      image->rows=rows;      if (image_info->ping)        {          CloseBlob(image);          return(image);       }      /*0       Convert MTV raster image to pixel packets.     */)     for (y=0; y < (int) image->rows; y++)      { 2       q=SetPixelCache(image,0,y,image->columns,1);$       if (q == (PixelPacket *) NULL)         break;.       for (x=0; x < (int) image->columns; x++)       { (         q->red=UpScale(ReadByte(image));*         q->green=UpScale(ReadByte(image));)         q->blue=UpScale(ReadByte(image));          q++;       } !       if (!SyncPixelCache(image))          break;,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(LoadImageText,y,image->rows);      }      /*       Proceed to next image.     */"     if (image_info->subrange != 0)H       if (image->scene >= (image_info->subimage+image_info->subrange-1))         break;     *buffer='\0'; '     (void) GetStringBlob(image,buffer); 2     count=sscanf(buffer,"%u %u\n",&columns,&rows);     if (count > 0)       { 
         /*(           Allocate next image structure.
         */,         AllocateNextImage(image_info,image);*         if (image->next == (Image *) NULL)           { !             DestroyImages(image); #             return((Image *) NULL);            }          image=image->next;F         ProgressMonitor(LoadImagesText,(unsigned int) TellBlob(image),*           (unsigned int) image->filesize);       }    } while (count > 0);+   while (image->previous != (Image *) NULL)      image=image->previous;   CloseBlob(image);    return(image); }    /*O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% O %                                                                             % O %                                                                             % O %                                                                             % O %   W r i t e M T V I m a g e                                                 % O %                                                                             % O %                                                                             % O %                                                                             % O %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%  % I %  Method WriteMTVImage writes an image to a file in red, green, and blue  %  MTV rasterfile format.  % - %  The format of the WriteMTVImage method is:  % K %      unsigned int WriteMTVImage(const ImageInfo *image_info,Image *image)  % + %  A description of each parameter follows.  % H %    o status: Method WriteMTVImage return True if the image is written.K %      False is returned is there is a memory shortage or if the image file  %      fails to write. % A %    o image_info: Specifies a pointer to an ImageInfo structure.  % . %    o image:  A pointer to a Image structure. %  %  */K Export unsigned int WriteMTVImage(const ImageInfo *image_info,Image *image)  {    char     buffer[MaxTextExtent];     int      y;     register int     x;     register PixelPacket     *p;      register unsigned char     *q;      unsigned char      *pixels;     unsigned int
     scene,     status;      /*     Open output image file.    */4   status=OpenBlob(image_info,image,WriteBinaryType);   if (status == False)<     WriterExit(FileOpenWarning,"Unable to open file",image);
   scene=0;   do   {      /*!       Allocate memory for pixels.      */+     TransformRGBImage(image,RGBColorspace);      pixels=(unsigned char *)9       AllocateMemory(image->columns*sizeof(PixelPacket)); )     if (pixels == (unsigned char *) NULL) H       WriterExit(ResourceLimitWarning,"Memory allocation failed",image);     /*$       Initialize raster file header.     */@     (void) sprintf(buffer,"%u %u\n",image->columns,image->rows);2     (void) WriteBlob(image,strlen(buffer),buffer);)     for (y=0; y < (int) image->rows; y++)      { 2       p=GetPixelCache(image,0,y,image->columns,1);$       if (p == (PixelPacket *) NULL)         break;       q=pixels; .       for (x=0; x < (int) image->columns; x++)       {          *q++=DownScale(p->red); !         *q++=DownScale(p->green);           *q++=DownScale(p->blue);         p++;       } 7       (void) WriteBlob(image,q-pixels,(char *) pixels); ,       if (image->previous == (Image *) NULL)'         if (QuantumTick(y,image->rows)) 7           ProgressMonitor(SaveImageText,y,image->rows);      }      FreeMemory(pixels); &     if (image->next == (Image *) NULL)       break;     image=GetNextImage(image);C     ProgressMonitor(SaveImagesText,scene++,GetNumberScenes(image));    } while (image_info->adjoin);    if (image_info->adjoin) -     while (image->previous != (Image *) NULL)        image=image->previous;   CloseBlob(image);    return(True);  } 